package appstream_center

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyNodePoolAttribute invokes the appstream_center.ModifyNodePoolAttribute API synchronously
func (client *Client) ModifyNodePoolAttribute(request *ModifyNodePoolAttributeRequest) (response *ModifyNodePoolAttributeResponse, err error) {
	response = CreateModifyNodePoolAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyNodePoolAttributeWithChan invokes the appstream_center.ModifyNodePoolAttribute API asynchronously
func (client *Client) ModifyNodePoolAttributeWithChan(request *ModifyNodePoolAttributeRequest) (<-chan *ModifyNodePoolAttributeResponse, <-chan error) {
	responseChan := make(chan *ModifyNodePoolAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyNodePoolAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyNodePoolAttributeWithCallback invokes the appstream_center.ModifyNodePoolAttribute API asynchronously
func (client *Client) ModifyNodePoolAttributeWithCallback(request *ModifyNodePoolAttributeRequest, callback func(response *ModifyNodePoolAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyNodePoolAttributeResponse
		var err error
		defer close(result)
		response, err = client.ModifyNodePoolAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyNodePoolAttributeRequest is the request struct for api ModifyNodePoolAttribute
type ModifyNodePoolAttributeRequest struct {
	*requests.RpcRequest
	BizRegionId      string                                  `position:"Body" name:"BizRegionId"`
	ProductType      string                                  `position:"Body" name:"ProductType"`
	PoolId           string                                  `position:"Body" name:"PoolId"`
	NodePoolStrategy ModifyNodePoolAttributeNodePoolStrategy `position:"Body" name:"NodePoolStrategy"  type:"Struct"`
	NodeCapacity     requests.Integer                        `position:"Body" name:"NodeCapacity"`
}

// ModifyNodePoolAttributeNodePoolStrategy is a repeated param struct in ModifyNodePoolAttributeRequest
type ModifyNodePoolAttributeNodePoolStrategy struct {
	RecurrenceSchedules         *[]ModifyNodePoolAttributeNodePoolStrategyRecurrenceSchedulesItem `name:"RecurrenceSchedules" type:"Repeated"`
	ScalingStep                 string                                                            `name:"ScalingStep"`
	StrategyDisableDate         string                                                            `name:"StrategyDisableDate"`
	ScalingDownAfterIdleMinutes string                                                            `name:"ScalingDownAfterIdleMinutes"`
	StrategyType                string                                                            `name:"StrategyType"`
	MaxScalingAmount            string                                                            `name:"MaxScalingAmount"`
	WarmUp                      string                                                            `name:"WarmUp"`
	ScalingUsageThreshold       string                                                            `name:"ScalingUsageThreshold"`
	StrategyEnableDate          string                                                            `name:"StrategyEnableDate"`
}

// ModifyNodePoolAttributeNodePoolStrategyRecurrenceSchedulesItem is a repeated param struct in ModifyNodePoolAttributeRequest
type ModifyNodePoolAttributeNodePoolStrategyRecurrenceSchedulesItem struct {
	RecurrenceValues *[]string                                                                         `name:"RecurrenceValues" type:"Repeated"`
	RecurrenceType   string                                                                            `name:"RecurrenceType"`
	TimerPeriods     *[]ModifyNodePoolAttributeNodePoolStrategyRecurrenceSchedulesItemTimerPeriodsItem `name:"TimerPeriods" type:"Repeated"`
}

// ModifyNodePoolAttributeNodePoolStrategyRecurrenceSchedulesItemTimerPeriodsItem is a repeated param struct in ModifyNodePoolAttributeRequest
type ModifyNodePoolAttributeNodePoolStrategyRecurrenceSchedulesItemTimerPeriodsItem struct {
	Amount    string `name:"Amount"`
	EndTime   string `name:"EndTime"`
	StartTime string `name:"StartTime"`
}

// ModifyNodePoolAttributeResponse is the response struct for api ModifyNodePoolAttribute
type ModifyNodePoolAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateModifyNodePoolAttributeRequest creates a request to invoke ModifyNodePoolAttribute API
func CreateModifyNodePoolAttributeRequest() (request *ModifyNodePoolAttributeRequest) {
	request = &ModifyNodePoolAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("appstream-center", "2021-09-01", "ModifyNodePoolAttribute", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyNodePoolAttributeResponse creates a response to parse from ModifyNodePoolAttribute response
func CreateModifyNodePoolAttributeResponse() (response *ModifyNodePoolAttributeResponse) {
	response = &ModifyNodePoolAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
