package amqp_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListQueueConsumers invokes the amqp_open.ListQueueConsumers API synchronously
func (client *Client) ListQueueConsumers(request *ListQueueConsumersRequest) (response *ListQueueConsumersResponse, err error) {
	response = CreateListQueueConsumersResponse()
	err = client.DoAction(request, response)
	return
}

// ListQueueConsumersWithChan invokes the amqp_open.ListQueueConsumers API asynchronously
func (client *Client) ListQueueConsumersWithChan(request *ListQueueConsumersRequest) (<-chan *ListQueueConsumersResponse, <-chan error) {
	responseChan := make(chan *ListQueueConsumersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListQueueConsumers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListQueueConsumersWithCallback invokes the amqp_open.ListQueueConsumers API asynchronously
func (client *Client) ListQueueConsumersWithCallback(request *ListQueueConsumersRequest, callback func(response *ListQueueConsumersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListQueueConsumersResponse
		var err error
		defer close(result)
		response, err = client.ListQueueConsumers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListQueueConsumersRequest is the request struct for api ListQueueConsumers
type ListQueueConsumersRequest struct {
	*requests.RpcRequest
	InstanceId  string           `position:"Query" name:"InstanceId"`
	NextToken   string           `position:"Query" name:"NextToken"`
	QueryCount  requests.Integer `position:"Query" name:"QueryCount"`
	VirtualHost string           `position:"Query" name:"VirtualHost"`
	Queue       string           `position:"Query" name:"Queue"`
}

// ListQueueConsumersResponse is the response struct for api ListQueueConsumers
type ListQueueConsumersResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateListQueueConsumersRequest creates a request to invoke ListQueueConsumers API
func CreateListQueueConsumersRequest() (request *ListQueueConsumersRequest) {
	request = &ListQueueConsumersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("amqp-open", "2019-12-12", "ListQueueConsumers", "onsproxy", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListQueueConsumersResponse creates a response to parse from ListQueueConsumers response
func CreateListQueueConsumersResponse() (response *ListQueueConsumersResponse) {
	response = &ListQueueConsumersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
