package aliyuncvc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RegisterDevice invokes the aliyuncvc.RegisterDevice API synchronously
func (client *Client) RegisterDevice(request *RegisterDeviceRequest) (response *RegisterDeviceResponse, err error) {
	response = CreateRegisterDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// RegisterDeviceWithChan invokes the aliyuncvc.RegisterDevice API asynchronously
func (client *Client) RegisterDeviceWithChan(request *RegisterDeviceRequest) (<-chan *RegisterDeviceResponse, <-chan error) {
	responseChan := make(chan *RegisterDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RegisterDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RegisterDeviceWithCallback invokes the aliyuncvc.RegisterDevice API asynchronously
func (client *Client) RegisterDeviceWithCallback(request *RegisterDeviceRequest, callback func(response *RegisterDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RegisterDeviceResponse
		var err error
		defer close(result)
		response, err = client.RegisterDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RegisterDeviceRequest is the request struct for api RegisterDevice
type RegisterDeviceRequest struct {
	*requests.RpcRequest
	IP            string `position:"Query" name:"IP"`
	Mac           string `position:"Query" name:"Mac"`
	Token         string `position:"Query" name:"Token"`
	DeviceVersion string `position:"Query" name:"DeviceVersion"`
	SN            string `position:"Query" name:"SN"`
}

// RegisterDeviceResponse is the response struct for api RegisterDevice
type RegisterDeviceResponse struct {
	*responses.BaseResponse
	ErrorCode  int        `json:"ErrorCode" xml:"ErrorCode"`
	Success    bool       `json:"Success" xml:"Success"`
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	Message    string     `json:"Message" xml:"Message"`
	DeviceInfo DeviceInfo `json:"DeviceInfo" xml:"DeviceInfo"`
}

// CreateRegisterDeviceRequest creates a request to invoke RegisterDevice API
func CreateRegisterDeviceRequest() (request *RegisterDeviceRequest) {
	request = &RegisterDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aliyuncvc", "2019-10-30", "RegisterDevice", "aliyuncvc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRegisterDeviceResponse creates a response to parse from RegisterDevice response
func CreateRegisterDeviceResponse() (response *RegisterDeviceResponse) {
	response = &RegisterDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
