package alinlp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetOpenNLUHighRecall invokes the alinlp.GetOpenNLUHighRecall API synchronously
func (client *Client) GetOpenNLUHighRecall(request *GetOpenNLUHighRecallRequest) (response *GetOpenNLUHighRecallResponse, err error) {
	response = CreateGetOpenNLUHighRecallResponse()
	err = client.DoAction(request, response)
	return
}

// GetOpenNLUHighRecallWithChan invokes the alinlp.GetOpenNLUHighRecall API asynchronously
func (client *Client) GetOpenNLUHighRecallWithChan(request *GetOpenNLUHighRecallRequest) (<-chan *GetOpenNLUHighRecallResponse, <-chan error) {
	responseChan := make(chan *GetOpenNLUHighRecallResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetOpenNLUHighRecall(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetOpenNLUHighRecallWithCallback invokes the alinlp.GetOpenNLUHighRecall API asynchronously
func (client *Client) GetOpenNLUHighRecallWithCallback(request *GetOpenNLUHighRecallRequest, callback func(response *GetOpenNLUHighRecallResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetOpenNLUHighRecallResponse
		var err error
		defer close(result)
		response, err = client.GetOpenNLUHighRecall(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetOpenNLUHighRecallRequest is the request struct for api GetOpenNLUHighRecall
type GetOpenNLUHighRecallRequest struct {
	*requests.RpcRequest
	Sentence    string `position:"Body" name:"Sentence"`
	Business    string `position:"Query" name:"Business"`
	Labels      string `position:"Body" name:"Labels"`
	Task        string `position:"Body" name:"Task"`
	ServiceCode string `position:"Body" name:"ServiceCode"`
	Examples    string `position:"Body" name:"Examples"`
}

// GetOpenNLUHighRecallResponse is the response struct for api GetOpenNLUHighRecall
type GetOpenNLUHighRecallResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetOpenNLUHighRecallRequest creates a request to invoke GetOpenNLUHighRecall API
func CreateGetOpenNLUHighRecallRequest() (request *GetOpenNLUHighRecallRequest) {
	request = &GetOpenNLUHighRecallRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alinlp", "2020-06-29", "GetOpenNLUHighRecall", "alinlp", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetOpenNLUHighRecallResponse creates a response to parse from GetOpenNLUHighRecall response
func CreateGetOpenNLUHighRecallResponse() (response *GetOpenNLUHighRecallResponse) {
	response = &GetOpenNLUHighRecallResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
