package alikafka

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetTopicSubscribeStatus invokes the alikafka.GetTopicSubscribeStatus API synchronously
func (client *Client) GetTopicSubscribeStatus(request *GetTopicSubscribeStatusRequest) (response *GetTopicSubscribeStatusResponse, err error) {
	response = CreateGetTopicSubscribeStatusResponse()
	err = client.DoAction(request, response)
	return
}

// GetTopicSubscribeStatusWithChan invokes the alikafka.GetTopicSubscribeStatus API asynchronously
func (client *Client) GetTopicSubscribeStatusWithChan(request *GetTopicSubscribeStatusRequest) (<-chan *GetTopicSubscribeStatusResponse, <-chan error) {
	responseChan := make(chan *GetTopicSubscribeStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetTopicSubscribeStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetTopicSubscribeStatusWithCallback invokes the alikafka.GetTopicSubscribeStatus API asynchronously
func (client *Client) GetTopicSubscribeStatusWithCallback(request *GetTopicSubscribeStatusRequest, callback func(response *GetTopicSubscribeStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetTopicSubscribeStatusResponse
		var err error
		defer close(result)
		response, err = client.GetTopicSubscribeStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetTopicSubscribeStatusRequest is the request struct for api GetTopicSubscribeStatus
type GetTopicSubscribeStatusRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	Topic      string `position:"Query" name:"Topic"`
}

// GetTopicSubscribeStatusResponse is the response struct for api GetTopicSubscribeStatus
type GetTopicSubscribeStatusResponse struct {
	*responses.BaseResponse
	RequestId            string               `json:"RequestId" xml:"RequestId"`
	Code                 int                  `json:"Code" xml:"Code"`
	Success              bool                 `json:"Success" xml:"Success"`
	Message              string               `json:"Message" xml:"Message"`
	TopicSubscribeStatus TopicSubscribeStatus `json:"TopicSubscribeStatus" xml:"TopicSubscribeStatus"`
}

// CreateGetTopicSubscribeStatusRequest creates a request to invoke GetTopicSubscribeStatus API
func CreateGetTopicSubscribeStatusRequest() (request *GetTopicSubscribeStatusRequest) {
	request = &GetTopicSubscribeStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alikafka", "2019-09-16", "GetTopicSubscribeStatus", "alikafka", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetTopicSubscribeStatusResponse creates a response to parse from GetTopicSubscribeStatus response
func CreateGetTopicSubscribeStatusResponse() (response *GetTopicSubscribeStatusResponse) {
	response = &GetTopicSubscribeStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
