package aiworkspace

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddMemberRole invokes the aiworkspace.AddMemberRole API synchronously
func (client *Client) AddMemberRole(request *AddMemberRoleRequest) (response *AddMemberRoleResponse, err error) {
	response = CreateAddMemberRoleResponse()
	err = client.DoAction(request, response)
	return
}

// AddMemberRoleWithChan invokes the aiworkspace.AddMemberRole API asynchronously
func (client *Client) AddMemberRoleWithChan(request *AddMemberRoleRequest) (<-chan *AddMemberRoleResponse, <-chan error) {
	responseChan := make(chan *AddMemberRoleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddMemberRole(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddMemberRoleWithCallback invokes the aiworkspace.AddMemberRole API asynchronously
func (client *Client) AddMemberRoleWithCallback(request *AddMemberRoleRequest, callback func(response *AddMemberRoleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddMemberRoleResponse
		var err error
		defer close(result)
		response, err = client.AddMemberRole(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddMemberRoleRequest is the request struct for api AddMemberRole
type AddMemberRoleRequest struct {
	*requests.RoaRequest
	RoleName    string `position:"Path" name:"RoleName"`
	WorkspaceId string `position:"Path" name:"WorkspaceId"`
	MemberId    string `position:"Path" name:"MemberId"`
}

// AddMemberRoleResponse is the response struct for api AddMemberRole
type AddMemberRoleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddMemberRoleRequest creates a request to invoke AddMemberRole API
func CreateAddMemberRoleRequest() (request *AddMemberRoleRequest) {
	request = &AddMemberRoleRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("AIWorkSpace", "2021-02-04", "AddMemberRole", "/api/v1/workspaces/[WorkspaceId]/members/[MemberId]/roles/[RoleName]", "", "")
	request.Method = requests.POST
	return
}

// CreateAddMemberRoleResponse creates a response to parse from AddMemberRole response
func CreateAddMemberRoleResponse() (response *AddMemberRoleResponse) {
	response = &AddMemberRoleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
