package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListRuleTasks invokes the airec.ListRuleTasks API synchronously
func (client *Client) ListRuleTasks(request *ListRuleTasksRequest) (response *ListRuleTasksResponse, err error) {
	response = CreateListRuleTasksResponse()
	err = client.DoAction(request, response)
	return
}

// ListRuleTasksWithChan invokes the airec.ListRuleTasks API asynchronously
func (client *Client) ListRuleTasksWithChan(request *ListRuleTasksRequest) (<-chan *ListRuleTasksResponse, <-chan error) {
	responseChan := make(chan *ListRuleTasksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListRuleTasks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListRuleTasksWithCallback invokes the airec.ListRuleTasks API asynchronously
func (client *Client) ListRuleTasksWithCallback(request *ListRuleTasksRequest, callback func(response *ListRuleTasksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListRuleTasksResponse
		var err error
		defer close(result)
		response, err = client.ListRuleTasks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListRuleTasksRequest is the request struct for api ListRuleTasks
type ListRuleTasksRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"instanceId"`
	SceneId    string `position:"Query" name:"sceneId"`
}

// ListRuleTasksResponse is the response struct for api ListRuleTasks
type ListRuleTasksResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
	Code      string `json:"code" xml:"code"`
	Message   string `json:"message" xml:"message"`
	Result    Result `json:"result" xml:"result"`
}

// CreateListRuleTasksRequest creates a request to invoke ListRuleTasks API
func CreateListRuleTasksRequest() (request *ListRuleTasksRequest) {
	request = &ListRuleTasksRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2020-11-26", "ListRuleTasks", "/v2/openapi/instances/[instanceId]/rule-tasks", "airec", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListRuleTasksResponse creates a response to parse from ListRuleTasks response
func CreateListRuleTasksResponse() (response *ListRuleTasksResponse) {
	response = &ListRuleTasksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
