package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeScreenScoreThread invokes the aegis.DescribeScreenScoreThread API synchronously
// api document: https://help.aliyun.com/api/aegis/describescreenscorethread.html
func (client *Client) DescribeScreenScoreThread(request *DescribeScreenScoreThreadRequest) (response *DescribeScreenScoreThreadResponse, err error) {
	response = CreateDescribeScreenScoreThreadResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeScreenScoreThreadWithChan invokes the aegis.DescribeScreenScoreThread API asynchronously
// api document: https://help.aliyun.com/api/aegis/describescreenscorethread.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeScreenScoreThreadWithChan(request *DescribeScreenScoreThreadRequest) (<-chan *DescribeScreenScoreThreadResponse, <-chan error) {
	responseChan := make(chan *DescribeScreenScoreThreadResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeScreenScoreThread(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeScreenScoreThreadWithCallback invokes the aegis.DescribeScreenScoreThread API asynchronously
// api document: https://help.aliyun.com/api/aegis/describescreenscorethread.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeScreenScoreThreadWithCallback(request *DescribeScreenScoreThreadRequest, callback func(response *DescribeScreenScoreThreadResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeScreenScoreThreadResponse
		var err error
		defer close(result)
		response, err = client.DescribeScreenScoreThread(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeScreenScoreThreadRequest is the request struct for api DescribeScreenScoreThread
type DescribeScreenScoreThreadRequest struct {
	*requests.RpcRequest
	SourceIp  string           `position:"Query" name:"SourceIp"`
	EndTime   requests.Integer `position:"Query" name:"EndTime"`
	StartTime requests.Integer `position:"Query" name:"StartTime"`
}

// DescribeScreenScoreThreadResponse is the response struct for api DescribeScreenScoreThread
type DescribeScreenScoreThreadResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeScreenScoreThreadRequest creates a request to invoke DescribeScreenScoreThread API
func CreateDescribeScreenScoreThreadRequest() (request *DescribeScreenScoreThreadRequest) {
	request = &DescribeScreenScoreThreadRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeScreenScoreThread", "vipaegis", "openAPI")
	return
}

// CreateDescribeScreenScoreThreadResponse creates a response to parse from DescribeScreenScoreThread response
func CreateDescribeScreenScoreThreadResponse() (response *DescribeScreenScoreThreadResponse) {
	response = &DescribeScreenScoreThreadResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
