package adb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAdviceServiceEnabled invokes the adb.DescribeAdviceServiceEnabled API synchronously
func (client *Client) DescribeAdviceServiceEnabled(request *DescribeAdviceServiceEnabledRequest) (response *DescribeAdviceServiceEnabledResponse, err error) {
	response = CreateDescribeAdviceServiceEnabledResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAdviceServiceEnabledWithChan invokes the adb.DescribeAdviceServiceEnabled API asynchronously
func (client *Client) DescribeAdviceServiceEnabledWithChan(request *DescribeAdviceServiceEnabledRequest) (<-chan *DescribeAdviceServiceEnabledResponse, <-chan error) {
	responseChan := make(chan *DescribeAdviceServiceEnabledResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAdviceServiceEnabled(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAdviceServiceEnabledWithCallback invokes the adb.DescribeAdviceServiceEnabled API asynchronously
func (client *Client) DescribeAdviceServiceEnabledWithCallback(request *DescribeAdviceServiceEnabledRequest, callback func(response *DescribeAdviceServiceEnabledResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAdviceServiceEnabledResponse
		var err error
		defer close(result)
		response, err = client.DescribeAdviceServiceEnabled(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAdviceServiceEnabledRequest is the request struct for api DescribeAdviceServiceEnabled
type DescribeAdviceServiceEnabledRequest struct {
	*requests.RpcRequest
	DBClusterId string `position:"Query" name:"DBClusterId"`
}

// DescribeAdviceServiceEnabledResponse is the response struct for api DescribeAdviceServiceEnabled
type DescribeAdviceServiceEnabledResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    bool   `json:"Result" xml:"Result"`
}

// CreateDescribeAdviceServiceEnabledRequest creates a request to invoke DescribeAdviceServiceEnabled API
func CreateDescribeAdviceServiceEnabledRequest() (request *DescribeAdviceServiceEnabledRequest) {
	request = &DescribeAdviceServiceEnabledRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("adb", "2019-03-15", "DescribeAdviceServiceEnabled", "ads", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeAdviceServiceEnabledResponse creates a response to parse from DescribeAdviceServiceEnabled response
func CreateDescribeAdviceServiceEnabledResponse() (response *DescribeAdviceServiceEnabledResponse) {
	response = &DescribeAdviceServiceEnabledResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
