package adb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AttachUserENI invokes the adb.AttachUserENI API synchronously
func (client *Client) AttachUserENI(request *AttachUserENIRequest) (response *AttachUserENIResponse, err error) {
	response = CreateAttachUserENIResponse()
	err = client.DoAction(request, response)
	return
}

// AttachUserENIWithChan invokes the adb.AttachUserENI API asynchronously
func (client *Client) AttachUserENIWithChan(request *AttachUserENIRequest) (<-chan *AttachUserENIResponse, <-chan error) {
	responseChan := make(chan *AttachUserENIResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AttachUserENI(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AttachUserENIWithCallback invokes the adb.AttachUserENI API asynchronously
func (client *Client) AttachUserENIWithCallback(request *AttachUserENIRequest, callback func(response *AttachUserENIResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AttachUserENIResponse
		var err error
		defer close(result)
		response, err = client.AttachUserENI(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AttachUserENIRequest is the request struct for api AttachUserENI
type AttachUserENIRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// AttachUserENIResponse is the response struct for api AttachUserENI
type AttachUserENIResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAttachUserENIRequest creates a request to invoke AttachUserENI API
func CreateAttachUserENIRequest() (request *AttachUserENIRequest) {
	request = &AttachUserENIRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("adb", "2019-03-15", "AttachUserENI", "ads", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAttachUserENIResponse creates a response to parse from AttachUserENI response
func CreateAttachUserENIResponse() (response *AttachUserENIResponse) {
	response = &AttachUserENIResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
