// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vpc

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opModifySubnetAttributesCommon = "ModifySubnetAttributes"

// ModifySubnetAttributesCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ModifySubnetAttributesCommon operation. The "output" return
// value will be populated with the ModifySubnetAttributesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ModifySubnetAttributesCommon Request to send the API call to the service.
// the "output" return value is not valid until after ModifySubnetAttributesCommon Send returns without error.
//
// See ModifySubnetAttributesCommon for more information on using the ModifySubnetAttributesCommon
// API call, and error handling.
//
//    // Example sending a request using the ModifySubnetAttributesCommonRequest method.
//    req, resp := client.ModifySubnetAttributesCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VPC) ModifySubnetAttributesCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opModifySubnetAttributesCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// ModifySubnetAttributesCommon API operation for VPC.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VPC's
// API operation ModifySubnetAttributesCommon for usage and error information.
func (c *VPC) ModifySubnetAttributesCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ModifySubnetAttributesCommonRequest(input)
	return out, req.Send()
}

// ModifySubnetAttributesCommonWithContext is the same as ModifySubnetAttributesCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ModifySubnetAttributesCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPC) ModifySubnetAttributesCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ModifySubnetAttributesCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifySubnetAttributes = "ModifySubnetAttributes"

// ModifySubnetAttributesRequest generates a "volcengine/request.Request" representing the
// client's request for the ModifySubnetAttributes operation. The "output" return
// value will be populated with the ModifySubnetAttributesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ModifySubnetAttributesCommon Request to send the API call to the service.
// the "output" return value is not valid until after ModifySubnetAttributesCommon Send returns without error.
//
// See ModifySubnetAttributes for more information on using the ModifySubnetAttributes
// API call, and error handling.
//
//    // Example sending a request using the ModifySubnetAttributesRequest method.
//    req, resp := client.ModifySubnetAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VPC) ModifySubnetAttributesRequest(input *ModifySubnetAttributesInput) (req *request.Request, output *ModifySubnetAttributesOutput) {
	op := &request.Operation{
		Name:       opModifySubnetAttributes,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifySubnetAttributesInput{}
	}

	output = &ModifySubnetAttributesOutput{}
	req = c.newRequest(op, input, output)

	return
}

// ModifySubnetAttributes API operation for VPC.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VPC's
// API operation ModifySubnetAttributes for usage and error information.
func (c *VPC) ModifySubnetAttributes(input *ModifySubnetAttributesInput) (*ModifySubnetAttributesOutput, error) {
	req, out := c.ModifySubnetAttributesRequest(input)
	return out, req.Send()
}

// ModifySubnetAttributesWithContext is the same as ModifySubnetAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See ModifySubnetAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPC) ModifySubnetAttributesWithContext(ctx volcengine.Context, input *ModifySubnetAttributesInput, opts ...request.Option) (*ModifySubnetAttributesOutput, error) {
	req, out := c.ModifySubnetAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ModifySubnetAttributesInput struct {
	_ struct{} `type:"structure"`

	Description *string `min:"1" max:"255" type:"string"`

	EnableIpv6 *bool `type:"boolean"`

	Ipv6CidrBlock *int64 `max:"255" type:"integer"`

	// SubnetId is a required field
	SubnetId *string `type:"string" required:"true"`

	SubnetName *string `min:"1" max:"128" type:"string"`
}

// String returns the string representation
func (s ModifySubnetAttributesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifySubnetAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifySubnetAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifySubnetAttributesInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Description != nil && len(*s.Description) > 255 {
		invalidParams.Add(request.NewErrParamMaxLen("Description", 255, *s.Description))
	}
	if s.Ipv6CidrBlock != nil && *s.Ipv6CidrBlock > 255 {
		invalidParams.Add(request.NewErrParamMaxValue("Ipv6CidrBlock", 255))
	}
	if s.SubnetId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetId"))
	}
	if s.SubnetName != nil && len(*s.SubnetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubnetName", 1))
	}
	if s.SubnetName != nil && len(*s.SubnetName) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("SubnetName", 128, *s.SubnetName))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *ModifySubnetAttributesInput) SetDescription(v string) *ModifySubnetAttributesInput {
	s.Description = &v
	return s
}

// SetEnableIpv6 sets the EnableIpv6 field's value.
func (s *ModifySubnetAttributesInput) SetEnableIpv6(v bool) *ModifySubnetAttributesInput {
	s.EnableIpv6 = &v
	return s
}

// SetIpv6CidrBlock sets the Ipv6CidrBlock field's value.
func (s *ModifySubnetAttributesInput) SetIpv6CidrBlock(v int64) *ModifySubnetAttributesInput {
	s.Ipv6CidrBlock = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *ModifySubnetAttributesInput) SetSubnetId(v string) *ModifySubnetAttributesInput {
	s.SubnetId = &v
	return s
}

// SetSubnetName sets the SubnetName field's value.
func (s *ModifySubnetAttributesInput) SetSubnetName(v string) *ModifySubnetAttributesInput {
	s.SubnetName = &v
	return s
}

type ModifySubnetAttributesOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	RequestId *string `type:"string"`
}

// String returns the string representation
func (s ModifySubnetAttributesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifySubnetAttributesOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *ModifySubnetAttributesOutput) SetRequestId(v string) *ModifySubnetAttributesOutput {
	s.RequestId = &v
	return s
}
