// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vpc

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opModifyFlowLogAttributeCommon = "ModifyFlowLogAttribute"

// ModifyFlowLogAttributeCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ModifyFlowLogAttributeCommon operation. The "output" return
// value will be populated with the ModifyFlowLogAttributeCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ModifyFlowLogAttributeCommon Request to send the API call to the service.
// the "output" return value is not valid until after ModifyFlowLogAttributeCommon Send returns without error.
//
// See ModifyFlowLogAttributeCommon for more information on using the ModifyFlowLogAttributeCommon
// API call, and error handling.
//
//    // Example sending a request using the ModifyFlowLogAttributeCommonRequest method.
//    req, resp := client.ModifyFlowLogAttributeCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VPC) ModifyFlowLogAttributeCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opModifyFlowLogAttributeCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// ModifyFlowLogAttributeCommon API operation for VPC.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VPC's
// API operation ModifyFlowLogAttributeCommon for usage and error information.
func (c *VPC) ModifyFlowLogAttributeCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ModifyFlowLogAttributeCommonRequest(input)
	return out, req.Send()
}

// ModifyFlowLogAttributeCommonWithContext is the same as ModifyFlowLogAttributeCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyFlowLogAttributeCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPC) ModifyFlowLogAttributeCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ModifyFlowLogAttributeCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyFlowLogAttribute = "ModifyFlowLogAttribute"

// ModifyFlowLogAttributeRequest generates a "volcengine/request.Request" representing the
// client's request for the ModifyFlowLogAttribute operation. The "output" return
// value will be populated with the ModifyFlowLogAttributeCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ModifyFlowLogAttributeCommon Request to send the API call to the service.
// the "output" return value is not valid until after ModifyFlowLogAttributeCommon Send returns without error.
//
// See ModifyFlowLogAttribute for more information on using the ModifyFlowLogAttribute
// API call, and error handling.
//
//    // Example sending a request using the ModifyFlowLogAttributeRequest method.
//    req, resp := client.ModifyFlowLogAttributeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VPC) ModifyFlowLogAttributeRequest(input *ModifyFlowLogAttributeInput) (req *request.Request, output *ModifyFlowLogAttributeOutput) {
	op := &request.Operation{
		Name:       opModifyFlowLogAttribute,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyFlowLogAttributeInput{}
	}

	output = &ModifyFlowLogAttributeOutput{}
	req = c.newRequest(op, input, output)

	return
}

// ModifyFlowLogAttribute API operation for VPC.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VPC's
// API operation ModifyFlowLogAttribute for usage and error information.
func (c *VPC) ModifyFlowLogAttribute(input *ModifyFlowLogAttributeInput) (*ModifyFlowLogAttributeOutput, error) {
	req, out := c.ModifyFlowLogAttributeRequest(input)
	return out, req.Send()
}

// ModifyFlowLogAttributeWithContext is the same as ModifyFlowLogAttribute with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyFlowLogAttribute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPC) ModifyFlowLogAttributeWithContext(ctx volcengine.Context, input *ModifyFlowLogAttributeInput, opts ...request.Option) (*ModifyFlowLogAttributeOutput, error) {
	req, out := c.ModifyFlowLogAttributeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ModifyFlowLogAttributeInput struct {
	_ struct{} `type:"structure"`

	AggregationInterval *int64 `type:"integer"`

	ClientToken *string `type:"string"`

	Description *string `max:"255" type:"string"`

	// FlowLogId is a required field
	FlowLogId *string `type:"string" required:"true"`

	FlowLogName *string `min:"1" max:"128" type:"string"`
}

// String returns the string representation
func (s ModifyFlowLogAttributeInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyFlowLogAttributeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyFlowLogAttributeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyFlowLogAttributeInput"}
	if s.Description != nil && len(*s.Description) > 255 {
		invalidParams.Add(request.NewErrParamMaxLen("Description", 255, *s.Description))
	}
	if s.FlowLogId == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowLogId"))
	}
	if s.FlowLogName != nil && len(*s.FlowLogName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowLogName", 1))
	}
	if s.FlowLogName != nil && len(*s.FlowLogName) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("FlowLogName", 128, *s.FlowLogName))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAggregationInterval sets the AggregationInterval field's value.
func (s *ModifyFlowLogAttributeInput) SetAggregationInterval(v int64) *ModifyFlowLogAttributeInput {
	s.AggregationInterval = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *ModifyFlowLogAttributeInput) SetClientToken(v string) *ModifyFlowLogAttributeInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ModifyFlowLogAttributeInput) SetDescription(v string) *ModifyFlowLogAttributeInput {
	s.Description = &v
	return s
}

// SetFlowLogId sets the FlowLogId field's value.
func (s *ModifyFlowLogAttributeInput) SetFlowLogId(v string) *ModifyFlowLogAttributeInput {
	s.FlowLogId = &v
	return s
}

// SetFlowLogName sets the FlowLogName field's value.
func (s *ModifyFlowLogAttributeInput) SetFlowLogName(v string) *ModifyFlowLogAttributeInput {
	s.FlowLogName = &v
	return s
}

type ModifyFlowLogAttributeOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	RequestId *string `type:"string"`
}

// String returns the string representation
func (s ModifyFlowLogAttributeOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyFlowLogAttributeOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *ModifyFlowLogAttributeOutput) SetRequestId(v string) *ModifyFlowLogAttributeOutput {
	s.RequestId = &v
	return s
}
