// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package rocketmq

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opModifyAccessKeyAuthorityCommon = "ModifyAccessKeyAuthority"

// ModifyAccessKeyAuthorityCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ModifyAccessKeyAuthorityCommon operation. The "output" return
// value will be populated with the ModifyAccessKeyAuthorityCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ModifyAccessKeyAuthorityCommon Request to send the API call to the service.
// the "output" return value is not valid until after ModifyAccessKeyAuthorityCommon Send returns without error.
//
// See ModifyAccessKeyAuthorityCommon for more information on using the ModifyAccessKeyAuthorityCommon
// API call, and error handling.
//
//    // Example sending a request using the ModifyAccessKeyAuthorityCommonRequest method.
//    req, resp := client.ModifyAccessKeyAuthorityCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ROCKETMQ) ModifyAccessKeyAuthorityCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opModifyAccessKeyAuthorityCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ModifyAccessKeyAuthorityCommon API operation for ROCKETMQ.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ROCKETMQ's
// API operation ModifyAccessKeyAuthorityCommon for usage and error information.
func (c *ROCKETMQ) ModifyAccessKeyAuthorityCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ModifyAccessKeyAuthorityCommonRequest(input)
	return out, req.Send()
}

// ModifyAccessKeyAuthorityCommonWithContext is the same as ModifyAccessKeyAuthorityCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyAccessKeyAuthorityCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ROCKETMQ) ModifyAccessKeyAuthorityCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ModifyAccessKeyAuthorityCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyAccessKeyAuthority = "ModifyAccessKeyAuthority"

// ModifyAccessKeyAuthorityRequest generates a "volcengine/request.Request" representing the
// client's request for the ModifyAccessKeyAuthority operation. The "output" return
// value will be populated with the ModifyAccessKeyAuthorityCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ModifyAccessKeyAuthorityCommon Request to send the API call to the service.
// the "output" return value is not valid until after ModifyAccessKeyAuthorityCommon Send returns without error.
//
// See ModifyAccessKeyAuthority for more information on using the ModifyAccessKeyAuthority
// API call, and error handling.
//
//    // Example sending a request using the ModifyAccessKeyAuthorityRequest method.
//    req, resp := client.ModifyAccessKeyAuthorityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ROCKETMQ) ModifyAccessKeyAuthorityRequest(input *ModifyAccessKeyAuthorityInput) (req *request.Request, output *ModifyAccessKeyAuthorityOutput) {
	op := &request.Operation{
		Name:       opModifyAccessKeyAuthority,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyAccessKeyAuthorityInput{}
	}

	output = &ModifyAccessKeyAuthorityOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ModifyAccessKeyAuthority API operation for ROCKETMQ.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ROCKETMQ's
// API operation ModifyAccessKeyAuthority for usage and error information.
func (c *ROCKETMQ) ModifyAccessKeyAuthority(input *ModifyAccessKeyAuthorityInput) (*ModifyAccessKeyAuthorityOutput, error) {
	req, out := c.ModifyAccessKeyAuthorityRequest(input)
	return out, req.Send()
}

// ModifyAccessKeyAuthorityWithContext is the same as ModifyAccessKeyAuthority with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyAccessKeyAuthority for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ROCKETMQ) ModifyAccessKeyAuthorityWithContext(ctx volcengine.Context, input *ModifyAccessKeyAuthorityInput, opts ...request.Option) (*ModifyAccessKeyAuthorityOutput, error) {
	req, out := c.ModifyAccessKeyAuthorityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AccessPolicyForModifyAccessKeyAuthorityInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Authority *string `min:"3" max:"4" type:"string" json:",omitempty"`

	TopicName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s AccessPolicyForModifyAccessKeyAuthorityInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessPolicyForModifyAccessKeyAuthorityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccessPolicyForModifyAccessKeyAuthorityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AccessPolicyForModifyAccessKeyAuthorityInput"}
	if s.Authority != nil && len(*s.Authority) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Authority", 3))
	}
	if s.Authority != nil && len(*s.Authority) > 4 {
		invalidParams.Add(request.NewErrParamMaxLen("Authority", 4, *s.Authority))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthority sets the Authority field's value.
func (s *AccessPolicyForModifyAccessKeyAuthorityInput) SetAuthority(v string) *AccessPolicyForModifyAccessKeyAuthorityInput {
	s.Authority = &v
	return s
}

// SetTopicName sets the TopicName field's value.
func (s *AccessPolicyForModifyAccessKeyAuthorityInput) SetTopicName(v string) *AccessPolicyForModifyAccessKeyAuthorityInput {
	s.TopicName = &v
	return s
}

type ModifyAccessKeyAuthorityInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// AccessKey is a required field
	AccessKey *string `type:"string" json:",omitempty" required:"true"`

	AccessPolicies []*AccessPolicyForModifyAccessKeyAuthorityInput `type:"list" json:",omitempty"`

	// InstanceId is a required field
	InstanceId *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s ModifyAccessKeyAuthorityInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyAccessKeyAuthorityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyAccessKeyAuthorityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyAccessKeyAuthorityInput"}
	if s.AccessKey == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessKey"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.AccessPolicies != nil {
		for i, v := range s.AccessPolicies {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AccessPolicies", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessKey sets the AccessKey field's value.
func (s *ModifyAccessKeyAuthorityInput) SetAccessKey(v string) *ModifyAccessKeyAuthorityInput {
	s.AccessKey = &v
	return s
}

// SetAccessPolicies sets the AccessPolicies field's value.
func (s *ModifyAccessKeyAuthorityInput) SetAccessPolicies(v []*AccessPolicyForModifyAccessKeyAuthorityInput) *ModifyAccessKeyAuthorityInput {
	s.AccessPolicies = v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *ModifyAccessKeyAuthorityInput) SetInstanceId(v string) *ModifyAccessKeyAuthorityInput {
	s.InstanceId = &v
	return s
}

type ModifyAccessKeyAuthorityOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata
}

// String returns the string representation
func (s ModifyAccessKeyAuthorityOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyAccessKeyAuthorityOutput) GoString() string {
	return s.String()
}
