// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package rocketmq

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opGetInspectConfigCommon = "GetInspectConfig"

// GetInspectConfigCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the GetInspectConfigCommon operation. The "output" return
// value will be populated with the GetInspectConfigCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned GetInspectConfigCommon Request to send the API call to the service.
// the "output" return value is not valid until after GetInspectConfigCommon Send returns without error.
//
// See GetInspectConfigCommon for more information on using the GetInspectConfigCommon
// API call, and error handling.
//
//    // Example sending a request using the GetInspectConfigCommonRequest method.
//    req, resp := client.GetInspectConfigCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ROCKETMQ) GetInspectConfigCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opGetInspectConfigCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// GetInspectConfigCommon API operation for ROCKETMQ.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ROCKETMQ's
// API operation GetInspectConfigCommon for usage and error information.
func (c *ROCKETMQ) GetInspectConfigCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.GetInspectConfigCommonRequest(input)
	return out, req.Send()
}

// GetInspectConfigCommonWithContext is the same as GetInspectConfigCommon with the addition of
// the ability to pass a context and additional request options.
//
// See GetInspectConfigCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ROCKETMQ) GetInspectConfigCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.GetInspectConfigCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInspectConfig = "GetInspectConfig"

// GetInspectConfigRequest generates a "volcengine/request.Request" representing the
// client's request for the GetInspectConfig operation. The "output" return
// value will be populated with the GetInspectConfigCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned GetInspectConfigCommon Request to send the API call to the service.
// the "output" return value is not valid until after GetInspectConfigCommon Send returns without error.
//
// See GetInspectConfig for more information on using the GetInspectConfig
// API call, and error handling.
//
//    // Example sending a request using the GetInspectConfigRequest method.
//    req, resp := client.GetInspectConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ROCKETMQ) GetInspectConfigRequest(input *GetInspectConfigInput) (req *request.Request, output *GetInspectConfigOutput) {
	op := &request.Operation{
		Name:       opGetInspectConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInspectConfigInput{}
	}

	output = &GetInspectConfigOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// GetInspectConfig API operation for ROCKETMQ.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ROCKETMQ's
// API operation GetInspectConfig for usage and error information.
func (c *ROCKETMQ) GetInspectConfig(input *GetInspectConfigInput) (*GetInspectConfigOutput, error) {
	req, out := c.GetInspectConfigRequest(input)
	return out, req.Send()
}

// GetInspectConfigWithContext is the same as GetInspectConfig with the addition of
// the ability to pass a context and additional request options.
//
// See GetInspectConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ROCKETMQ) GetInspectConfigWithContext(ctx volcengine.Context, input *GetInspectConfigInput, opts ...request.Option) (*GetInspectConfigOutput, error) {
	req, out := c.GetInspectConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ConfigForGetInspectConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Configurable *ConfigurableForGetInspectConfigOutput `type:"structure" json:",omitempty"`

	Describe *string `type:"string" json:",omitempty"`

	InspectName *string `type:"string" json:",omitempty"`

	StartInspectTimeStamp *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ConfigForGetInspectConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigForGetInspectConfigOutput) GoString() string {
	return s.String()
}

// SetConfigurable sets the Configurable field's value.
func (s *ConfigForGetInspectConfigOutput) SetConfigurable(v *ConfigurableForGetInspectConfigOutput) *ConfigForGetInspectConfigOutput {
	s.Configurable = v
	return s
}

// SetDescribe sets the Describe field's value.
func (s *ConfigForGetInspectConfigOutput) SetDescribe(v string) *ConfigForGetInspectConfigOutput {
	s.Describe = &v
	return s
}

// SetInspectName sets the InspectName field's value.
func (s *ConfigForGetInspectConfigOutput) SetInspectName(v string) *ConfigForGetInspectConfigOutput {
	s.InspectName = &v
	return s
}

// SetStartInspectTimeStamp sets the StartInspectTimeStamp field's value.
func (s *ConfigForGetInspectConfigOutput) SetStartInspectTimeStamp(v string) *ConfigForGetInspectConfigOutput {
	s.StartInspectTimeStamp = &v
	return s
}

// SetType sets the Type field's value.
func (s *ConfigForGetInspectConfigOutput) SetType(v string) *ConfigForGetInspectConfigOutput {
	s.Type = &v
	return s
}

type ConfigurableForGetInspectConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	Interval *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ConfigurableForGetInspectConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigurableForGetInspectConfigOutput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *ConfigurableForGetInspectConfigOutput) SetEnable(v bool) *ConfigurableForGetInspectConfigOutput {
	s.Enable = &v
	return s
}

// SetInterval sets the Interval field's value.
func (s *ConfigurableForGetInspectConfigOutput) SetInterval(v int32) *ConfigurableForGetInspectConfigOutput {
	s.Interval = &v
	return s
}

type GetInspectConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Filters map[string]*string `type:"map" json:",omitempty"`

	// InstanceId is a required field
	InstanceId *string `type:"string" json:",omitempty" required:"true"`

	// PageNumber is a required field
	PageNumber *int32 `type:"int32" json:",omitempty" required:"true"`

	// PageSize is a required field
	PageSize *int32 `type:"int32" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s GetInspectConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInspectConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInspectConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetInspectConfigInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.PageNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PageNumber"))
	}
	if s.PageSize == nil {
		invalidParams.Add(request.NewErrParamRequired("PageSize"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *GetInspectConfigInput) SetFilters(v map[string]*string) *GetInspectConfigInput {
	s.Filters = v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *GetInspectConfigInput) SetInstanceId(v string) *GetInspectConfigInput {
	s.InstanceId = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *GetInspectConfigInput) SetPageNumber(v int32) *GetInspectConfigInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetInspectConfigInput) SetPageSize(v int32) *GetInspectConfigInput {
	s.PageSize = &v
	return s
}

type GetInspectConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Configs []*ConfigForGetInspectConfigOutput `type:"list" json:",omitempty"`

	InstanceId *string `type:"string" json:",omitempty"`

	Total *int32 `type:"int32" json:",omitempty"`

	TriggerLimit *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s GetInspectConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInspectConfigOutput) GoString() string {
	return s.String()
}

// SetConfigs sets the Configs field's value.
func (s *GetInspectConfigOutput) SetConfigs(v []*ConfigForGetInspectConfigOutput) *GetInspectConfigOutput {
	s.Configs = v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *GetInspectConfigOutput) SetInstanceId(v string) *GetInspectConfigOutput {
	s.InstanceId = &v
	return s
}

// SetTotal sets the Total field's value.
func (s *GetInspectConfigOutput) SetTotal(v int32) *GetInspectConfigOutput {
	s.Total = &v
	return s
}

// SetTriggerLimit sets the TriggerLimit field's value.
func (s *GetInspectConfigOutput) SetTriggerLimit(v int32) *GetInspectConfigOutput {
	s.TriggerLimit = &v
	return s
}
