// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package rdsmysql

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateParameterTemplateCommon = "CreateParameterTemplate"

// CreateParameterTemplateCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateParameterTemplateCommon operation. The "output" return
// value will be populated with the CreateParameterTemplateCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateParameterTemplateCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateParameterTemplateCommon Send returns without error.
//
// See CreateParameterTemplateCommon for more information on using the CreateParameterTemplateCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateParameterTemplateCommonRequest method.
//    req, resp := client.CreateParameterTemplateCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *RDSMYSQL) CreateParameterTemplateCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateParameterTemplateCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateParameterTemplateCommon API operation for RDS_MYSQL.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for RDS_MYSQL's
// API operation CreateParameterTemplateCommon for usage and error information.
func (c *RDSMYSQL) CreateParameterTemplateCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateParameterTemplateCommonRequest(input)
	return out, req.Send()
}

// CreateParameterTemplateCommonWithContext is the same as CreateParameterTemplateCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateParameterTemplateCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDSMYSQL) CreateParameterTemplateCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateParameterTemplateCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateParameterTemplate = "CreateParameterTemplate"

// CreateParameterTemplateRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateParameterTemplate operation. The "output" return
// value will be populated with the CreateParameterTemplateCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateParameterTemplateCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateParameterTemplateCommon Send returns without error.
//
// See CreateParameterTemplate for more information on using the CreateParameterTemplate
// API call, and error handling.
//
//    // Example sending a request using the CreateParameterTemplateRequest method.
//    req, resp := client.CreateParameterTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *RDSMYSQL) CreateParameterTemplateRequest(input *CreateParameterTemplateInput) (req *request.Request, output *CreateParameterTemplateOutput) {
	op := &request.Operation{
		Name:       opCreateParameterTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateParameterTemplateInput{}
	}

	output = &CreateParameterTemplateOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateParameterTemplate API operation for RDS_MYSQL.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for RDS_MYSQL's
// API operation CreateParameterTemplate for usage and error information.
func (c *RDSMYSQL) CreateParameterTemplate(input *CreateParameterTemplateInput) (*CreateParameterTemplateOutput, error) {
	req, out := c.CreateParameterTemplateRequest(input)
	return out, req.Send()
}

// CreateParameterTemplateWithContext is the same as CreateParameterTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateParameterTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDSMYSQL) CreateParameterTemplateWithContext(ctx volcengine.Context, input *CreateParameterTemplateInput, opts ...request.Option) (*CreateParameterTemplateOutput, error) {
	req, out := c.CreateParameterTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateParameterTemplateInput struct {
	_ struct{} `type:"structure"`

	TemplateDesc *string `max:"200" type:"string"`

	TemplateName *string `min:"2" max:"64" type:"string"`

	TemplateParams []*TemplateParamForCreateParameterTemplateInput `type:"list"`

	TemplateType *string `type:"string" enum:"EnumOfTemplateTypeForCreateParameterTemplateInput"`

	TemplateTypeVersion *string `type:"string" enum:"EnumOfTemplateTypeVersionForCreateParameterTemplateInput"`
}

// String returns the string representation
func (s CreateParameterTemplateInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateParameterTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateParameterTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateParameterTemplateInput"}
	if s.TemplateDesc != nil && len(*s.TemplateDesc) > 200 {
		invalidParams.Add(request.NewErrParamMaxLen("TemplateDesc", 200, *s.TemplateDesc))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 2))
	}
	if s.TemplateName != nil && len(*s.TemplateName) > 64 {
		invalidParams.Add(request.NewErrParamMaxLen("TemplateName", 64, *s.TemplateName))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTemplateDesc sets the TemplateDesc field's value.
func (s *CreateParameterTemplateInput) SetTemplateDesc(v string) *CreateParameterTemplateInput {
	s.TemplateDesc = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *CreateParameterTemplateInput) SetTemplateName(v string) *CreateParameterTemplateInput {
	s.TemplateName = &v
	return s
}

// SetTemplateParams sets the TemplateParams field's value.
func (s *CreateParameterTemplateInput) SetTemplateParams(v []*TemplateParamForCreateParameterTemplateInput) *CreateParameterTemplateInput {
	s.TemplateParams = v
	return s
}

// SetTemplateType sets the TemplateType field's value.
func (s *CreateParameterTemplateInput) SetTemplateType(v string) *CreateParameterTemplateInput {
	s.TemplateType = &v
	return s
}

// SetTemplateTypeVersion sets the TemplateTypeVersion field's value.
func (s *CreateParameterTemplateInput) SetTemplateTypeVersion(v string) *CreateParameterTemplateInput {
	s.TemplateTypeVersion = &v
	return s
}

type CreateParameterTemplateOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata
}

// String returns the string representation
func (s CreateParameterTemplateOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateParameterTemplateOutput) GoString() string {
	return s.String()
}

type TemplateParamForCreateParameterTemplateInput struct {
	_ struct{} `type:"structure"`

	DefaultValue *string `type:"string"`

	Description *string `type:"string"`

	ExpectValue *string `type:"string"`

	Name *string `type:"string"`

	Restart *bool `type:"boolean"`

	RunningValue *string `type:"string"`

	ValueRange *string `type:"string"`
}

// String returns the string representation
func (s TemplateParamForCreateParameterTemplateInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TemplateParamForCreateParameterTemplateInput) GoString() string {
	return s.String()
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *TemplateParamForCreateParameterTemplateInput) SetDefaultValue(v string) *TemplateParamForCreateParameterTemplateInput {
	s.DefaultValue = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *TemplateParamForCreateParameterTemplateInput) SetDescription(v string) *TemplateParamForCreateParameterTemplateInput {
	s.Description = &v
	return s
}

// SetExpectValue sets the ExpectValue field's value.
func (s *TemplateParamForCreateParameterTemplateInput) SetExpectValue(v string) *TemplateParamForCreateParameterTemplateInput {
	s.ExpectValue = &v
	return s
}

// SetName sets the Name field's value.
func (s *TemplateParamForCreateParameterTemplateInput) SetName(v string) *TemplateParamForCreateParameterTemplateInput {
	s.Name = &v
	return s
}

// SetRestart sets the Restart field's value.
func (s *TemplateParamForCreateParameterTemplateInput) SetRestart(v bool) *TemplateParamForCreateParameterTemplateInput {
	s.Restart = &v
	return s
}

// SetRunningValue sets the RunningValue field's value.
func (s *TemplateParamForCreateParameterTemplateInput) SetRunningValue(v string) *TemplateParamForCreateParameterTemplateInput {
	s.RunningValue = &v
	return s
}

// SetValueRange sets the ValueRange field's value.
func (s *TemplateParamForCreateParameterTemplateInput) SetValueRange(v string) *TemplateParamForCreateParameterTemplateInput {
	s.ValueRange = &v
	return s
}

const (
	// EnumOfTemplateTypeForCreateParameterTemplateInputMySql is a EnumOfTemplateTypeForCreateParameterTemplateInput enum value
	EnumOfTemplateTypeForCreateParameterTemplateInputMySql = "MySQL"
)

const (
	// EnumOfTemplateTypeVersionForCreateParameterTemplateInputMySql80 is a EnumOfTemplateTypeVersionForCreateParameterTemplateInput enum value
	EnumOfTemplateTypeVersionForCreateParameterTemplateInputMySql80 = "MySQL_8_0"

	// EnumOfTemplateTypeVersionForCreateParameterTemplateInputMySqlCommunity57 is a EnumOfTemplateTypeVersionForCreateParameterTemplateInput enum value
	EnumOfTemplateTypeVersionForCreateParameterTemplateInputMySqlCommunity57 = "MySQL_Community_5_7"
)
