// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package organization

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListTargetsForPolicyCommon = "ListTargetsForPolicy"

// ListTargetsForPolicyCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListTargetsForPolicyCommon operation. The "output" return
// value will be populated with the ListTargetsForPolicyCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListTargetsForPolicyCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListTargetsForPolicyCommon Send returns without error.
//
// See ListTargetsForPolicyCommon for more information on using the ListTargetsForPolicyCommon
// API call, and error handling.
//
//    // Example sending a request using the ListTargetsForPolicyCommonRequest method.
//    req, resp := client.ListTargetsForPolicyCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ORGANIZATION) ListTargetsForPolicyCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListTargetsForPolicyCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListTargetsForPolicyCommon API operation for ORGANIZATION.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ORGANIZATION's
// API operation ListTargetsForPolicyCommon for usage and error information.
func (c *ORGANIZATION) ListTargetsForPolicyCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListTargetsForPolicyCommonRequest(input)
	return out, req.Send()
}

// ListTargetsForPolicyCommonWithContext is the same as ListTargetsForPolicyCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListTargetsForPolicyCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ORGANIZATION) ListTargetsForPolicyCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListTargetsForPolicyCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTargetsForPolicy = "ListTargetsForPolicy"

// ListTargetsForPolicyRequest generates a "volcengine/request.Request" representing the
// client's request for the ListTargetsForPolicy operation. The "output" return
// value will be populated with the ListTargetsForPolicyCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListTargetsForPolicyCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListTargetsForPolicyCommon Send returns without error.
//
// See ListTargetsForPolicy for more information on using the ListTargetsForPolicy
// API call, and error handling.
//
//    // Example sending a request using the ListTargetsForPolicyRequest method.
//    req, resp := client.ListTargetsForPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ORGANIZATION) ListTargetsForPolicyRequest(input *ListTargetsForPolicyInput) (req *request.Request, output *ListTargetsForPolicyOutput) {
	op := &request.Operation{
		Name:       opListTargetsForPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTargetsForPolicyInput{}
	}

	output = &ListTargetsForPolicyOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListTargetsForPolicy API operation for ORGANIZATION.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ORGANIZATION's
// API operation ListTargetsForPolicy for usage and error information.
func (c *ORGANIZATION) ListTargetsForPolicy(input *ListTargetsForPolicyInput) (*ListTargetsForPolicyOutput, error) {
	req, out := c.ListTargetsForPolicyRequest(input)
	return out, req.Send()
}

// ListTargetsForPolicyWithContext is the same as ListTargetsForPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See ListTargetsForPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ORGANIZATION) ListTargetsForPolicyWithContext(ctx volcengine.Context, input *ListTargetsForPolicyInput, opts ...request.Option) (*ListTargetsForPolicyOutput, error) {
	req, out := c.ListTargetsForPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ListTargetsForPolicyInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Limit *int32 `type:"int32" json:",omitempty"`

	Offset *int32 `type:"int32" json:",omitempty"`

	// PolicyID is a required field
	PolicyID *string `type:"string" json:",omitempty" required:"true"`

	SortBy *string `type:"string" json:",omitempty"`

	SortOrder *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ListTargetsForPolicyInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTargetsForPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTargetsForPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTargetsForPolicyInput"}
	if s.PolicyID == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyID"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListTargetsForPolicyInput) SetLimit(v int32) *ListTargetsForPolicyInput {
	s.Limit = &v
	return s
}

// SetOffset sets the Offset field's value.
func (s *ListTargetsForPolicyInput) SetOffset(v int32) *ListTargetsForPolicyInput {
	s.Offset = &v
	return s
}

// SetPolicyID sets the PolicyID field's value.
func (s *ListTargetsForPolicyInput) SetPolicyID(v string) *ListTargetsForPolicyInput {
	s.PolicyID = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListTargetsForPolicyInput) SetSortBy(v string) *ListTargetsForPolicyInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListTargetsForPolicyInput) SetSortOrder(v string) *ListTargetsForPolicyInput {
	s.SortOrder = &v
	return s
}

type ListTargetsForPolicyOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Limit *int32 `type:"int32" json:",omitempty"`

	Offset *int32 `type:"int32" json:",omitempty"`

	Targets []*TargetForListTargetsForPolicyOutput `type:"list" json:",omitempty"`

	Total *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ListTargetsForPolicyOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTargetsForPolicyOutput) GoString() string {
	return s.String()
}

// SetLimit sets the Limit field's value.
func (s *ListTargetsForPolicyOutput) SetLimit(v int32) *ListTargetsForPolicyOutput {
	s.Limit = &v
	return s
}

// SetOffset sets the Offset field's value.
func (s *ListTargetsForPolicyOutput) SetOffset(v int32) *ListTargetsForPolicyOutput {
	s.Offset = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *ListTargetsForPolicyOutput) SetTargets(v []*TargetForListTargetsForPolicyOutput) *ListTargetsForPolicyOutput {
	s.Targets = v
	return s
}

// SetTotal sets the Total field's value.
func (s *ListTargetsForPolicyOutput) SetTotal(v int32) *ListTargetsForPolicyOutput {
	s.Total = &v
	return s
}

type TargetForListTargetsForPolicyOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AttachedTime *string `type:"string" json:",omitempty"`

	TargetID *string `type:"string" json:",omitempty"`

	TargetName *string `type:"string" json:",omitempty"`

	TargetType *string `type:"string" json:",omitempty" enum:"EnumOfTargetTypeForListTargetsForPolicyOutput"`
}

// String returns the string representation
func (s TargetForListTargetsForPolicyOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TargetForListTargetsForPolicyOutput) GoString() string {
	return s.String()
}

// SetAttachedTime sets the AttachedTime field's value.
func (s *TargetForListTargetsForPolicyOutput) SetAttachedTime(v string) *TargetForListTargetsForPolicyOutput {
	s.AttachedTime = &v
	return s
}

// SetTargetID sets the TargetID field's value.
func (s *TargetForListTargetsForPolicyOutput) SetTargetID(v string) *TargetForListTargetsForPolicyOutput {
	s.TargetID = &v
	return s
}

// SetTargetName sets the TargetName field's value.
func (s *TargetForListTargetsForPolicyOutput) SetTargetName(v string) *TargetForListTargetsForPolicyOutput {
	s.TargetName = &v
	return s
}

// SetTargetType sets the TargetType field's value.
func (s *TargetForListTargetsForPolicyOutput) SetTargetType(v string) *TargetForListTargetsForPolicyOutput {
	s.TargetType = &v
	return s
}

const (
	// EnumOfTargetTypeForListTargetsForPolicyOutputOu is a EnumOfTargetTypeForListTargetsForPolicyOutput enum value
	EnumOfTargetTypeForListTargetsForPolicyOutputOu = "OU"

	// EnumOfTargetTypeForListTargetsForPolicyOutputAccount is a EnumOfTargetTypeForListTargetsForPolicyOutput enum value
	EnumOfTargetTypeForListTargetsForPolicyOutputAccount = "Account"
)
