// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package natgateway

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opModifyDnatEntryAttributesCommon = "ModifyDnatEntryAttributes"

// ModifyDnatEntryAttributesCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ModifyDnatEntryAttributesCommon operation. The "output" return
// value will be populated with the ModifyDnatEntryAttributesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ModifyDnatEntryAttributesCommon Request to send the API call to the service.
// the "output" return value is not valid until after ModifyDnatEntryAttributesCommon Send returns without error.
//
// See ModifyDnatEntryAttributesCommon for more information on using the ModifyDnatEntryAttributesCommon
// API call, and error handling.
//
//    // Example sending a request using the ModifyDnatEntryAttributesCommonRequest method.
//    req, resp := client.ModifyDnatEntryAttributesCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *NATGATEWAY) ModifyDnatEntryAttributesCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opModifyDnatEntryAttributesCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// ModifyDnatEntryAttributesCommon API operation for NATGATEWAY.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for NATGATEWAY's
// API operation ModifyDnatEntryAttributesCommon for usage and error information.
func (c *NATGATEWAY) ModifyDnatEntryAttributesCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ModifyDnatEntryAttributesCommonRequest(input)
	return out, req.Send()
}

// ModifyDnatEntryAttributesCommonWithContext is the same as ModifyDnatEntryAttributesCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyDnatEntryAttributesCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NATGATEWAY) ModifyDnatEntryAttributesCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ModifyDnatEntryAttributesCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyDnatEntryAttributes = "ModifyDnatEntryAttributes"

// ModifyDnatEntryAttributesRequest generates a "volcengine/request.Request" representing the
// client's request for the ModifyDnatEntryAttributes operation. The "output" return
// value will be populated with the ModifyDnatEntryAttributesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ModifyDnatEntryAttributesCommon Request to send the API call to the service.
// the "output" return value is not valid until after ModifyDnatEntryAttributesCommon Send returns without error.
//
// See ModifyDnatEntryAttributes for more information on using the ModifyDnatEntryAttributes
// API call, and error handling.
//
//    // Example sending a request using the ModifyDnatEntryAttributesRequest method.
//    req, resp := client.ModifyDnatEntryAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *NATGATEWAY) ModifyDnatEntryAttributesRequest(input *ModifyDnatEntryAttributesInput) (req *request.Request, output *ModifyDnatEntryAttributesOutput) {
	op := &request.Operation{
		Name:       opModifyDnatEntryAttributes,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDnatEntryAttributesInput{}
	}

	output = &ModifyDnatEntryAttributesOutput{}
	req = c.newRequest(op, input, output)

	return
}

// ModifyDnatEntryAttributes API operation for NATGATEWAY.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for NATGATEWAY's
// API operation ModifyDnatEntryAttributes for usage and error information.
func (c *NATGATEWAY) ModifyDnatEntryAttributes(input *ModifyDnatEntryAttributesInput) (*ModifyDnatEntryAttributesOutput, error) {
	req, out := c.ModifyDnatEntryAttributesRequest(input)
	return out, req.Send()
}

// ModifyDnatEntryAttributesWithContext is the same as ModifyDnatEntryAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyDnatEntryAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NATGATEWAY) ModifyDnatEntryAttributesWithContext(ctx volcengine.Context, input *ModifyDnatEntryAttributesInput, opts ...request.Option) (*ModifyDnatEntryAttributesOutput, error) {
	req, out := c.ModifyDnatEntryAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ModifyDnatEntryAttributesInput struct {
	_ struct{} `type:"structure"`

	// DnatEntryId is a required field
	DnatEntryId *string `type:"string" required:"true"`

	DnatEntryName *string `min:"1" max:"128" type:"string"`

	ExternalIp *string `type:"string"`

	ExternalPort *string `type:"string"`

	InternalIp *string `type:"string"`

	InternalPort *string `type:"string"`

	Protocol *string `type:"string"`
}

// String returns the string representation
func (s ModifyDnatEntryAttributesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDnatEntryAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyDnatEntryAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyDnatEntryAttributesInput"}
	if s.DnatEntryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DnatEntryId"))
	}
	if s.DnatEntryName != nil && len(*s.DnatEntryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DnatEntryName", 1))
	}
	if s.DnatEntryName != nil && len(*s.DnatEntryName) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("DnatEntryName", 128, *s.DnatEntryName))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDnatEntryId sets the DnatEntryId field's value.
func (s *ModifyDnatEntryAttributesInput) SetDnatEntryId(v string) *ModifyDnatEntryAttributesInput {
	s.DnatEntryId = &v
	return s
}

// SetDnatEntryName sets the DnatEntryName field's value.
func (s *ModifyDnatEntryAttributesInput) SetDnatEntryName(v string) *ModifyDnatEntryAttributesInput {
	s.DnatEntryName = &v
	return s
}

// SetExternalIp sets the ExternalIp field's value.
func (s *ModifyDnatEntryAttributesInput) SetExternalIp(v string) *ModifyDnatEntryAttributesInput {
	s.ExternalIp = &v
	return s
}

// SetExternalPort sets the ExternalPort field's value.
func (s *ModifyDnatEntryAttributesInput) SetExternalPort(v string) *ModifyDnatEntryAttributesInput {
	s.ExternalPort = &v
	return s
}

// SetInternalIp sets the InternalIp field's value.
func (s *ModifyDnatEntryAttributesInput) SetInternalIp(v string) *ModifyDnatEntryAttributesInput {
	s.InternalIp = &v
	return s
}

// SetInternalPort sets the InternalPort field's value.
func (s *ModifyDnatEntryAttributesInput) SetInternalPort(v string) *ModifyDnatEntryAttributesInput {
	s.InternalPort = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *ModifyDnatEntryAttributesInput) SetProtocol(v string) *ModifyDnatEntryAttributesInput {
	s.Protocol = &v
	return s
}

type ModifyDnatEntryAttributesOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	RequestId *string `type:"string"`
}

// String returns the string representation
func (s ModifyDnatEntryAttributesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDnatEntryAttributesOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *ModifyDnatEntryAttributesOutput) SetRequestId(v string) *ModifyDnatEntryAttributesOutput {
	s.RequestId = &v
	return s
}
