// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDisableKeyRotationCommon = "DisableKeyRotation"

// DisableKeyRotationCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DisableKeyRotationCommon operation. The "output" return
// value will be populated with the DisableKeyRotationCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DisableKeyRotationCommon Request to send the API call to the service.
// the "output" return value is not valid until after DisableKeyRotationCommon Send returns without error.
//
// See DisableKeyRotationCommon for more information on using the DisableKeyRotationCommon
// API call, and error handling.
//
//    // Example sending a request using the DisableKeyRotationCommonRequest method.
//    req, resp := client.DisableKeyRotationCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) DisableKeyRotationCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDisableKeyRotationCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// DisableKeyRotationCommon API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation DisableKeyRotationCommon for usage and error information.
func (c *KMS) DisableKeyRotationCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DisableKeyRotationCommonRequest(input)
	return out, req.Send()
}

// DisableKeyRotationCommonWithContext is the same as DisableKeyRotationCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DisableKeyRotationCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) DisableKeyRotationCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DisableKeyRotationCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableKeyRotation = "DisableKeyRotation"

// DisableKeyRotationRequest generates a "volcengine/request.Request" representing the
// client's request for the DisableKeyRotation operation. The "output" return
// value will be populated with the DisableKeyRotationCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DisableKeyRotationCommon Request to send the API call to the service.
// the "output" return value is not valid until after DisableKeyRotationCommon Send returns without error.
//
// See DisableKeyRotation for more information on using the DisableKeyRotation
// API call, and error handling.
//
//    // Example sending a request using the DisableKeyRotationRequest method.
//    req, resp := client.DisableKeyRotationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) DisableKeyRotationRequest(input *DisableKeyRotationInput) (req *request.Request, output *DisableKeyRotationOutput) {
	op := &request.Operation{
		Name:       opDisableKeyRotation,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableKeyRotationInput{}
	}

	output = &DisableKeyRotationOutput{}
	req = c.newRequest(op, input, output)

	return
}

// DisableKeyRotation API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation DisableKeyRotation for usage and error information.
func (c *KMS) DisableKeyRotation(input *DisableKeyRotationInput) (*DisableKeyRotationOutput, error) {
	req, out := c.DisableKeyRotationRequest(input)
	return out, req.Send()
}

// DisableKeyRotationWithContext is the same as DisableKeyRotation with the addition of
// the ability to pass a context and additional request options.
//
// See DisableKeyRotation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) DisableKeyRotationWithContext(ctx volcengine.Context, input *DisableKeyRotationInput, opts ...request.Option) (*DisableKeyRotationOutput, error) {
	req, out := c.DisableKeyRotationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type DisableKeyRotationInput struct {
	_ struct{} `type:"structure"`

	KeyID *string `type:"string"`

	KeyName *string `min:"2" max:"31" type:"string"`

	KeyringName *string `min:"2" max:"31" type:"string"`
}

// String returns the string representation
func (s DisableKeyRotationInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableKeyRotationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableKeyRotationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableKeyRotationInput"}
	if s.KeyName != nil && len(*s.KeyName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("KeyName", 2))
	}
	if s.KeyName != nil && len(*s.KeyName) > 31 {
		invalidParams.Add(request.NewErrParamMaxLen("KeyName", 31, *s.KeyName))
	}
	if s.KeyringName != nil && len(*s.KeyringName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("KeyringName", 2))
	}
	if s.KeyringName != nil && len(*s.KeyringName) > 31 {
		invalidParams.Add(request.NewErrParamMaxLen("KeyringName", 31, *s.KeyringName))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyID sets the KeyID field's value.
func (s *DisableKeyRotationInput) SetKeyID(v string) *DisableKeyRotationInput {
	s.KeyID = &v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *DisableKeyRotationInput) SetKeyName(v string) *DisableKeyRotationInput {
	s.KeyName = &v
	return s
}

// SetKeyringName sets the KeyringName field's value.
func (s *DisableKeyRotationInput) SetKeyringName(v string) *DisableKeyRotationInput {
	s.KeyringName = &v
	return s
}

type DisableKeyRotationOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata
}

// String returns the string representation
func (s DisableKeyRotationOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableKeyRotationOutput) GoString() string {
	return s.String()
}
