// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package kafka

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDescribeTopicsCommon = "DescribeTopics"

// DescribeTopicsCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeTopicsCommon operation. The "output" return
// value will be populated with the DescribeTopicsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeTopicsCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeTopicsCommon Send returns without error.
//
// See DescribeTopicsCommon for more information on using the DescribeTopicsCommon
// API call, and error handling.
//
//    // Example sending a request using the DescribeTopicsCommonRequest method.
//    req, resp := client.DescribeTopicsCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KAFKA) DescribeTopicsCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDescribeTopicsCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeTopicsCommon API operation for KAFKA.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KAFKA's
// API operation DescribeTopicsCommon for usage and error information.
func (c *KAFKA) DescribeTopicsCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DescribeTopicsCommonRequest(input)
	return out, req.Send()
}

// DescribeTopicsCommonWithContext is the same as DescribeTopicsCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTopicsCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KAFKA) DescribeTopicsCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DescribeTopicsCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTopics = "DescribeTopics"

// DescribeTopicsRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeTopics operation. The "output" return
// value will be populated with the DescribeTopicsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeTopicsCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeTopicsCommon Send returns without error.
//
// See DescribeTopics for more information on using the DescribeTopics
// API call, and error handling.
//
//    // Example sending a request using the DescribeTopicsRequest method.
//    req, resp := client.DescribeTopicsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KAFKA) DescribeTopicsRequest(input *DescribeTopicsInput) (req *request.Request, output *DescribeTopicsOutput) {
	op := &request.Operation{
		Name:       opDescribeTopics,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTopicsInput{}
	}

	output = &DescribeTopicsOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeTopics API operation for KAFKA.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KAFKA's
// API operation DescribeTopics for usage and error information.
func (c *KAFKA) DescribeTopics(input *DescribeTopicsInput) (*DescribeTopicsOutput, error) {
	req, out := c.DescribeTopicsRequest(input)
	return out, req.Send()
}

// DescribeTopicsWithContext is the same as DescribeTopics with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTopics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KAFKA) DescribeTopicsWithContext(ctx volcengine.Context, input *DescribeTopicsInput, opts ...request.Option) (*DescribeTopicsOutput, error) {
	req, out := c.DescribeTopicsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type DescribeTopicsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// InstanceId is a required field
	InstanceId *string `type:"string" json:",omitempty" required:"true"`

	// PageNumber is a required field
	PageNumber *int32 `type:"int32" json:",omitempty" required:"true"`

	// PageSize is a required field
	PageSize *int32 `type:"int32" json:",omitempty" required:"true"`

	PartitionNumber *int32 `type:"int32" json:",omitempty"`

	ReplicaNumber *int32 `type:"int32" json:",omitempty"`

	TagFilters []*TagFilterForDescribeTopicsInput `type:"list" json:",omitempty"`

	TopicName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s DescribeTopicsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTopicsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTopicsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTopicsInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.PageNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PageNumber"))
	}
	if s.PageSize == nil {
		invalidParams.Add(request.NewErrParamRequired("PageSize"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *DescribeTopicsInput) SetInstanceId(v string) *DescribeTopicsInput {
	s.InstanceId = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *DescribeTopicsInput) SetPageNumber(v int32) *DescribeTopicsInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *DescribeTopicsInput) SetPageSize(v int32) *DescribeTopicsInput {
	s.PageSize = &v
	return s
}

// SetPartitionNumber sets the PartitionNumber field's value.
func (s *DescribeTopicsInput) SetPartitionNumber(v int32) *DescribeTopicsInput {
	s.PartitionNumber = &v
	return s
}

// SetReplicaNumber sets the ReplicaNumber field's value.
func (s *DescribeTopicsInput) SetReplicaNumber(v int32) *DescribeTopicsInput {
	s.ReplicaNumber = &v
	return s
}

// SetTagFilters sets the TagFilters field's value.
func (s *DescribeTopicsInput) SetTagFilters(v []*TagFilterForDescribeTopicsInput) *DescribeTopicsInput {
	s.TagFilters = v
	return s
}

// SetTopicName sets the TopicName field's value.
func (s *DescribeTopicsInput) SetTopicName(v string) *DescribeTopicsInput {
	s.TopicName = &v
	return s
}

type DescribeTopicsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	InstanceId *string `type:"string" json:",omitempty"`

	TopicsInfo []*TopicsInfoForDescribeTopicsOutput `type:"list" json:",omitempty"`

	Total *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s DescribeTopicsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTopicsOutput) GoString() string {
	return s.String()
}

// SetInstanceId sets the InstanceId field's value.
func (s *DescribeTopicsOutput) SetInstanceId(v string) *DescribeTopicsOutput {
	s.InstanceId = &v
	return s
}

// SetTopicsInfo sets the TopicsInfo field's value.
func (s *DescribeTopicsOutput) SetTopicsInfo(v []*TopicsInfoForDescribeTopicsOutput) *DescribeTopicsOutput {
	s.TopicsInfo = v
	return s
}

// SetTotal sets the Total field's value.
func (s *DescribeTopicsOutput) SetTotal(v int32) *DescribeTopicsOutput {
	s.Total = &v
	return s
}

type TagFilterForDescribeTopicsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TagFilterForDescribeTopicsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagFilterForDescribeTopicsInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagFilterForDescribeTopicsInput) SetKey(v string) *TagFilterForDescribeTopicsInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagFilterForDescribeTopicsInput) SetValue(v string) *TagFilterForDescribeTopicsInput {
	s.Value = &v
	return s
}

type TagForDescribeTopicsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TagForDescribeTopicsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForDescribeTopicsOutput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForDescribeTopicsOutput) SetKey(v string) *TagForDescribeTopicsOutput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForDescribeTopicsOutput) SetValue(v string) *TagForDescribeTopicsOutput {
	s.Value = &v
	return s
}

type TopicsInfoForDescribeTopicsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CleanupPolicy []*string `type:"list" json:",omitempty"`

	CreateTime *string `type:"string" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	LogRetentionHours *int32 `type:"int32" json:",omitempty"`

	PartitionNumber *int32 `type:"int32" json:",omitempty"`

	ReplicaNumber *int32 `type:"int32" json:",omitempty"`

	Status *string `type:"string" json:",omitempty"`

	Tags []*TagForDescribeTopicsOutput `type:"list" json:",omitempty"`

	TopicName *string `type:"string" json:",omitempty"`

	UsedStoragePercentageInInstance *float64 `type:"double" json:",omitempty"`

	UsedStorageSpaceInBytes *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s TopicsInfoForDescribeTopicsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TopicsInfoForDescribeTopicsOutput) GoString() string {
	return s.String()
}

// SetCleanupPolicy sets the CleanupPolicy field's value.
func (s *TopicsInfoForDescribeTopicsOutput) SetCleanupPolicy(v []*string) *TopicsInfoForDescribeTopicsOutput {
	s.CleanupPolicy = v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *TopicsInfoForDescribeTopicsOutput) SetCreateTime(v string) *TopicsInfoForDescribeTopicsOutput {
	s.CreateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *TopicsInfoForDescribeTopicsOutput) SetDescription(v string) *TopicsInfoForDescribeTopicsOutput {
	s.Description = &v
	return s
}

// SetLogRetentionHours sets the LogRetentionHours field's value.
func (s *TopicsInfoForDescribeTopicsOutput) SetLogRetentionHours(v int32) *TopicsInfoForDescribeTopicsOutput {
	s.LogRetentionHours = &v
	return s
}

// SetPartitionNumber sets the PartitionNumber field's value.
func (s *TopicsInfoForDescribeTopicsOutput) SetPartitionNumber(v int32) *TopicsInfoForDescribeTopicsOutput {
	s.PartitionNumber = &v
	return s
}

// SetReplicaNumber sets the ReplicaNumber field's value.
func (s *TopicsInfoForDescribeTopicsOutput) SetReplicaNumber(v int32) *TopicsInfoForDescribeTopicsOutput {
	s.ReplicaNumber = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *TopicsInfoForDescribeTopicsOutput) SetStatus(v string) *TopicsInfoForDescribeTopicsOutput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TopicsInfoForDescribeTopicsOutput) SetTags(v []*TagForDescribeTopicsOutput) *TopicsInfoForDescribeTopicsOutput {
	s.Tags = v
	return s
}

// SetTopicName sets the TopicName field's value.
func (s *TopicsInfoForDescribeTopicsOutput) SetTopicName(v string) *TopicsInfoForDescribeTopicsOutput {
	s.TopicName = &v
	return s
}

// SetUsedStoragePercentageInInstance sets the UsedStoragePercentageInInstance field's value.
func (s *TopicsInfoForDescribeTopicsOutput) SetUsedStoragePercentageInInstance(v float64) *TopicsInfoForDescribeTopicsOutput {
	s.UsedStoragePercentageInInstance = &v
	return s
}

// SetUsedStorageSpaceInBytes sets the UsedStorageSpaceInBytes field's value.
func (s *TopicsInfoForDescribeTopicsOutput) SetUsedStorageSpaceInBytes(v int64) *TopicsInfoForDescribeTopicsOutput {
	s.UsedStorageSpaceInBytes = &v
	return s
}
