// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opUpdateOAuthProviderCommon = "UpdateOAuthProvider"

// UpdateOAuthProviderCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the UpdateOAuthProviderCommon operation. The "output" return
// value will be populated with the UpdateOAuthProviderCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned UpdateOAuthProviderCommon Request to send the API call to the service.
// the "output" return value is not valid until after UpdateOAuthProviderCommon Send returns without error.
//
// See UpdateOAuthProviderCommon for more information on using the UpdateOAuthProviderCommon
// API call, and error handling.
//
//    // Example sending a request using the UpdateOAuthProviderCommonRequest method.
//    req, resp := client.UpdateOAuthProviderCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IAM) UpdateOAuthProviderCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opUpdateOAuthProviderCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// UpdateOAuthProviderCommon API operation for IAM.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for IAM's
// API operation UpdateOAuthProviderCommon for usage and error information.
func (c *IAM) UpdateOAuthProviderCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.UpdateOAuthProviderCommonRequest(input)
	return out, req.Send()
}

// UpdateOAuthProviderCommonWithContext is the same as UpdateOAuthProviderCommon with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateOAuthProviderCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IAM) UpdateOAuthProviderCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.UpdateOAuthProviderCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateOAuthProvider = "UpdateOAuthProvider"

// UpdateOAuthProviderRequest generates a "volcengine/request.Request" representing the
// client's request for the UpdateOAuthProvider operation. The "output" return
// value will be populated with the UpdateOAuthProviderCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned UpdateOAuthProviderCommon Request to send the API call to the service.
// the "output" return value is not valid until after UpdateOAuthProviderCommon Send returns without error.
//
// See UpdateOAuthProvider for more information on using the UpdateOAuthProvider
// API call, and error handling.
//
//    // Example sending a request using the UpdateOAuthProviderRequest method.
//    req, resp := client.UpdateOAuthProviderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *IAM) UpdateOAuthProviderRequest(input *UpdateOAuthProviderInput) (req *request.Request, output *UpdateOAuthProviderOutput) {
	op := &request.Operation{
		Name:       opUpdateOAuthProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateOAuthProviderInput{}
	}

	output = &UpdateOAuthProviderOutput{}
	req = c.newRequest(op, input, output)

	return
}

// UpdateOAuthProvider API operation for IAM.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for IAM's
// API operation UpdateOAuthProvider for usage and error information.
func (c *IAM) UpdateOAuthProvider(input *UpdateOAuthProviderInput) (*UpdateOAuthProviderOutput, error) {
	req, out := c.UpdateOAuthProviderRequest(input)
	return out, req.Send()
}

// UpdateOAuthProviderWithContext is the same as UpdateOAuthProvider with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateOAuthProvider for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IAM) UpdateOAuthProviderWithContext(ctx volcengine.Context, input *UpdateOAuthProviderInput, opts ...request.Option) (*UpdateOAuthProviderOutput, error) {
	req, out := c.UpdateOAuthProviderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type UpdateOAuthProviderInput struct {
	_ struct{} `type:"structure"`

	AuthorizeTemplate *string `type:"string"`

	AuthorizeURL *string `type:"string"`

	ClientId *string `type:"string"`

	ClientSecret *string `type:"string"`

	Description *string `type:"string"`

	IdentityMapType *int32 `type:"int32"`

	IdpIdentityKey *string `type:"string"`

	// OAuthProviderName is a required field
	OAuthProviderName *string `type:"string" required:"true"`

	Scope *string `type:"string"`

	Status *int32 `type:"int32"`

	TokenURL *string `type:"string"`

	UserInfoURL *string `type:"string"`
}

// String returns the string representation
func (s UpdateOAuthProviderInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateOAuthProviderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateOAuthProviderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateOAuthProviderInput"}
	if s.OAuthProviderName == nil {
		invalidParams.Add(request.NewErrParamRequired("OAuthProviderName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthorizeTemplate sets the AuthorizeTemplate field's value.
func (s *UpdateOAuthProviderInput) SetAuthorizeTemplate(v string) *UpdateOAuthProviderInput {
	s.AuthorizeTemplate = &v
	return s
}

// SetAuthorizeURL sets the AuthorizeURL field's value.
func (s *UpdateOAuthProviderInput) SetAuthorizeURL(v string) *UpdateOAuthProviderInput {
	s.AuthorizeURL = &v
	return s
}

// SetClientId sets the ClientId field's value.
func (s *UpdateOAuthProviderInput) SetClientId(v string) *UpdateOAuthProviderInput {
	s.ClientId = &v
	return s
}

// SetClientSecret sets the ClientSecret field's value.
func (s *UpdateOAuthProviderInput) SetClientSecret(v string) *UpdateOAuthProviderInput {
	s.ClientSecret = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateOAuthProviderInput) SetDescription(v string) *UpdateOAuthProviderInput {
	s.Description = &v
	return s
}

// SetIdentityMapType sets the IdentityMapType field's value.
func (s *UpdateOAuthProviderInput) SetIdentityMapType(v int32) *UpdateOAuthProviderInput {
	s.IdentityMapType = &v
	return s
}

// SetIdpIdentityKey sets the IdpIdentityKey field's value.
func (s *UpdateOAuthProviderInput) SetIdpIdentityKey(v string) *UpdateOAuthProviderInput {
	s.IdpIdentityKey = &v
	return s
}

// SetOAuthProviderName sets the OAuthProviderName field's value.
func (s *UpdateOAuthProviderInput) SetOAuthProviderName(v string) *UpdateOAuthProviderInput {
	s.OAuthProviderName = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *UpdateOAuthProviderInput) SetScope(v string) *UpdateOAuthProviderInput {
	s.Scope = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateOAuthProviderInput) SetStatus(v int32) *UpdateOAuthProviderInput {
	s.Status = &v
	return s
}

// SetTokenURL sets the TokenURL field's value.
func (s *UpdateOAuthProviderInput) SetTokenURL(v string) *UpdateOAuthProviderInput {
	s.TokenURL = &v
	return s
}

// SetUserInfoURL sets the UserInfoURL field's value.
func (s *UpdateOAuthProviderInput) SetUserInfoURL(v string) *UpdateOAuthProviderInput {
	s.UserInfoURL = &v
	return s
}

type UpdateOAuthProviderOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	CreateDate *string `type:"string"`

	Description *string `type:"string"`

	OAuthProviderName *string `type:"string"`

	SSOType *int32 `type:"int32"`

	Status *int32 `type:"int32"`

	Trn *string `type:"string"`

	UpdateDate *string `type:"string"`
}

// String returns the string representation
func (s UpdateOAuthProviderOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateOAuthProviderOutput) GoString() string {
	return s.String()
}

// SetCreateDate sets the CreateDate field's value.
func (s *UpdateOAuthProviderOutput) SetCreateDate(v string) *UpdateOAuthProviderOutput {
	s.CreateDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateOAuthProviderOutput) SetDescription(v string) *UpdateOAuthProviderOutput {
	s.Description = &v
	return s
}

// SetOAuthProviderName sets the OAuthProviderName field's value.
func (s *UpdateOAuthProviderOutput) SetOAuthProviderName(v string) *UpdateOAuthProviderOutput {
	s.OAuthProviderName = &v
	return s
}

// SetSSOType sets the SSOType field's value.
func (s *UpdateOAuthProviderOutput) SetSSOType(v int32) *UpdateOAuthProviderOutput {
	s.SSOType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateOAuthProviderOutput) SetStatus(v int32) *UpdateOAuthProviderOutput {
	s.Status = &v
	return s
}

// SetTrn sets the Trn field's value.
func (s *UpdateOAuthProviderOutput) SetTrn(v string) *UpdateOAuthProviderOutput {
	s.Trn = &v
	return s
}

// SetUpdateDate sets the UpdateDate field's value.
func (s *UpdateOAuthProviderOutput) SetUpdateDate(v string) *UpdateOAuthProviderOutput {
	s.UpdateDate = &v
	return s
}
