// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package cdn

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opUpdateCdnConfigCommon = "UpdateCdnConfig"

// UpdateCdnConfigCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the UpdateCdnConfigCommon operation. The "output" return
// value will be populated with the UpdateCdnConfigCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned UpdateCdnConfigCommon Request to send the API call to the service.
// the "output" return value is not valid until after UpdateCdnConfigCommon Send returns without error.
//
// See UpdateCdnConfigCommon for more information on using the UpdateCdnConfigCommon
// API call, and error handling.
//
//    // Example sending a request using the UpdateCdnConfigCommonRequest method.
//    req, resp := client.UpdateCdnConfigCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CDN) UpdateCdnConfigCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opUpdateCdnConfigCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// UpdateCdnConfigCommon API operation for CDN.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CDN's
// API operation UpdateCdnConfigCommon for usage and error information.
func (c *CDN) UpdateCdnConfigCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.UpdateCdnConfigCommonRequest(input)
	return out, req.Send()
}

// UpdateCdnConfigCommonWithContext is the same as UpdateCdnConfigCommon with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCdnConfigCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CDN) UpdateCdnConfigCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.UpdateCdnConfigCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCdnConfig = "UpdateCdnConfig"

// UpdateCdnConfigRequest generates a "volcengine/request.Request" representing the
// client's request for the UpdateCdnConfig operation. The "output" return
// value will be populated with the UpdateCdnConfigCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned UpdateCdnConfigCommon Request to send the API call to the service.
// the "output" return value is not valid until after UpdateCdnConfigCommon Send returns without error.
//
// See UpdateCdnConfig for more information on using the UpdateCdnConfig
// API call, and error handling.
//
//    // Example sending a request using the UpdateCdnConfigRequest method.
//    req, resp := client.UpdateCdnConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CDN) UpdateCdnConfigRequest(input *UpdateCdnConfigInput) (req *request.Request, output *UpdateCdnConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateCdnConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateCdnConfigInput{}
	}

	output = &UpdateCdnConfigOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// UpdateCdnConfig API operation for CDN.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CDN's
// API operation UpdateCdnConfig for usage and error information.
func (c *CDN) UpdateCdnConfig(input *UpdateCdnConfigInput) (*UpdateCdnConfigOutput, error) {
	req, out := c.UpdateCdnConfigRequest(input)
	return out, req.Send()
}

// UpdateCdnConfigWithContext is the same as UpdateCdnConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCdnConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CDN) UpdateCdnConfigWithContext(ctx volcengine.Context, input *UpdateCdnConfigInput, opts ...request.Option) (*UpdateCdnConfigOutput, error) {
	req, out := c.UpdateCdnConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AccessActionForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	AllowEmpty *bool `type:"boolean"`

	ListRules []*string `type:"list"`

	RequestHeader *string `type:"string"`

	RuleType *string `type:"string"`
}

// String returns the string representation
func (s AccessActionForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessActionForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAllowEmpty sets the AllowEmpty field's value.
func (s *AccessActionForUpdateCdnConfigInput) SetAllowEmpty(v bool) *AccessActionForUpdateCdnConfigInput {
	s.AllowEmpty = &v
	return s
}

// SetListRules sets the ListRules field's value.
func (s *AccessActionForUpdateCdnConfigInput) SetListRules(v []*string) *AccessActionForUpdateCdnConfigInput {
	s.ListRules = v
	return s
}

// SetRequestHeader sets the RequestHeader field's value.
func (s *AccessActionForUpdateCdnConfigInput) SetRequestHeader(v string) *AccessActionForUpdateCdnConfigInput {
	s.RequestHeader = &v
	return s
}

// SetRuleType sets the RuleType field's value.
func (s *AccessActionForUpdateCdnConfigInput) SetRuleType(v string) *AccessActionForUpdateCdnConfigInput {
	s.RuleType = &v
	return s
}

type ActionsForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	OriginLines []*OriginLineForUpdateCdnConfigInput `type:"list"`
}

// String returns the string representation
func (s ActionsForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ActionsForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetOriginLines sets the OriginLines field's value.
func (s *ActionsForUpdateCdnConfigInput) SetOriginLines(v []*OriginLineForUpdateCdnConfigInput) *ActionsForUpdateCdnConfigInput {
	s.OriginLines = v
	return s
}

type AreaAccessRuleForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Area []*string `type:"list"`

	RuleType *string `type:"string"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s AreaAccessRuleForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AreaAccessRuleForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetArea sets the Area field's value.
func (s *AreaAccessRuleForUpdateCdnConfigInput) SetArea(v []*string) *AreaAccessRuleForUpdateCdnConfigInput {
	s.Area = v
	return s
}

// SetRuleType sets the RuleType field's value.
func (s *AreaAccessRuleForUpdateCdnConfigInput) SetRuleType(v string) *AreaAccessRuleForUpdateCdnConfigInput {
	s.RuleType = &v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *AreaAccessRuleForUpdateCdnConfigInput) SetSwitch(v bool) *AreaAccessRuleForUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type AuthModeConfigForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	BackupRemoteAddr *string `type:"string"`

	MasterRemoteAddr *string `type:"string"`

	PathType *string `type:"string"`

	PathValue *string `type:"string"`

	RequestMethod *string `type:"string"`
}

// String returns the string representation
func (s AuthModeConfigForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthModeConfigForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetBackupRemoteAddr sets the BackupRemoteAddr field's value.
func (s *AuthModeConfigForUpdateCdnConfigInput) SetBackupRemoteAddr(v string) *AuthModeConfigForUpdateCdnConfigInput {
	s.BackupRemoteAddr = &v
	return s
}

// SetMasterRemoteAddr sets the MasterRemoteAddr field's value.
func (s *AuthModeConfigForUpdateCdnConfigInput) SetMasterRemoteAddr(v string) *AuthModeConfigForUpdateCdnConfigInput {
	s.MasterRemoteAddr = &v
	return s
}

// SetPathType sets the PathType field's value.
func (s *AuthModeConfigForUpdateCdnConfigInput) SetPathType(v string) *AuthModeConfigForUpdateCdnConfigInput {
	s.PathType = &v
	return s
}

// SetPathValue sets the PathValue field's value.
func (s *AuthModeConfigForUpdateCdnConfigInput) SetPathValue(v string) *AuthModeConfigForUpdateCdnConfigInput {
	s.PathValue = &v
	return s
}

// SetRequestMethod sets the RequestMethod field's value.
func (s *AuthModeConfigForUpdateCdnConfigInput) SetRequestMethod(v string) *AuthModeConfigForUpdateCdnConfigInput {
	s.RequestMethod = &v
	return s
}

type AuthResponseConfigForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	CacheAction *ConvertCacheActionForUpdateCdnConfigInput `type:"structure"`

	ResponseAction *ResponseActionForUpdateCdnConfigInput `type:"structure"`

	StatusCodeAction *StatusCodeActionForUpdateCdnConfigInput `type:"structure"`

	TimeOutAction *TimeOutActionForUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s AuthResponseConfigForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthResponseConfigForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCacheAction sets the CacheAction field's value.
func (s *AuthResponseConfigForUpdateCdnConfigInput) SetCacheAction(v *ConvertCacheActionForUpdateCdnConfigInput) *AuthResponseConfigForUpdateCdnConfigInput {
	s.CacheAction = v
	return s
}

// SetResponseAction sets the ResponseAction field's value.
func (s *AuthResponseConfigForUpdateCdnConfigInput) SetResponseAction(v *ResponseActionForUpdateCdnConfigInput) *AuthResponseConfigForUpdateCdnConfigInput {
	s.ResponseAction = v
	return s
}

// SetStatusCodeAction sets the StatusCodeAction field's value.
func (s *AuthResponseConfigForUpdateCdnConfigInput) SetStatusCodeAction(v *StatusCodeActionForUpdateCdnConfigInput) *AuthResponseConfigForUpdateCdnConfigInput {
	s.StatusCodeAction = v
	return s
}

// SetTimeOutAction sets the TimeOutAction field's value.
func (s *AuthResponseConfigForUpdateCdnConfigInput) SetTimeOutAction(v *TimeOutActionForUpdateCdnConfigInput) *AuthResponseConfigForUpdateCdnConfigInput {
	s.TimeOutAction = v
	return s
}

type BandwidthLimitActionForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	BandwidthThreshold *int64 `type:"int64"`

	LimitType *string `type:"string"`

	SpeedLimitRate *int64 `type:"int64"`

	SpeedLimitRateMax *int64 `type:"int64"`
}

// String returns the string representation
func (s BandwidthLimitActionForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BandwidthLimitActionForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetBandwidthThreshold sets the BandwidthThreshold field's value.
func (s *BandwidthLimitActionForUpdateCdnConfigInput) SetBandwidthThreshold(v int64) *BandwidthLimitActionForUpdateCdnConfigInput {
	s.BandwidthThreshold = &v
	return s
}

// SetLimitType sets the LimitType field's value.
func (s *BandwidthLimitActionForUpdateCdnConfigInput) SetLimitType(v string) *BandwidthLimitActionForUpdateCdnConfigInput {
	s.LimitType = &v
	return s
}

// SetSpeedLimitRate sets the SpeedLimitRate field's value.
func (s *BandwidthLimitActionForUpdateCdnConfigInput) SetSpeedLimitRate(v int64) *BandwidthLimitActionForUpdateCdnConfigInput {
	s.SpeedLimitRate = &v
	return s
}

// SetSpeedLimitRateMax sets the SpeedLimitRateMax field's value.
func (s *BandwidthLimitActionForUpdateCdnConfigInput) SetSpeedLimitRateMax(v int64) *BandwidthLimitActionForUpdateCdnConfigInput {
	s.SpeedLimitRateMax = &v
	return s
}

type BandwidthLimitForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	BandwidthLimitRule *BandwidthLimitRuleForUpdateCdnConfigInput `type:"structure"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s BandwidthLimitForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BandwidthLimitForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetBandwidthLimitRule sets the BandwidthLimitRule field's value.
func (s *BandwidthLimitForUpdateCdnConfigInput) SetBandwidthLimitRule(v *BandwidthLimitRuleForUpdateCdnConfigInput) *BandwidthLimitForUpdateCdnConfigInput {
	s.BandwidthLimitRule = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *BandwidthLimitForUpdateCdnConfigInput) SetSwitch(v bool) *BandwidthLimitForUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type BandwidthLimitRuleForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	BandwidthLimitAction *BandwidthLimitActionForUpdateCdnConfigInput `type:"structure"`

	Condition *ConditionForUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s BandwidthLimitRuleForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BandwidthLimitRuleForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetBandwidthLimitAction sets the BandwidthLimitAction field's value.
func (s *BandwidthLimitRuleForUpdateCdnConfigInput) SetBandwidthLimitAction(v *BandwidthLimitActionForUpdateCdnConfigInput) *BandwidthLimitRuleForUpdateCdnConfigInput {
	s.BandwidthLimitAction = v
	return s
}

// SetCondition sets the Condition field's value.
func (s *BandwidthLimitRuleForUpdateCdnConfigInput) SetCondition(v *ConditionForUpdateCdnConfigInput) *BandwidthLimitRuleForUpdateCdnConfigInput {
	s.Condition = v
	return s
}

type BlockActionForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Action *string `type:"string"`

	ErrorPage *string `type:"string"`

	RedirectUrl *string `type:"string"`

	StatusCode *string `type:"string"`
}

// String returns the string representation
func (s BlockActionForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BlockActionForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *BlockActionForUpdateCdnConfigInput) SetAction(v string) *BlockActionForUpdateCdnConfigInput {
	s.Action = &v
	return s
}

// SetErrorPage sets the ErrorPage field's value.
func (s *BlockActionForUpdateCdnConfigInput) SetErrorPage(v string) *BlockActionForUpdateCdnConfigInput {
	s.ErrorPage = &v
	return s
}

// SetRedirectUrl sets the RedirectUrl field's value.
func (s *BlockActionForUpdateCdnConfigInput) SetRedirectUrl(v string) *BlockActionForUpdateCdnConfigInput {
	s.RedirectUrl = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *BlockActionForUpdateCdnConfigInput) SetStatusCode(v string) *BlockActionForUpdateCdnConfigInput {
	s.StatusCode = &v
	return s
}

type BlockRuleForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	BlockAction *BlockActionForUpdateCdnConfigInput `type:"structure"`

	Condition *ConditionForUpdateCdnConfigInput `type:"structure"`

	RuleName *string `type:"string"`
}

// String returns the string representation
func (s BlockRuleForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BlockRuleForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetBlockAction sets the BlockAction field's value.
func (s *BlockRuleForUpdateCdnConfigInput) SetBlockAction(v *BlockActionForUpdateCdnConfigInput) *BlockRuleForUpdateCdnConfigInput {
	s.BlockAction = v
	return s
}

// SetCondition sets the Condition field's value.
func (s *BlockRuleForUpdateCdnConfigInput) SetCondition(v *ConditionForUpdateCdnConfigInput) *BlockRuleForUpdateCdnConfigInput {
	s.Condition = v
	return s
}

// SetRuleName sets the RuleName field's value.
func (s *BlockRuleForUpdateCdnConfigInput) SetRuleName(v string) *BlockRuleForUpdateCdnConfigInput {
	s.RuleName = &v
	return s
}

type BrowserCacheForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	CacheAction *CacheActionForUpdateCdnConfigInput `type:"structure"`

	Condition *ConditionForUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s BrowserCacheForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BrowserCacheForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCacheAction sets the CacheAction field's value.
func (s *BrowserCacheForUpdateCdnConfigInput) SetCacheAction(v *CacheActionForUpdateCdnConfigInput) *BrowserCacheForUpdateCdnConfigInput {
	s.CacheAction = v
	return s
}

// SetCondition sets the Condition field's value.
func (s *BrowserCacheForUpdateCdnConfigInput) SetCondition(v *ConditionForUpdateCdnConfigInput) *BrowserCacheForUpdateCdnConfigInput {
	s.Condition = v
	return s
}

type CacheActionForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Action *string `type:"string"`

	DefaultPolicy *string `type:"string"`

	IgnoreCase *bool `type:"boolean"`

	Ttl *int64 `type:"int64"`
}

// String returns the string representation
func (s CacheActionForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheActionForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *CacheActionForUpdateCdnConfigInput) SetAction(v string) *CacheActionForUpdateCdnConfigInput {
	s.Action = &v
	return s
}

// SetDefaultPolicy sets the DefaultPolicy field's value.
func (s *CacheActionForUpdateCdnConfigInput) SetDefaultPolicy(v string) *CacheActionForUpdateCdnConfigInput {
	s.DefaultPolicy = &v
	return s
}

// SetIgnoreCase sets the IgnoreCase field's value.
func (s *CacheActionForUpdateCdnConfigInput) SetIgnoreCase(v bool) *CacheActionForUpdateCdnConfigInput {
	s.IgnoreCase = &v
	return s
}

// SetTtl sets the Ttl field's value.
func (s *CacheActionForUpdateCdnConfigInput) SetTtl(v int64) *CacheActionForUpdateCdnConfigInput {
	s.Ttl = &v
	return s
}

type CacheForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	CacheAction *CacheActionForUpdateCdnConfigInput `type:"structure"`

	Condition *ConditionForUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s CacheForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCacheAction sets the CacheAction field's value.
func (s *CacheForUpdateCdnConfigInput) SetCacheAction(v *CacheActionForUpdateCdnConfigInput) *CacheForUpdateCdnConfigInput {
	s.CacheAction = v
	return s
}

// SetCondition sets the Condition field's value.
func (s *CacheForUpdateCdnConfigInput) SetCondition(v *ConditionForUpdateCdnConfigInput) *CacheForUpdateCdnConfigInput {
	s.Condition = v
	return s
}

type CacheHostActionForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	CacheHost *string `type:"string"`
}

// String returns the string representation
func (s CacheHostActionForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheHostActionForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCacheHost sets the CacheHost field's value.
func (s *CacheHostActionForUpdateCdnConfigInput) SetCacheHost(v string) *CacheHostActionForUpdateCdnConfigInput {
	s.CacheHost = &v
	return s
}

type CacheHostForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	CacheHostRule []*CacheHostRuleForUpdateCdnConfigInput `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s CacheHostForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheHostForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCacheHostRule sets the CacheHostRule field's value.
func (s *CacheHostForUpdateCdnConfigInput) SetCacheHostRule(v []*CacheHostRuleForUpdateCdnConfigInput) *CacheHostForUpdateCdnConfigInput {
	s.CacheHostRule = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *CacheHostForUpdateCdnConfigInput) SetSwitch(v bool) *CacheHostForUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type CacheHostRuleForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	CacheHostAction *CacheHostActionForUpdateCdnConfigInput `type:"structure"`

	Condition *ConditionForUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s CacheHostRuleForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheHostRuleForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCacheHostAction sets the CacheHostAction field's value.
func (s *CacheHostRuleForUpdateCdnConfigInput) SetCacheHostAction(v *CacheHostActionForUpdateCdnConfigInput) *CacheHostRuleForUpdateCdnConfigInput {
	s.CacheHostAction = v
	return s
}

// SetCondition sets the Condition field's value.
func (s *CacheHostRuleForUpdateCdnConfigInput) SetCondition(v *ConditionForUpdateCdnConfigInput) *CacheHostRuleForUpdateCdnConfigInput {
	s.Condition = v
	return s
}

type CacheKeyActionForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	CacheKeyComponents []*CacheKeyComponentForUpdateCdnConfigInput `type:"list"`
}

// String returns the string representation
func (s CacheKeyActionForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheKeyActionForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCacheKeyComponents sets the CacheKeyComponents field's value.
func (s *CacheKeyActionForUpdateCdnConfigInput) SetCacheKeyComponents(v []*CacheKeyComponentForUpdateCdnConfigInput) *CacheKeyActionForUpdateCdnConfigInput {
	s.CacheKeyComponents = v
	return s
}

type CacheKeyComponentForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Action *string `type:"string"`

	IgnoreCase *bool `type:"boolean"`

	Object *string `type:"string"`

	Subobject *string `type:"string"`
}

// String returns the string representation
func (s CacheKeyComponentForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheKeyComponentForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *CacheKeyComponentForUpdateCdnConfigInput) SetAction(v string) *CacheKeyComponentForUpdateCdnConfigInput {
	s.Action = &v
	return s
}

// SetIgnoreCase sets the IgnoreCase field's value.
func (s *CacheKeyComponentForUpdateCdnConfigInput) SetIgnoreCase(v bool) *CacheKeyComponentForUpdateCdnConfigInput {
	s.IgnoreCase = &v
	return s
}

// SetObject sets the Object field's value.
func (s *CacheKeyComponentForUpdateCdnConfigInput) SetObject(v string) *CacheKeyComponentForUpdateCdnConfigInput {
	s.Object = &v
	return s
}

// SetSubobject sets the Subobject field's value.
func (s *CacheKeyComponentForUpdateCdnConfigInput) SetSubobject(v string) *CacheKeyComponentForUpdateCdnConfigInput {
	s.Subobject = &v
	return s
}

type CacheKeyForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	CacheKeyAction *CacheKeyActionForUpdateCdnConfigInput `type:"structure"`

	Condition *ConditionForUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s CacheKeyForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheKeyForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCacheKeyAction sets the CacheKeyAction field's value.
func (s *CacheKeyForUpdateCdnConfigInput) SetCacheKeyAction(v *CacheKeyActionForUpdateCdnConfigInput) *CacheKeyForUpdateCdnConfigInput {
	s.CacheKeyAction = v
	return s
}

// SetCondition sets the Condition field's value.
func (s *CacheKeyForUpdateCdnConfigInput) SetCondition(v *ConditionForUpdateCdnConfigInput) *CacheKeyForUpdateCdnConfigInput {
	s.Condition = v
	return s
}

type CertCheckForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	CertInfoList []*CertInfoListForUpdateCdnConfigInput `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s CertCheckForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CertCheckForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCertInfoList sets the CertInfoList field's value.
func (s *CertCheckForUpdateCdnConfigInput) SetCertInfoList(v []*CertInfoListForUpdateCdnConfigInput) *CertCheckForUpdateCdnConfigInput {
	s.CertInfoList = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *CertCheckForUpdateCdnConfigInput) SetSwitch(v bool) *CertCheckForUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type CertInfoForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	CertId *string `type:"string"`

	CertName *string `type:"string"`

	Certificate *CertificateForUpdateCdnConfigInput `type:"structure"`

	Desc *string `type:"string"`

	EffectiveTime *int64 `type:"int64"`

	EncryType *string `type:"string"`

	ExpireTime *int64 `type:"int64"`

	Source *string `type:"string"`
}

// String returns the string representation
func (s CertInfoForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CertInfoForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCertId sets the CertId field's value.
func (s *CertInfoForUpdateCdnConfigInput) SetCertId(v string) *CertInfoForUpdateCdnConfigInput {
	s.CertId = &v
	return s
}

// SetCertName sets the CertName field's value.
func (s *CertInfoForUpdateCdnConfigInput) SetCertName(v string) *CertInfoForUpdateCdnConfigInput {
	s.CertName = &v
	return s
}

// SetCertificate sets the Certificate field's value.
func (s *CertInfoForUpdateCdnConfigInput) SetCertificate(v *CertificateForUpdateCdnConfigInput) *CertInfoForUpdateCdnConfigInput {
	s.Certificate = v
	return s
}

// SetDesc sets the Desc field's value.
func (s *CertInfoForUpdateCdnConfigInput) SetDesc(v string) *CertInfoForUpdateCdnConfigInput {
	s.Desc = &v
	return s
}

// SetEffectiveTime sets the EffectiveTime field's value.
func (s *CertInfoForUpdateCdnConfigInput) SetEffectiveTime(v int64) *CertInfoForUpdateCdnConfigInput {
	s.EffectiveTime = &v
	return s
}

// SetEncryType sets the EncryType field's value.
func (s *CertInfoForUpdateCdnConfigInput) SetEncryType(v string) *CertInfoForUpdateCdnConfigInput {
	s.EncryType = &v
	return s
}

// SetExpireTime sets the ExpireTime field's value.
func (s *CertInfoForUpdateCdnConfigInput) SetExpireTime(v int64) *CertInfoForUpdateCdnConfigInput {
	s.ExpireTime = &v
	return s
}

// SetSource sets the Source field's value.
func (s *CertInfoForUpdateCdnConfigInput) SetSource(v string) *CertInfoForUpdateCdnConfigInput {
	s.Source = &v
	return s
}

type CertInfoListForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	CertId *string `type:"string"`

	CertName *string `type:"string"`

	Certificate *CertificateForUpdateCdnConfigInput `type:"structure"`

	Desc *string `type:"string"`

	EffectiveTime *int64 `type:"int64"`

	EncryType *string `type:"string"`

	ExpireTime *int64 `type:"int64"`

	Source *string `type:"string"`
}

// String returns the string representation
func (s CertInfoListForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CertInfoListForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCertId sets the CertId field's value.
func (s *CertInfoListForUpdateCdnConfigInput) SetCertId(v string) *CertInfoListForUpdateCdnConfigInput {
	s.CertId = &v
	return s
}

// SetCertName sets the CertName field's value.
func (s *CertInfoListForUpdateCdnConfigInput) SetCertName(v string) *CertInfoListForUpdateCdnConfigInput {
	s.CertName = &v
	return s
}

// SetCertificate sets the Certificate field's value.
func (s *CertInfoListForUpdateCdnConfigInput) SetCertificate(v *CertificateForUpdateCdnConfigInput) *CertInfoListForUpdateCdnConfigInput {
	s.Certificate = v
	return s
}

// SetDesc sets the Desc field's value.
func (s *CertInfoListForUpdateCdnConfigInput) SetDesc(v string) *CertInfoListForUpdateCdnConfigInput {
	s.Desc = &v
	return s
}

// SetEffectiveTime sets the EffectiveTime field's value.
func (s *CertInfoListForUpdateCdnConfigInput) SetEffectiveTime(v int64) *CertInfoListForUpdateCdnConfigInput {
	s.EffectiveTime = &v
	return s
}

// SetEncryType sets the EncryType field's value.
func (s *CertInfoListForUpdateCdnConfigInput) SetEncryType(v string) *CertInfoListForUpdateCdnConfigInput {
	s.EncryType = &v
	return s
}

// SetExpireTime sets the ExpireTime field's value.
func (s *CertInfoListForUpdateCdnConfigInput) SetExpireTime(v int64) *CertInfoListForUpdateCdnConfigInput {
	s.ExpireTime = &v
	return s
}

// SetSource sets the Source field's value.
func (s *CertInfoListForUpdateCdnConfigInput) SetSource(v string) *CertInfoListForUpdateCdnConfigInput {
	s.Source = &v
	return s
}

type CertificateForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Certificate *string `type:"string"`

	EncryptionCert *string `type:"string"`

	EncryptionKey *string `type:"string"`

	PrivateKey *string `type:"string"`
}

// String returns the string representation
func (s CertificateForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CertificateForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCertificate sets the Certificate field's value.
func (s *CertificateForUpdateCdnConfigInput) SetCertificate(v string) *CertificateForUpdateCdnConfigInput {
	s.Certificate = &v
	return s
}

// SetEncryptionCert sets the EncryptionCert field's value.
func (s *CertificateForUpdateCdnConfigInput) SetEncryptionCert(v string) *CertificateForUpdateCdnConfigInput {
	s.EncryptionCert = &v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *CertificateForUpdateCdnConfigInput) SetEncryptionKey(v string) *CertificateForUpdateCdnConfigInput {
	s.EncryptionKey = &v
	return s
}

// SetPrivateKey sets the PrivateKey field's value.
func (s *CertificateForUpdateCdnConfigInput) SetPrivateKey(v string) *CertificateForUpdateCdnConfigInput {
	s.PrivateKey = &v
	return s
}

type CommonTypeForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	IgnoreCase *bool `type:"boolean"`

	IgnoreScheme *bool `type:"boolean"`

	Referers []*string `type:"list"`
}

// String returns the string representation
func (s CommonTypeForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CommonTypeForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetIgnoreCase sets the IgnoreCase field's value.
func (s *CommonTypeForUpdateCdnConfigInput) SetIgnoreCase(v bool) *CommonTypeForUpdateCdnConfigInput {
	s.IgnoreCase = &v
	return s
}

// SetIgnoreScheme sets the IgnoreScheme field's value.
func (s *CommonTypeForUpdateCdnConfigInput) SetIgnoreScheme(v bool) *CommonTypeForUpdateCdnConfigInput {
	s.IgnoreScheme = &v
	return s
}

// SetReferers sets the Referers field's value.
func (s *CommonTypeForUpdateCdnConfigInput) SetReferers(v []*string) *CommonTypeForUpdateCdnConfigInput {
	s.Referers = v
	return s
}

type CompressionActionForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	CompressionFormat *string `type:"string"`

	CompressionTarget *string `type:"string"`

	CompressionType []*string `type:"list"`

	MinFileSizeKB *int64 `type:"int64"`
}

// String returns the string representation
func (s CompressionActionForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CompressionActionForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCompressionFormat sets the CompressionFormat field's value.
func (s *CompressionActionForUpdateCdnConfigInput) SetCompressionFormat(v string) *CompressionActionForUpdateCdnConfigInput {
	s.CompressionFormat = &v
	return s
}

// SetCompressionTarget sets the CompressionTarget field's value.
func (s *CompressionActionForUpdateCdnConfigInput) SetCompressionTarget(v string) *CompressionActionForUpdateCdnConfigInput {
	s.CompressionTarget = &v
	return s
}

// SetCompressionType sets the CompressionType field's value.
func (s *CompressionActionForUpdateCdnConfigInput) SetCompressionType(v []*string) *CompressionActionForUpdateCdnConfigInput {
	s.CompressionType = v
	return s
}

// SetMinFileSizeKB sets the MinFileSizeKB field's value.
func (s *CompressionActionForUpdateCdnConfigInput) SetMinFileSizeKB(v int64) *CompressionActionForUpdateCdnConfigInput {
	s.MinFileSizeKB = &v
	return s
}

type CompressionForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	CompressionRules []*CompressionRuleForUpdateCdnConfigInput `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s CompressionForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CompressionForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCompressionRules sets the CompressionRules field's value.
func (s *CompressionForUpdateCdnConfigInput) SetCompressionRules(v []*CompressionRuleForUpdateCdnConfigInput) *CompressionForUpdateCdnConfigInput {
	s.CompressionRules = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *CompressionForUpdateCdnConfigInput) SetSwitch(v bool) *CompressionForUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type CompressionRuleForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	CompressionAction *CompressionActionForUpdateCdnConfigInput `type:"structure"`

	Condition *ConditionForUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s CompressionRuleForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CompressionRuleForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCompressionAction sets the CompressionAction field's value.
func (s *CompressionRuleForUpdateCdnConfigInput) SetCompressionAction(v *CompressionActionForUpdateCdnConfigInput) *CompressionRuleForUpdateCdnConfigInput {
	s.CompressionAction = v
	return s
}

// SetCondition sets the Condition field's value.
func (s *CompressionRuleForUpdateCdnConfigInput) SetCondition(v *ConditionForUpdateCdnConfigInput) *CompressionRuleForUpdateCdnConfigInput {
	s.Condition = v
	return s
}

type ConditionForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	ConditionRule []*ConditionRuleForUpdateCdnConfigInput `type:"list"`

	Connective *string `type:"string"`
}

// String returns the string representation
func (s ConditionForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConditionForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetConditionRule sets the ConditionRule field's value.
func (s *ConditionForUpdateCdnConfigInput) SetConditionRule(v []*ConditionRuleForUpdateCdnConfigInput) *ConditionForUpdateCdnConfigInput {
	s.ConditionRule = v
	return s
}

// SetConnective sets the Connective field's value.
func (s *ConditionForUpdateCdnConfigInput) SetConnective(v string) *ConditionForUpdateCdnConfigInput {
	s.Connective = &v
	return s
}

type ConditionGroupForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Condition *ConvertConditionForUpdateCdnConfigInput `type:"structure"`

	IsGroup *bool `type:"boolean"`
}

// String returns the string representation
func (s ConditionGroupForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConditionGroupForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *ConditionGroupForUpdateCdnConfigInput) SetCondition(v *ConvertConditionForUpdateCdnConfigInput) *ConditionGroupForUpdateCdnConfigInput {
	s.Condition = v
	return s
}

// SetIsGroup sets the IsGroup field's value.
func (s *ConditionGroupForUpdateCdnConfigInput) SetIsGroup(v bool) *ConditionGroupForUpdateCdnConfigInput {
	s.IsGroup = &v
	return s
}

type ConditionRuleForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Name *string `type:"string"`

	Object *string `type:"string"`

	Operator *string `type:"string"`

	Type *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s ConditionRuleForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConditionRuleForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *ConditionRuleForUpdateCdnConfigInput) SetName(v string) *ConditionRuleForUpdateCdnConfigInput {
	s.Name = &v
	return s
}

// SetObject sets the Object field's value.
func (s *ConditionRuleForUpdateCdnConfigInput) SetObject(v string) *ConditionRuleForUpdateCdnConfigInput {
	s.Object = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *ConditionRuleForUpdateCdnConfigInput) SetOperator(v string) *ConditionRuleForUpdateCdnConfigInput {
	s.Operator = &v
	return s
}

// SetType sets the Type field's value.
func (s *ConditionRuleForUpdateCdnConfigInput) SetType(v string) *ConditionRuleForUpdateCdnConfigInput {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ConditionRuleForUpdateCdnConfigInput) SetValue(v string) *ConditionRuleForUpdateCdnConfigInput {
	s.Value = &v
	return s
}

type ConditionalOriginForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	OriginRules []*OriginRuleForUpdateCdnConfigInput `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s ConditionalOriginForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConditionalOriginForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetOriginRules sets the OriginRules field's value.
func (s *ConditionalOriginForUpdateCdnConfigInput) SetOriginRules(v []*OriginRuleForUpdateCdnConfigInput) *ConditionalOriginForUpdateCdnConfigInput {
	s.OriginRules = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *ConditionalOriginForUpdateCdnConfigInput) SetSwitch(v bool) *ConditionalOriginForUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type ConvertCacheActionForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Action *string `type:"string"`

	CacheKey []*string `type:"list"`

	IgnoreCase *bool `type:"boolean"`

	Ttl *int64 `type:"int64"`
}

// String returns the string representation
func (s ConvertCacheActionForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertCacheActionForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *ConvertCacheActionForUpdateCdnConfigInput) SetAction(v string) *ConvertCacheActionForUpdateCdnConfigInput {
	s.Action = &v
	return s
}

// SetCacheKey sets the CacheKey field's value.
func (s *ConvertCacheActionForUpdateCdnConfigInput) SetCacheKey(v []*string) *ConvertCacheActionForUpdateCdnConfigInput {
	s.CacheKey = v
	return s
}

// SetIgnoreCase sets the IgnoreCase field's value.
func (s *ConvertCacheActionForUpdateCdnConfigInput) SetIgnoreCase(v bool) *ConvertCacheActionForUpdateCdnConfigInput {
	s.IgnoreCase = &v
	return s
}

// SetTtl sets the Ttl field's value.
func (s *ConvertCacheActionForUpdateCdnConfigInput) SetTtl(v int64) *ConvertCacheActionForUpdateCdnConfigInput {
	s.Ttl = &v
	return s
}

type ConvertConditionForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Object *string `type:"string"`

	Operator *string `type:"string"`

	Value []*string `type:"list"`
}

// String returns the string representation
func (s ConvertConditionForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertConditionForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetObject sets the Object field's value.
func (s *ConvertConditionForUpdateCdnConfigInput) SetObject(v string) *ConvertConditionForUpdateCdnConfigInput {
	s.Object = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *ConvertConditionForUpdateCdnConfigInput) SetOperator(v string) *ConvertConditionForUpdateCdnConfigInput {
	s.Operator = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ConvertConditionForUpdateCdnConfigInput) SetValue(v []*string) *ConvertConditionForUpdateCdnConfigInput {
	s.Value = v
	return s
}

type ConvertConvertConditionForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	ConditionGroups []*ConditionGroupForUpdateCdnConfigInput `type:"list"`

	Connective *string `type:"string"`

	IsGroup *bool `type:"boolean"`
}

// String returns the string representation
func (s ConvertConvertConditionForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertConvertConditionForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetConditionGroups sets the ConditionGroups field's value.
func (s *ConvertConvertConditionForUpdateCdnConfigInput) SetConditionGroups(v []*ConditionGroupForUpdateCdnConfigInput) *ConvertConvertConditionForUpdateCdnConfigInput {
	s.ConditionGroups = v
	return s
}

// SetConnective sets the Connective field's value.
func (s *ConvertConvertConditionForUpdateCdnConfigInput) SetConnective(v string) *ConvertConvertConditionForUpdateCdnConfigInput {
	s.Connective = &v
	return s
}

// SetIsGroup sets the IsGroup field's value.
func (s *ConvertConvertConditionForUpdateCdnConfigInput) SetIsGroup(v bool) *ConvertConvertConditionForUpdateCdnConfigInput {
	s.IsGroup = &v
	return s
}

type ConvertOriginLineForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Address *string `type:"string"`

	BucketName *string `type:"string"`

	HttpPort *string `type:"string"`

	HttpsPort *string `type:"string"`

	InstanceType *string `type:"string"`

	OriginHost *string `type:"string"`

	OriginType *string `type:"string"`

	PrivateBucketAccess *bool `type:"boolean"`

	PrivateBucketAuth *PrivateBucketAuthForUpdateCdnConfigInput `type:"structure"`

	Region *string `type:"string"`

	Weight *string `type:"string"`
}

// String returns the string representation
func (s ConvertOriginLineForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertOriginLineForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *ConvertOriginLineForUpdateCdnConfigInput) SetAddress(v string) *ConvertOriginLineForUpdateCdnConfigInput {
	s.Address = &v
	return s
}

// SetBucketName sets the BucketName field's value.
func (s *ConvertOriginLineForUpdateCdnConfigInput) SetBucketName(v string) *ConvertOriginLineForUpdateCdnConfigInput {
	s.BucketName = &v
	return s
}

// SetHttpPort sets the HttpPort field's value.
func (s *ConvertOriginLineForUpdateCdnConfigInput) SetHttpPort(v string) *ConvertOriginLineForUpdateCdnConfigInput {
	s.HttpPort = &v
	return s
}

// SetHttpsPort sets the HttpsPort field's value.
func (s *ConvertOriginLineForUpdateCdnConfigInput) SetHttpsPort(v string) *ConvertOriginLineForUpdateCdnConfigInput {
	s.HttpsPort = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *ConvertOriginLineForUpdateCdnConfigInput) SetInstanceType(v string) *ConvertOriginLineForUpdateCdnConfigInput {
	s.InstanceType = &v
	return s
}

// SetOriginHost sets the OriginHost field's value.
func (s *ConvertOriginLineForUpdateCdnConfigInput) SetOriginHost(v string) *ConvertOriginLineForUpdateCdnConfigInput {
	s.OriginHost = &v
	return s
}

// SetOriginType sets the OriginType field's value.
func (s *ConvertOriginLineForUpdateCdnConfigInput) SetOriginType(v string) *ConvertOriginLineForUpdateCdnConfigInput {
	s.OriginType = &v
	return s
}

// SetPrivateBucketAccess sets the PrivateBucketAccess field's value.
func (s *ConvertOriginLineForUpdateCdnConfigInput) SetPrivateBucketAccess(v bool) *ConvertOriginLineForUpdateCdnConfigInput {
	s.PrivateBucketAccess = &v
	return s
}

// SetPrivateBucketAuth sets the PrivateBucketAuth field's value.
func (s *ConvertOriginLineForUpdateCdnConfigInput) SetPrivateBucketAuth(v *PrivateBucketAuthForUpdateCdnConfigInput) *ConvertOriginLineForUpdateCdnConfigInput {
	s.PrivateBucketAuth = v
	return s
}

// SetRegion sets the Region field's value.
func (s *ConvertOriginLineForUpdateCdnConfigInput) SetRegion(v string) *ConvertOriginLineForUpdateCdnConfigInput {
	s.Region = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *ConvertOriginLineForUpdateCdnConfigInput) SetWeight(v string) *ConvertOriginLineForUpdateCdnConfigInput {
	s.Weight = &v
	return s
}

type ConvertTimeoutActionForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	HttpTimeout *int64 `type:"int64"`

	TcpTimeout *int64 `type:"int64"`
}

// String returns the string representation
func (s ConvertTimeoutActionForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertTimeoutActionForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetHttpTimeout sets the HttpTimeout field's value.
func (s *ConvertTimeoutActionForUpdateCdnConfigInput) SetHttpTimeout(v int64) *ConvertTimeoutActionForUpdateCdnConfigInput {
	s.HttpTimeout = &v
	return s
}

// SetTcpTimeout sets the TcpTimeout field's value.
func (s *ConvertTimeoutActionForUpdateCdnConfigInput) SetTcpTimeout(v int64) *ConvertTimeoutActionForUpdateCdnConfigInput {
	s.TcpTimeout = &v
	return s
}

type CustomErrorPageForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	ErrorPageRule []*ErrorPageRuleForUpdateCdnConfigInput `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s CustomErrorPageForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomErrorPageForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetErrorPageRule sets the ErrorPageRule field's value.
func (s *CustomErrorPageForUpdateCdnConfigInput) SetErrorPageRule(v []*ErrorPageRuleForUpdateCdnConfigInput) *CustomErrorPageForUpdateCdnConfigInput {
	s.ErrorPageRule = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *CustomErrorPageForUpdateCdnConfigInput) SetSwitch(v bool) *CustomErrorPageForUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type CustomVariableInstanceForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Operator *string `type:"string"`

	Type *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s CustomVariableInstanceForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomVariableInstanceForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetOperator sets the Operator field's value.
func (s *CustomVariableInstanceForUpdateCdnConfigInput) SetOperator(v string) *CustomVariableInstanceForUpdateCdnConfigInput {
	s.Operator = &v
	return s
}

// SetType sets the Type field's value.
func (s *CustomVariableInstanceForUpdateCdnConfigInput) SetType(v string) *CustomVariableInstanceForUpdateCdnConfigInput {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *CustomVariableInstanceForUpdateCdnConfigInput) SetValue(v string) *CustomVariableInstanceForUpdateCdnConfigInput {
	s.Value = &v
	return s
}

type CustomVariableRulesForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	CustomVariableInstances []*CustomVariableInstanceForUpdateCdnConfigInput `type:"list"`
}

// String returns the string representation
func (s CustomVariableRulesForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomVariableRulesForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCustomVariableInstances sets the CustomVariableInstances field's value.
func (s *CustomVariableRulesForUpdateCdnConfigInput) SetCustomVariableInstances(v []*CustomVariableInstanceForUpdateCdnConfigInput) *CustomVariableRulesForUpdateCdnConfigInput {
	s.CustomVariableInstances = v
	return s
}

type CustomizeAccessRuleForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	CustomizeInstances []*CustomizeInstanceForUpdateCdnConfigInput `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s CustomizeAccessRuleForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomizeAccessRuleForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCustomizeInstances sets the CustomizeInstances field's value.
func (s *CustomizeAccessRuleForUpdateCdnConfigInput) SetCustomizeInstances(v []*CustomizeInstanceForUpdateCdnConfigInput) *CustomizeAccessRuleForUpdateCdnConfigInput {
	s.CustomizeInstances = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *CustomizeAccessRuleForUpdateCdnConfigInput) SetSwitch(v bool) *CustomizeAccessRuleForUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type CustomizeInstanceForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	CustomizeRule *CustomizeRuleForUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s CustomizeInstanceForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomizeInstanceForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCustomizeRule sets the CustomizeRule field's value.
func (s *CustomizeInstanceForUpdateCdnConfigInput) SetCustomizeRule(v *CustomizeRuleForUpdateCdnConfigInput) *CustomizeInstanceForUpdateCdnConfigInput {
	s.CustomizeRule = v
	return s
}

type CustomizeRuleForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	AccessAction *AccessActionForUpdateCdnConfigInput `type:"structure"`

	Condition *ConditionForUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s CustomizeRuleForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomizeRuleForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAccessAction sets the AccessAction field's value.
func (s *CustomizeRuleForUpdateCdnConfigInput) SetAccessAction(v *AccessActionForUpdateCdnConfigInput) *CustomizeRuleForUpdateCdnConfigInput {
	s.AccessAction = v
	return s
}

// SetCondition sets the Condition field's value.
func (s *CustomizeRuleForUpdateCdnConfigInput) SetCondition(v *ConditionForUpdateCdnConfigInput) *CustomizeRuleForUpdateCdnConfigInput {
	s.Condition = v
	return s
}

type DownloadSpeedLimitActionForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	SpeedLimitRate *int64 `type:"int64"`

	SpeedLimitRateAfter *int64 `type:"int64"`

	SpeedLimitTime *SpeedLimitTimeForUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s DownloadSpeedLimitActionForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DownloadSpeedLimitActionForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetSpeedLimitRate sets the SpeedLimitRate field's value.
func (s *DownloadSpeedLimitActionForUpdateCdnConfigInput) SetSpeedLimitRate(v int64) *DownloadSpeedLimitActionForUpdateCdnConfigInput {
	s.SpeedLimitRate = &v
	return s
}

// SetSpeedLimitRateAfter sets the SpeedLimitRateAfter field's value.
func (s *DownloadSpeedLimitActionForUpdateCdnConfigInput) SetSpeedLimitRateAfter(v int64) *DownloadSpeedLimitActionForUpdateCdnConfigInput {
	s.SpeedLimitRateAfter = &v
	return s
}

// SetSpeedLimitTime sets the SpeedLimitTime field's value.
func (s *DownloadSpeedLimitActionForUpdateCdnConfigInput) SetSpeedLimitTime(v *SpeedLimitTimeForUpdateCdnConfigInput) *DownloadSpeedLimitActionForUpdateCdnConfigInput {
	s.SpeedLimitTime = v
	return s
}

type DownloadSpeedLimitForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	DownloadSpeedLimitRules []*DownloadSpeedLimitRuleForUpdateCdnConfigInput `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s DownloadSpeedLimitForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DownloadSpeedLimitForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetDownloadSpeedLimitRules sets the DownloadSpeedLimitRules field's value.
func (s *DownloadSpeedLimitForUpdateCdnConfigInput) SetDownloadSpeedLimitRules(v []*DownloadSpeedLimitRuleForUpdateCdnConfigInput) *DownloadSpeedLimitForUpdateCdnConfigInput {
	s.DownloadSpeedLimitRules = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *DownloadSpeedLimitForUpdateCdnConfigInput) SetSwitch(v bool) *DownloadSpeedLimitForUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type DownloadSpeedLimitRuleForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Condition *ConditionForUpdateCdnConfigInput `type:"structure"`

	DownloadSpeedLimitAction *DownloadSpeedLimitActionForUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s DownloadSpeedLimitRuleForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DownloadSpeedLimitRuleForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *DownloadSpeedLimitRuleForUpdateCdnConfigInput) SetCondition(v *ConditionForUpdateCdnConfigInput) *DownloadSpeedLimitRuleForUpdateCdnConfigInput {
	s.Condition = v
	return s
}

// SetDownloadSpeedLimitAction sets the DownloadSpeedLimitAction field's value.
func (s *DownloadSpeedLimitRuleForUpdateCdnConfigInput) SetDownloadSpeedLimitAction(v *DownloadSpeedLimitActionForUpdateCdnConfigInput) *DownloadSpeedLimitRuleForUpdateCdnConfigInput {
	s.DownloadSpeedLimitAction = v
	return s
}

type ErrorPageActionForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Action *string `type:"string"`

	RedirectCode *string `type:"string"`

	RedirectUrl *string `type:"string"`

	StatusCode *string `type:"string"`
}

// String returns the string representation
func (s ErrorPageActionForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ErrorPageActionForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *ErrorPageActionForUpdateCdnConfigInput) SetAction(v string) *ErrorPageActionForUpdateCdnConfigInput {
	s.Action = &v
	return s
}

// SetRedirectCode sets the RedirectCode field's value.
func (s *ErrorPageActionForUpdateCdnConfigInput) SetRedirectCode(v string) *ErrorPageActionForUpdateCdnConfigInput {
	s.RedirectCode = &v
	return s
}

// SetRedirectUrl sets the RedirectUrl field's value.
func (s *ErrorPageActionForUpdateCdnConfigInput) SetRedirectUrl(v string) *ErrorPageActionForUpdateCdnConfigInput {
	s.RedirectUrl = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *ErrorPageActionForUpdateCdnConfigInput) SetStatusCode(v string) *ErrorPageActionForUpdateCdnConfigInput {
	s.StatusCode = &v
	return s
}

type ErrorPageRuleForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	ErrorPageAction *ErrorPageActionForUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s ErrorPageRuleForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ErrorPageRuleForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetErrorPageAction sets the ErrorPageAction field's value.
func (s *ErrorPageRuleForUpdateCdnConfigInput) SetErrorPageAction(v *ErrorPageActionForUpdateCdnConfigInput) *ErrorPageRuleForUpdateCdnConfigInput {
	s.ErrorPageAction = v
	return s
}

type ExpTimeCapRuleForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	CapMode *string `type:"string"`

	ParamName *string `type:"string"`

	UriLevel *int64 `type:"int64"`
}

// String returns the string representation
func (s ExpTimeCapRuleForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ExpTimeCapRuleForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCapMode sets the CapMode field's value.
func (s *ExpTimeCapRuleForUpdateCdnConfigInput) SetCapMode(v string) *ExpTimeCapRuleForUpdateCdnConfigInput {
	s.CapMode = &v
	return s
}

// SetParamName sets the ParamName field's value.
func (s *ExpTimeCapRuleForUpdateCdnConfigInput) SetParamName(v string) *ExpTimeCapRuleForUpdateCdnConfigInput {
	s.ParamName = &v
	return s
}

// SetUriLevel sets the UriLevel field's value.
func (s *ExpTimeCapRuleForUpdateCdnConfigInput) SetUriLevel(v int64) *ExpTimeCapRuleForUpdateCdnConfigInput {
	s.UriLevel = &v
	return s
}

type ForcedRedirectForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	EnableForcedRedirect *bool `type:"boolean"`

	StatusCode *string `type:"string"`
}

// String returns the string representation
func (s ForcedRedirectForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ForcedRedirectForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetEnableForcedRedirect sets the EnableForcedRedirect field's value.
func (s *ForcedRedirectForUpdateCdnConfigInput) SetEnableForcedRedirect(v bool) *ForcedRedirectForUpdateCdnConfigInput {
	s.EnableForcedRedirect = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *ForcedRedirectForUpdateCdnConfigInput) SetStatusCode(v string) *ForcedRedirectForUpdateCdnConfigInput {
	s.StatusCode = &v
	return s
}

type HTTPSForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	CertCheck *CertCheckForUpdateCdnConfigInput `type:"structure"`

	CertInfo *CertInfoForUpdateCdnConfigInput `type:"structure"`

	CertInfoList []*CertInfoListForUpdateCdnConfigInput `type:"list"`

	DisableHttp *bool `type:"boolean"`

	ForcedRedirect *ForcedRedirectForUpdateCdnConfigInput `type:"structure"`

	HTTP2 *bool `type:"boolean"`

	Hsts *HstsForUpdateCdnConfigInput `type:"structure"`

	OCSP *bool `type:"boolean"`

	Switch *bool `type:"boolean"`

	TlsVersion []*string `type:"list"`
}

// String returns the string representation
func (s HTTPSForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HTTPSForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCertCheck sets the CertCheck field's value.
func (s *HTTPSForUpdateCdnConfigInput) SetCertCheck(v *CertCheckForUpdateCdnConfigInput) *HTTPSForUpdateCdnConfigInput {
	s.CertCheck = v
	return s
}

// SetCertInfo sets the CertInfo field's value.
func (s *HTTPSForUpdateCdnConfigInput) SetCertInfo(v *CertInfoForUpdateCdnConfigInput) *HTTPSForUpdateCdnConfigInput {
	s.CertInfo = v
	return s
}

// SetCertInfoList sets the CertInfoList field's value.
func (s *HTTPSForUpdateCdnConfigInput) SetCertInfoList(v []*CertInfoListForUpdateCdnConfigInput) *HTTPSForUpdateCdnConfigInput {
	s.CertInfoList = v
	return s
}

// SetDisableHttp sets the DisableHttp field's value.
func (s *HTTPSForUpdateCdnConfigInput) SetDisableHttp(v bool) *HTTPSForUpdateCdnConfigInput {
	s.DisableHttp = &v
	return s
}

// SetForcedRedirect sets the ForcedRedirect field's value.
func (s *HTTPSForUpdateCdnConfigInput) SetForcedRedirect(v *ForcedRedirectForUpdateCdnConfigInput) *HTTPSForUpdateCdnConfigInput {
	s.ForcedRedirect = v
	return s
}

// SetHTTP2 sets the HTTP2 field's value.
func (s *HTTPSForUpdateCdnConfigInput) SetHTTP2(v bool) *HTTPSForUpdateCdnConfigInput {
	s.HTTP2 = &v
	return s
}

// SetHsts sets the Hsts field's value.
func (s *HTTPSForUpdateCdnConfigInput) SetHsts(v *HstsForUpdateCdnConfigInput) *HTTPSForUpdateCdnConfigInput {
	s.Hsts = v
	return s
}

// SetOCSP sets the OCSP field's value.
func (s *HTTPSForUpdateCdnConfigInput) SetOCSP(v bool) *HTTPSForUpdateCdnConfigInput {
	s.OCSP = &v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *HTTPSForUpdateCdnConfigInput) SetSwitch(v bool) *HTTPSForUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

// SetTlsVersion sets the TlsVersion field's value.
func (s *HTTPSForUpdateCdnConfigInput) SetTlsVersion(v []*string) *HTTPSForUpdateCdnConfigInput {
	s.TlsVersion = v
	return s
}

type HstsForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Subdomain *string `type:"string"`

	Switch *bool `type:"boolean"`

	Ttl *int64 `type:"int64"`
}

// String returns the string representation
func (s HstsForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HstsForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetSubdomain sets the Subdomain field's value.
func (s *HstsForUpdateCdnConfigInput) SetSubdomain(v string) *HstsForUpdateCdnConfigInput {
	s.Subdomain = &v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *HstsForUpdateCdnConfigInput) SetSwitch(v bool) *HstsForUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

// SetTtl sets the Ttl field's value.
func (s *HstsForUpdateCdnConfigInput) SetTtl(v int64) *HstsForUpdateCdnConfigInput {
	s.Ttl = &v
	return s
}

type HttpForcedRedirectForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	EnableForcedRedirect *bool `type:"boolean"`

	StatusCode *string `type:"string"`
}

// String returns the string representation
func (s HttpForcedRedirectForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HttpForcedRedirectForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetEnableForcedRedirect sets the EnableForcedRedirect field's value.
func (s *HttpForcedRedirectForUpdateCdnConfigInput) SetEnableForcedRedirect(v bool) *HttpForcedRedirectForUpdateCdnConfigInput {
	s.EnableForcedRedirect = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *HttpForcedRedirectForUpdateCdnConfigInput) SetStatusCode(v string) *HttpForcedRedirectForUpdateCdnConfigInput {
	s.StatusCode = &v
	return s
}

type IPv6ForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s IPv6ForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s IPv6ForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetSwitch sets the Switch field's value.
func (s *IPv6ForUpdateCdnConfigInput) SetSwitch(v bool) *IPv6ForUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type IpAccessRuleForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Ip []*string `type:"list"`

	RuleType *string `type:"string"`

	SharedConfig *SharedConfigForUpdateCdnConfigInput `type:"structure"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s IpAccessRuleForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s IpAccessRuleForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetIp sets the Ip field's value.
func (s *IpAccessRuleForUpdateCdnConfigInput) SetIp(v []*string) *IpAccessRuleForUpdateCdnConfigInput {
	s.Ip = v
	return s
}

// SetRuleType sets the RuleType field's value.
func (s *IpAccessRuleForUpdateCdnConfigInput) SetRuleType(v string) *IpAccessRuleForUpdateCdnConfigInput {
	s.RuleType = &v
	return s
}

// SetSharedConfig sets the SharedConfig field's value.
func (s *IpAccessRuleForUpdateCdnConfigInput) SetSharedConfig(v *SharedConfigForUpdateCdnConfigInput) *IpAccessRuleForUpdateCdnConfigInput {
	s.SharedConfig = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *IpAccessRuleForUpdateCdnConfigInput) SetSwitch(v bool) *IpAccessRuleForUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type IpFreqLimitActionForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Action *string `type:"string"`

	FreqLimitRate *int64 `type:"int64"`

	StatusCode *string `type:"string"`
}

// String returns the string representation
func (s IpFreqLimitActionForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s IpFreqLimitActionForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *IpFreqLimitActionForUpdateCdnConfigInput) SetAction(v string) *IpFreqLimitActionForUpdateCdnConfigInput {
	s.Action = &v
	return s
}

// SetFreqLimitRate sets the FreqLimitRate field's value.
func (s *IpFreqLimitActionForUpdateCdnConfigInput) SetFreqLimitRate(v int64) *IpFreqLimitActionForUpdateCdnConfigInput {
	s.FreqLimitRate = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *IpFreqLimitActionForUpdateCdnConfigInput) SetStatusCode(v string) *IpFreqLimitActionForUpdateCdnConfigInput {
	s.StatusCode = &v
	return s
}

type IpFreqLimitForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	IpFreqLimitRules []*IpFreqLimitRuleForUpdateCdnConfigInput `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s IpFreqLimitForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s IpFreqLimitForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetIpFreqLimitRules sets the IpFreqLimitRules field's value.
func (s *IpFreqLimitForUpdateCdnConfigInput) SetIpFreqLimitRules(v []*IpFreqLimitRuleForUpdateCdnConfigInput) *IpFreqLimitForUpdateCdnConfigInput {
	s.IpFreqLimitRules = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *IpFreqLimitForUpdateCdnConfigInput) SetSwitch(v bool) *IpFreqLimitForUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type IpFreqLimitRuleForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Condition *ConditionForUpdateCdnConfigInput `type:"structure"`

	IpFreqLimitAction *IpFreqLimitActionForUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s IpFreqLimitRuleForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s IpFreqLimitRuleForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *IpFreqLimitRuleForUpdateCdnConfigInput) SetCondition(v *ConditionForUpdateCdnConfigInput) *IpFreqLimitRuleForUpdateCdnConfigInput {
	s.Condition = v
	return s
}

// SetIpFreqLimitAction sets the IpFreqLimitAction field's value.
func (s *IpFreqLimitRuleForUpdateCdnConfigInput) SetIpFreqLimitAction(v *IpFreqLimitActionForUpdateCdnConfigInput) *IpFreqLimitRuleForUpdateCdnConfigInput {
	s.IpFreqLimitAction = v
	return s
}

type MethodDeniedRuleForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Methods *string `type:"string"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s MethodDeniedRuleForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s MethodDeniedRuleForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetMethods sets the Methods field's value.
func (s *MethodDeniedRuleForUpdateCdnConfigInput) SetMethods(v string) *MethodDeniedRuleForUpdateCdnConfigInput {
	s.Methods = &v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *MethodDeniedRuleForUpdateCdnConfigInput) SetSwitch(v bool) *MethodDeniedRuleForUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type MultiRangeForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s MultiRangeForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s MultiRangeForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetSwitch sets the Switch field's value.
func (s *MultiRangeForUpdateCdnConfigInput) SetSwitch(v bool) *MultiRangeForUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type NegativeCacheForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Condition *ConditionForUpdateCdnConfigInput `type:"structure"`

	NegativeCacheRule *NegativeCacheRuleForUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s NegativeCacheForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NegativeCacheForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *NegativeCacheForUpdateCdnConfigInput) SetCondition(v *ConditionForUpdateCdnConfigInput) *NegativeCacheForUpdateCdnConfigInput {
	s.Condition = v
	return s
}

// SetNegativeCacheRule sets the NegativeCacheRule field's value.
func (s *NegativeCacheForUpdateCdnConfigInput) SetNegativeCacheRule(v *NegativeCacheRuleForUpdateCdnConfigInput) *NegativeCacheForUpdateCdnConfigInput {
	s.NegativeCacheRule = v
	return s
}

type NegativeCacheRuleForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Action *string `type:"string"`

	IgnoreCase *bool `type:"boolean"`

	StatusCode *string `type:"string"`

	Ttl *int64 `type:"int64"`
}

// String returns the string representation
func (s NegativeCacheRuleForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NegativeCacheRuleForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *NegativeCacheRuleForUpdateCdnConfigInput) SetAction(v string) *NegativeCacheRuleForUpdateCdnConfigInput {
	s.Action = &v
	return s
}

// SetIgnoreCase sets the IgnoreCase field's value.
func (s *NegativeCacheRuleForUpdateCdnConfigInput) SetIgnoreCase(v bool) *NegativeCacheRuleForUpdateCdnConfigInput {
	s.IgnoreCase = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *NegativeCacheRuleForUpdateCdnConfigInput) SetStatusCode(v string) *NegativeCacheRuleForUpdateCdnConfigInput {
	s.StatusCode = &v
	return s
}

// SetTtl sets the Ttl field's value.
func (s *NegativeCacheRuleForUpdateCdnConfigInput) SetTtl(v int64) *NegativeCacheRuleForUpdateCdnConfigInput {
	s.Ttl = &v
	return s
}

type OriginAccessRuleForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	AllowEmpty *bool `type:"boolean"`

	IgnoreCase *bool `type:"boolean"`

	Origins []*string `type:"list"`

	RuleType *string `type:"string"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s OriginAccessRuleForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginAccessRuleForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAllowEmpty sets the AllowEmpty field's value.
func (s *OriginAccessRuleForUpdateCdnConfigInput) SetAllowEmpty(v bool) *OriginAccessRuleForUpdateCdnConfigInput {
	s.AllowEmpty = &v
	return s
}

// SetIgnoreCase sets the IgnoreCase field's value.
func (s *OriginAccessRuleForUpdateCdnConfigInput) SetIgnoreCase(v bool) *OriginAccessRuleForUpdateCdnConfigInput {
	s.IgnoreCase = &v
	return s
}

// SetOrigins sets the Origins field's value.
func (s *OriginAccessRuleForUpdateCdnConfigInput) SetOrigins(v []*string) *OriginAccessRuleForUpdateCdnConfigInput {
	s.Origins = v
	return s
}

// SetRuleType sets the RuleType field's value.
func (s *OriginAccessRuleForUpdateCdnConfigInput) SetRuleType(v string) *OriginAccessRuleForUpdateCdnConfigInput {
	s.RuleType = &v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *OriginAccessRuleForUpdateCdnConfigInput) SetSwitch(v bool) *OriginAccessRuleForUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type OriginActionForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	OriginLines []*ConvertOriginLineForUpdateCdnConfigInput `type:"list"`
}

// String returns the string representation
func (s OriginActionForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginActionForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetOriginLines sets the OriginLines field's value.
func (s *OriginActionForUpdateCdnConfigInput) SetOriginLines(v []*ConvertOriginLineForUpdateCdnConfigInput) *OriginActionForUpdateCdnConfigInput {
	s.OriginLines = v
	return s
}

type OriginArgActionForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	OriginArgComponents []*OriginArgComponentForUpdateCdnConfigInput `type:"list"`
}

// String returns the string representation
func (s OriginArgActionForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginArgActionForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetOriginArgComponents sets the OriginArgComponents field's value.
func (s *OriginArgActionForUpdateCdnConfigInput) SetOriginArgComponents(v []*OriginArgComponentForUpdateCdnConfigInput) *OriginArgActionForUpdateCdnConfigInput {
	s.OriginArgComponents = v
	return s
}

type OriginArgComponentForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Action *string `type:"string"`

	Object *string `type:"string"`

	Subobject *string `type:"string"`
}

// String returns the string representation
func (s OriginArgComponentForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginArgComponentForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *OriginArgComponentForUpdateCdnConfigInput) SetAction(v string) *OriginArgComponentForUpdateCdnConfigInput {
	s.Action = &v
	return s
}

// SetObject sets the Object field's value.
func (s *OriginArgComponentForUpdateCdnConfigInput) SetObject(v string) *OriginArgComponentForUpdateCdnConfigInput {
	s.Object = &v
	return s
}

// SetSubobject sets the Subobject field's value.
func (s *OriginArgComponentForUpdateCdnConfigInput) SetSubobject(v string) *OriginArgComponentForUpdateCdnConfigInput {
	s.Subobject = &v
	return s
}

type OriginArgForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Condition *ConditionForUpdateCdnConfigInput `type:"structure"`

	OriginArgAction *OriginArgActionForUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s OriginArgForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginArgForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *OriginArgForUpdateCdnConfigInput) SetCondition(v *ConditionForUpdateCdnConfigInput) *OriginArgForUpdateCdnConfigInput {
	s.Condition = v
	return s
}

// SetOriginArgAction sets the OriginArgAction field's value.
func (s *OriginArgForUpdateCdnConfigInput) SetOriginArgAction(v *OriginArgActionForUpdateCdnConfigInput) *OriginArgForUpdateCdnConfigInput {
	s.OriginArgAction = v
	return s
}

type OriginCertCheckForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s OriginCertCheckForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginCertCheckForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetSwitch sets the Switch field's value.
func (s *OriginCertCheckForUpdateCdnConfigInput) SetSwitch(v bool) *OriginCertCheckForUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type OriginForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Condition *ConditionForUpdateCdnConfigInput `type:"structure"`

	OriginAction *OriginActionForUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s OriginForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *OriginForUpdateCdnConfigInput) SetCondition(v *ConditionForUpdateCdnConfigInput) *OriginForUpdateCdnConfigInput {
	s.Condition = v
	return s
}

// SetOriginAction sets the OriginAction field's value.
func (s *OriginForUpdateCdnConfigInput) SetOriginAction(v *OriginActionForUpdateCdnConfigInput) *OriginForUpdateCdnConfigInput {
	s.OriginAction = v
	return s
}

type OriginLineForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Address *string `type:"string"`

	HttpPort *string `type:"string"`

	HttpsPort *string `type:"string"`

	InstanceType *string `type:"string"`

	OriginHost *string `type:"string"`
}

// String returns the string representation
func (s OriginLineForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginLineForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *OriginLineForUpdateCdnConfigInput) SetAddress(v string) *OriginLineForUpdateCdnConfigInput {
	s.Address = &v
	return s
}

// SetHttpPort sets the HttpPort field's value.
func (s *OriginLineForUpdateCdnConfigInput) SetHttpPort(v string) *OriginLineForUpdateCdnConfigInput {
	s.HttpPort = &v
	return s
}

// SetHttpsPort sets the HttpsPort field's value.
func (s *OriginLineForUpdateCdnConfigInput) SetHttpsPort(v string) *OriginLineForUpdateCdnConfigInput {
	s.HttpsPort = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *OriginLineForUpdateCdnConfigInput) SetInstanceType(v string) *OriginLineForUpdateCdnConfigInput {
	s.InstanceType = &v
	return s
}

// SetOriginHost sets the OriginHost field's value.
func (s *OriginLineForUpdateCdnConfigInput) SetOriginHost(v string) *OriginLineForUpdateCdnConfigInput {
	s.OriginHost = &v
	return s
}

type OriginRetryForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	StatusCode *string `type:"string"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s OriginRetryForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginRetryForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetStatusCode sets the StatusCode field's value.
func (s *OriginRetryForUpdateCdnConfigInput) SetStatusCode(v string) *OriginRetryForUpdateCdnConfigInput {
	s.StatusCode = &v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *OriginRetryForUpdateCdnConfigInput) SetSwitch(v bool) *OriginRetryForUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type OriginRewriteActionForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	RewriteType *string `type:"string"`

	SourcePath *string `type:"string"`

	TargetPath *string `type:"string"`
}

// String returns the string representation
func (s OriginRewriteActionForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginRewriteActionForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetRewriteType sets the RewriteType field's value.
func (s *OriginRewriteActionForUpdateCdnConfigInput) SetRewriteType(v string) *OriginRewriteActionForUpdateCdnConfigInput {
	s.RewriteType = &v
	return s
}

// SetSourcePath sets the SourcePath field's value.
func (s *OriginRewriteActionForUpdateCdnConfigInput) SetSourcePath(v string) *OriginRewriteActionForUpdateCdnConfigInput {
	s.SourcePath = &v
	return s
}

// SetTargetPath sets the TargetPath field's value.
func (s *OriginRewriteActionForUpdateCdnConfigInput) SetTargetPath(v string) *OriginRewriteActionForUpdateCdnConfigInput {
	s.TargetPath = &v
	return s
}

type OriginRewriteForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	OriginRewriteRule []*OriginRewriteRuleForUpdateCdnConfigInput `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s OriginRewriteForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginRewriteForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetOriginRewriteRule sets the OriginRewriteRule field's value.
func (s *OriginRewriteForUpdateCdnConfigInput) SetOriginRewriteRule(v []*OriginRewriteRuleForUpdateCdnConfigInput) *OriginRewriteForUpdateCdnConfigInput {
	s.OriginRewriteRule = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *OriginRewriteForUpdateCdnConfigInput) SetSwitch(v bool) *OriginRewriteForUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type OriginRewriteRuleForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Condition *ConditionForUpdateCdnConfigInput `type:"structure"`

	OriginRewriteAction *OriginRewriteActionForUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s OriginRewriteRuleForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginRewriteRuleForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *OriginRewriteRuleForUpdateCdnConfigInput) SetCondition(v *ConditionForUpdateCdnConfigInput) *OriginRewriteRuleForUpdateCdnConfigInput {
	s.Condition = v
	return s
}

// SetOriginRewriteAction sets the OriginRewriteAction field's value.
func (s *OriginRewriteRuleForUpdateCdnConfigInput) SetOriginRewriteAction(v *OriginRewriteActionForUpdateCdnConfigInput) *OriginRewriteRuleForUpdateCdnConfigInput {
	s.OriginRewriteAction = v
	return s
}

type OriginRuleForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Actions *ActionsForUpdateCdnConfigInput `type:"structure"`

	Condition *ConvertConvertConditionForUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s OriginRuleForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginRuleForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetActions sets the Actions field's value.
func (s *OriginRuleForUpdateCdnConfigInput) SetActions(v *ActionsForUpdateCdnConfigInput) *OriginRuleForUpdateCdnConfigInput {
	s.Actions = v
	return s
}

// SetCondition sets the Condition field's value.
func (s *OriginRuleForUpdateCdnConfigInput) SetCondition(v *ConvertConvertConditionForUpdateCdnConfigInput) *OriginRuleForUpdateCdnConfigInput {
	s.Condition = v
	return s
}

type OriginSniForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	SniDomain *string `type:"string"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s OriginSniForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginSniForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetSniDomain sets the SniDomain field's value.
func (s *OriginSniForUpdateCdnConfigInput) SetSniDomain(v string) *OriginSniForUpdateCdnConfigInput {
	s.SniDomain = &v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *OriginSniForUpdateCdnConfigInput) SetSwitch(v bool) *OriginSniForUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type PageOptimizationForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	OptimizationType []*string `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s PageOptimizationForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PageOptimizationForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetOptimizationType sets the OptimizationType field's value.
func (s *PageOptimizationForUpdateCdnConfigInput) SetOptimizationType(v []*string) *PageOptimizationForUpdateCdnConfigInput {
	s.OptimizationType = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *PageOptimizationForUpdateCdnConfigInput) SetSwitch(v bool) *PageOptimizationForUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type PrivateBucketAuthForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	AuthType *string `type:"string"`

	Switch *bool `type:"boolean"`

	TosAuthInformation *TosAuthInformationForUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s PrivateBucketAuthForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PrivateBucketAuthForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAuthType sets the AuthType field's value.
func (s *PrivateBucketAuthForUpdateCdnConfigInput) SetAuthType(v string) *PrivateBucketAuthForUpdateCdnConfigInput {
	s.AuthType = &v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *PrivateBucketAuthForUpdateCdnConfigInput) SetSwitch(v bool) *PrivateBucketAuthForUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

// SetTosAuthInformation sets the TosAuthInformation field's value.
func (s *PrivateBucketAuthForUpdateCdnConfigInput) SetTosAuthInformation(v *TosAuthInformationForUpdateCdnConfigInput) *PrivateBucketAuthForUpdateCdnConfigInput {
	s.TosAuthInformation = v
	return s
}

type QueryStringComponentsForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Action *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s QueryStringComponentsForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryStringComponentsForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *QueryStringComponentsForUpdateCdnConfigInput) SetAction(v string) *QueryStringComponentsForUpdateCdnConfigInput {
	s.Action = &v
	return s
}

// SetValue sets the Value field's value.
func (s *QueryStringComponentsForUpdateCdnConfigInput) SetValue(v string) *QueryStringComponentsForUpdateCdnConfigInput {
	s.Value = &v
	return s
}

type QueryStringInstanceForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Action *string `type:"string"`

	Key *string `type:"string"`

	Value *string `type:"string"`

	ValueType *string `type:"string"`
}

// String returns the string representation
func (s QueryStringInstanceForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryStringInstanceForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *QueryStringInstanceForUpdateCdnConfigInput) SetAction(v string) *QueryStringInstanceForUpdateCdnConfigInput {
	s.Action = &v
	return s
}

// SetKey sets the Key field's value.
func (s *QueryStringInstanceForUpdateCdnConfigInput) SetKey(v string) *QueryStringInstanceForUpdateCdnConfigInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *QueryStringInstanceForUpdateCdnConfigInput) SetValue(v string) *QueryStringInstanceForUpdateCdnConfigInput {
	s.Value = &v
	return s
}

// SetValueType sets the ValueType field's value.
func (s *QueryStringInstanceForUpdateCdnConfigInput) SetValueType(v string) *QueryStringInstanceForUpdateCdnConfigInput {
	s.ValueType = &v
	return s
}

type QueryStringRulesForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	QueryStringComponents *QueryStringComponentsForUpdateCdnConfigInput `type:"structure"`

	QueryStringInstances []*QueryStringInstanceForUpdateCdnConfigInput `type:"list"`
}

// String returns the string representation
func (s QueryStringRulesForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryStringRulesForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetQueryStringComponents sets the QueryStringComponents field's value.
func (s *QueryStringRulesForUpdateCdnConfigInput) SetQueryStringComponents(v *QueryStringComponentsForUpdateCdnConfigInput) *QueryStringRulesForUpdateCdnConfigInput {
	s.QueryStringComponents = v
	return s
}

// SetQueryStringInstances sets the QueryStringInstances field's value.
func (s *QueryStringRulesForUpdateCdnConfigInput) SetQueryStringInstances(v []*QueryStringInstanceForUpdateCdnConfigInput) *QueryStringRulesForUpdateCdnConfigInput {
	s.QueryStringInstances = v
	return s
}

type QuicForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s QuicForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s QuicForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetSwitch sets the Switch field's value.
func (s *QuicForUpdateCdnConfigInput) SetSwitch(v bool) *QuicForUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type RedirectionActionForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	RedirectCode *string `type:"string"`

	SourcePath *string `type:"string"`

	TargetHost *string `type:"string"`

	TargetPath *string `type:"string"`

	TargetProtocol *string `type:"string"`

	TargetQueryComponents *TargetQueryComponentsForUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s RedirectionActionForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RedirectionActionForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetRedirectCode sets the RedirectCode field's value.
func (s *RedirectionActionForUpdateCdnConfigInput) SetRedirectCode(v string) *RedirectionActionForUpdateCdnConfigInput {
	s.RedirectCode = &v
	return s
}

// SetSourcePath sets the SourcePath field's value.
func (s *RedirectionActionForUpdateCdnConfigInput) SetSourcePath(v string) *RedirectionActionForUpdateCdnConfigInput {
	s.SourcePath = &v
	return s
}

// SetTargetHost sets the TargetHost field's value.
func (s *RedirectionActionForUpdateCdnConfigInput) SetTargetHost(v string) *RedirectionActionForUpdateCdnConfigInput {
	s.TargetHost = &v
	return s
}

// SetTargetPath sets the TargetPath field's value.
func (s *RedirectionActionForUpdateCdnConfigInput) SetTargetPath(v string) *RedirectionActionForUpdateCdnConfigInput {
	s.TargetPath = &v
	return s
}

// SetTargetProtocol sets the TargetProtocol field's value.
func (s *RedirectionActionForUpdateCdnConfigInput) SetTargetProtocol(v string) *RedirectionActionForUpdateCdnConfigInput {
	s.TargetProtocol = &v
	return s
}

// SetTargetQueryComponents sets the TargetQueryComponents field's value.
func (s *RedirectionActionForUpdateCdnConfigInput) SetTargetQueryComponents(v *TargetQueryComponentsForUpdateCdnConfigInput) *RedirectionActionForUpdateCdnConfigInput {
	s.TargetQueryComponents = v
	return s
}

type RedirectionRewriteForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	RedirectionRule []*RedirectionRuleForUpdateCdnConfigInput `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s RedirectionRewriteForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RedirectionRewriteForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetRedirectionRule sets the RedirectionRule field's value.
func (s *RedirectionRewriteForUpdateCdnConfigInput) SetRedirectionRule(v []*RedirectionRuleForUpdateCdnConfigInput) *RedirectionRewriteForUpdateCdnConfigInput {
	s.RedirectionRule = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *RedirectionRewriteForUpdateCdnConfigInput) SetSwitch(v bool) *RedirectionRewriteForUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type RedirectionRuleForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	RedirectionAction *RedirectionActionForUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s RedirectionRuleForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RedirectionRuleForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetRedirectionAction sets the RedirectionAction field's value.
func (s *RedirectionRuleForUpdateCdnConfigInput) SetRedirectionAction(v *RedirectionActionForUpdateCdnConfigInput) *RedirectionRuleForUpdateCdnConfigInput {
	s.RedirectionAction = v
	return s
}

type RefererAccessRuleForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	AllowEmpty *bool `type:"boolean"`

	Referers []*string `type:"list"`

	ReferersType *ReferersTypeForUpdateCdnConfigInput `type:"structure"`

	RuleType *string `type:"string"`

	SharedConfig *SharedConfigForUpdateCdnConfigInput `type:"structure"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s RefererAccessRuleForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RefererAccessRuleForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAllowEmpty sets the AllowEmpty field's value.
func (s *RefererAccessRuleForUpdateCdnConfigInput) SetAllowEmpty(v bool) *RefererAccessRuleForUpdateCdnConfigInput {
	s.AllowEmpty = &v
	return s
}

// SetReferers sets the Referers field's value.
func (s *RefererAccessRuleForUpdateCdnConfigInput) SetReferers(v []*string) *RefererAccessRuleForUpdateCdnConfigInput {
	s.Referers = v
	return s
}

// SetReferersType sets the ReferersType field's value.
func (s *RefererAccessRuleForUpdateCdnConfigInput) SetReferersType(v *ReferersTypeForUpdateCdnConfigInput) *RefererAccessRuleForUpdateCdnConfigInput {
	s.ReferersType = v
	return s
}

// SetRuleType sets the RuleType field's value.
func (s *RefererAccessRuleForUpdateCdnConfigInput) SetRuleType(v string) *RefererAccessRuleForUpdateCdnConfigInput {
	s.RuleType = &v
	return s
}

// SetSharedConfig sets the SharedConfig field's value.
func (s *RefererAccessRuleForUpdateCdnConfigInput) SetSharedConfig(v *SharedConfigForUpdateCdnConfigInput) *RefererAccessRuleForUpdateCdnConfigInput {
	s.SharedConfig = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *RefererAccessRuleForUpdateCdnConfigInput) SetSwitch(v bool) *RefererAccessRuleForUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type ReferersTypeForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	CommonType *CommonTypeForUpdateCdnConfigInput `type:"structure"`

	RegularType *RegularTypeForUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s ReferersTypeForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ReferersTypeForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCommonType sets the CommonType field's value.
func (s *ReferersTypeForUpdateCdnConfigInput) SetCommonType(v *CommonTypeForUpdateCdnConfigInput) *ReferersTypeForUpdateCdnConfigInput {
	s.CommonType = v
	return s
}

// SetRegularType sets the RegularType field's value.
func (s *ReferersTypeForUpdateCdnConfigInput) SetRegularType(v *RegularTypeForUpdateCdnConfigInput) *ReferersTypeForUpdateCdnConfigInput {
	s.RegularType = v
	return s
}

type RegularTypeForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Referers []*string `type:"list"`
}

// String returns the string representation
func (s RegularTypeForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RegularTypeForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetReferers sets the Referers field's value.
func (s *RegularTypeForUpdateCdnConfigInput) SetReferers(v []*string) *RegularTypeForUpdateCdnConfigInput {
	s.Referers = v
	return s
}

type RemoteAuthForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	RemoteAuthRules []*RemoteAuthRuleForUpdateCdnConfigInput `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s RemoteAuthForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoteAuthForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetRemoteAuthRules sets the RemoteAuthRules field's value.
func (s *RemoteAuthForUpdateCdnConfigInput) SetRemoteAuthRules(v []*RemoteAuthRuleForUpdateCdnConfigInput) *RemoteAuthForUpdateCdnConfigInput {
	s.RemoteAuthRules = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *RemoteAuthForUpdateCdnConfigInput) SetSwitch(v bool) *RemoteAuthForUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type RemoteAuthRuleActionForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	AuthModeConfig *AuthModeConfigForUpdateCdnConfigInput `type:"structure"`

	AuthResponseConfig *AuthResponseConfigForUpdateCdnConfigInput `type:"structure"`

	QueryStringRules *QueryStringRulesForUpdateCdnConfigInput `type:"structure"`

	RequestBodyRules *string `type:"string"`

	RequestHeaderRules *RequestHeaderRulesForUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s RemoteAuthRuleActionForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoteAuthRuleActionForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAuthModeConfig sets the AuthModeConfig field's value.
func (s *RemoteAuthRuleActionForUpdateCdnConfigInput) SetAuthModeConfig(v *AuthModeConfigForUpdateCdnConfigInput) *RemoteAuthRuleActionForUpdateCdnConfigInput {
	s.AuthModeConfig = v
	return s
}

// SetAuthResponseConfig sets the AuthResponseConfig field's value.
func (s *RemoteAuthRuleActionForUpdateCdnConfigInput) SetAuthResponseConfig(v *AuthResponseConfigForUpdateCdnConfigInput) *RemoteAuthRuleActionForUpdateCdnConfigInput {
	s.AuthResponseConfig = v
	return s
}

// SetQueryStringRules sets the QueryStringRules field's value.
func (s *RemoteAuthRuleActionForUpdateCdnConfigInput) SetQueryStringRules(v *QueryStringRulesForUpdateCdnConfigInput) *RemoteAuthRuleActionForUpdateCdnConfigInput {
	s.QueryStringRules = v
	return s
}

// SetRequestBodyRules sets the RequestBodyRules field's value.
func (s *RemoteAuthRuleActionForUpdateCdnConfigInput) SetRequestBodyRules(v string) *RemoteAuthRuleActionForUpdateCdnConfigInput {
	s.RequestBodyRules = &v
	return s
}

// SetRequestHeaderRules sets the RequestHeaderRules field's value.
func (s *RemoteAuthRuleActionForUpdateCdnConfigInput) SetRequestHeaderRules(v *RequestHeaderRulesForUpdateCdnConfigInput) *RemoteAuthRuleActionForUpdateCdnConfigInput {
	s.RequestHeaderRules = v
	return s
}

type RemoteAuthRuleForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Condition *ConditionForUpdateCdnConfigInput `type:"structure"`

	RemoteAuthRuleAction *RemoteAuthRuleActionForUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s RemoteAuthRuleForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoteAuthRuleForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *RemoteAuthRuleForUpdateCdnConfigInput) SetCondition(v *ConditionForUpdateCdnConfigInput) *RemoteAuthRuleForUpdateCdnConfigInput {
	s.Condition = v
	return s
}

// SetRemoteAuthRuleAction sets the RemoteAuthRuleAction field's value.
func (s *RemoteAuthRuleForUpdateCdnConfigInput) SetRemoteAuthRuleAction(v *RemoteAuthRuleActionForUpdateCdnConfigInput) *RemoteAuthRuleForUpdateCdnConfigInput {
	s.RemoteAuthRuleAction = v
	return s
}

type RequestBlockRuleForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	BlockRule []*BlockRuleForUpdateCdnConfigInput `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s RequestBlockRuleForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestBlockRuleForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetBlockRule sets the BlockRule field's value.
func (s *RequestBlockRuleForUpdateCdnConfigInput) SetBlockRule(v []*BlockRuleForUpdateCdnConfigInput) *RequestBlockRuleForUpdateCdnConfigInput {
	s.BlockRule = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *RequestBlockRuleForUpdateCdnConfigInput) SetSwitch(v bool) *RequestBlockRuleForUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type RequestHeaderActionForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	RequestHeaderInstances []*RequestHeaderInstanceForUpdateCdnConfigInput `type:"list"`
}

// String returns the string representation
func (s RequestHeaderActionForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestHeaderActionForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetRequestHeaderInstances sets the RequestHeaderInstances field's value.
func (s *RequestHeaderActionForUpdateCdnConfigInput) SetRequestHeaderInstances(v []*RequestHeaderInstanceForUpdateCdnConfigInput) *RequestHeaderActionForUpdateCdnConfigInput {
	s.RequestHeaderInstances = v
	return s
}

type RequestHeaderComponentsForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Action *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s RequestHeaderComponentsForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestHeaderComponentsForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *RequestHeaderComponentsForUpdateCdnConfigInput) SetAction(v string) *RequestHeaderComponentsForUpdateCdnConfigInput {
	s.Action = &v
	return s
}

// SetValue sets the Value field's value.
func (s *RequestHeaderComponentsForUpdateCdnConfigInput) SetValue(v string) *RequestHeaderComponentsForUpdateCdnConfigInput {
	s.Value = &v
	return s
}

type RequestHeaderForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Condition *ConditionForUpdateCdnConfigInput `type:"structure"`

	RequestHeaderAction *RequestHeaderActionForUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s RequestHeaderForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestHeaderForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *RequestHeaderForUpdateCdnConfigInput) SetCondition(v *ConditionForUpdateCdnConfigInput) *RequestHeaderForUpdateCdnConfigInput {
	s.Condition = v
	return s
}

// SetRequestHeaderAction sets the RequestHeaderAction field's value.
func (s *RequestHeaderForUpdateCdnConfigInput) SetRequestHeaderAction(v *RequestHeaderActionForUpdateCdnConfigInput) *RequestHeaderForUpdateCdnConfigInput {
	s.RequestHeaderAction = v
	return s
}

type RequestHeaderInstanceForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Action *string `type:"string"`

	Key *string `type:"string"`

	Value *string `type:"string"`

	ValueType *string `type:"string"`
}

// String returns the string representation
func (s RequestHeaderInstanceForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestHeaderInstanceForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *RequestHeaderInstanceForUpdateCdnConfigInput) SetAction(v string) *RequestHeaderInstanceForUpdateCdnConfigInput {
	s.Action = &v
	return s
}

// SetKey sets the Key field's value.
func (s *RequestHeaderInstanceForUpdateCdnConfigInput) SetKey(v string) *RequestHeaderInstanceForUpdateCdnConfigInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *RequestHeaderInstanceForUpdateCdnConfigInput) SetValue(v string) *RequestHeaderInstanceForUpdateCdnConfigInput {
	s.Value = &v
	return s
}

// SetValueType sets the ValueType field's value.
func (s *RequestHeaderInstanceForUpdateCdnConfigInput) SetValueType(v string) *RequestHeaderInstanceForUpdateCdnConfigInput {
	s.ValueType = &v
	return s
}

type RequestHeaderRulesForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	RequestHeaderComponents *RequestHeaderComponentsForUpdateCdnConfigInput `type:"structure"`

	RequestHeaderInstances []*RequestHeaderInstanceForUpdateCdnConfigInput `type:"list"`

	RequestHost *string `type:"string"`
}

// String returns the string representation
func (s RequestHeaderRulesForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestHeaderRulesForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetRequestHeaderComponents sets the RequestHeaderComponents field's value.
func (s *RequestHeaderRulesForUpdateCdnConfigInput) SetRequestHeaderComponents(v *RequestHeaderComponentsForUpdateCdnConfigInput) *RequestHeaderRulesForUpdateCdnConfigInput {
	s.RequestHeaderComponents = v
	return s
}

// SetRequestHeaderInstances sets the RequestHeaderInstances field's value.
func (s *RequestHeaderRulesForUpdateCdnConfigInput) SetRequestHeaderInstances(v []*RequestHeaderInstanceForUpdateCdnConfigInput) *RequestHeaderRulesForUpdateCdnConfigInput {
	s.RequestHeaderInstances = v
	return s
}

// SetRequestHost sets the RequestHost field's value.
func (s *RequestHeaderRulesForUpdateCdnConfigInput) SetRequestHost(v string) *RequestHeaderRulesForUpdateCdnConfigInput {
	s.RequestHost = &v
	return s
}

type ResponseActionForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	StatusCode *string `type:"string"`
}

// String returns the string representation
func (s ResponseActionForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResponseActionForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetStatusCode sets the StatusCode field's value.
func (s *ResponseActionForUpdateCdnConfigInput) SetStatusCode(v string) *ResponseActionForUpdateCdnConfigInput {
	s.StatusCode = &v
	return s
}

type ResponseHeaderActionForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	ResponseHeaderInstances []*ResponseHeaderInstanceForUpdateCdnConfigInput `type:"list"`
}

// String returns the string representation
func (s ResponseHeaderActionForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResponseHeaderActionForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetResponseHeaderInstances sets the ResponseHeaderInstances field's value.
func (s *ResponseHeaderActionForUpdateCdnConfigInput) SetResponseHeaderInstances(v []*ResponseHeaderInstanceForUpdateCdnConfigInput) *ResponseHeaderActionForUpdateCdnConfigInput {
	s.ResponseHeaderInstances = v
	return s
}

type ResponseHeaderForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Condition *ConditionForUpdateCdnConfigInput `type:"structure"`

	ResponseHeaderAction *ResponseHeaderActionForUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s ResponseHeaderForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResponseHeaderForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *ResponseHeaderForUpdateCdnConfigInput) SetCondition(v *ConditionForUpdateCdnConfigInput) *ResponseHeaderForUpdateCdnConfigInput {
	s.Condition = v
	return s
}

// SetResponseHeaderAction sets the ResponseHeaderAction field's value.
func (s *ResponseHeaderForUpdateCdnConfigInput) SetResponseHeaderAction(v *ResponseHeaderActionForUpdateCdnConfigInput) *ResponseHeaderForUpdateCdnConfigInput {
	s.ResponseHeaderAction = v
	return s
}

type ResponseHeaderInstanceForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	AccessOriginControl *bool `type:"boolean"`

	Action *string `type:"string"`

	Key *string `type:"string"`

	Value *string `type:"string"`

	ValueType *string `type:"string"`
}

// String returns the string representation
func (s ResponseHeaderInstanceForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResponseHeaderInstanceForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAccessOriginControl sets the AccessOriginControl field's value.
func (s *ResponseHeaderInstanceForUpdateCdnConfigInput) SetAccessOriginControl(v bool) *ResponseHeaderInstanceForUpdateCdnConfigInput {
	s.AccessOriginControl = &v
	return s
}

// SetAction sets the Action field's value.
func (s *ResponseHeaderInstanceForUpdateCdnConfigInput) SetAction(v string) *ResponseHeaderInstanceForUpdateCdnConfigInput {
	s.Action = &v
	return s
}

// SetKey sets the Key field's value.
func (s *ResponseHeaderInstanceForUpdateCdnConfigInput) SetKey(v string) *ResponseHeaderInstanceForUpdateCdnConfigInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ResponseHeaderInstanceForUpdateCdnConfigInput) SetValue(v string) *ResponseHeaderInstanceForUpdateCdnConfigInput {
	s.Value = &v
	return s
}

// SetValueType sets the ValueType field's value.
func (s *ResponseHeaderInstanceForUpdateCdnConfigInput) SetValueType(v string) *ResponseHeaderInstanceForUpdateCdnConfigInput {
	s.ValueType = &v
	return s
}

type RewriteHLSForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	SignName *string `type:"string"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s RewriteHLSForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RewriteHLSForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetSignName sets the SignName field's value.
func (s *RewriteHLSForUpdateCdnConfigInput) SetSignName(v string) *RewriteHLSForUpdateCdnConfigInput {
	s.SignName = &v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *RewriteHLSForUpdateCdnConfigInput) SetSwitch(v bool) *RewriteHLSForUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type RewriteM3u8RuleForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	DeleteParam *bool `type:"boolean"`

	KeepM3u8Param *bool `type:"boolean"`

	TransferEncoding *bool `type:"boolean"`
}

// String returns the string representation
func (s RewriteM3u8RuleForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RewriteM3u8RuleForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetDeleteParam sets the DeleteParam field's value.
func (s *RewriteM3u8RuleForUpdateCdnConfigInput) SetDeleteParam(v bool) *RewriteM3u8RuleForUpdateCdnConfigInput {
	s.DeleteParam = &v
	return s
}

// SetKeepM3u8Param sets the KeepM3u8Param field's value.
func (s *RewriteM3u8RuleForUpdateCdnConfigInput) SetKeepM3u8Param(v bool) *RewriteM3u8RuleForUpdateCdnConfigInput {
	s.KeepM3u8Param = &v
	return s
}

// SetTransferEncoding sets the TransferEncoding field's value.
func (s *RewriteM3u8RuleForUpdateCdnConfigInput) SetTransferEncoding(v bool) *RewriteM3u8RuleForUpdateCdnConfigInput {
	s.TransferEncoding = &v
	return s
}

type SharedConfigForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	ConfigName *string `type:"string"`
}

// String returns the string representation
func (s SharedConfigForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SharedConfigForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetConfigName sets the ConfigName field's value.
func (s *SharedConfigForUpdateCdnConfigInput) SetConfigName(v string) *SharedConfigForUpdateCdnConfigInput {
	s.ConfigName = &v
	return s
}

type SignCapRuleForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	CapMode *string `type:"string"`

	ParamName *string `type:"string"`

	UriLevel *int64 `type:"int64"`
}

// String returns the string representation
func (s SignCapRuleForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SignCapRuleForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCapMode sets the CapMode field's value.
func (s *SignCapRuleForUpdateCdnConfigInput) SetCapMode(v string) *SignCapRuleForUpdateCdnConfigInput {
	s.CapMode = &v
	return s
}

// SetParamName sets the ParamName field's value.
func (s *SignCapRuleForUpdateCdnConfigInput) SetParamName(v string) *SignCapRuleForUpdateCdnConfigInput {
	s.ParamName = &v
	return s
}

// SetUriLevel sets the UriLevel field's value.
func (s *SignCapRuleForUpdateCdnConfigInput) SetUriLevel(v int64) *SignCapRuleForUpdateCdnConfigInput {
	s.UriLevel = &v
	return s
}

type SignParamForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	ParamType *string `type:"string"`

	RequestHeader *string `type:"string"`

	SupContent *string `type:"string"`

	UriParamSup *UriParamSupForUpdateCdnConfigInput `type:"structure"`

	UrlParam *SignCapRuleForUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s SignParamForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SignParamForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetParamType sets the ParamType field's value.
func (s *SignParamForUpdateCdnConfigInput) SetParamType(v string) *SignParamForUpdateCdnConfigInput {
	s.ParamType = &v
	return s
}

// SetRequestHeader sets the RequestHeader field's value.
func (s *SignParamForUpdateCdnConfigInput) SetRequestHeader(v string) *SignParamForUpdateCdnConfigInput {
	s.RequestHeader = &v
	return s
}

// SetSupContent sets the SupContent field's value.
func (s *SignParamForUpdateCdnConfigInput) SetSupContent(v string) *SignParamForUpdateCdnConfigInput {
	s.SupContent = &v
	return s
}

// SetUriParamSup sets the UriParamSup field's value.
func (s *SignParamForUpdateCdnConfigInput) SetUriParamSup(v *UriParamSupForUpdateCdnConfigInput) *SignParamForUpdateCdnConfigInput {
	s.UriParamSup = v
	return s
}

// SetUrlParam sets the UrlParam field's value.
func (s *SignParamForUpdateCdnConfigInput) SetUrlParam(v *SignCapRuleForUpdateCdnConfigInput) *SignParamForUpdateCdnConfigInput {
	s.UrlParam = v
	return s
}

type SignedUrlAuthActionForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	AuthAlgorithm *string `type:"string"`

	BackupSecretKey *string `type:"string"`

	CustomVariableRules *CustomVariableRulesForUpdateCdnConfigInput `type:"structure"`

	Duration *int64 `type:"int64"`

	KeepOriginArg *bool `type:"boolean"`

	MasterSecretKey *string `type:"string"`

	MpdVarExpand *bool `type:"boolean"`

	RewriteM3u8 *bool `type:"boolean"`

	RewriteM3u8Rule *RewriteM3u8RuleForUpdateCdnConfigInput `type:"structure"`

	RewriteMpd *bool `type:"boolean"`

	SignName *string `type:"string"`

	SignatureRule []*string `type:"list"`

	TimeFormat *string `type:"string"`

	TimeName *string `type:"string"`

	URLAuthType *string `type:"string"`

	UrlAuthCustomAction *UrlAuthCustomActionForUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s SignedUrlAuthActionForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SignedUrlAuthActionForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAuthAlgorithm sets the AuthAlgorithm field's value.
func (s *SignedUrlAuthActionForUpdateCdnConfigInput) SetAuthAlgorithm(v string) *SignedUrlAuthActionForUpdateCdnConfigInput {
	s.AuthAlgorithm = &v
	return s
}

// SetBackupSecretKey sets the BackupSecretKey field's value.
func (s *SignedUrlAuthActionForUpdateCdnConfigInput) SetBackupSecretKey(v string) *SignedUrlAuthActionForUpdateCdnConfigInput {
	s.BackupSecretKey = &v
	return s
}

// SetCustomVariableRules sets the CustomVariableRules field's value.
func (s *SignedUrlAuthActionForUpdateCdnConfigInput) SetCustomVariableRules(v *CustomVariableRulesForUpdateCdnConfigInput) *SignedUrlAuthActionForUpdateCdnConfigInput {
	s.CustomVariableRules = v
	return s
}

// SetDuration sets the Duration field's value.
func (s *SignedUrlAuthActionForUpdateCdnConfigInput) SetDuration(v int64) *SignedUrlAuthActionForUpdateCdnConfigInput {
	s.Duration = &v
	return s
}

// SetKeepOriginArg sets the KeepOriginArg field's value.
func (s *SignedUrlAuthActionForUpdateCdnConfigInput) SetKeepOriginArg(v bool) *SignedUrlAuthActionForUpdateCdnConfigInput {
	s.KeepOriginArg = &v
	return s
}

// SetMasterSecretKey sets the MasterSecretKey field's value.
func (s *SignedUrlAuthActionForUpdateCdnConfigInput) SetMasterSecretKey(v string) *SignedUrlAuthActionForUpdateCdnConfigInput {
	s.MasterSecretKey = &v
	return s
}

// SetMpdVarExpand sets the MpdVarExpand field's value.
func (s *SignedUrlAuthActionForUpdateCdnConfigInput) SetMpdVarExpand(v bool) *SignedUrlAuthActionForUpdateCdnConfigInput {
	s.MpdVarExpand = &v
	return s
}

// SetRewriteM3u8 sets the RewriteM3u8 field's value.
func (s *SignedUrlAuthActionForUpdateCdnConfigInput) SetRewriteM3u8(v bool) *SignedUrlAuthActionForUpdateCdnConfigInput {
	s.RewriteM3u8 = &v
	return s
}

// SetRewriteM3u8Rule sets the RewriteM3u8Rule field's value.
func (s *SignedUrlAuthActionForUpdateCdnConfigInput) SetRewriteM3u8Rule(v *RewriteM3u8RuleForUpdateCdnConfigInput) *SignedUrlAuthActionForUpdateCdnConfigInput {
	s.RewriteM3u8Rule = v
	return s
}

// SetRewriteMpd sets the RewriteMpd field's value.
func (s *SignedUrlAuthActionForUpdateCdnConfigInput) SetRewriteMpd(v bool) *SignedUrlAuthActionForUpdateCdnConfigInput {
	s.RewriteMpd = &v
	return s
}

// SetSignName sets the SignName field's value.
func (s *SignedUrlAuthActionForUpdateCdnConfigInput) SetSignName(v string) *SignedUrlAuthActionForUpdateCdnConfigInput {
	s.SignName = &v
	return s
}

// SetSignatureRule sets the SignatureRule field's value.
func (s *SignedUrlAuthActionForUpdateCdnConfigInput) SetSignatureRule(v []*string) *SignedUrlAuthActionForUpdateCdnConfigInput {
	s.SignatureRule = v
	return s
}

// SetTimeFormat sets the TimeFormat field's value.
func (s *SignedUrlAuthActionForUpdateCdnConfigInput) SetTimeFormat(v string) *SignedUrlAuthActionForUpdateCdnConfigInput {
	s.TimeFormat = &v
	return s
}

// SetTimeName sets the TimeName field's value.
func (s *SignedUrlAuthActionForUpdateCdnConfigInput) SetTimeName(v string) *SignedUrlAuthActionForUpdateCdnConfigInput {
	s.TimeName = &v
	return s
}

// SetURLAuthType sets the URLAuthType field's value.
func (s *SignedUrlAuthActionForUpdateCdnConfigInput) SetURLAuthType(v string) *SignedUrlAuthActionForUpdateCdnConfigInput {
	s.URLAuthType = &v
	return s
}

// SetUrlAuthCustomAction sets the UrlAuthCustomAction field's value.
func (s *SignedUrlAuthActionForUpdateCdnConfigInput) SetUrlAuthCustomAction(v *UrlAuthCustomActionForUpdateCdnConfigInput) *SignedUrlAuthActionForUpdateCdnConfigInput {
	s.UrlAuthCustomAction = v
	return s
}

type SignedUrlAuthForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	SignedUrlAuthRules []*SignedUrlAuthRuleForUpdateCdnConfigInput `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s SignedUrlAuthForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SignedUrlAuthForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetSignedUrlAuthRules sets the SignedUrlAuthRules field's value.
func (s *SignedUrlAuthForUpdateCdnConfigInput) SetSignedUrlAuthRules(v []*SignedUrlAuthRuleForUpdateCdnConfigInput) *SignedUrlAuthForUpdateCdnConfigInput {
	s.SignedUrlAuthRules = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *SignedUrlAuthForUpdateCdnConfigInput) SetSwitch(v bool) *SignedUrlAuthForUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type SignedUrlAuthRuleForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Condition *ConditionForUpdateCdnConfigInput `type:"structure"`

	SignedUrlAuthAction *SignedUrlAuthActionForUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s SignedUrlAuthRuleForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SignedUrlAuthRuleForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *SignedUrlAuthRuleForUpdateCdnConfigInput) SetCondition(v *ConditionForUpdateCdnConfigInput) *SignedUrlAuthRuleForUpdateCdnConfigInput {
	s.Condition = v
	return s
}

// SetSignedUrlAuthAction sets the SignedUrlAuthAction field's value.
func (s *SignedUrlAuthRuleForUpdateCdnConfigInput) SetSignedUrlAuthAction(v *SignedUrlAuthActionForUpdateCdnConfigInput) *SignedUrlAuthRuleForUpdateCdnConfigInput {
	s.SignedUrlAuthAction = v
	return s
}

type SpeedLimitTimeForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	BeginTime *string `type:"string"`

	DayWeek *string `type:"string"`

	EndTime *string `type:"string"`
}

// String returns the string representation
func (s SpeedLimitTimeForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SpeedLimitTimeForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetBeginTime sets the BeginTime field's value.
func (s *SpeedLimitTimeForUpdateCdnConfigInput) SetBeginTime(v string) *SpeedLimitTimeForUpdateCdnConfigInput {
	s.BeginTime = &v
	return s
}

// SetDayWeek sets the DayWeek field's value.
func (s *SpeedLimitTimeForUpdateCdnConfigInput) SetDayWeek(v string) *SpeedLimitTimeForUpdateCdnConfigInput {
	s.DayWeek = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *SpeedLimitTimeForUpdateCdnConfigInput) SetEndTime(v string) *SpeedLimitTimeForUpdateCdnConfigInput {
	s.EndTime = &v
	return s
}

type StatusCodeActionForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	DefaultAction *string `type:"string"`

	FailCode *string `type:"string"`

	SuccessCode *string `type:"string"`
}

// String returns the string representation
func (s StatusCodeActionForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StatusCodeActionForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetDefaultAction sets the DefaultAction field's value.
func (s *StatusCodeActionForUpdateCdnConfigInput) SetDefaultAction(v string) *StatusCodeActionForUpdateCdnConfigInput {
	s.DefaultAction = &v
	return s
}

// SetFailCode sets the FailCode field's value.
func (s *StatusCodeActionForUpdateCdnConfigInput) SetFailCode(v string) *StatusCodeActionForUpdateCdnConfigInput {
	s.FailCode = &v
	return s
}

// SetSuccessCode sets the SuccessCode field's value.
func (s *StatusCodeActionForUpdateCdnConfigInput) SetSuccessCode(v string) *StatusCodeActionForUpdateCdnConfigInput {
	s.SuccessCode = &v
	return s
}

type TargetQueryComponentsForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Action *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s TargetQueryComponentsForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TargetQueryComponentsForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *TargetQueryComponentsForUpdateCdnConfigInput) SetAction(v string) *TargetQueryComponentsForUpdateCdnConfigInput {
	s.Action = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TargetQueryComponentsForUpdateCdnConfigInput) SetValue(v string) *TargetQueryComponentsForUpdateCdnConfigInput {
	s.Value = &v
	return s
}

type TimeOutActionForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Action *string `type:"string"`

	Time *int64 `type:"int64"`
}

// String returns the string representation
func (s TimeOutActionForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TimeOutActionForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *TimeOutActionForUpdateCdnConfigInput) SetAction(v string) *TimeOutActionForUpdateCdnConfigInput {
	s.Action = &v
	return s
}

// SetTime sets the Time field's value.
func (s *TimeOutActionForUpdateCdnConfigInput) SetTime(v int64) *TimeOutActionForUpdateCdnConfigInput {
	s.Time = &v
	return s
}

type TimeoutForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Switch *bool `type:"boolean"`

	TimeoutRules []*TimeoutRuleForUpdateCdnConfigInput `type:"list"`
}

// String returns the string representation
func (s TimeoutForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TimeoutForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetSwitch sets the Switch field's value.
func (s *TimeoutForUpdateCdnConfigInput) SetSwitch(v bool) *TimeoutForUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

// SetTimeoutRules sets the TimeoutRules field's value.
func (s *TimeoutForUpdateCdnConfigInput) SetTimeoutRules(v []*TimeoutRuleForUpdateCdnConfigInput) *TimeoutForUpdateCdnConfigInput {
	s.TimeoutRules = v
	return s
}

type TimeoutRuleForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Condition *ConditionForUpdateCdnConfigInput `type:"structure"`

	TimeoutAction *ConvertTimeoutActionForUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s TimeoutRuleForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TimeoutRuleForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *TimeoutRuleForUpdateCdnConfigInput) SetCondition(v *ConditionForUpdateCdnConfigInput) *TimeoutRuleForUpdateCdnConfigInput {
	s.Condition = v
	return s
}

// SetTimeoutAction sets the TimeoutAction field's value.
func (s *TimeoutRuleForUpdateCdnConfigInput) SetTimeoutAction(v *ConvertTimeoutActionForUpdateCdnConfigInput) *TimeoutRuleForUpdateCdnConfigInput {
	s.TimeoutAction = v
	return s
}

type TosAuthInformationForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	AccessKeyId *string `type:"string"`

	AccessKeySecret *string `type:"string"`

	AccountKey *string `type:"string"`
}

// String returns the string representation
func (s TosAuthInformationForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TosAuthInformationForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAccessKeyId sets the AccessKeyId field's value.
func (s *TosAuthInformationForUpdateCdnConfigInput) SetAccessKeyId(v string) *TosAuthInformationForUpdateCdnConfigInput {
	s.AccessKeyId = &v
	return s
}

// SetAccessKeySecret sets the AccessKeySecret field's value.
func (s *TosAuthInformationForUpdateCdnConfigInput) SetAccessKeySecret(v string) *TosAuthInformationForUpdateCdnConfigInput {
	s.AccessKeySecret = &v
	return s
}

// SetAccountKey sets the AccountKey field's value.
func (s *TosAuthInformationForUpdateCdnConfigInput) SetAccountKey(v string) *TosAuthInformationForUpdateCdnConfigInput {
	s.AccountKey = &v
	return s
}

type UaAccessRuleForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	AllowEmpty *bool `type:"boolean"`

	IgnoreCase *bool `type:"boolean"`

	RuleType *string `type:"string"`

	Switch *bool `type:"boolean"`

	UserAgent []*string `type:"list"`
}

// String returns the string representation
func (s UaAccessRuleForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UaAccessRuleForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetAllowEmpty sets the AllowEmpty field's value.
func (s *UaAccessRuleForUpdateCdnConfigInput) SetAllowEmpty(v bool) *UaAccessRuleForUpdateCdnConfigInput {
	s.AllowEmpty = &v
	return s
}

// SetIgnoreCase sets the IgnoreCase field's value.
func (s *UaAccessRuleForUpdateCdnConfigInput) SetIgnoreCase(v bool) *UaAccessRuleForUpdateCdnConfigInput {
	s.IgnoreCase = &v
	return s
}

// SetRuleType sets the RuleType field's value.
func (s *UaAccessRuleForUpdateCdnConfigInput) SetRuleType(v string) *UaAccessRuleForUpdateCdnConfigInput {
	s.RuleType = &v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *UaAccessRuleForUpdateCdnConfigInput) SetSwitch(v bool) *UaAccessRuleForUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

// SetUserAgent sets the UserAgent field's value.
func (s *UaAccessRuleForUpdateCdnConfigInput) SetUserAgent(v []*string) *UaAccessRuleForUpdateCdnConfigInput {
	s.UserAgent = v
	return s
}

type UpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	AreaAccessRule *AreaAccessRuleForUpdateCdnConfigInput `type:"structure"`

	BandwidthLimit *BandwidthLimitForUpdateCdnConfigInput `type:"structure"`

	BrowserCache []*BrowserCacheForUpdateCdnConfigInput `type:"list"`

	Cache []*CacheForUpdateCdnConfigInput `type:"list"`

	CacheHost *CacheHostForUpdateCdnConfigInput `type:"structure"`

	CacheKey []*CacheKeyForUpdateCdnConfigInput `type:"list"`

	Compression *CompressionForUpdateCdnConfigInput `type:"structure"`

	ConditionalOrigin *ConditionalOriginForUpdateCdnConfigInput `type:"structure"`

	CustomErrorPage *CustomErrorPageForUpdateCdnConfigInput `type:"structure"`

	CustomizeAccessRule *CustomizeAccessRuleForUpdateCdnConfigInput `type:"structure"`

	// Domain is a required field
	Domain *string `type:"string" required:"true"`

	DownloadSpeedLimit *DownloadSpeedLimitForUpdateCdnConfigInput `type:"structure"`

	FollowRedirect *bool `type:"boolean"`

	HTTPS *HTTPSForUpdateCdnConfigInput `type:"structure"`

	HttpForcedRedirect *HttpForcedRedirectForUpdateCdnConfigInput `type:"structure"`

	IPv6 *IPv6ForUpdateCdnConfigInput `type:"structure"`

	IpAccessRule *IpAccessRuleForUpdateCdnConfigInput `type:"structure"`

	IpFreqLimit *IpFreqLimitForUpdateCdnConfigInput `type:"structure"`

	MethodDeniedRule *MethodDeniedRuleForUpdateCdnConfigInput `type:"structure"`

	MultiRange *MultiRangeForUpdateCdnConfigInput `type:"structure"`

	NegativeCache []*NegativeCacheForUpdateCdnConfigInput `type:"list"`

	Origin []*OriginForUpdateCdnConfigInput `type:"list"`

	OriginAccessRule *OriginAccessRuleForUpdateCdnConfigInput `type:"structure"`

	OriginArg []*OriginArgForUpdateCdnConfigInput `type:"list"`

	OriginCertCheck *OriginCertCheckForUpdateCdnConfigInput `type:"structure"`

	OriginHost *string `type:"string"`

	OriginIPv6 *string `type:"string"`

	OriginProtocol *string `type:"string"`

	OriginRange *bool `type:"boolean"`

	OriginRetry *OriginRetryForUpdateCdnConfigInput `type:"structure"`

	OriginRewrite *OriginRewriteForUpdateCdnConfigInput `type:"structure"`

	OriginSni *OriginSniForUpdateCdnConfigInput `type:"structure"`

	PageOptimization *PageOptimizationForUpdateCdnConfigInput `type:"structure"`

	Quic *QuicForUpdateCdnConfigInput `type:"structure"`

	RedirectionRewrite *RedirectionRewriteForUpdateCdnConfigInput `type:"structure"`

	RefererAccessRule *RefererAccessRuleForUpdateCdnConfigInput `type:"structure"`

	RemoteAuth *RemoteAuthForUpdateCdnConfigInput `type:"structure"`

	RequestBlockRule *RequestBlockRuleForUpdateCdnConfigInput `type:"structure"`

	RequestHeader []*RequestHeaderForUpdateCdnConfigInput `type:"list"`

	ResponseHeader []*ResponseHeaderForUpdateCdnConfigInput `type:"list"`

	RewriteHLS *RewriteHLSForUpdateCdnConfigInput `type:"structure"`

	ServiceRegion *string `type:"string"`

	SignedUrlAuth *SignedUrlAuthForUpdateCdnConfigInput `type:"structure"`

	Timeout *TimeoutForUpdateCdnConfigInput `type:"structure"`

	UaAccessRule *UaAccessRuleForUpdateCdnConfigInput `type:"structure"`

	UrlNormalize *UrlNormalizeForUpdateCdnConfigInput `type:"structure"`

	VideoDrag *VideoDragForUpdateCdnConfigInput `type:"structure"`
}

// String returns the string representation
func (s UpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCdnConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCdnConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCdnConfigInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAreaAccessRule sets the AreaAccessRule field's value.
func (s *UpdateCdnConfigInput) SetAreaAccessRule(v *AreaAccessRuleForUpdateCdnConfigInput) *UpdateCdnConfigInput {
	s.AreaAccessRule = v
	return s
}

// SetBandwidthLimit sets the BandwidthLimit field's value.
func (s *UpdateCdnConfigInput) SetBandwidthLimit(v *BandwidthLimitForUpdateCdnConfigInput) *UpdateCdnConfigInput {
	s.BandwidthLimit = v
	return s
}

// SetBrowserCache sets the BrowserCache field's value.
func (s *UpdateCdnConfigInput) SetBrowserCache(v []*BrowserCacheForUpdateCdnConfigInput) *UpdateCdnConfigInput {
	s.BrowserCache = v
	return s
}

// SetCache sets the Cache field's value.
func (s *UpdateCdnConfigInput) SetCache(v []*CacheForUpdateCdnConfigInput) *UpdateCdnConfigInput {
	s.Cache = v
	return s
}

// SetCacheHost sets the CacheHost field's value.
func (s *UpdateCdnConfigInput) SetCacheHost(v *CacheHostForUpdateCdnConfigInput) *UpdateCdnConfigInput {
	s.CacheHost = v
	return s
}

// SetCacheKey sets the CacheKey field's value.
func (s *UpdateCdnConfigInput) SetCacheKey(v []*CacheKeyForUpdateCdnConfigInput) *UpdateCdnConfigInput {
	s.CacheKey = v
	return s
}

// SetCompression sets the Compression field's value.
func (s *UpdateCdnConfigInput) SetCompression(v *CompressionForUpdateCdnConfigInput) *UpdateCdnConfigInput {
	s.Compression = v
	return s
}

// SetConditionalOrigin sets the ConditionalOrigin field's value.
func (s *UpdateCdnConfigInput) SetConditionalOrigin(v *ConditionalOriginForUpdateCdnConfigInput) *UpdateCdnConfigInput {
	s.ConditionalOrigin = v
	return s
}

// SetCustomErrorPage sets the CustomErrorPage field's value.
func (s *UpdateCdnConfigInput) SetCustomErrorPage(v *CustomErrorPageForUpdateCdnConfigInput) *UpdateCdnConfigInput {
	s.CustomErrorPage = v
	return s
}

// SetCustomizeAccessRule sets the CustomizeAccessRule field's value.
func (s *UpdateCdnConfigInput) SetCustomizeAccessRule(v *CustomizeAccessRuleForUpdateCdnConfigInput) *UpdateCdnConfigInput {
	s.CustomizeAccessRule = v
	return s
}

// SetDomain sets the Domain field's value.
func (s *UpdateCdnConfigInput) SetDomain(v string) *UpdateCdnConfigInput {
	s.Domain = &v
	return s
}

// SetDownloadSpeedLimit sets the DownloadSpeedLimit field's value.
func (s *UpdateCdnConfigInput) SetDownloadSpeedLimit(v *DownloadSpeedLimitForUpdateCdnConfigInput) *UpdateCdnConfigInput {
	s.DownloadSpeedLimit = v
	return s
}

// SetFollowRedirect sets the FollowRedirect field's value.
func (s *UpdateCdnConfigInput) SetFollowRedirect(v bool) *UpdateCdnConfigInput {
	s.FollowRedirect = &v
	return s
}

// SetHTTPS sets the HTTPS field's value.
func (s *UpdateCdnConfigInput) SetHTTPS(v *HTTPSForUpdateCdnConfigInput) *UpdateCdnConfigInput {
	s.HTTPS = v
	return s
}

// SetHttpForcedRedirect sets the HttpForcedRedirect field's value.
func (s *UpdateCdnConfigInput) SetHttpForcedRedirect(v *HttpForcedRedirectForUpdateCdnConfigInput) *UpdateCdnConfigInput {
	s.HttpForcedRedirect = v
	return s
}

// SetIPv6 sets the IPv6 field's value.
func (s *UpdateCdnConfigInput) SetIPv6(v *IPv6ForUpdateCdnConfigInput) *UpdateCdnConfigInput {
	s.IPv6 = v
	return s
}

// SetIpAccessRule sets the IpAccessRule field's value.
func (s *UpdateCdnConfigInput) SetIpAccessRule(v *IpAccessRuleForUpdateCdnConfigInput) *UpdateCdnConfigInput {
	s.IpAccessRule = v
	return s
}

// SetIpFreqLimit sets the IpFreqLimit field's value.
func (s *UpdateCdnConfigInput) SetIpFreqLimit(v *IpFreqLimitForUpdateCdnConfigInput) *UpdateCdnConfigInput {
	s.IpFreqLimit = v
	return s
}

// SetMethodDeniedRule sets the MethodDeniedRule field's value.
func (s *UpdateCdnConfigInput) SetMethodDeniedRule(v *MethodDeniedRuleForUpdateCdnConfigInput) *UpdateCdnConfigInput {
	s.MethodDeniedRule = v
	return s
}

// SetMultiRange sets the MultiRange field's value.
func (s *UpdateCdnConfigInput) SetMultiRange(v *MultiRangeForUpdateCdnConfigInput) *UpdateCdnConfigInput {
	s.MultiRange = v
	return s
}

// SetNegativeCache sets the NegativeCache field's value.
func (s *UpdateCdnConfigInput) SetNegativeCache(v []*NegativeCacheForUpdateCdnConfigInput) *UpdateCdnConfigInput {
	s.NegativeCache = v
	return s
}

// SetOrigin sets the Origin field's value.
func (s *UpdateCdnConfigInput) SetOrigin(v []*OriginForUpdateCdnConfigInput) *UpdateCdnConfigInput {
	s.Origin = v
	return s
}

// SetOriginAccessRule sets the OriginAccessRule field's value.
func (s *UpdateCdnConfigInput) SetOriginAccessRule(v *OriginAccessRuleForUpdateCdnConfigInput) *UpdateCdnConfigInput {
	s.OriginAccessRule = v
	return s
}

// SetOriginArg sets the OriginArg field's value.
func (s *UpdateCdnConfigInput) SetOriginArg(v []*OriginArgForUpdateCdnConfigInput) *UpdateCdnConfigInput {
	s.OriginArg = v
	return s
}

// SetOriginCertCheck sets the OriginCertCheck field's value.
func (s *UpdateCdnConfigInput) SetOriginCertCheck(v *OriginCertCheckForUpdateCdnConfigInput) *UpdateCdnConfigInput {
	s.OriginCertCheck = v
	return s
}

// SetOriginHost sets the OriginHost field's value.
func (s *UpdateCdnConfigInput) SetOriginHost(v string) *UpdateCdnConfigInput {
	s.OriginHost = &v
	return s
}

// SetOriginIPv6 sets the OriginIPv6 field's value.
func (s *UpdateCdnConfigInput) SetOriginIPv6(v string) *UpdateCdnConfigInput {
	s.OriginIPv6 = &v
	return s
}

// SetOriginProtocol sets the OriginProtocol field's value.
func (s *UpdateCdnConfigInput) SetOriginProtocol(v string) *UpdateCdnConfigInput {
	s.OriginProtocol = &v
	return s
}

// SetOriginRange sets the OriginRange field's value.
func (s *UpdateCdnConfigInput) SetOriginRange(v bool) *UpdateCdnConfigInput {
	s.OriginRange = &v
	return s
}

// SetOriginRetry sets the OriginRetry field's value.
func (s *UpdateCdnConfigInput) SetOriginRetry(v *OriginRetryForUpdateCdnConfigInput) *UpdateCdnConfigInput {
	s.OriginRetry = v
	return s
}

// SetOriginRewrite sets the OriginRewrite field's value.
func (s *UpdateCdnConfigInput) SetOriginRewrite(v *OriginRewriteForUpdateCdnConfigInput) *UpdateCdnConfigInput {
	s.OriginRewrite = v
	return s
}

// SetOriginSni sets the OriginSni field's value.
func (s *UpdateCdnConfigInput) SetOriginSni(v *OriginSniForUpdateCdnConfigInput) *UpdateCdnConfigInput {
	s.OriginSni = v
	return s
}

// SetPageOptimization sets the PageOptimization field's value.
func (s *UpdateCdnConfigInput) SetPageOptimization(v *PageOptimizationForUpdateCdnConfigInput) *UpdateCdnConfigInput {
	s.PageOptimization = v
	return s
}

// SetQuic sets the Quic field's value.
func (s *UpdateCdnConfigInput) SetQuic(v *QuicForUpdateCdnConfigInput) *UpdateCdnConfigInput {
	s.Quic = v
	return s
}

// SetRedirectionRewrite sets the RedirectionRewrite field's value.
func (s *UpdateCdnConfigInput) SetRedirectionRewrite(v *RedirectionRewriteForUpdateCdnConfigInput) *UpdateCdnConfigInput {
	s.RedirectionRewrite = v
	return s
}

// SetRefererAccessRule sets the RefererAccessRule field's value.
func (s *UpdateCdnConfigInput) SetRefererAccessRule(v *RefererAccessRuleForUpdateCdnConfigInput) *UpdateCdnConfigInput {
	s.RefererAccessRule = v
	return s
}

// SetRemoteAuth sets the RemoteAuth field's value.
func (s *UpdateCdnConfigInput) SetRemoteAuth(v *RemoteAuthForUpdateCdnConfigInput) *UpdateCdnConfigInput {
	s.RemoteAuth = v
	return s
}

// SetRequestBlockRule sets the RequestBlockRule field's value.
func (s *UpdateCdnConfigInput) SetRequestBlockRule(v *RequestBlockRuleForUpdateCdnConfigInput) *UpdateCdnConfigInput {
	s.RequestBlockRule = v
	return s
}

// SetRequestHeader sets the RequestHeader field's value.
func (s *UpdateCdnConfigInput) SetRequestHeader(v []*RequestHeaderForUpdateCdnConfigInput) *UpdateCdnConfigInput {
	s.RequestHeader = v
	return s
}

// SetResponseHeader sets the ResponseHeader field's value.
func (s *UpdateCdnConfigInput) SetResponseHeader(v []*ResponseHeaderForUpdateCdnConfigInput) *UpdateCdnConfigInput {
	s.ResponseHeader = v
	return s
}

// SetRewriteHLS sets the RewriteHLS field's value.
func (s *UpdateCdnConfigInput) SetRewriteHLS(v *RewriteHLSForUpdateCdnConfigInput) *UpdateCdnConfigInput {
	s.RewriteHLS = v
	return s
}

// SetServiceRegion sets the ServiceRegion field's value.
func (s *UpdateCdnConfigInput) SetServiceRegion(v string) *UpdateCdnConfigInput {
	s.ServiceRegion = &v
	return s
}

// SetSignedUrlAuth sets the SignedUrlAuth field's value.
func (s *UpdateCdnConfigInput) SetSignedUrlAuth(v *SignedUrlAuthForUpdateCdnConfigInput) *UpdateCdnConfigInput {
	s.SignedUrlAuth = v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *UpdateCdnConfigInput) SetTimeout(v *TimeoutForUpdateCdnConfigInput) *UpdateCdnConfigInput {
	s.Timeout = v
	return s
}

// SetUaAccessRule sets the UaAccessRule field's value.
func (s *UpdateCdnConfigInput) SetUaAccessRule(v *UaAccessRuleForUpdateCdnConfigInput) *UpdateCdnConfigInput {
	s.UaAccessRule = v
	return s
}

// SetUrlNormalize sets the UrlNormalize field's value.
func (s *UpdateCdnConfigInput) SetUrlNormalize(v *UrlNormalizeForUpdateCdnConfigInput) *UpdateCdnConfigInput {
	s.UrlNormalize = v
	return s
}

// SetVideoDrag sets the VideoDrag field's value.
func (s *UpdateCdnConfigInput) SetVideoDrag(v *VideoDragForUpdateCdnConfigInput) *UpdateCdnConfigInput {
	s.VideoDrag = v
	return s
}

type UpdateCdnConfigOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata
}

// String returns the string representation
func (s UpdateCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCdnConfigOutput) GoString() string {
	return s.String()
}

type UriParamSupForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	JoinSymbol *string `type:"string"`

	SplitSymbol *string `type:"string"`

	StartLevel *int64 `type:"int64"`

	TermLevel *int64 `type:"int64"`
}

// String returns the string representation
func (s UriParamSupForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UriParamSupForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetJoinSymbol sets the JoinSymbol field's value.
func (s *UriParamSupForUpdateCdnConfigInput) SetJoinSymbol(v string) *UriParamSupForUpdateCdnConfigInput {
	s.JoinSymbol = &v
	return s
}

// SetSplitSymbol sets the SplitSymbol field's value.
func (s *UriParamSupForUpdateCdnConfigInput) SetSplitSymbol(v string) *UriParamSupForUpdateCdnConfigInput {
	s.SplitSymbol = &v
	return s
}

// SetStartLevel sets the StartLevel field's value.
func (s *UriParamSupForUpdateCdnConfigInput) SetStartLevel(v int64) *UriParamSupForUpdateCdnConfigInput {
	s.StartLevel = &v
	return s
}

// SetTermLevel sets the TermLevel field's value.
func (s *UriParamSupForUpdateCdnConfigInput) SetTermLevel(v int64) *UriParamSupForUpdateCdnConfigInput {
	s.TermLevel = &v
	return s
}

type UrlAuthCustomActionForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	ExpTimeCapRule *ExpTimeCapRuleForUpdateCdnConfigInput `type:"structure"`

	ParamCalRules []*string `type:"list"`

	SignCapRule *SignCapRuleForUpdateCdnConfigInput `type:"structure"`

	SignJoinSymbol *string `type:"string"`

	SignParam []*SignParamForUpdateCdnConfigInput `type:"list"`
}

// String returns the string representation
func (s UrlAuthCustomActionForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UrlAuthCustomActionForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetExpTimeCapRule sets the ExpTimeCapRule field's value.
func (s *UrlAuthCustomActionForUpdateCdnConfigInput) SetExpTimeCapRule(v *ExpTimeCapRuleForUpdateCdnConfigInput) *UrlAuthCustomActionForUpdateCdnConfigInput {
	s.ExpTimeCapRule = v
	return s
}

// SetParamCalRules sets the ParamCalRules field's value.
func (s *UrlAuthCustomActionForUpdateCdnConfigInput) SetParamCalRules(v []*string) *UrlAuthCustomActionForUpdateCdnConfigInput {
	s.ParamCalRules = v
	return s
}

// SetSignCapRule sets the SignCapRule field's value.
func (s *UrlAuthCustomActionForUpdateCdnConfigInput) SetSignCapRule(v *SignCapRuleForUpdateCdnConfigInput) *UrlAuthCustomActionForUpdateCdnConfigInput {
	s.SignCapRule = v
	return s
}

// SetSignJoinSymbol sets the SignJoinSymbol field's value.
func (s *UrlAuthCustomActionForUpdateCdnConfigInput) SetSignJoinSymbol(v string) *UrlAuthCustomActionForUpdateCdnConfigInput {
	s.SignJoinSymbol = &v
	return s
}

// SetSignParam sets the SignParam field's value.
func (s *UrlAuthCustomActionForUpdateCdnConfigInput) SetSignParam(v []*SignParamForUpdateCdnConfigInput) *UrlAuthCustomActionForUpdateCdnConfigInput {
	s.SignParam = v
	return s
}

type UrlNormalizeForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	NormalizeObject []*string `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s UrlNormalizeForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UrlNormalizeForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetNormalizeObject sets the NormalizeObject field's value.
func (s *UrlNormalizeForUpdateCdnConfigInput) SetNormalizeObject(v []*string) *UrlNormalizeForUpdateCdnConfigInput {
	s.NormalizeObject = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *UrlNormalizeForUpdateCdnConfigInput) SetSwitch(v bool) *UrlNormalizeForUpdateCdnConfigInput {
	s.Switch = &v
	return s
}

type VideoDragForUpdateCdnConfigInput struct {
	_ struct{} `type:"structure"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s VideoDragForUpdateCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s VideoDragForUpdateCdnConfigInput) GoString() string {
	return s.String()
}

// SetSwitch sets the Switch field's value.
func (s *VideoDragForUpdateCdnConfigInput) SetSwitch(v bool) *VideoDragForUpdateCdnConfigInput {
	s.Switch = &v
	return s
}
