// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package cdn

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListCertInfoCommon = "ListCertInfo"

// ListCertInfoCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListCertInfoCommon operation. The "output" return
// value will be populated with the ListCertInfoCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListCertInfoCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListCertInfoCommon Send returns without error.
//
// See ListCertInfoCommon for more information on using the ListCertInfoCommon
// API call, and error handling.
//
//    // Example sending a request using the ListCertInfoCommonRequest method.
//    req, resp := client.ListCertInfoCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CDN) ListCertInfoCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListCertInfoCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListCertInfoCommon API operation for CDN.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CDN's
// API operation ListCertInfoCommon for usage and error information.
func (c *CDN) ListCertInfoCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListCertInfoCommonRequest(input)
	return out, req.Send()
}

// ListCertInfoCommonWithContext is the same as ListCertInfoCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListCertInfoCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CDN) ListCertInfoCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListCertInfoCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCertInfo = "ListCertInfo"

// ListCertInfoRequest generates a "volcengine/request.Request" representing the
// client's request for the ListCertInfo operation. The "output" return
// value will be populated with the ListCertInfoCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListCertInfoCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListCertInfoCommon Send returns without error.
//
// See ListCertInfo for more information on using the ListCertInfo
// API call, and error handling.
//
//    // Example sending a request using the ListCertInfoRequest method.
//    req, resp := client.ListCertInfoRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CDN) ListCertInfoRequest(input *ListCertInfoInput) (req *request.Request, output *ListCertInfoOutput) {
	op := &request.Operation{
		Name:       opListCertInfo,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListCertInfoInput{}
	}

	output = &ListCertInfoOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListCertInfo API operation for CDN.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CDN's
// API operation ListCertInfo for usage and error information.
func (c *CDN) ListCertInfo(input *ListCertInfoInput) (*ListCertInfoOutput, error) {
	req, out := c.ListCertInfoRequest(input)
	return out, req.Send()
}

// ListCertInfoWithContext is the same as ListCertInfo with the addition of
// the ability to pass a context and additional request options.
//
// See ListCertInfo for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CDN) ListCertInfoWithContext(ctx volcengine.Context, input *ListCertInfoInput, opts ...request.Option) (*ListCertInfoOutput, error) {
	req, out := c.ListCertInfoRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CertFingerprintForListCertInfoOutput struct {
	_ struct{} `type:"structure"`

	Sha1 *string `type:"string"`

	Sha256 *string `type:"string"`
}

// String returns the string representation
func (s CertFingerprintForListCertInfoOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CertFingerprintForListCertInfoOutput) GoString() string {
	return s.String()
}

// SetSha1 sets the Sha1 field's value.
func (s *CertFingerprintForListCertInfoOutput) SetSha1(v string) *CertFingerprintForListCertInfoOutput {
	s.Sha1 = &v
	return s
}

// SetSha256 sets the Sha256 field's value.
func (s *CertFingerprintForListCertInfoOutput) SetSha256(v string) *CertFingerprintForListCertInfoOutput {
	s.Sha256 = &v
	return s
}

type CertInfoForListCertInfoOutput struct {
	_ struct{} `type:"structure"`

	CertFingerprint *CertFingerprintForListCertInfoOutput `type:"structure"`

	CertId *string `type:"string"`

	CertName *string `type:"string"`

	CertType *string `type:"string"`

	ConfiguredDomain *string `type:"string"`

	ConfiguredDomainDetail []*ConfiguredDomainDetailForListCertInfoOutput `type:"list"`

	Desc *string `type:"string"`

	DnsName *string `type:"string"`

	EffectiveTime *int64 `type:"int64"`

	EncryType *string `type:"string"`

	ExpireTime *int64 `type:"int64"`

	Source *string `type:"string"`

	Status *string `type:"string"`
}

// String returns the string representation
func (s CertInfoForListCertInfoOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CertInfoForListCertInfoOutput) GoString() string {
	return s.String()
}

// SetCertFingerprint sets the CertFingerprint field's value.
func (s *CertInfoForListCertInfoOutput) SetCertFingerprint(v *CertFingerprintForListCertInfoOutput) *CertInfoForListCertInfoOutput {
	s.CertFingerprint = v
	return s
}

// SetCertId sets the CertId field's value.
func (s *CertInfoForListCertInfoOutput) SetCertId(v string) *CertInfoForListCertInfoOutput {
	s.CertId = &v
	return s
}

// SetCertName sets the CertName field's value.
func (s *CertInfoForListCertInfoOutput) SetCertName(v string) *CertInfoForListCertInfoOutput {
	s.CertName = &v
	return s
}

// SetCertType sets the CertType field's value.
func (s *CertInfoForListCertInfoOutput) SetCertType(v string) *CertInfoForListCertInfoOutput {
	s.CertType = &v
	return s
}

// SetConfiguredDomain sets the ConfiguredDomain field's value.
func (s *CertInfoForListCertInfoOutput) SetConfiguredDomain(v string) *CertInfoForListCertInfoOutput {
	s.ConfiguredDomain = &v
	return s
}

// SetConfiguredDomainDetail sets the ConfiguredDomainDetail field's value.
func (s *CertInfoForListCertInfoOutput) SetConfiguredDomainDetail(v []*ConfiguredDomainDetailForListCertInfoOutput) *CertInfoForListCertInfoOutput {
	s.ConfiguredDomainDetail = v
	return s
}

// SetDesc sets the Desc field's value.
func (s *CertInfoForListCertInfoOutput) SetDesc(v string) *CertInfoForListCertInfoOutput {
	s.Desc = &v
	return s
}

// SetDnsName sets the DnsName field's value.
func (s *CertInfoForListCertInfoOutput) SetDnsName(v string) *CertInfoForListCertInfoOutput {
	s.DnsName = &v
	return s
}

// SetEffectiveTime sets the EffectiveTime field's value.
func (s *CertInfoForListCertInfoOutput) SetEffectiveTime(v int64) *CertInfoForListCertInfoOutput {
	s.EffectiveTime = &v
	return s
}

// SetEncryType sets the EncryType field's value.
func (s *CertInfoForListCertInfoOutput) SetEncryType(v string) *CertInfoForListCertInfoOutput {
	s.EncryType = &v
	return s
}

// SetExpireTime sets the ExpireTime field's value.
func (s *CertInfoForListCertInfoOutput) SetExpireTime(v int64) *CertInfoForListCertInfoOutput {
	s.ExpireTime = &v
	return s
}

// SetSource sets the Source field's value.
func (s *CertInfoForListCertInfoOutput) SetSource(v string) *CertInfoForListCertInfoOutput {
	s.Source = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CertInfoForListCertInfoOutput) SetStatus(v string) *CertInfoForListCertInfoOutput {
	s.Status = &v
	return s
}

type ConfiguredDomainDetailForListCertInfoOutput struct {
	_ struct{} `type:"structure"`

	Domain *string `type:"string"`

	Type *string `type:"string"`
}

// String returns the string representation
func (s ConfiguredDomainDetailForListCertInfoOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfiguredDomainDetailForListCertInfoOutput) GoString() string {
	return s.String()
}

// SetDomain sets the Domain field's value.
func (s *ConfiguredDomainDetailForListCertInfoOutput) SetDomain(v string) *ConfiguredDomainDetailForListCertInfoOutput {
	s.Domain = &v
	return s
}

// SetType sets the Type field's value.
func (s *ConfiguredDomainDetailForListCertInfoOutput) SetType(v string) *ConfiguredDomainDetailForListCertInfoOutput {
	s.Type = &v
	return s
}

type ListCertInfoInput struct {
	_ struct{} `type:"structure"`

	CertId *string `type:"string"`

	CertType *string `type:"string"`

	ConfiguredDomain *string `type:"string"`

	EncryType *string `type:"string"`

	FuzzyMatch *bool `type:"boolean"`

	Name *string `type:"string"`

	PageNum *int32 `type:"int32"`

	PageSize *int32 `type:"int32"`

	SortRule *SortRuleForListCertInfoInput `type:"structure"`

	// Source is a required field
	Source *string `type:"string" required:"true"`

	Status *string `type:"string"`
}

// String returns the string representation
func (s ListCertInfoInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCertInfoInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCertInfoInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCertInfoInput"}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertId sets the CertId field's value.
func (s *ListCertInfoInput) SetCertId(v string) *ListCertInfoInput {
	s.CertId = &v
	return s
}

// SetCertType sets the CertType field's value.
func (s *ListCertInfoInput) SetCertType(v string) *ListCertInfoInput {
	s.CertType = &v
	return s
}

// SetConfiguredDomain sets the ConfiguredDomain field's value.
func (s *ListCertInfoInput) SetConfiguredDomain(v string) *ListCertInfoInput {
	s.ConfiguredDomain = &v
	return s
}

// SetEncryType sets the EncryType field's value.
func (s *ListCertInfoInput) SetEncryType(v string) *ListCertInfoInput {
	s.EncryType = &v
	return s
}

// SetFuzzyMatch sets the FuzzyMatch field's value.
func (s *ListCertInfoInput) SetFuzzyMatch(v bool) *ListCertInfoInput {
	s.FuzzyMatch = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListCertInfoInput) SetName(v string) *ListCertInfoInput {
	s.Name = &v
	return s
}

// SetPageNum sets the PageNum field's value.
func (s *ListCertInfoInput) SetPageNum(v int32) *ListCertInfoInput {
	s.PageNum = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListCertInfoInput) SetPageSize(v int32) *ListCertInfoInput {
	s.PageSize = &v
	return s
}

// SetSortRule sets the SortRule field's value.
func (s *ListCertInfoInput) SetSortRule(v *SortRuleForListCertInfoInput) *ListCertInfoInput {
	s.SortRule = v
	return s
}

// SetSource sets the Source field's value.
func (s *ListCertInfoInput) SetSource(v string) *ListCertInfoInput {
	s.Source = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListCertInfoInput) SetStatus(v string) *ListCertInfoInput {
	s.Status = &v
	return s
}

type ListCertInfoOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	CertInfo []*CertInfoForListCertInfoOutput `type:"list"`

	ExpiringCount *int64 `type:"int64"`

	PageNum *int64 `type:"int64"`

	PageSize *int64 `type:"int64"`

	Total *int64 `type:"int64"`
}

// String returns the string representation
func (s ListCertInfoOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCertInfoOutput) GoString() string {
	return s.String()
}

// SetCertInfo sets the CertInfo field's value.
func (s *ListCertInfoOutput) SetCertInfo(v []*CertInfoForListCertInfoOutput) *ListCertInfoOutput {
	s.CertInfo = v
	return s
}

// SetExpiringCount sets the ExpiringCount field's value.
func (s *ListCertInfoOutput) SetExpiringCount(v int64) *ListCertInfoOutput {
	s.ExpiringCount = &v
	return s
}

// SetPageNum sets the PageNum field's value.
func (s *ListCertInfoOutput) SetPageNum(v int64) *ListCertInfoOutput {
	s.PageNum = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListCertInfoOutput) SetPageSize(v int64) *ListCertInfoOutput {
	s.PageSize = &v
	return s
}

// SetTotal sets the Total field's value.
func (s *ListCertInfoOutput) SetTotal(v int64) *ListCertInfoOutput {
	s.Total = &v
	return s
}

type SortRuleForListCertInfoInput struct {
	_ struct{} `type:"structure"`

	Asc *bool `type:"boolean"`

	OrderBy *string `type:"string"`
}

// String returns the string representation
func (s SortRuleForListCertInfoInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SortRuleForListCertInfoInput) GoString() string {
	return s.String()
}

// SetAsc sets the Asc field's value.
func (s *SortRuleForListCertInfoInput) SetAsc(v bool) *SortRuleForListCertInfoInput {
	s.Asc = &v
	return s
}

// SetOrderBy sets the OrderBy field's value.
func (s *SortRuleForListCertInfoInput) SetOrderBy(v string) *SortRuleForListCertInfoInput {
	s.OrderBy = &v
	return s
}
