// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package cdn

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opAddCertificateCommon = "AddCertificate"

// AddCertificateCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the AddCertificateCommon operation. The "output" return
// value will be populated with the AddCertificateCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned AddCertificateCommon Request to send the API call to the service.
// the "output" return value is not valid until after AddCertificateCommon Send returns without error.
//
// See AddCertificateCommon for more information on using the AddCertificateCommon
// API call, and error handling.
//
//    // Example sending a request using the AddCertificateCommonRequest method.
//    req, resp := client.AddCertificateCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CDN) AddCertificateCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opAddCertificateCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// AddCertificateCommon API operation for CDN.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CDN's
// API operation AddCertificateCommon for usage and error information.
func (c *CDN) AddCertificateCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.AddCertificateCommonRequest(input)
	return out, req.Send()
}

// AddCertificateCommonWithContext is the same as AddCertificateCommon with the addition of
// the ability to pass a context and additional request options.
//
// See AddCertificateCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CDN) AddCertificateCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.AddCertificateCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddCertificate = "AddCertificate"

// AddCertificateRequest generates a "volcengine/request.Request" representing the
// client's request for the AddCertificate operation. The "output" return
// value will be populated with the AddCertificateCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned AddCertificateCommon Request to send the API call to the service.
// the "output" return value is not valid until after AddCertificateCommon Send returns without error.
//
// See AddCertificate for more information on using the AddCertificate
// API call, and error handling.
//
//    // Example sending a request using the AddCertificateRequest method.
//    req, resp := client.AddCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CDN) AddCertificateRequest(input *AddCertificateInput) (req *request.Request, output *AddCertificateOutput) {
	op := &request.Operation{
		Name:       opAddCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddCertificateInput{}
	}

	output = &AddCertificateOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// AddCertificate API operation for CDN.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CDN's
// API operation AddCertificate for usage and error information.
func (c *CDN) AddCertificate(input *AddCertificateInput) (*AddCertificateOutput, error) {
	req, out := c.AddCertificateRequest(input)
	return out, req.Send()
}

// AddCertificateWithContext is the same as AddCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See AddCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CDN) AddCertificateWithContext(ctx volcengine.Context, input *AddCertificateInput, opts ...request.Option) (*AddCertificateOutput, error) {
	req, out := c.AddCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AddCertificateInput struct {
	_ struct{} `type:"structure"`

	CertType *string `type:"string"`

	// Certificate is a required field
	Certificate *string `type:"string" required:"true"`

	Desc *string `type:"string"`

	EncryType *string `type:"string"`

	EncryptionCert *string `type:"string"`

	EncryptionKey *string `type:"string"`

	// PrivateKey is a required field
	PrivateKey *string `type:"string" required:"true"`

	Repeatable *bool `type:"boolean"`

	Source *string `type:"string"`
}

// String returns the string representation
func (s AddCertificateInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AddCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddCertificateInput"}
	if s.Certificate == nil {
		invalidParams.Add(request.NewErrParamRequired("Certificate"))
	}
	if s.PrivateKey == nil {
		invalidParams.Add(request.NewErrParamRequired("PrivateKey"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertType sets the CertType field's value.
func (s *AddCertificateInput) SetCertType(v string) *AddCertificateInput {
	s.CertType = &v
	return s
}

// SetCertificate sets the Certificate field's value.
func (s *AddCertificateInput) SetCertificate(v string) *AddCertificateInput {
	s.Certificate = &v
	return s
}

// SetDesc sets the Desc field's value.
func (s *AddCertificateInput) SetDesc(v string) *AddCertificateInput {
	s.Desc = &v
	return s
}

// SetEncryType sets the EncryType field's value.
func (s *AddCertificateInput) SetEncryType(v string) *AddCertificateInput {
	s.EncryType = &v
	return s
}

// SetEncryptionCert sets the EncryptionCert field's value.
func (s *AddCertificateInput) SetEncryptionCert(v string) *AddCertificateInput {
	s.EncryptionCert = &v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *AddCertificateInput) SetEncryptionKey(v string) *AddCertificateInput {
	s.EncryptionKey = &v
	return s
}

// SetPrivateKey sets the PrivateKey field's value.
func (s *AddCertificateInput) SetPrivateKey(v string) *AddCertificateInput {
	s.PrivateKey = &v
	return s
}

// SetRepeatable sets the Repeatable field's value.
func (s *AddCertificateInput) SetRepeatable(v bool) *AddCertificateInput {
	s.Repeatable = &v
	return s
}

// SetSource sets the Source field's value.
func (s *AddCertificateInput) SetSource(v string) *AddCertificateInput {
	s.Source = &v
	return s
}

type AddCertificateOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	CertId *string `type:"string"`
}

// String returns the string representation
func (s AddCertificateOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AddCertificateOutput) GoString() string {
	return s.String()
}

// SetCertId sets the CertId field's value.
func (s *AddCertificateOutput) SetCertId(v string) *AddCertificateOutput {
	s.CertId = &v
	return s
}
