// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package cdn

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opAddCdnDomainCommon = "AddCdnDomain"

// AddCdnDomainCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the AddCdnDomainCommon operation. The "output" return
// value will be populated with the AddCdnDomainCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned AddCdnDomainCommon Request to send the API call to the service.
// the "output" return value is not valid until after AddCdnDomainCommon Send returns without error.
//
// See AddCdnDomainCommon for more information on using the AddCdnDomainCommon
// API call, and error handling.
//
//    // Example sending a request using the AddCdnDomainCommonRequest method.
//    req, resp := client.AddCdnDomainCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CDN) AddCdnDomainCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opAddCdnDomainCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// AddCdnDomainCommon API operation for CDN.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CDN's
// API operation AddCdnDomainCommon for usage and error information.
func (c *CDN) AddCdnDomainCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.AddCdnDomainCommonRequest(input)
	return out, req.Send()
}

// AddCdnDomainCommonWithContext is the same as AddCdnDomainCommon with the addition of
// the ability to pass a context and additional request options.
//
// See AddCdnDomainCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CDN) AddCdnDomainCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.AddCdnDomainCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddCdnDomain = "AddCdnDomain"

// AddCdnDomainRequest generates a "volcengine/request.Request" representing the
// client's request for the AddCdnDomain operation. The "output" return
// value will be populated with the AddCdnDomainCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned AddCdnDomainCommon Request to send the API call to the service.
// the "output" return value is not valid until after AddCdnDomainCommon Send returns without error.
//
// See AddCdnDomain for more information on using the AddCdnDomain
// API call, and error handling.
//
//    // Example sending a request using the AddCdnDomainRequest method.
//    req, resp := client.AddCdnDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CDN) AddCdnDomainRequest(input *AddCdnDomainInput) (req *request.Request, output *AddCdnDomainOutput) {
	op := &request.Operation{
		Name:       opAddCdnDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddCdnDomainInput{}
	}

	output = &AddCdnDomainOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// AddCdnDomain API operation for CDN.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CDN's
// API operation AddCdnDomain for usage and error information.
func (c *CDN) AddCdnDomain(input *AddCdnDomainInput) (*AddCdnDomainOutput, error) {
	req, out := c.AddCdnDomainRequest(input)
	return out, req.Send()
}

// AddCdnDomainWithContext is the same as AddCdnDomain with the addition of
// the ability to pass a context and additional request options.
//
// See AddCdnDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CDN) AddCdnDomainWithContext(ctx volcengine.Context, input *AddCdnDomainInput, opts ...request.Option) (*AddCdnDomainOutput, error) {
	req, out := c.AddCdnDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AccessActionForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	AllowEmpty *bool `type:"boolean"`

	ListRules []*string `type:"list"`

	RequestHeader *string `type:"string"`

	RuleType *string `type:"string"`
}

// String returns the string representation
func (s AccessActionForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessActionForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetAllowEmpty sets the AllowEmpty field's value.
func (s *AccessActionForAddCdnDomainInput) SetAllowEmpty(v bool) *AccessActionForAddCdnDomainInput {
	s.AllowEmpty = &v
	return s
}

// SetListRules sets the ListRules field's value.
func (s *AccessActionForAddCdnDomainInput) SetListRules(v []*string) *AccessActionForAddCdnDomainInput {
	s.ListRules = v
	return s
}

// SetRequestHeader sets the RequestHeader field's value.
func (s *AccessActionForAddCdnDomainInput) SetRequestHeader(v string) *AccessActionForAddCdnDomainInput {
	s.RequestHeader = &v
	return s
}

// SetRuleType sets the RuleType field's value.
func (s *AccessActionForAddCdnDomainInput) SetRuleType(v string) *AccessActionForAddCdnDomainInput {
	s.RuleType = &v
	return s
}

type ActionsForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	OriginLines []*OriginLineForAddCdnDomainInput `type:"list"`
}

// String returns the string representation
func (s ActionsForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ActionsForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetOriginLines sets the OriginLines field's value.
func (s *ActionsForAddCdnDomainInput) SetOriginLines(v []*OriginLineForAddCdnDomainInput) *ActionsForAddCdnDomainInput {
	s.OriginLines = v
	return s
}

type AddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	AreaAccessRule *AreaAccessRuleForAddCdnDomainInput `type:"structure"`

	BandwidthLimit *BandwidthLimitForAddCdnDomainInput `type:"structure"`

	BrowserCache []*BrowserCacheForAddCdnDomainInput `type:"list"`

	Cache []*CacheForAddCdnDomainInput `type:"list"`

	CacheHost *CacheHostForAddCdnDomainInput `type:"structure"`

	CacheKey []*CacheKeyForAddCdnDomainInput `type:"list"`

	Compression *CompressionForAddCdnDomainInput `type:"structure"`

	ConditionalOrigin *ConditionalOriginForAddCdnDomainInput `type:"structure"`

	CustomErrorPage *CustomErrorPageForAddCdnDomainInput `type:"structure"`

	CustomizeAccessRule *CustomizeAccessRuleForAddCdnDomainInput `type:"structure"`

	// Domain is a required field
	Domain *string `type:"string" required:"true"`

	DownloadSpeedLimit *DownloadSpeedLimitForAddCdnDomainInput `type:"structure"`

	FollowRedirect *bool `type:"boolean"`

	HTTPS *HTTPSForAddCdnDomainInput `type:"structure"`

	HttpForcedRedirect *HttpForcedRedirectForAddCdnDomainInput `type:"structure"`

	IPv6 *IPv6ForAddCdnDomainInput `type:"structure"`

	IpAccessRule *IpAccessRuleForAddCdnDomainInput `type:"structure"`

	IpFreqLimit *IpFreqLimitForAddCdnDomainInput `type:"structure"`

	MethodDeniedRule *MethodDeniedRuleForAddCdnDomainInput `type:"structure"`

	MultiRange *MultiRangeForAddCdnDomainInput `type:"structure"`

	NegativeCache []*NegativeCacheForAddCdnDomainInput `type:"list"`

	Origin []*OriginForAddCdnDomainInput `type:"list"`

	OriginAccessRule *OriginAccessRuleForAddCdnDomainInput `type:"structure"`

	OriginArg []*OriginArgForAddCdnDomainInput `type:"list"`

	OriginCertCheck *OriginCertCheckForAddCdnDomainInput `type:"structure"`

	OriginHost *string `type:"string"`

	OriginIPv6 *string `type:"string"`

	OriginProtocol *string `type:"string"`

	OriginRange *bool `type:"boolean"`

	OriginRetry *OriginRetryForAddCdnDomainInput `type:"structure"`

	OriginRewrite *OriginRewriteForAddCdnDomainInput `type:"structure"`

	OriginSni *OriginSniForAddCdnDomainInput `type:"structure"`

	PageOptimization *PageOptimizationForAddCdnDomainInput `type:"structure"`

	Project *string `type:"string"`

	Quic *QuicForAddCdnDomainInput `type:"structure"`

	RedirectionRewrite *RedirectionRewriteForAddCdnDomainInput `type:"structure"`

	RefererAccessRule *RefererAccessRuleForAddCdnDomainInput `type:"structure"`

	RemoteAuth *RemoteAuthForAddCdnDomainInput `type:"structure"`

	RequestBlockRule *RequestBlockRuleForAddCdnDomainInput `type:"structure"`

	RequestHeader []*RequestHeaderForAddCdnDomainInput `type:"list"`

	ResourceTags []*ResourceTagForAddCdnDomainInput `type:"list"`

	ResponseHeader []*ResponseHeaderForAddCdnDomainInput `type:"list"`

	RewriteHLS *RewriteHLSForAddCdnDomainInput `type:"structure"`

	ServiceRegion *string `type:"string"`

	// ServiceType is a required field
	ServiceType *string `type:"string" required:"true"`

	SignedUrlAuth *SignedUrlAuthForAddCdnDomainInput `type:"structure"`

	Timeout *TimeoutForAddCdnDomainInput `type:"structure"`

	UaAccessRule *UaAccessRuleForAddCdnDomainInput `type:"structure"`

	UrlNormalize *UrlNormalizeForAddCdnDomainInput `type:"structure"`

	VideoDrag *VideoDragForAddCdnDomainInput `type:"structure"`
}

// String returns the string representation
func (s AddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AddCdnDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddCdnDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddCdnDomainInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.ServiceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAreaAccessRule sets the AreaAccessRule field's value.
func (s *AddCdnDomainInput) SetAreaAccessRule(v *AreaAccessRuleForAddCdnDomainInput) *AddCdnDomainInput {
	s.AreaAccessRule = v
	return s
}

// SetBandwidthLimit sets the BandwidthLimit field's value.
func (s *AddCdnDomainInput) SetBandwidthLimit(v *BandwidthLimitForAddCdnDomainInput) *AddCdnDomainInput {
	s.BandwidthLimit = v
	return s
}

// SetBrowserCache sets the BrowserCache field's value.
func (s *AddCdnDomainInput) SetBrowserCache(v []*BrowserCacheForAddCdnDomainInput) *AddCdnDomainInput {
	s.BrowserCache = v
	return s
}

// SetCache sets the Cache field's value.
func (s *AddCdnDomainInput) SetCache(v []*CacheForAddCdnDomainInput) *AddCdnDomainInput {
	s.Cache = v
	return s
}

// SetCacheHost sets the CacheHost field's value.
func (s *AddCdnDomainInput) SetCacheHost(v *CacheHostForAddCdnDomainInput) *AddCdnDomainInput {
	s.CacheHost = v
	return s
}

// SetCacheKey sets the CacheKey field's value.
func (s *AddCdnDomainInput) SetCacheKey(v []*CacheKeyForAddCdnDomainInput) *AddCdnDomainInput {
	s.CacheKey = v
	return s
}

// SetCompression sets the Compression field's value.
func (s *AddCdnDomainInput) SetCompression(v *CompressionForAddCdnDomainInput) *AddCdnDomainInput {
	s.Compression = v
	return s
}

// SetConditionalOrigin sets the ConditionalOrigin field's value.
func (s *AddCdnDomainInput) SetConditionalOrigin(v *ConditionalOriginForAddCdnDomainInput) *AddCdnDomainInput {
	s.ConditionalOrigin = v
	return s
}

// SetCustomErrorPage sets the CustomErrorPage field's value.
func (s *AddCdnDomainInput) SetCustomErrorPage(v *CustomErrorPageForAddCdnDomainInput) *AddCdnDomainInput {
	s.CustomErrorPage = v
	return s
}

// SetCustomizeAccessRule sets the CustomizeAccessRule field's value.
func (s *AddCdnDomainInput) SetCustomizeAccessRule(v *CustomizeAccessRuleForAddCdnDomainInput) *AddCdnDomainInput {
	s.CustomizeAccessRule = v
	return s
}

// SetDomain sets the Domain field's value.
func (s *AddCdnDomainInput) SetDomain(v string) *AddCdnDomainInput {
	s.Domain = &v
	return s
}

// SetDownloadSpeedLimit sets the DownloadSpeedLimit field's value.
func (s *AddCdnDomainInput) SetDownloadSpeedLimit(v *DownloadSpeedLimitForAddCdnDomainInput) *AddCdnDomainInput {
	s.DownloadSpeedLimit = v
	return s
}

// SetFollowRedirect sets the FollowRedirect field's value.
func (s *AddCdnDomainInput) SetFollowRedirect(v bool) *AddCdnDomainInput {
	s.FollowRedirect = &v
	return s
}

// SetHTTPS sets the HTTPS field's value.
func (s *AddCdnDomainInput) SetHTTPS(v *HTTPSForAddCdnDomainInput) *AddCdnDomainInput {
	s.HTTPS = v
	return s
}

// SetHttpForcedRedirect sets the HttpForcedRedirect field's value.
func (s *AddCdnDomainInput) SetHttpForcedRedirect(v *HttpForcedRedirectForAddCdnDomainInput) *AddCdnDomainInput {
	s.HttpForcedRedirect = v
	return s
}

// SetIPv6 sets the IPv6 field's value.
func (s *AddCdnDomainInput) SetIPv6(v *IPv6ForAddCdnDomainInput) *AddCdnDomainInput {
	s.IPv6 = v
	return s
}

// SetIpAccessRule sets the IpAccessRule field's value.
func (s *AddCdnDomainInput) SetIpAccessRule(v *IpAccessRuleForAddCdnDomainInput) *AddCdnDomainInput {
	s.IpAccessRule = v
	return s
}

// SetIpFreqLimit sets the IpFreqLimit field's value.
func (s *AddCdnDomainInput) SetIpFreqLimit(v *IpFreqLimitForAddCdnDomainInput) *AddCdnDomainInput {
	s.IpFreqLimit = v
	return s
}

// SetMethodDeniedRule sets the MethodDeniedRule field's value.
func (s *AddCdnDomainInput) SetMethodDeniedRule(v *MethodDeniedRuleForAddCdnDomainInput) *AddCdnDomainInput {
	s.MethodDeniedRule = v
	return s
}

// SetMultiRange sets the MultiRange field's value.
func (s *AddCdnDomainInput) SetMultiRange(v *MultiRangeForAddCdnDomainInput) *AddCdnDomainInput {
	s.MultiRange = v
	return s
}

// SetNegativeCache sets the NegativeCache field's value.
func (s *AddCdnDomainInput) SetNegativeCache(v []*NegativeCacheForAddCdnDomainInput) *AddCdnDomainInput {
	s.NegativeCache = v
	return s
}

// SetOrigin sets the Origin field's value.
func (s *AddCdnDomainInput) SetOrigin(v []*OriginForAddCdnDomainInput) *AddCdnDomainInput {
	s.Origin = v
	return s
}

// SetOriginAccessRule sets the OriginAccessRule field's value.
func (s *AddCdnDomainInput) SetOriginAccessRule(v *OriginAccessRuleForAddCdnDomainInput) *AddCdnDomainInput {
	s.OriginAccessRule = v
	return s
}

// SetOriginArg sets the OriginArg field's value.
func (s *AddCdnDomainInput) SetOriginArg(v []*OriginArgForAddCdnDomainInput) *AddCdnDomainInput {
	s.OriginArg = v
	return s
}

// SetOriginCertCheck sets the OriginCertCheck field's value.
func (s *AddCdnDomainInput) SetOriginCertCheck(v *OriginCertCheckForAddCdnDomainInput) *AddCdnDomainInput {
	s.OriginCertCheck = v
	return s
}

// SetOriginHost sets the OriginHost field's value.
func (s *AddCdnDomainInput) SetOriginHost(v string) *AddCdnDomainInput {
	s.OriginHost = &v
	return s
}

// SetOriginIPv6 sets the OriginIPv6 field's value.
func (s *AddCdnDomainInput) SetOriginIPv6(v string) *AddCdnDomainInput {
	s.OriginIPv6 = &v
	return s
}

// SetOriginProtocol sets the OriginProtocol field's value.
func (s *AddCdnDomainInput) SetOriginProtocol(v string) *AddCdnDomainInput {
	s.OriginProtocol = &v
	return s
}

// SetOriginRange sets the OriginRange field's value.
func (s *AddCdnDomainInput) SetOriginRange(v bool) *AddCdnDomainInput {
	s.OriginRange = &v
	return s
}

// SetOriginRetry sets the OriginRetry field's value.
func (s *AddCdnDomainInput) SetOriginRetry(v *OriginRetryForAddCdnDomainInput) *AddCdnDomainInput {
	s.OriginRetry = v
	return s
}

// SetOriginRewrite sets the OriginRewrite field's value.
func (s *AddCdnDomainInput) SetOriginRewrite(v *OriginRewriteForAddCdnDomainInput) *AddCdnDomainInput {
	s.OriginRewrite = v
	return s
}

// SetOriginSni sets the OriginSni field's value.
func (s *AddCdnDomainInput) SetOriginSni(v *OriginSniForAddCdnDomainInput) *AddCdnDomainInput {
	s.OriginSni = v
	return s
}

// SetPageOptimization sets the PageOptimization field's value.
func (s *AddCdnDomainInput) SetPageOptimization(v *PageOptimizationForAddCdnDomainInput) *AddCdnDomainInput {
	s.PageOptimization = v
	return s
}

// SetProject sets the Project field's value.
func (s *AddCdnDomainInput) SetProject(v string) *AddCdnDomainInput {
	s.Project = &v
	return s
}

// SetQuic sets the Quic field's value.
func (s *AddCdnDomainInput) SetQuic(v *QuicForAddCdnDomainInput) *AddCdnDomainInput {
	s.Quic = v
	return s
}

// SetRedirectionRewrite sets the RedirectionRewrite field's value.
func (s *AddCdnDomainInput) SetRedirectionRewrite(v *RedirectionRewriteForAddCdnDomainInput) *AddCdnDomainInput {
	s.RedirectionRewrite = v
	return s
}

// SetRefererAccessRule sets the RefererAccessRule field's value.
func (s *AddCdnDomainInput) SetRefererAccessRule(v *RefererAccessRuleForAddCdnDomainInput) *AddCdnDomainInput {
	s.RefererAccessRule = v
	return s
}

// SetRemoteAuth sets the RemoteAuth field's value.
func (s *AddCdnDomainInput) SetRemoteAuth(v *RemoteAuthForAddCdnDomainInput) *AddCdnDomainInput {
	s.RemoteAuth = v
	return s
}

// SetRequestBlockRule sets the RequestBlockRule field's value.
func (s *AddCdnDomainInput) SetRequestBlockRule(v *RequestBlockRuleForAddCdnDomainInput) *AddCdnDomainInput {
	s.RequestBlockRule = v
	return s
}

// SetRequestHeader sets the RequestHeader field's value.
func (s *AddCdnDomainInput) SetRequestHeader(v []*RequestHeaderForAddCdnDomainInput) *AddCdnDomainInput {
	s.RequestHeader = v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *AddCdnDomainInput) SetResourceTags(v []*ResourceTagForAddCdnDomainInput) *AddCdnDomainInput {
	s.ResourceTags = v
	return s
}

// SetResponseHeader sets the ResponseHeader field's value.
func (s *AddCdnDomainInput) SetResponseHeader(v []*ResponseHeaderForAddCdnDomainInput) *AddCdnDomainInput {
	s.ResponseHeader = v
	return s
}

// SetRewriteHLS sets the RewriteHLS field's value.
func (s *AddCdnDomainInput) SetRewriteHLS(v *RewriteHLSForAddCdnDomainInput) *AddCdnDomainInput {
	s.RewriteHLS = v
	return s
}

// SetServiceRegion sets the ServiceRegion field's value.
func (s *AddCdnDomainInput) SetServiceRegion(v string) *AddCdnDomainInput {
	s.ServiceRegion = &v
	return s
}

// SetServiceType sets the ServiceType field's value.
func (s *AddCdnDomainInput) SetServiceType(v string) *AddCdnDomainInput {
	s.ServiceType = &v
	return s
}

// SetSignedUrlAuth sets the SignedUrlAuth field's value.
func (s *AddCdnDomainInput) SetSignedUrlAuth(v *SignedUrlAuthForAddCdnDomainInput) *AddCdnDomainInput {
	s.SignedUrlAuth = v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *AddCdnDomainInput) SetTimeout(v *TimeoutForAddCdnDomainInput) *AddCdnDomainInput {
	s.Timeout = v
	return s
}

// SetUaAccessRule sets the UaAccessRule field's value.
func (s *AddCdnDomainInput) SetUaAccessRule(v *UaAccessRuleForAddCdnDomainInput) *AddCdnDomainInput {
	s.UaAccessRule = v
	return s
}

// SetUrlNormalize sets the UrlNormalize field's value.
func (s *AddCdnDomainInput) SetUrlNormalize(v *UrlNormalizeForAddCdnDomainInput) *AddCdnDomainInput {
	s.UrlNormalize = v
	return s
}

// SetVideoDrag sets the VideoDrag field's value.
func (s *AddCdnDomainInput) SetVideoDrag(v *VideoDragForAddCdnDomainInput) *AddCdnDomainInput {
	s.VideoDrag = v
	return s
}

type AddCdnDomainOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata
}

// String returns the string representation
func (s AddCdnDomainOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AddCdnDomainOutput) GoString() string {
	return s.String()
}

type AreaAccessRuleForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Area []*string `type:"list"`

	RuleType *string `type:"string"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s AreaAccessRuleForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AreaAccessRuleForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetArea sets the Area field's value.
func (s *AreaAccessRuleForAddCdnDomainInput) SetArea(v []*string) *AreaAccessRuleForAddCdnDomainInput {
	s.Area = v
	return s
}

// SetRuleType sets the RuleType field's value.
func (s *AreaAccessRuleForAddCdnDomainInput) SetRuleType(v string) *AreaAccessRuleForAddCdnDomainInput {
	s.RuleType = &v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *AreaAccessRuleForAddCdnDomainInput) SetSwitch(v bool) *AreaAccessRuleForAddCdnDomainInput {
	s.Switch = &v
	return s
}

type AuthModeConfigForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	BackupRemoteAddr *string `type:"string"`

	MasterRemoteAddr *string `type:"string"`

	PathType *string `type:"string"`

	PathValue *string `type:"string"`

	RequestMethod *string `type:"string"`
}

// String returns the string representation
func (s AuthModeConfigForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthModeConfigForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetBackupRemoteAddr sets the BackupRemoteAddr field's value.
func (s *AuthModeConfigForAddCdnDomainInput) SetBackupRemoteAddr(v string) *AuthModeConfigForAddCdnDomainInput {
	s.BackupRemoteAddr = &v
	return s
}

// SetMasterRemoteAddr sets the MasterRemoteAddr field's value.
func (s *AuthModeConfigForAddCdnDomainInput) SetMasterRemoteAddr(v string) *AuthModeConfigForAddCdnDomainInput {
	s.MasterRemoteAddr = &v
	return s
}

// SetPathType sets the PathType field's value.
func (s *AuthModeConfigForAddCdnDomainInput) SetPathType(v string) *AuthModeConfigForAddCdnDomainInput {
	s.PathType = &v
	return s
}

// SetPathValue sets the PathValue field's value.
func (s *AuthModeConfigForAddCdnDomainInput) SetPathValue(v string) *AuthModeConfigForAddCdnDomainInput {
	s.PathValue = &v
	return s
}

// SetRequestMethod sets the RequestMethod field's value.
func (s *AuthModeConfigForAddCdnDomainInput) SetRequestMethod(v string) *AuthModeConfigForAddCdnDomainInput {
	s.RequestMethod = &v
	return s
}

type AuthResponseConfigForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	CacheAction *ConvertCacheActionForAddCdnDomainInput `type:"structure"`

	ResponseAction *ResponseActionForAddCdnDomainInput `type:"structure"`

	StatusCodeAction *StatusCodeActionForAddCdnDomainInput `type:"structure"`

	TimeOutAction *TimeOutActionForAddCdnDomainInput `type:"structure"`
}

// String returns the string representation
func (s AuthResponseConfigForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthResponseConfigForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetCacheAction sets the CacheAction field's value.
func (s *AuthResponseConfigForAddCdnDomainInput) SetCacheAction(v *ConvertCacheActionForAddCdnDomainInput) *AuthResponseConfigForAddCdnDomainInput {
	s.CacheAction = v
	return s
}

// SetResponseAction sets the ResponseAction field's value.
func (s *AuthResponseConfigForAddCdnDomainInput) SetResponseAction(v *ResponseActionForAddCdnDomainInput) *AuthResponseConfigForAddCdnDomainInput {
	s.ResponseAction = v
	return s
}

// SetStatusCodeAction sets the StatusCodeAction field's value.
func (s *AuthResponseConfigForAddCdnDomainInput) SetStatusCodeAction(v *StatusCodeActionForAddCdnDomainInput) *AuthResponseConfigForAddCdnDomainInput {
	s.StatusCodeAction = v
	return s
}

// SetTimeOutAction sets the TimeOutAction field's value.
func (s *AuthResponseConfigForAddCdnDomainInput) SetTimeOutAction(v *TimeOutActionForAddCdnDomainInput) *AuthResponseConfigForAddCdnDomainInput {
	s.TimeOutAction = v
	return s
}

type BandwidthLimitActionForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	BandwidthThreshold *int64 `type:"int64"`

	LimitType *string `type:"string"`

	SpeedLimitRate *int64 `type:"int64"`

	SpeedLimitRateMax *int64 `type:"int64"`
}

// String returns the string representation
func (s BandwidthLimitActionForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BandwidthLimitActionForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetBandwidthThreshold sets the BandwidthThreshold field's value.
func (s *BandwidthLimitActionForAddCdnDomainInput) SetBandwidthThreshold(v int64) *BandwidthLimitActionForAddCdnDomainInput {
	s.BandwidthThreshold = &v
	return s
}

// SetLimitType sets the LimitType field's value.
func (s *BandwidthLimitActionForAddCdnDomainInput) SetLimitType(v string) *BandwidthLimitActionForAddCdnDomainInput {
	s.LimitType = &v
	return s
}

// SetSpeedLimitRate sets the SpeedLimitRate field's value.
func (s *BandwidthLimitActionForAddCdnDomainInput) SetSpeedLimitRate(v int64) *BandwidthLimitActionForAddCdnDomainInput {
	s.SpeedLimitRate = &v
	return s
}

// SetSpeedLimitRateMax sets the SpeedLimitRateMax field's value.
func (s *BandwidthLimitActionForAddCdnDomainInput) SetSpeedLimitRateMax(v int64) *BandwidthLimitActionForAddCdnDomainInput {
	s.SpeedLimitRateMax = &v
	return s
}

type BandwidthLimitForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	BandwidthLimitRule *BandwidthLimitRuleForAddCdnDomainInput `type:"structure"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s BandwidthLimitForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BandwidthLimitForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetBandwidthLimitRule sets the BandwidthLimitRule field's value.
func (s *BandwidthLimitForAddCdnDomainInput) SetBandwidthLimitRule(v *BandwidthLimitRuleForAddCdnDomainInput) *BandwidthLimitForAddCdnDomainInput {
	s.BandwidthLimitRule = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *BandwidthLimitForAddCdnDomainInput) SetSwitch(v bool) *BandwidthLimitForAddCdnDomainInput {
	s.Switch = &v
	return s
}

type BandwidthLimitRuleForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	BandwidthLimitAction *BandwidthLimitActionForAddCdnDomainInput `type:"structure"`

	Condition *ConditionForAddCdnDomainInput `type:"structure"`
}

// String returns the string representation
func (s BandwidthLimitRuleForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BandwidthLimitRuleForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetBandwidthLimitAction sets the BandwidthLimitAction field's value.
func (s *BandwidthLimitRuleForAddCdnDomainInput) SetBandwidthLimitAction(v *BandwidthLimitActionForAddCdnDomainInput) *BandwidthLimitRuleForAddCdnDomainInput {
	s.BandwidthLimitAction = v
	return s
}

// SetCondition sets the Condition field's value.
func (s *BandwidthLimitRuleForAddCdnDomainInput) SetCondition(v *ConditionForAddCdnDomainInput) *BandwidthLimitRuleForAddCdnDomainInput {
	s.Condition = v
	return s
}

type BlockActionForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Action *string `type:"string"`

	ErrorPage *string `type:"string"`

	RedirectUrl *string `type:"string"`

	StatusCode *string `type:"string"`
}

// String returns the string representation
func (s BlockActionForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BlockActionForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *BlockActionForAddCdnDomainInput) SetAction(v string) *BlockActionForAddCdnDomainInput {
	s.Action = &v
	return s
}

// SetErrorPage sets the ErrorPage field's value.
func (s *BlockActionForAddCdnDomainInput) SetErrorPage(v string) *BlockActionForAddCdnDomainInput {
	s.ErrorPage = &v
	return s
}

// SetRedirectUrl sets the RedirectUrl field's value.
func (s *BlockActionForAddCdnDomainInput) SetRedirectUrl(v string) *BlockActionForAddCdnDomainInput {
	s.RedirectUrl = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *BlockActionForAddCdnDomainInput) SetStatusCode(v string) *BlockActionForAddCdnDomainInput {
	s.StatusCode = &v
	return s
}

type BlockRuleForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	BlockAction *BlockActionForAddCdnDomainInput `type:"structure"`

	Condition *ConditionForAddCdnDomainInput `type:"structure"`

	RuleName *string `type:"string"`
}

// String returns the string representation
func (s BlockRuleForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BlockRuleForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetBlockAction sets the BlockAction field's value.
func (s *BlockRuleForAddCdnDomainInput) SetBlockAction(v *BlockActionForAddCdnDomainInput) *BlockRuleForAddCdnDomainInput {
	s.BlockAction = v
	return s
}

// SetCondition sets the Condition field's value.
func (s *BlockRuleForAddCdnDomainInput) SetCondition(v *ConditionForAddCdnDomainInput) *BlockRuleForAddCdnDomainInput {
	s.Condition = v
	return s
}

// SetRuleName sets the RuleName field's value.
func (s *BlockRuleForAddCdnDomainInput) SetRuleName(v string) *BlockRuleForAddCdnDomainInput {
	s.RuleName = &v
	return s
}

type BrowserCacheForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	CacheAction *CacheActionForAddCdnDomainInput `type:"structure"`

	Condition *ConditionForAddCdnDomainInput `type:"structure"`
}

// String returns the string representation
func (s BrowserCacheForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BrowserCacheForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetCacheAction sets the CacheAction field's value.
func (s *BrowserCacheForAddCdnDomainInput) SetCacheAction(v *CacheActionForAddCdnDomainInput) *BrowserCacheForAddCdnDomainInput {
	s.CacheAction = v
	return s
}

// SetCondition sets the Condition field's value.
func (s *BrowserCacheForAddCdnDomainInput) SetCondition(v *ConditionForAddCdnDomainInput) *BrowserCacheForAddCdnDomainInput {
	s.Condition = v
	return s
}

type CacheActionForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Action *string `type:"string"`

	DefaultPolicy *string `type:"string"`

	IgnoreCase *bool `type:"boolean"`

	Ttl *int64 `type:"int64"`
}

// String returns the string representation
func (s CacheActionForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheActionForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *CacheActionForAddCdnDomainInput) SetAction(v string) *CacheActionForAddCdnDomainInput {
	s.Action = &v
	return s
}

// SetDefaultPolicy sets the DefaultPolicy field's value.
func (s *CacheActionForAddCdnDomainInput) SetDefaultPolicy(v string) *CacheActionForAddCdnDomainInput {
	s.DefaultPolicy = &v
	return s
}

// SetIgnoreCase sets the IgnoreCase field's value.
func (s *CacheActionForAddCdnDomainInput) SetIgnoreCase(v bool) *CacheActionForAddCdnDomainInput {
	s.IgnoreCase = &v
	return s
}

// SetTtl sets the Ttl field's value.
func (s *CacheActionForAddCdnDomainInput) SetTtl(v int64) *CacheActionForAddCdnDomainInput {
	s.Ttl = &v
	return s
}

type CacheForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	CacheAction *CacheActionForAddCdnDomainInput `type:"structure"`

	Condition *ConditionForAddCdnDomainInput `type:"structure"`
}

// String returns the string representation
func (s CacheForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetCacheAction sets the CacheAction field's value.
func (s *CacheForAddCdnDomainInput) SetCacheAction(v *CacheActionForAddCdnDomainInput) *CacheForAddCdnDomainInput {
	s.CacheAction = v
	return s
}

// SetCondition sets the Condition field's value.
func (s *CacheForAddCdnDomainInput) SetCondition(v *ConditionForAddCdnDomainInput) *CacheForAddCdnDomainInput {
	s.Condition = v
	return s
}

type CacheHostActionForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	CacheHost *string `type:"string"`
}

// String returns the string representation
func (s CacheHostActionForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheHostActionForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetCacheHost sets the CacheHost field's value.
func (s *CacheHostActionForAddCdnDomainInput) SetCacheHost(v string) *CacheHostActionForAddCdnDomainInput {
	s.CacheHost = &v
	return s
}

type CacheHostForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	CacheHostRule []*CacheHostRuleForAddCdnDomainInput `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s CacheHostForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheHostForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetCacheHostRule sets the CacheHostRule field's value.
func (s *CacheHostForAddCdnDomainInput) SetCacheHostRule(v []*CacheHostRuleForAddCdnDomainInput) *CacheHostForAddCdnDomainInput {
	s.CacheHostRule = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *CacheHostForAddCdnDomainInput) SetSwitch(v bool) *CacheHostForAddCdnDomainInput {
	s.Switch = &v
	return s
}

type CacheHostRuleForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	CacheHostAction *CacheHostActionForAddCdnDomainInput `type:"structure"`

	Condition *ConditionForAddCdnDomainInput `type:"structure"`
}

// String returns the string representation
func (s CacheHostRuleForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheHostRuleForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetCacheHostAction sets the CacheHostAction field's value.
func (s *CacheHostRuleForAddCdnDomainInput) SetCacheHostAction(v *CacheHostActionForAddCdnDomainInput) *CacheHostRuleForAddCdnDomainInput {
	s.CacheHostAction = v
	return s
}

// SetCondition sets the Condition field's value.
func (s *CacheHostRuleForAddCdnDomainInput) SetCondition(v *ConditionForAddCdnDomainInput) *CacheHostRuleForAddCdnDomainInput {
	s.Condition = v
	return s
}

type CacheKeyActionForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	CacheKeyComponents []*CacheKeyComponentForAddCdnDomainInput `type:"list"`
}

// String returns the string representation
func (s CacheKeyActionForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheKeyActionForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetCacheKeyComponents sets the CacheKeyComponents field's value.
func (s *CacheKeyActionForAddCdnDomainInput) SetCacheKeyComponents(v []*CacheKeyComponentForAddCdnDomainInput) *CacheKeyActionForAddCdnDomainInput {
	s.CacheKeyComponents = v
	return s
}

type CacheKeyComponentForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Action *string `type:"string"`

	IgnoreCase *bool `type:"boolean"`

	Object *string `type:"string"`

	Subobject *string `type:"string"`
}

// String returns the string representation
func (s CacheKeyComponentForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheKeyComponentForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *CacheKeyComponentForAddCdnDomainInput) SetAction(v string) *CacheKeyComponentForAddCdnDomainInput {
	s.Action = &v
	return s
}

// SetIgnoreCase sets the IgnoreCase field's value.
func (s *CacheKeyComponentForAddCdnDomainInput) SetIgnoreCase(v bool) *CacheKeyComponentForAddCdnDomainInput {
	s.IgnoreCase = &v
	return s
}

// SetObject sets the Object field's value.
func (s *CacheKeyComponentForAddCdnDomainInput) SetObject(v string) *CacheKeyComponentForAddCdnDomainInput {
	s.Object = &v
	return s
}

// SetSubobject sets the Subobject field's value.
func (s *CacheKeyComponentForAddCdnDomainInput) SetSubobject(v string) *CacheKeyComponentForAddCdnDomainInput {
	s.Subobject = &v
	return s
}

type CacheKeyForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	CacheKeyAction *CacheKeyActionForAddCdnDomainInput `type:"structure"`

	Condition *ConditionForAddCdnDomainInput `type:"structure"`
}

// String returns the string representation
func (s CacheKeyForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheKeyForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetCacheKeyAction sets the CacheKeyAction field's value.
func (s *CacheKeyForAddCdnDomainInput) SetCacheKeyAction(v *CacheKeyActionForAddCdnDomainInput) *CacheKeyForAddCdnDomainInput {
	s.CacheKeyAction = v
	return s
}

// SetCondition sets the Condition field's value.
func (s *CacheKeyForAddCdnDomainInput) SetCondition(v *ConditionForAddCdnDomainInput) *CacheKeyForAddCdnDomainInput {
	s.Condition = v
	return s
}

type CertCheckForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	CertInfoList []*CertInfoListForAddCdnDomainInput `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s CertCheckForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CertCheckForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetCertInfoList sets the CertInfoList field's value.
func (s *CertCheckForAddCdnDomainInput) SetCertInfoList(v []*CertInfoListForAddCdnDomainInput) *CertCheckForAddCdnDomainInput {
	s.CertInfoList = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *CertCheckForAddCdnDomainInput) SetSwitch(v bool) *CertCheckForAddCdnDomainInput {
	s.Switch = &v
	return s
}

type CertInfoForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	CertId *string `type:"string"`

	CertName *string `type:"string"`

	Certificate *CertificateForAddCdnDomainInput `type:"structure"`

	Desc *string `type:"string"`

	EffectiveTime *int64 `type:"int64"`

	EncryType *string `type:"string"`

	ExpireTime *int64 `type:"int64"`

	Source *string `type:"string"`
}

// String returns the string representation
func (s CertInfoForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CertInfoForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetCertId sets the CertId field's value.
func (s *CertInfoForAddCdnDomainInput) SetCertId(v string) *CertInfoForAddCdnDomainInput {
	s.CertId = &v
	return s
}

// SetCertName sets the CertName field's value.
func (s *CertInfoForAddCdnDomainInput) SetCertName(v string) *CertInfoForAddCdnDomainInput {
	s.CertName = &v
	return s
}

// SetCertificate sets the Certificate field's value.
func (s *CertInfoForAddCdnDomainInput) SetCertificate(v *CertificateForAddCdnDomainInput) *CertInfoForAddCdnDomainInput {
	s.Certificate = v
	return s
}

// SetDesc sets the Desc field's value.
func (s *CertInfoForAddCdnDomainInput) SetDesc(v string) *CertInfoForAddCdnDomainInput {
	s.Desc = &v
	return s
}

// SetEffectiveTime sets the EffectiveTime field's value.
func (s *CertInfoForAddCdnDomainInput) SetEffectiveTime(v int64) *CertInfoForAddCdnDomainInput {
	s.EffectiveTime = &v
	return s
}

// SetEncryType sets the EncryType field's value.
func (s *CertInfoForAddCdnDomainInput) SetEncryType(v string) *CertInfoForAddCdnDomainInput {
	s.EncryType = &v
	return s
}

// SetExpireTime sets the ExpireTime field's value.
func (s *CertInfoForAddCdnDomainInput) SetExpireTime(v int64) *CertInfoForAddCdnDomainInput {
	s.ExpireTime = &v
	return s
}

// SetSource sets the Source field's value.
func (s *CertInfoForAddCdnDomainInput) SetSource(v string) *CertInfoForAddCdnDomainInput {
	s.Source = &v
	return s
}

type CertInfoListForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	CertId *string `type:"string"`

	CertName *string `type:"string"`

	Certificate *CertificateForAddCdnDomainInput `type:"structure"`

	Desc *string `type:"string"`

	EffectiveTime *int64 `type:"int64"`

	EncryType *string `type:"string"`

	ExpireTime *int64 `type:"int64"`

	Source *string `type:"string"`
}

// String returns the string representation
func (s CertInfoListForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CertInfoListForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetCertId sets the CertId field's value.
func (s *CertInfoListForAddCdnDomainInput) SetCertId(v string) *CertInfoListForAddCdnDomainInput {
	s.CertId = &v
	return s
}

// SetCertName sets the CertName field's value.
func (s *CertInfoListForAddCdnDomainInput) SetCertName(v string) *CertInfoListForAddCdnDomainInput {
	s.CertName = &v
	return s
}

// SetCertificate sets the Certificate field's value.
func (s *CertInfoListForAddCdnDomainInput) SetCertificate(v *CertificateForAddCdnDomainInput) *CertInfoListForAddCdnDomainInput {
	s.Certificate = v
	return s
}

// SetDesc sets the Desc field's value.
func (s *CertInfoListForAddCdnDomainInput) SetDesc(v string) *CertInfoListForAddCdnDomainInput {
	s.Desc = &v
	return s
}

// SetEffectiveTime sets the EffectiveTime field's value.
func (s *CertInfoListForAddCdnDomainInput) SetEffectiveTime(v int64) *CertInfoListForAddCdnDomainInput {
	s.EffectiveTime = &v
	return s
}

// SetEncryType sets the EncryType field's value.
func (s *CertInfoListForAddCdnDomainInput) SetEncryType(v string) *CertInfoListForAddCdnDomainInput {
	s.EncryType = &v
	return s
}

// SetExpireTime sets the ExpireTime field's value.
func (s *CertInfoListForAddCdnDomainInput) SetExpireTime(v int64) *CertInfoListForAddCdnDomainInput {
	s.ExpireTime = &v
	return s
}

// SetSource sets the Source field's value.
func (s *CertInfoListForAddCdnDomainInput) SetSource(v string) *CertInfoListForAddCdnDomainInput {
	s.Source = &v
	return s
}

type CertificateForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Certificate *string `type:"string"`

	EncryptionCert *string `type:"string"`

	EncryptionKey *string `type:"string"`

	PrivateKey *string `type:"string"`
}

// String returns the string representation
func (s CertificateForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CertificateForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetCertificate sets the Certificate field's value.
func (s *CertificateForAddCdnDomainInput) SetCertificate(v string) *CertificateForAddCdnDomainInput {
	s.Certificate = &v
	return s
}

// SetEncryptionCert sets the EncryptionCert field's value.
func (s *CertificateForAddCdnDomainInput) SetEncryptionCert(v string) *CertificateForAddCdnDomainInput {
	s.EncryptionCert = &v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *CertificateForAddCdnDomainInput) SetEncryptionKey(v string) *CertificateForAddCdnDomainInput {
	s.EncryptionKey = &v
	return s
}

// SetPrivateKey sets the PrivateKey field's value.
func (s *CertificateForAddCdnDomainInput) SetPrivateKey(v string) *CertificateForAddCdnDomainInput {
	s.PrivateKey = &v
	return s
}

type CommonTypeForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	IgnoreCase *bool `type:"boolean"`

	IgnoreScheme *bool `type:"boolean"`

	Referers []*string `type:"list"`
}

// String returns the string representation
func (s CommonTypeForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CommonTypeForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetIgnoreCase sets the IgnoreCase field's value.
func (s *CommonTypeForAddCdnDomainInput) SetIgnoreCase(v bool) *CommonTypeForAddCdnDomainInput {
	s.IgnoreCase = &v
	return s
}

// SetIgnoreScheme sets the IgnoreScheme field's value.
func (s *CommonTypeForAddCdnDomainInput) SetIgnoreScheme(v bool) *CommonTypeForAddCdnDomainInput {
	s.IgnoreScheme = &v
	return s
}

// SetReferers sets the Referers field's value.
func (s *CommonTypeForAddCdnDomainInput) SetReferers(v []*string) *CommonTypeForAddCdnDomainInput {
	s.Referers = v
	return s
}

type CompressionActionForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	CompressionFormat *string `type:"string"`

	CompressionTarget *string `type:"string"`

	CompressionType []*string `type:"list"`

	MinFileSizeKB *int64 `type:"int64"`
}

// String returns the string representation
func (s CompressionActionForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CompressionActionForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetCompressionFormat sets the CompressionFormat field's value.
func (s *CompressionActionForAddCdnDomainInput) SetCompressionFormat(v string) *CompressionActionForAddCdnDomainInput {
	s.CompressionFormat = &v
	return s
}

// SetCompressionTarget sets the CompressionTarget field's value.
func (s *CompressionActionForAddCdnDomainInput) SetCompressionTarget(v string) *CompressionActionForAddCdnDomainInput {
	s.CompressionTarget = &v
	return s
}

// SetCompressionType sets the CompressionType field's value.
func (s *CompressionActionForAddCdnDomainInput) SetCompressionType(v []*string) *CompressionActionForAddCdnDomainInput {
	s.CompressionType = v
	return s
}

// SetMinFileSizeKB sets the MinFileSizeKB field's value.
func (s *CompressionActionForAddCdnDomainInput) SetMinFileSizeKB(v int64) *CompressionActionForAddCdnDomainInput {
	s.MinFileSizeKB = &v
	return s
}

type CompressionForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	CompressionRules []*CompressionRuleForAddCdnDomainInput `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s CompressionForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CompressionForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetCompressionRules sets the CompressionRules field's value.
func (s *CompressionForAddCdnDomainInput) SetCompressionRules(v []*CompressionRuleForAddCdnDomainInput) *CompressionForAddCdnDomainInput {
	s.CompressionRules = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *CompressionForAddCdnDomainInput) SetSwitch(v bool) *CompressionForAddCdnDomainInput {
	s.Switch = &v
	return s
}

type CompressionRuleForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	CompressionAction *CompressionActionForAddCdnDomainInput `type:"structure"`

	Condition *ConditionForAddCdnDomainInput `type:"structure"`
}

// String returns the string representation
func (s CompressionRuleForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CompressionRuleForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetCompressionAction sets the CompressionAction field's value.
func (s *CompressionRuleForAddCdnDomainInput) SetCompressionAction(v *CompressionActionForAddCdnDomainInput) *CompressionRuleForAddCdnDomainInput {
	s.CompressionAction = v
	return s
}

// SetCondition sets the Condition field's value.
func (s *CompressionRuleForAddCdnDomainInput) SetCondition(v *ConditionForAddCdnDomainInput) *CompressionRuleForAddCdnDomainInput {
	s.Condition = v
	return s
}

type ConditionForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	ConditionRule []*ConditionRuleForAddCdnDomainInput `type:"list"`

	Connective *string `type:"string"`
}

// String returns the string representation
func (s ConditionForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConditionForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetConditionRule sets the ConditionRule field's value.
func (s *ConditionForAddCdnDomainInput) SetConditionRule(v []*ConditionRuleForAddCdnDomainInput) *ConditionForAddCdnDomainInput {
	s.ConditionRule = v
	return s
}

// SetConnective sets the Connective field's value.
func (s *ConditionForAddCdnDomainInput) SetConnective(v string) *ConditionForAddCdnDomainInput {
	s.Connective = &v
	return s
}

type ConditionGroupForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Condition *ConvertConditionForAddCdnDomainInput `type:"structure"`

	IsGroup *bool `type:"boolean"`
}

// String returns the string representation
func (s ConditionGroupForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConditionGroupForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *ConditionGroupForAddCdnDomainInput) SetCondition(v *ConvertConditionForAddCdnDomainInput) *ConditionGroupForAddCdnDomainInput {
	s.Condition = v
	return s
}

// SetIsGroup sets the IsGroup field's value.
func (s *ConditionGroupForAddCdnDomainInput) SetIsGroup(v bool) *ConditionGroupForAddCdnDomainInput {
	s.IsGroup = &v
	return s
}

type ConditionRuleForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Name *string `type:"string"`

	Object *string `type:"string"`

	Operator *string `type:"string"`

	Type *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s ConditionRuleForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConditionRuleForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *ConditionRuleForAddCdnDomainInput) SetName(v string) *ConditionRuleForAddCdnDomainInput {
	s.Name = &v
	return s
}

// SetObject sets the Object field's value.
func (s *ConditionRuleForAddCdnDomainInput) SetObject(v string) *ConditionRuleForAddCdnDomainInput {
	s.Object = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *ConditionRuleForAddCdnDomainInput) SetOperator(v string) *ConditionRuleForAddCdnDomainInput {
	s.Operator = &v
	return s
}

// SetType sets the Type field's value.
func (s *ConditionRuleForAddCdnDomainInput) SetType(v string) *ConditionRuleForAddCdnDomainInput {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ConditionRuleForAddCdnDomainInput) SetValue(v string) *ConditionRuleForAddCdnDomainInput {
	s.Value = &v
	return s
}

type ConditionalOriginForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	OriginRules []*OriginRuleForAddCdnDomainInput `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s ConditionalOriginForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConditionalOriginForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetOriginRules sets the OriginRules field's value.
func (s *ConditionalOriginForAddCdnDomainInput) SetOriginRules(v []*OriginRuleForAddCdnDomainInput) *ConditionalOriginForAddCdnDomainInput {
	s.OriginRules = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *ConditionalOriginForAddCdnDomainInput) SetSwitch(v bool) *ConditionalOriginForAddCdnDomainInput {
	s.Switch = &v
	return s
}

type ConvertCacheActionForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Action *string `type:"string"`

	CacheKey []*string `type:"list"`

	IgnoreCase *bool `type:"boolean"`

	Ttl *int64 `type:"int64"`
}

// String returns the string representation
func (s ConvertCacheActionForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertCacheActionForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *ConvertCacheActionForAddCdnDomainInput) SetAction(v string) *ConvertCacheActionForAddCdnDomainInput {
	s.Action = &v
	return s
}

// SetCacheKey sets the CacheKey field's value.
func (s *ConvertCacheActionForAddCdnDomainInput) SetCacheKey(v []*string) *ConvertCacheActionForAddCdnDomainInput {
	s.CacheKey = v
	return s
}

// SetIgnoreCase sets the IgnoreCase field's value.
func (s *ConvertCacheActionForAddCdnDomainInput) SetIgnoreCase(v bool) *ConvertCacheActionForAddCdnDomainInput {
	s.IgnoreCase = &v
	return s
}

// SetTtl sets the Ttl field's value.
func (s *ConvertCacheActionForAddCdnDomainInput) SetTtl(v int64) *ConvertCacheActionForAddCdnDomainInput {
	s.Ttl = &v
	return s
}

type ConvertConditionForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Object *string `type:"string"`

	Operator *string `type:"string"`

	Value []*string `type:"list"`
}

// String returns the string representation
func (s ConvertConditionForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertConditionForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetObject sets the Object field's value.
func (s *ConvertConditionForAddCdnDomainInput) SetObject(v string) *ConvertConditionForAddCdnDomainInput {
	s.Object = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *ConvertConditionForAddCdnDomainInput) SetOperator(v string) *ConvertConditionForAddCdnDomainInput {
	s.Operator = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ConvertConditionForAddCdnDomainInput) SetValue(v []*string) *ConvertConditionForAddCdnDomainInput {
	s.Value = v
	return s
}

type ConvertConvertConditionForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	ConditionGroups []*ConditionGroupForAddCdnDomainInput `type:"list"`

	Connective *string `type:"string"`

	IsGroup *bool `type:"boolean"`
}

// String returns the string representation
func (s ConvertConvertConditionForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertConvertConditionForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetConditionGroups sets the ConditionGroups field's value.
func (s *ConvertConvertConditionForAddCdnDomainInput) SetConditionGroups(v []*ConditionGroupForAddCdnDomainInput) *ConvertConvertConditionForAddCdnDomainInput {
	s.ConditionGroups = v
	return s
}

// SetConnective sets the Connective field's value.
func (s *ConvertConvertConditionForAddCdnDomainInput) SetConnective(v string) *ConvertConvertConditionForAddCdnDomainInput {
	s.Connective = &v
	return s
}

// SetIsGroup sets the IsGroup field's value.
func (s *ConvertConvertConditionForAddCdnDomainInput) SetIsGroup(v bool) *ConvertConvertConditionForAddCdnDomainInput {
	s.IsGroup = &v
	return s
}

type ConvertOriginLineForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Address *string `type:"string"`

	BucketName *string `type:"string"`

	HttpPort *string `type:"string"`

	HttpsPort *string `type:"string"`

	InstanceType *string `type:"string"`

	OriginHost *string `type:"string"`

	OriginType *string `type:"string"`

	PrivateBucketAccess *bool `type:"boolean"`

	PrivateBucketAuth *PrivateBucketAuthForAddCdnDomainInput `type:"structure"`

	Region *string `type:"string"`

	Weight *string `type:"string"`
}

// String returns the string representation
func (s ConvertOriginLineForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertOriginLineForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *ConvertOriginLineForAddCdnDomainInput) SetAddress(v string) *ConvertOriginLineForAddCdnDomainInput {
	s.Address = &v
	return s
}

// SetBucketName sets the BucketName field's value.
func (s *ConvertOriginLineForAddCdnDomainInput) SetBucketName(v string) *ConvertOriginLineForAddCdnDomainInput {
	s.BucketName = &v
	return s
}

// SetHttpPort sets the HttpPort field's value.
func (s *ConvertOriginLineForAddCdnDomainInput) SetHttpPort(v string) *ConvertOriginLineForAddCdnDomainInput {
	s.HttpPort = &v
	return s
}

// SetHttpsPort sets the HttpsPort field's value.
func (s *ConvertOriginLineForAddCdnDomainInput) SetHttpsPort(v string) *ConvertOriginLineForAddCdnDomainInput {
	s.HttpsPort = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *ConvertOriginLineForAddCdnDomainInput) SetInstanceType(v string) *ConvertOriginLineForAddCdnDomainInput {
	s.InstanceType = &v
	return s
}

// SetOriginHost sets the OriginHost field's value.
func (s *ConvertOriginLineForAddCdnDomainInput) SetOriginHost(v string) *ConvertOriginLineForAddCdnDomainInput {
	s.OriginHost = &v
	return s
}

// SetOriginType sets the OriginType field's value.
func (s *ConvertOriginLineForAddCdnDomainInput) SetOriginType(v string) *ConvertOriginLineForAddCdnDomainInput {
	s.OriginType = &v
	return s
}

// SetPrivateBucketAccess sets the PrivateBucketAccess field's value.
func (s *ConvertOriginLineForAddCdnDomainInput) SetPrivateBucketAccess(v bool) *ConvertOriginLineForAddCdnDomainInput {
	s.PrivateBucketAccess = &v
	return s
}

// SetPrivateBucketAuth sets the PrivateBucketAuth field's value.
func (s *ConvertOriginLineForAddCdnDomainInput) SetPrivateBucketAuth(v *PrivateBucketAuthForAddCdnDomainInput) *ConvertOriginLineForAddCdnDomainInput {
	s.PrivateBucketAuth = v
	return s
}

// SetRegion sets the Region field's value.
func (s *ConvertOriginLineForAddCdnDomainInput) SetRegion(v string) *ConvertOriginLineForAddCdnDomainInput {
	s.Region = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *ConvertOriginLineForAddCdnDomainInput) SetWeight(v string) *ConvertOriginLineForAddCdnDomainInput {
	s.Weight = &v
	return s
}

type ConvertTimeoutActionForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	HttpTimeout *int64 `type:"int64"`

	TcpTimeout *int64 `type:"int64"`
}

// String returns the string representation
func (s ConvertTimeoutActionForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertTimeoutActionForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetHttpTimeout sets the HttpTimeout field's value.
func (s *ConvertTimeoutActionForAddCdnDomainInput) SetHttpTimeout(v int64) *ConvertTimeoutActionForAddCdnDomainInput {
	s.HttpTimeout = &v
	return s
}

// SetTcpTimeout sets the TcpTimeout field's value.
func (s *ConvertTimeoutActionForAddCdnDomainInput) SetTcpTimeout(v int64) *ConvertTimeoutActionForAddCdnDomainInput {
	s.TcpTimeout = &v
	return s
}

type CustomErrorPageForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	ErrorPageRule []*ErrorPageRuleForAddCdnDomainInput `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s CustomErrorPageForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomErrorPageForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetErrorPageRule sets the ErrorPageRule field's value.
func (s *CustomErrorPageForAddCdnDomainInput) SetErrorPageRule(v []*ErrorPageRuleForAddCdnDomainInput) *CustomErrorPageForAddCdnDomainInput {
	s.ErrorPageRule = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *CustomErrorPageForAddCdnDomainInput) SetSwitch(v bool) *CustomErrorPageForAddCdnDomainInput {
	s.Switch = &v
	return s
}

type CustomVariableInstanceForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Operator *string `type:"string"`

	Type *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s CustomVariableInstanceForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomVariableInstanceForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetOperator sets the Operator field's value.
func (s *CustomVariableInstanceForAddCdnDomainInput) SetOperator(v string) *CustomVariableInstanceForAddCdnDomainInput {
	s.Operator = &v
	return s
}

// SetType sets the Type field's value.
func (s *CustomVariableInstanceForAddCdnDomainInput) SetType(v string) *CustomVariableInstanceForAddCdnDomainInput {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *CustomVariableInstanceForAddCdnDomainInput) SetValue(v string) *CustomVariableInstanceForAddCdnDomainInput {
	s.Value = &v
	return s
}

type CustomVariableRulesForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	CustomVariableInstances []*CustomVariableInstanceForAddCdnDomainInput `type:"list"`
}

// String returns the string representation
func (s CustomVariableRulesForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomVariableRulesForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetCustomVariableInstances sets the CustomVariableInstances field's value.
func (s *CustomVariableRulesForAddCdnDomainInput) SetCustomVariableInstances(v []*CustomVariableInstanceForAddCdnDomainInput) *CustomVariableRulesForAddCdnDomainInput {
	s.CustomVariableInstances = v
	return s
}

type CustomizeAccessRuleForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	CustomizeInstances []*CustomizeInstanceForAddCdnDomainInput `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s CustomizeAccessRuleForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomizeAccessRuleForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetCustomizeInstances sets the CustomizeInstances field's value.
func (s *CustomizeAccessRuleForAddCdnDomainInput) SetCustomizeInstances(v []*CustomizeInstanceForAddCdnDomainInput) *CustomizeAccessRuleForAddCdnDomainInput {
	s.CustomizeInstances = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *CustomizeAccessRuleForAddCdnDomainInput) SetSwitch(v bool) *CustomizeAccessRuleForAddCdnDomainInput {
	s.Switch = &v
	return s
}

type CustomizeInstanceForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	CustomizeRule *CustomizeRuleForAddCdnDomainInput `type:"structure"`
}

// String returns the string representation
func (s CustomizeInstanceForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomizeInstanceForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetCustomizeRule sets the CustomizeRule field's value.
func (s *CustomizeInstanceForAddCdnDomainInput) SetCustomizeRule(v *CustomizeRuleForAddCdnDomainInput) *CustomizeInstanceForAddCdnDomainInput {
	s.CustomizeRule = v
	return s
}

type CustomizeRuleForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	AccessAction *AccessActionForAddCdnDomainInput `type:"structure"`

	Condition *ConditionForAddCdnDomainInput `type:"structure"`
}

// String returns the string representation
func (s CustomizeRuleForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomizeRuleForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetAccessAction sets the AccessAction field's value.
func (s *CustomizeRuleForAddCdnDomainInput) SetAccessAction(v *AccessActionForAddCdnDomainInput) *CustomizeRuleForAddCdnDomainInput {
	s.AccessAction = v
	return s
}

// SetCondition sets the Condition field's value.
func (s *CustomizeRuleForAddCdnDomainInput) SetCondition(v *ConditionForAddCdnDomainInput) *CustomizeRuleForAddCdnDomainInput {
	s.Condition = v
	return s
}

type DownloadSpeedLimitActionForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	SpeedLimitRate *int64 `type:"int64"`

	SpeedLimitRateAfter *int64 `type:"int64"`

	SpeedLimitTime *SpeedLimitTimeForAddCdnDomainInput `type:"structure"`
}

// String returns the string representation
func (s DownloadSpeedLimitActionForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DownloadSpeedLimitActionForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetSpeedLimitRate sets the SpeedLimitRate field's value.
func (s *DownloadSpeedLimitActionForAddCdnDomainInput) SetSpeedLimitRate(v int64) *DownloadSpeedLimitActionForAddCdnDomainInput {
	s.SpeedLimitRate = &v
	return s
}

// SetSpeedLimitRateAfter sets the SpeedLimitRateAfter field's value.
func (s *DownloadSpeedLimitActionForAddCdnDomainInput) SetSpeedLimitRateAfter(v int64) *DownloadSpeedLimitActionForAddCdnDomainInput {
	s.SpeedLimitRateAfter = &v
	return s
}

// SetSpeedLimitTime sets the SpeedLimitTime field's value.
func (s *DownloadSpeedLimitActionForAddCdnDomainInput) SetSpeedLimitTime(v *SpeedLimitTimeForAddCdnDomainInput) *DownloadSpeedLimitActionForAddCdnDomainInput {
	s.SpeedLimitTime = v
	return s
}

type DownloadSpeedLimitForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	DownloadSpeedLimitRules []*DownloadSpeedLimitRuleForAddCdnDomainInput `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s DownloadSpeedLimitForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DownloadSpeedLimitForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetDownloadSpeedLimitRules sets the DownloadSpeedLimitRules field's value.
func (s *DownloadSpeedLimitForAddCdnDomainInput) SetDownloadSpeedLimitRules(v []*DownloadSpeedLimitRuleForAddCdnDomainInput) *DownloadSpeedLimitForAddCdnDomainInput {
	s.DownloadSpeedLimitRules = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *DownloadSpeedLimitForAddCdnDomainInput) SetSwitch(v bool) *DownloadSpeedLimitForAddCdnDomainInput {
	s.Switch = &v
	return s
}

type DownloadSpeedLimitRuleForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Condition *ConditionForAddCdnDomainInput `type:"structure"`

	DownloadSpeedLimitAction *DownloadSpeedLimitActionForAddCdnDomainInput `type:"structure"`
}

// String returns the string representation
func (s DownloadSpeedLimitRuleForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DownloadSpeedLimitRuleForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *DownloadSpeedLimitRuleForAddCdnDomainInput) SetCondition(v *ConditionForAddCdnDomainInput) *DownloadSpeedLimitRuleForAddCdnDomainInput {
	s.Condition = v
	return s
}

// SetDownloadSpeedLimitAction sets the DownloadSpeedLimitAction field's value.
func (s *DownloadSpeedLimitRuleForAddCdnDomainInput) SetDownloadSpeedLimitAction(v *DownloadSpeedLimitActionForAddCdnDomainInput) *DownloadSpeedLimitRuleForAddCdnDomainInput {
	s.DownloadSpeedLimitAction = v
	return s
}

type ErrorPageActionForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Action *string `type:"string"`

	RedirectCode *string `type:"string"`

	RedirectUrl *string `type:"string"`

	StatusCode *string `type:"string"`
}

// String returns the string representation
func (s ErrorPageActionForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ErrorPageActionForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *ErrorPageActionForAddCdnDomainInput) SetAction(v string) *ErrorPageActionForAddCdnDomainInput {
	s.Action = &v
	return s
}

// SetRedirectCode sets the RedirectCode field's value.
func (s *ErrorPageActionForAddCdnDomainInput) SetRedirectCode(v string) *ErrorPageActionForAddCdnDomainInput {
	s.RedirectCode = &v
	return s
}

// SetRedirectUrl sets the RedirectUrl field's value.
func (s *ErrorPageActionForAddCdnDomainInput) SetRedirectUrl(v string) *ErrorPageActionForAddCdnDomainInput {
	s.RedirectUrl = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *ErrorPageActionForAddCdnDomainInput) SetStatusCode(v string) *ErrorPageActionForAddCdnDomainInput {
	s.StatusCode = &v
	return s
}

type ErrorPageRuleForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	ErrorPageAction *ErrorPageActionForAddCdnDomainInput `type:"structure"`
}

// String returns the string representation
func (s ErrorPageRuleForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ErrorPageRuleForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetErrorPageAction sets the ErrorPageAction field's value.
func (s *ErrorPageRuleForAddCdnDomainInput) SetErrorPageAction(v *ErrorPageActionForAddCdnDomainInput) *ErrorPageRuleForAddCdnDomainInput {
	s.ErrorPageAction = v
	return s
}

type ExpTimeCapRuleForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	CapMode *string `type:"string"`

	ParamName *string `type:"string"`

	UriLevel *int64 `type:"int64"`
}

// String returns the string representation
func (s ExpTimeCapRuleForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ExpTimeCapRuleForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetCapMode sets the CapMode field's value.
func (s *ExpTimeCapRuleForAddCdnDomainInput) SetCapMode(v string) *ExpTimeCapRuleForAddCdnDomainInput {
	s.CapMode = &v
	return s
}

// SetParamName sets the ParamName field's value.
func (s *ExpTimeCapRuleForAddCdnDomainInput) SetParamName(v string) *ExpTimeCapRuleForAddCdnDomainInput {
	s.ParamName = &v
	return s
}

// SetUriLevel sets the UriLevel field's value.
func (s *ExpTimeCapRuleForAddCdnDomainInput) SetUriLevel(v int64) *ExpTimeCapRuleForAddCdnDomainInput {
	s.UriLevel = &v
	return s
}

type ForcedRedirectForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	EnableForcedRedirect *bool `type:"boolean"`

	StatusCode *string `type:"string"`
}

// String returns the string representation
func (s ForcedRedirectForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ForcedRedirectForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetEnableForcedRedirect sets the EnableForcedRedirect field's value.
func (s *ForcedRedirectForAddCdnDomainInput) SetEnableForcedRedirect(v bool) *ForcedRedirectForAddCdnDomainInput {
	s.EnableForcedRedirect = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *ForcedRedirectForAddCdnDomainInput) SetStatusCode(v string) *ForcedRedirectForAddCdnDomainInput {
	s.StatusCode = &v
	return s
}

type HTTPSForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	CertCheck *CertCheckForAddCdnDomainInput `type:"structure"`

	CertInfo *CertInfoForAddCdnDomainInput `type:"structure"`

	CertInfoList []*CertInfoListForAddCdnDomainInput `type:"list"`

	DisableHttp *bool `type:"boolean"`

	ForcedRedirect *ForcedRedirectForAddCdnDomainInput `type:"structure"`

	HTTP2 *bool `type:"boolean"`

	Hsts *HstsForAddCdnDomainInput `type:"structure"`

	OCSP *bool `type:"boolean"`

	Switch *bool `type:"boolean"`

	TlsVersion []*string `type:"list"`
}

// String returns the string representation
func (s HTTPSForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HTTPSForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetCertCheck sets the CertCheck field's value.
func (s *HTTPSForAddCdnDomainInput) SetCertCheck(v *CertCheckForAddCdnDomainInput) *HTTPSForAddCdnDomainInput {
	s.CertCheck = v
	return s
}

// SetCertInfo sets the CertInfo field's value.
func (s *HTTPSForAddCdnDomainInput) SetCertInfo(v *CertInfoForAddCdnDomainInput) *HTTPSForAddCdnDomainInput {
	s.CertInfo = v
	return s
}

// SetCertInfoList sets the CertInfoList field's value.
func (s *HTTPSForAddCdnDomainInput) SetCertInfoList(v []*CertInfoListForAddCdnDomainInput) *HTTPSForAddCdnDomainInput {
	s.CertInfoList = v
	return s
}

// SetDisableHttp sets the DisableHttp field's value.
func (s *HTTPSForAddCdnDomainInput) SetDisableHttp(v bool) *HTTPSForAddCdnDomainInput {
	s.DisableHttp = &v
	return s
}

// SetForcedRedirect sets the ForcedRedirect field's value.
func (s *HTTPSForAddCdnDomainInput) SetForcedRedirect(v *ForcedRedirectForAddCdnDomainInput) *HTTPSForAddCdnDomainInput {
	s.ForcedRedirect = v
	return s
}

// SetHTTP2 sets the HTTP2 field's value.
func (s *HTTPSForAddCdnDomainInput) SetHTTP2(v bool) *HTTPSForAddCdnDomainInput {
	s.HTTP2 = &v
	return s
}

// SetHsts sets the Hsts field's value.
func (s *HTTPSForAddCdnDomainInput) SetHsts(v *HstsForAddCdnDomainInput) *HTTPSForAddCdnDomainInput {
	s.Hsts = v
	return s
}

// SetOCSP sets the OCSP field's value.
func (s *HTTPSForAddCdnDomainInput) SetOCSP(v bool) *HTTPSForAddCdnDomainInput {
	s.OCSP = &v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *HTTPSForAddCdnDomainInput) SetSwitch(v bool) *HTTPSForAddCdnDomainInput {
	s.Switch = &v
	return s
}

// SetTlsVersion sets the TlsVersion field's value.
func (s *HTTPSForAddCdnDomainInput) SetTlsVersion(v []*string) *HTTPSForAddCdnDomainInput {
	s.TlsVersion = v
	return s
}

type HstsForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Subdomain *string `type:"string"`

	Switch *bool `type:"boolean"`

	Ttl *int64 `type:"int64"`
}

// String returns the string representation
func (s HstsForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HstsForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetSubdomain sets the Subdomain field's value.
func (s *HstsForAddCdnDomainInput) SetSubdomain(v string) *HstsForAddCdnDomainInput {
	s.Subdomain = &v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *HstsForAddCdnDomainInput) SetSwitch(v bool) *HstsForAddCdnDomainInput {
	s.Switch = &v
	return s
}

// SetTtl sets the Ttl field's value.
func (s *HstsForAddCdnDomainInput) SetTtl(v int64) *HstsForAddCdnDomainInput {
	s.Ttl = &v
	return s
}

type HttpForcedRedirectForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	EnableForcedRedirect *bool `type:"boolean"`

	StatusCode *string `type:"string"`
}

// String returns the string representation
func (s HttpForcedRedirectForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HttpForcedRedirectForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetEnableForcedRedirect sets the EnableForcedRedirect field's value.
func (s *HttpForcedRedirectForAddCdnDomainInput) SetEnableForcedRedirect(v bool) *HttpForcedRedirectForAddCdnDomainInput {
	s.EnableForcedRedirect = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *HttpForcedRedirectForAddCdnDomainInput) SetStatusCode(v string) *HttpForcedRedirectForAddCdnDomainInput {
	s.StatusCode = &v
	return s
}

type IPv6ForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s IPv6ForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s IPv6ForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetSwitch sets the Switch field's value.
func (s *IPv6ForAddCdnDomainInput) SetSwitch(v bool) *IPv6ForAddCdnDomainInput {
	s.Switch = &v
	return s
}

type IpAccessRuleForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Ip []*string `type:"list"`

	RuleType *string `type:"string"`

	SharedConfig *SharedConfigForAddCdnDomainInput `type:"structure"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s IpAccessRuleForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s IpAccessRuleForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetIp sets the Ip field's value.
func (s *IpAccessRuleForAddCdnDomainInput) SetIp(v []*string) *IpAccessRuleForAddCdnDomainInput {
	s.Ip = v
	return s
}

// SetRuleType sets the RuleType field's value.
func (s *IpAccessRuleForAddCdnDomainInput) SetRuleType(v string) *IpAccessRuleForAddCdnDomainInput {
	s.RuleType = &v
	return s
}

// SetSharedConfig sets the SharedConfig field's value.
func (s *IpAccessRuleForAddCdnDomainInput) SetSharedConfig(v *SharedConfigForAddCdnDomainInput) *IpAccessRuleForAddCdnDomainInput {
	s.SharedConfig = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *IpAccessRuleForAddCdnDomainInput) SetSwitch(v bool) *IpAccessRuleForAddCdnDomainInput {
	s.Switch = &v
	return s
}

type IpFreqLimitActionForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Action *string `type:"string"`

	FreqLimitRate *int64 `type:"int64"`

	StatusCode *string `type:"string"`
}

// String returns the string representation
func (s IpFreqLimitActionForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s IpFreqLimitActionForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *IpFreqLimitActionForAddCdnDomainInput) SetAction(v string) *IpFreqLimitActionForAddCdnDomainInput {
	s.Action = &v
	return s
}

// SetFreqLimitRate sets the FreqLimitRate field's value.
func (s *IpFreqLimitActionForAddCdnDomainInput) SetFreqLimitRate(v int64) *IpFreqLimitActionForAddCdnDomainInput {
	s.FreqLimitRate = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *IpFreqLimitActionForAddCdnDomainInput) SetStatusCode(v string) *IpFreqLimitActionForAddCdnDomainInput {
	s.StatusCode = &v
	return s
}

type IpFreqLimitForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	IpFreqLimitRules []*IpFreqLimitRuleForAddCdnDomainInput `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s IpFreqLimitForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s IpFreqLimitForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetIpFreqLimitRules sets the IpFreqLimitRules field's value.
func (s *IpFreqLimitForAddCdnDomainInput) SetIpFreqLimitRules(v []*IpFreqLimitRuleForAddCdnDomainInput) *IpFreqLimitForAddCdnDomainInput {
	s.IpFreqLimitRules = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *IpFreqLimitForAddCdnDomainInput) SetSwitch(v bool) *IpFreqLimitForAddCdnDomainInput {
	s.Switch = &v
	return s
}

type IpFreqLimitRuleForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Condition *ConditionForAddCdnDomainInput `type:"structure"`

	IpFreqLimitAction *IpFreqLimitActionForAddCdnDomainInput `type:"structure"`
}

// String returns the string representation
func (s IpFreqLimitRuleForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s IpFreqLimitRuleForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *IpFreqLimitRuleForAddCdnDomainInput) SetCondition(v *ConditionForAddCdnDomainInput) *IpFreqLimitRuleForAddCdnDomainInput {
	s.Condition = v
	return s
}

// SetIpFreqLimitAction sets the IpFreqLimitAction field's value.
func (s *IpFreqLimitRuleForAddCdnDomainInput) SetIpFreqLimitAction(v *IpFreqLimitActionForAddCdnDomainInput) *IpFreqLimitRuleForAddCdnDomainInput {
	s.IpFreqLimitAction = v
	return s
}

type MethodDeniedRuleForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Methods *string `type:"string"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s MethodDeniedRuleForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s MethodDeniedRuleForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetMethods sets the Methods field's value.
func (s *MethodDeniedRuleForAddCdnDomainInput) SetMethods(v string) *MethodDeniedRuleForAddCdnDomainInput {
	s.Methods = &v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *MethodDeniedRuleForAddCdnDomainInput) SetSwitch(v bool) *MethodDeniedRuleForAddCdnDomainInput {
	s.Switch = &v
	return s
}

type MultiRangeForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s MultiRangeForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s MultiRangeForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetSwitch sets the Switch field's value.
func (s *MultiRangeForAddCdnDomainInput) SetSwitch(v bool) *MultiRangeForAddCdnDomainInput {
	s.Switch = &v
	return s
}

type NegativeCacheForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Condition *ConditionForAddCdnDomainInput `type:"structure"`

	NegativeCacheRule *NegativeCacheRuleForAddCdnDomainInput `type:"structure"`
}

// String returns the string representation
func (s NegativeCacheForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NegativeCacheForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *NegativeCacheForAddCdnDomainInput) SetCondition(v *ConditionForAddCdnDomainInput) *NegativeCacheForAddCdnDomainInput {
	s.Condition = v
	return s
}

// SetNegativeCacheRule sets the NegativeCacheRule field's value.
func (s *NegativeCacheForAddCdnDomainInput) SetNegativeCacheRule(v *NegativeCacheRuleForAddCdnDomainInput) *NegativeCacheForAddCdnDomainInput {
	s.NegativeCacheRule = v
	return s
}

type NegativeCacheRuleForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Action *string `type:"string"`

	IgnoreCase *bool `type:"boolean"`

	StatusCode *string `type:"string"`

	Ttl *int64 `type:"int64"`
}

// String returns the string representation
func (s NegativeCacheRuleForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NegativeCacheRuleForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *NegativeCacheRuleForAddCdnDomainInput) SetAction(v string) *NegativeCacheRuleForAddCdnDomainInput {
	s.Action = &v
	return s
}

// SetIgnoreCase sets the IgnoreCase field's value.
func (s *NegativeCacheRuleForAddCdnDomainInput) SetIgnoreCase(v bool) *NegativeCacheRuleForAddCdnDomainInput {
	s.IgnoreCase = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *NegativeCacheRuleForAddCdnDomainInput) SetStatusCode(v string) *NegativeCacheRuleForAddCdnDomainInput {
	s.StatusCode = &v
	return s
}

// SetTtl sets the Ttl field's value.
func (s *NegativeCacheRuleForAddCdnDomainInput) SetTtl(v int64) *NegativeCacheRuleForAddCdnDomainInput {
	s.Ttl = &v
	return s
}

type OriginAccessRuleForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	AllowEmpty *bool `type:"boolean"`

	IgnoreCase *bool `type:"boolean"`

	Origins []*string `type:"list"`

	RuleType *string `type:"string"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s OriginAccessRuleForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginAccessRuleForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetAllowEmpty sets the AllowEmpty field's value.
func (s *OriginAccessRuleForAddCdnDomainInput) SetAllowEmpty(v bool) *OriginAccessRuleForAddCdnDomainInput {
	s.AllowEmpty = &v
	return s
}

// SetIgnoreCase sets the IgnoreCase field's value.
func (s *OriginAccessRuleForAddCdnDomainInput) SetIgnoreCase(v bool) *OriginAccessRuleForAddCdnDomainInput {
	s.IgnoreCase = &v
	return s
}

// SetOrigins sets the Origins field's value.
func (s *OriginAccessRuleForAddCdnDomainInput) SetOrigins(v []*string) *OriginAccessRuleForAddCdnDomainInput {
	s.Origins = v
	return s
}

// SetRuleType sets the RuleType field's value.
func (s *OriginAccessRuleForAddCdnDomainInput) SetRuleType(v string) *OriginAccessRuleForAddCdnDomainInput {
	s.RuleType = &v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *OriginAccessRuleForAddCdnDomainInput) SetSwitch(v bool) *OriginAccessRuleForAddCdnDomainInput {
	s.Switch = &v
	return s
}

type OriginActionForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	OriginLines []*ConvertOriginLineForAddCdnDomainInput `type:"list"`
}

// String returns the string representation
func (s OriginActionForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginActionForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetOriginLines sets the OriginLines field's value.
func (s *OriginActionForAddCdnDomainInput) SetOriginLines(v []*ConvertOriginLineForAddCdnDomainInput) *OriginActionForAddCdnDomainInput {
	s.OriginLines = v
	return s
}

type OriginArgActionForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	OriginArgComponents []*OriginArgComponentForAddCdnDomainInput `type:"list"`
}

// String returns the string representation
func (s OriginArgActionForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginArgActionForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetOriginArgComponents sets the OriginArgComponents field's value.
func (s *OriginArgActionForAddCdnDomainInput) SetOriginArgComponents(v []*OriginArgComponentForAddCdnDomainInput) *OriginArgActionForAddCdnDomainInput {
	s.OriginArgComponents = v
	return s
}

type OriginArgComponentForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Action *string `type:"string"`

	Object *string `type:"string"`

	Subobject *string `type:"string"`
}

// String returns the string representation
func (s OriginArgComponentForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginArgComponentForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *OriginArgComponentForAddCdnDomainInput) SetAction(v string) *OriginArgComponentForAddCdnDomainInput {
	s.Action = &v
	return s
}

// SetObject sets the Object field's value.
func (s *OriginArgComponentForAddCdnDomainInput) SetObject(v string) *OriginArgComponentForAddCdnDomainInput {
	s.Object = &v
	return s
}

// SetSubobject sets the Subobject field's value.
func (s *OriginArgComponentForAddCdnDomainInput) SetSubobject(v string) *OriginArgComponentForAddCdnDomainInput {
	s.Subobject = &v
	return s
}

type OriginArgForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Condition *ConditionForAddCdnDomainInput `type:"structure"`

	OriginArgAction *OriginArgActionForAddCdnDomainInput `type:"structure"`
}

// String returns the string representation
func (s OriginArgForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginArgForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *OriginArgForAddCdnDomainInput) SetCondition(v *ConditionForAddCdnDomainInput) *OriginArgForAddCdnDomainInput {
	s.Condition = v
	return s
}

// SetOriginArgAction sets the OriginArgAction field's value.
func (s *OriginArgForAddCdnDomainInput) SetOriginArgAction(v *OriginArgActionForAddCdnDomainInput) *OriginArgForAddCdnDomainInput {
	s.OriginArgAction = v
	return s
}

type OriginCertCheckForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s OriginCertCheckForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginCertCheckForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetSwitch sets the Switch field's value.
func (s *OriginCertCheckForAddCdnDomainInput) SetSwitch(v bool) *OriginCertCheckForAddCdnDomainInput {
	s.Switch = &v
	return s
}

type OriginForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Condition *ConditionForAddCdnDomainInput `type:"structure"`

	OriginAction *OriginActionForAddCdnDomainInput `type:"structure"`
}

// String returns the string representation
func (s OriginForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *OriginForAddCdnDomainInput) SetCondition(v *ConditionForAddCdnDomainInput) *OriginForAddCdnDomainInput {
	s.Condition = v
	return s
}

// SetOriginAction sets the OriginAction field's value.
func (s *OriginForAddCdnDomainInput) SetOriginAction(v *OriginActionForAddCdnDomainInput) *OriginForAddCdnDomainInput {
	s.OriginAction = v
	return s
}

type OriginLineForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Address *string `type:"string"`

	HttpPort *string `type:"string"`

	HttpsPort *string `type:"string"`

	InstanceType *string `type:"string"`

	OriginHost *string `type:"string"`
}

// String returns the string representation
func (s OriginLineForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginLineForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *OriginLineForAddCdnDomainInput) SetAddress(v string) *OriginLineForAddCdnDomainInput {
	s.Address = &v
	return s
}

// SetHttpPort sets the HttpPort field's value.
func (s *OriginLineForAddCdnDomainInput) SetHttpPort(v string) *OriginLineForAddCdnDomainInput {
	s.HttpPort = &v
	return s
}

// SetHttpsPort sets the HttpsPort field's value.
func (s *OriginLineForAddCdnDomainInput) SetHttpsPort(v string) *OriginLineForAddCdnDomainInput {
	s.HttpsPort = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *OriginLineForAddCdnDomainInput) SetInstanceType(v string) *OriginLineForAddCdnDomainInput {
	s.InstanceType = &v
	return s
}

// SetOriginHost sets the OriginHost field's value.
func (s *OriginLineForAddCdnDomainInput) SetOriginHost(v string) *OriginLineForAddCdnDomainInput {
	s.OriginHost = &v
	return s
}

type OriginRetryForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	StatusCode *string `type:"string"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s OriginRetryForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginRetryForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetStatusCode sets the StatusCode field's value.
func (s *OriginRetryForAddCdnDomainInput) SetStatusCode(v string) *OriginRetryForAddCdnDomainInput {
	s.StatusCode = &v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *OriginRetryForAddCdnDomainInput) SetSwitch(v bool) *OriginRetryForAddCdnDomainInput {
	s.Switch = &v
	return s
}

type OriginRewriteActionForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	RewriteType *string `type:"string"`

	SourcePath *string `type:"string"`

	TargetPath *string `type:"string"`
}

// String returns the string representation
func (s OriginRewriteActionForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginRewriteActionForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetRewriteType sets the RewriteType field's value.
func (s *OriginRewriteActionForAddCdnDomainInput) SetRewriteType(v string) *OriginRewriteActionForAddCdnDomainInput {
	s.RewriteType = &v
	return s
}

// SetSourcePath sets the SourcePath field's value.
func (s *OriginRewriteActionForAddCdnDomainInput) SetSourcePath(v string) *OriginRewriteActionForAddCdnDomainInput {
	s.SourcePath = &v
	return s
}

// SetTargetPath sets the TargetPath field's value.
func (s *OriginRewriteActionForAddCdnDomainInput) SetTargetPath(v string) *OriginRewriteActionForAddCdnDomainInput {
	s.TargetPath = &v
	return s
}

type OriginRewriteForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	OriginRewriteRule []*OriginRewriteRuleForAddCdnDomainInput `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s OriginRewriteForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginRewriteForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetOriginRewriteRule sets the OriginRewriteRule field's value.
func (s *OriginRewriteForAddCdnDomainInput) SetOriginRewriteRule(v []*OriginRewriteRuleForAddCdnDomainInput) *OriginRewriteForAddCdnDomainInput {
	s.OriginRewriteRule = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *OriginRewriteForAddCdnDomainInput) SetSwitch(v bool) *OriginRewriteForAddCdnDomainInput {
	s.Switch = &v
	return s
}

type OriginRewriteRuleForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Condition *ConditionForAddCdnDomainInput `type:"structure"`

	OriginRewriteAction *OriginRewriteActionForAddCdnDomainInput `type:"structure"`
}

// String returns the string representation
func (s OriginRewriteRuleForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginRewriteRuleForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *OriginRewriteRuleForAddCdnDomainInput) SetCondition(v *ConditionForAddCdnDomainInput) *OriginRewriteRuleForAddCdnDomainInput {
	s.Condition = v
	return s
}

// SetOriginRewriteAction sets the OriginRewriteAction field's value.
func (s *OriginRewriteRuleForAddCdnDomainInput) SetOriginRewriteAction(v *OriginRewriteActionForAddCdnDomainInput) *OriginRewriteRuleForAddCdnDomainInput {
	s.OriginRewriteAction = v
	return s
}

type OriginRuleForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Actions *ActionsForAddCdnDomainInput `type:"structure"`

	Condition *ConvertConvertConditionForAddCdnDomainInput `type:"structure"`
}

// String returns the string representation
func (s OriginRuleForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginRuleForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetActions sets the Actions field's value.
func (s *OriginRuleForAddCdnDomainInput) SetActions(v *ActionsForAddCdnDomainInput) *OriginRuleForAddCdnDomainInput {
	s.Actions = v
	return s
}

// SetCondition sets the Condition field's value.
func (s *OriginRuleForAddCdnDomainInput) SetCondition(v *ConvertConvertConditionForAddCdnDomainInput) *OriginRuleForAddCdnDomainInput {
	s.Condition = v
	return s
}

type OriginSniForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	SniDomain *string `type:"string"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s OriginSniForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginSniForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetSniDomain sets the SniDomain field's value.
func (s *OriginSniForAddCdnDomainInput) SetSniDomain(v string) *OriginSniForAddCdnDomainInput {
	s.SniDomain = &v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *OriginSniForAddCdnDomainInput) SetSwitch(v bool) *OriginSniForAddCdnDomainInput {
	s.Switch = &v
	return s
}

type PageOptimizationForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	OptimizationType []*string `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s PageOptimizationForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PageOptimizationForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetOptimizationType sets the OptimizationType field's value.
func (s *PageOptimizationForAddCdnDomainInput) SetOptimizationType(v []*string) *PageOptimizationForAddCdnDomainInput {
	s.OptimizationType = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *PageOptimizationForAddCdnDomainInput) SetSwitch(v bool) *PageOptimizationForAddCdnDomainInput {
	s.Switch = &v
	return s
}

type PrivateBucketAuthForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	AuthType *string `type:"string"`

	Switch *bool `type:"boolean"`

	TosAuthInformation *TosAuthInformationForAddCdnDomainInput `type:"structure"`
}

// String returns the string representation
func (s PrivateBucketAuthForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PrivateBucketAuthForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetAuthType sets the AuthType field's value.
func (s *PrivateBucketAuthForAddCdnDomainInput) SetAuthType(v string) *PrivateBucketAuthForAddCdnDomainInput {
	s.AuthType = &v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *PrivateBucketAuthForAddCdnDomainInput) SetSwitch(v bool) *PrivateBucketAuthForAddCdnDomainInput {
	s.Switch = &v
	return s
}

// SetTosAuthInformation sets the TosAuthInformation field's value.
func (s *PrivateBucketAuthForAddCdnDomainInput) SetTosAuthInformation(v *TosAuthInformationForAddCdnDomainInput) *PrivateBucketAuthForAddCdnDomainInput {
	s.TosAuthInformation = v
	return s
}

type QueryStringComponentsForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Action *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s QueryStringComponentsForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryStringComponentsForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *QueryStringComponentsForAddCdnDomainInput) SetAction(v string) *QueryStringComponentsForAddCdnDomainInput {
	s.Action = &v
	return s
}

// SetValue sets the Value field's value.
func (s *QueryStringComponentsForAddCdnDomainInput) SetValue(v string) *QueryStringComponentsForAddCdnDomainInput {
	s.Value = &v
	return s
}

type QueryStringInstanceForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Action *string `type:"string"`

	Key *string `type:"string"`

	Value *string `type:"string"`

	ValueType *string `type:"string"`
}

// String returns the string representation
func (s QueryStringInstanceForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryStringInstanceForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *QueryStringInstanceForAddCdnDomainInput) SetAction(v string) *QueryStringInstanceForAddCdnDomainInput {
	s.Action = &v
	return s
}

// SetKey sets the Key field's value.
func (s *QueryStringInstanceForAddCdnDomainInput) SetKey(v string) *QueryStringInstanceForAddCdnDomainInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *QueryStringInstanceForAddCdnDomainInput) SetValue(v string) *QueryStringInstanceForAddCdnDomainInput {
	s.Value = &v
	return s
}

// SetValueType sets the ValueType field's value.
func (s *QueryStringInstanceForAddCdnDomainInput) SetValueType(v string) *QueryStringInstanceForAddCdnDomainInput {
	s.ValueType = &v
	return s
}

type QueryStringRulesForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	QueryStringComponents *QueryStringComponentsForAddCdnDomainInput `type:"structure"`

	QueryStringInstances []*QueryStringInstanceForAddCdnDomainInput `type:"list"`
}

// String returns the string representation
func (s QueryStringRulesForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryStringRulesForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetQueryStringComponents sets the QueryStringComponents field's value.
func (s *QueryStringRulesForAddCdnDomainInput) SetQueryStringComponents(v *QueryStringComponentsForAddCdnDomainInput) *QueryStringRulesForAddCdnDomainInput {
	s.QueryStringComponents = v
	return s
}

// SetQueryStringInstances sets the QueryStringInstances field's value.
func (s *QueryStringRulesForAddCdnDomainInput) SetQueryStringInstances(v []*QueryStringInstanceForAddCdnDomainInput) *QueryStringRulesForAddCdnDomainInput {
	s.QueryStringInstances = v
	return s
}

type QuicForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s QuicForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s QuicForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetSwitch sets the Switch field's value.
func (s *QuicForAddCdnDomainInput) SetSwitch(v bool) *QuicForAddCdnDomainInput {
	s.Switch = &v
	return s
}

type RedirectionActionForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	RedirectCode *string `type:"string"`

	SourcePath *string `type:"string"`

	TargetHost *string `type:"string"`

	TargetPath *string `type:"string"`

	TargetProtocol *string `type:"string"`

	TargetQueryComponents *TargetQueryComponentsForAddCdnDomainInput `type:"structure"`
}

// String returns the string representation
func (s RedirectionActionForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RedirectionActionForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetRedirectCode sets the RedirectCode field's value.
func (s *RedirectionActionForAddCdnDomainInput) SetRedirectCode(v string) *RedirectionActionForAddCdnDomainInput {
	s.RedirectCode = &v
	return s
}

// SetSourcePath sets the SourcePath field's value.
func (s *RedirectionActionForAddCdnDomainInput) SetSourcePath(v string) *RedirectionActionForAddCdnDomainInput {
	s.SourcePath = &v
	return s
}

// SetTargetHost sets the TargetHost field's value.
func (s *RedirectionActionForAddCdnDomainInput) SetTargetHost(v string) *RedirectionActionForAddCdnDomainInput {
	s.TargetHost = &v
	return s
}

// SetTargetPath sets the TargetPath field's value.
func (s *RedirectionActionForAddCdnDomainInput) SetTargetPath(v string) *RedirectionActionForAddCdnDomainInput {
	s.TargetPath = &v
	return s
}

// SetTargetProtocol sets the TargetProtocol field's value.
func (s *RedirectionActionForAddCdnDomainInput) SetTargetProtocol(v string) *RedirectionActionForAddCdnDomainInput {
	s.TargetProtocol = &v
	return s
}

// SetTargetQueryComponents sets the TargetQueryComponents field's value.
func (s *RedirectionActionForAddCdnDomainInput) SetTargetQueryComponents(v *TargetQueryComponentsForAddCdnDomainInput) *RedirectionActionForAddCdnDomainInput {
	s.TargetQueryComponents = v
	return s
}

type RedirectionRewriteForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	RedirectionRule []*RedirectionRuleForAddCdnDomainInput `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s RedirectionRewriteForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RedirectionRewriteForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetRedirectionRule sets the RedirectionRule field's value.
func (s *RedirectionRewriteForAddCdnDomainInput) SetRedirectionRule(v []*RedirectionRuleForAddCdnDomainInput) *RedirectionRewriteForAddCdnDomainInput {
	s.RedirectionRule = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *RedirectionRewriteForAddCdnDomainInput) SetSwitch(v bool) *RedirectionRewriteForAddCdnDomainInput {
	s.Switch = &v
	return s
}

type RedirectionRuleForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	RedirectionAction *RedirectionActionForAddCdnDomainInput `type:"structure"`
}

// String returns the string representation
func (s RedirectionRuleForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RedirectionRuleForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetRedirectionAction sets the RedirectionAction field's value.
func (s *RedirectionRuleForAddCdnDomainInput) SetRedirectionAction(v *RedirectionActionForAddCdnDomainInput) *RedirectionRuleForAddCdnDomainInput {
	s.RedirectionAction = v
	return s
}

type RefererAccessRuleForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	AllowEmpty *bool `type:"boolean"`

	Referers []*string `type:"list"`

	ReferersType *ReferersTypeForAddCdnDomainInput `type:"structure"`

	RuleType *string `type:"string"`

	SharedConfig *SharedConfigForAddCdnDomainInput `type:"structure"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s RefererAccessRuleForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RefererAccessRuleForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetAllowEmpty sets the AllowEmpty field's value.
func (s *RefererAccessRuleForAddCdnDomainInput) SetAllowEmpty(v bool) *RefererAccessRuleForAddCdnDomainInput {
	s.AllowEmpty = &v
	return s
}

// SetReferers sets the Referers field's value.
func (s *RefererAccessRuleForAddCdnDomainInput) SetReferers(v []*string) *RefererAccessRuleForAddCdnDomainInput {
	s.Referers = v
	return s
}

// SetReferersType sets the ReferersType field's value.
func (s *RefererAccessRuleForAddCdnDomainInput) SetReferersType(v *ReferersTypeForAddCdnDomainInput) *RefererAccessRuleForAddCdnDomainInput {
	s.ReferersType = v
	return s
}

// SetRuleType sets the RuleType field's value.
func (s *RefererAccessRuleForAddCdnDomainInput) SetRuleType(v string) *RefererAccessRuleForAddCdnDomainInput {
	s.RuleType = &v
	return s
}

// SetSharedConfig sets the SharedConfig field's value.
func (s *RefererAccessRuleForAddCdnDomainInput) SetSharedConfig(v *SharedConfigForAddCdnDomainInput) *RefererAccessRuleForAddCdnDomainInput {
	s.SharedConfig = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *RefererAccessRuleForAddCdnDomainInput) SetSwitch(v bool) *RefererAccessRuleForAddCdnDomainInput {
	s.Switch = &v
	return s
}

type ReferersTypeForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	CommonType *CommonTypeForAddCdnDomainInput `type:"structure"`

	RegularType *RegularTypeForAddCdnDomainInput `type:"structure"`
}

// String returns the string representation
func (s ReferersTypeForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ReferersTypeForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetCommonType sets the CommonType field's value.
func (s *ReferersTypeForAddCdnDomainInput) SetCommonType(v *CommonTypeForAddCdnDomainInput) *ReferersTypeForAddCdnDomainInput {
	s.CommonType = v
	return s
}

// SetRegularType sets the RegularType field's value.
func (s *ReferersTypeForAddCdnDomainInput) SetRegularType(v *RegularTypeForAddCdnDomainInput) *ReferersTypeForAddCdnDomainInput {
	s.RegularType = v
	return s
}

type RegularTypeForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Referers []*string `type:"list"`
}

// String returns the string representation
func (s RegularTypeForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RegularTypeForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetReferers sets the Referers field's value.
func (s *RegularTypeForAddCdnDomainInput) SetReferers(v []*string) *RegularTypeForAddCdnDomainInput {
	s.Referers = v
	return s
}

type RemoteAuthForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	RemoteAuthRules []*RemoteAuthRuleForAddCdnDomainInput `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s RemoteAuthForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoteAuthForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetRemoteAuthRules sets the RemoteAuthRules field's value.
func (s *RemoteAuthForAddCdnDomainInput) SetRemoteAuthRules(v []*RemoteAuthRuleForAddCdnDomainInput) *RemoteAuthForAddCdnDomainInput {
	s.RemoteAuthRules = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *RemoteAuthForAddCdnDomainInput) SetSwitch(v bool) *RemoteAuthForAddCdnDomainInput {
	s.Switch = &v
	return s
}

type RemoteAuthRuleActionForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	AuthModeConfig *AuthModeConfigForAddCdnDomainInput `type:"structure"`

	AuthResponseConfig *AuthResponseConfigForAddCdnDomainInput `type:"structure"`

	QueryStringRules *QueryStringRulesForAddCdnDomainInput `type:"structure"`

	RequestBodyRules *string `type:"string"`

	RequestHeaderRules *RequestHeaderRulesForAddCdnDomainInput `type:"structure"`
}

// String returns the string representation
func (s RemoteAuthRuleActionForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoteAuthRuleActionForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetAuthModeConfig sets the AuthModeConfig field's value.
func (s *RemoteAuthRuleActionForAddCdnDomainInput) SetAuthModeConfig(v *AuthModeConfigForAddCdnDomainInput) *RemoteAuthRuleActionForAddCdnDomainInput {
	s.AuthModeConfig = v
	return s
}

// SetAuthResponseConfig sets the AuthResponseConfig field's value.
func (s *RemoteAuthRuleActionForAddCdnDomainInput) SetAuthResponseConfig(v *AuthResponseConfigForAddCdnDomainInput) *RemoteAuthRuleActionForAddCdnDomainInput {
	s.AuthResponseConfig = v
	return s
}

// SetQueryStringRules sets the QueryStringRules field's value.
func (s *RemoteAuthRuleActionForAddCdnDomainInput) SetQueryStringRules(v *QueryStringRulesForAddCdnDomainInput) *RemoteAuthRuleActionForAddCdnDomainInput {
	s.QueryStringRules = v
	return s
}

// SetRequestBodyRules sets the RequestBodyRules field's value.
func (s *RemoteAuthRuleActionForAddCdnDomainInput) SetRequestBodyRules(v string) *RemoteAuthRuleActionForAddCdnDomainInput {
	s.RequestBodyRules = &v
	return s
}

// SetRequestHeaderRules sets the RequestHeaderRules field's value.
func (s *RemoteAuthRuleActionForAddCdnDomainInput) SetRequestHeaderRules(v *RequestHeaderRulesForAddCdnDomainInput) *RemoteAuthRuleActionForAddCdnDomainInput {
	s.RequestHeaderRules = v
	return s
}

type RemoteAuthRuleForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Condition *ConditionForAddCdnDomainInput `type:"structure"`

	RemoteAuthRuleAction *RemoteAuthRuleActionForAddCdnDomainInput `type:"structure"`
}

// String returns the string representation
func (s RemoteAuthRuleForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoteAuthRuleForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *RemoteAuthRuleForAddCdnDomainInput) SetCondition(v *ConditionForAddCdnDomainInput) *RemoteAuthRuleForAddCdnDomainInput {
	s.Condition = v
	return s
}

// SetRemoteAuthRuleAction sets the RemoteAuthRuleAction field's value.
func (s *RemoteAuthRuleForAddCdnDomainInput) SetRemoteAuthRuleAction(v *RemoteAuthRuleActionForAddCdnDomainInput) *RemoteAuthRuleForAddCdnDomainInput {
	s.RemoteAuthRuleAction = v
	return s
}

type RequestBlockRuleForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	BlockRule []*BlockRuleForAddCdnDomainInput `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s RequestBlockRuleForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestBlockRuleForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetBlockRule sets the BlockRule field's value.
func (s *RequestBlockRuleForAddCdnDomainInput) SetBlockRule(v []*BlockRuleForAddCdnDomainInput) *RequestBlockRuleForAddCdnDomainInput {
	s.BlockRule = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *RequestBlockRuleForAddCdnDomainInput) SetSwitch(v bool) *RequestBlockRuleForAddCdnDomainInput {
	s.Switch = &v
	return s
}

type RequestHeaderActionForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	RequestHeaderInstances []*RequestHeaderInstanceForAddCdnDomainInput `type:"list"`
}

// String returns the string representation
func (s RequestHeaderActionForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestHeaderActionForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetRequestHeaderInstances sets the RequestHeaderInstances field's value.
func (s *RequestHeaderActionForAddCdnDomainInput) SetRequestHeaderInstances(v []*RequestHeaderInstanceForAddCdnDomainInput) *RequestHeaderActionForAddCdnDomainInput {
	s.RequestHeaderInstances = v
	return s
}

type RequestHeaderComponentsForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Action *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s RequestHeaderComponentsForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestHeaderComponentsForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *RequestHeaderComponentsForAddCdnDomainInput) SetAction(v string) *RequestHeaderComponentsForAddCdnDomainInput {
	s.Action = &v
	return s
}

// SetValue sets the Value field's value.
func (s *RequestHeaderComponentsForAddCdnDomainInput) SetValue(v string) *RequestHeaderComponentsForAddCdnDomainInput {
	s.Value = &v
	return s
}

type RequestHeaderForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Condition *ConditionForAddCdnDomainInput `type:"structure"`

	RequestHeaderAction *RequestHeaderActionForAddCdnDomainInput `type:"structure"`
}

// String returns the string representation
func (s RequestHeaderForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestHeaderForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *RequestHeaderForAddCdnDomainInput) SetCondition(v *ConditionForAddCdnDomainInput) *RequestHeaderForAddCdnDomainInput {
	s.Condition = v
	return s
}

// SetRequestHeaderAction sets the RequestHeaderAction field's value.
func (s *RequestHeaderForAddCdnDomainInput) SetRequestHeaderAction(v *RequestHeaderActionForAddCdnDomainInput) *RequestHeaderForAddCdnDomainInput {
	s.RequestHeaderAction = v
	return s
}

type RequestHeaderInstanceForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Action *string `type:"string"`

	Key *string `type:"string"`

	Value *string `type:"string"`

	ValueType *string `type:"string"`
}

// String returns the string representation
func (s RequestHeaderInstanceForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestHeaderInstanceForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *RequestHeaderInstanceForAddCdnDomainInput) SetAction(v string) *RequestHeaderInstanceForAddCdnDomainInput {
	s.Action = &v
	return s
}

// SetKey sets the Key field's value.
func (s *RequestHeaderInstanceForAddCdnDomainInput) SetKey(v string) *RequestHeaderInstanceForAddCdnDomainInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *RequestHeaderInstanceForAddCdnDomainInput) SetValue(v string) *RequestHeaderInstanceForAddCdnDomainInput {
	s.Value = &v
	return s
}

// SetValueType sets the ValueType field's value.
func (s *RequestHeaderInstanceForAddCdnDomainInput) SetValueType(v string) *RequestHeaderInstanceForAddCdnDomainInput {
	s.ValueType = &v
	return s
}

type RequestHeaderRulesForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	RequestHeaderComponents *RequestHeaderComponentsForAddCdnDomainInput `type:"structure"`

	RequestHeaderInstances []*RequestHeaderInstanceForAddCdnDomainInput `type:"list"`

	RequestHost *string `type:"string"`
}

// String returns the string representation
func (s RequestHeaderRulesForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestHeaderRulesForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetRequestHeaderComponents sets the RequestHeaderComponents field's value.
func (s *RequestHeaderRulesForAddCdnDomainInput) SetRequestHeaderComponents(v *RequestHeaderComponentsForAddCdnDomainInput) *RequestHeaderRulesForAddCdnDomainInput {
	s.RequestHeaderComponents = v
	return s
}

// SetRequestHeaderInstances sets the RequestHeaderInstances field's value.
func (s *RequestHeaderRulesForAddCdnDomainInput) SetRequestHeaderInstances(v []*RequestHeaderInstanceForAddCdnDomainInput) *RequestHeaderRulesForAddCdnDomainInput {
	s.RequestHeaderInstances = v
	return s
}

// SetRequestHost sets the RequestHost field's value.
func (s *RequestHeaderRulesForAddCdnDomainInput) SetRequestHost(v string) *RequestHeaderRulesForAddCdnDomainInput {
	s.RequestHost = &v
	return s
}

type ResourceTagForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Key *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s ResourceTagForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceTagForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *ResourceTagForAddCdnDomainInput) SetKey(v string) *ResourceTagForAddCdnDomainInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ResourceTagForAddCdnDomainInput) SetValue(v string) *ResourceTagForAddCdnDomainInput {
	s.Value = &v
	return s
}

type ResponseActionForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	StatusCode *string `type:"string"`
}

// String returns the string representation
func (s ResponseActionForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResponseActionForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetStatusCode sets the StatusCode field's value.
func (s *ResponseActionForAddCdnDomainInput) SetStatusCode(v string) *ResponseActionForAddCdnDomainInput {
	s.StatusCode = &v
	return s
}

type ResponseHeaderActionForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	ResponseHeaderInstances []*ResponseHeaderInstanceForAddCdnDomainInput `type:"list"`
}

// String returns the string representation
func (s ResponseHeaderActionForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResponseHeaderActionForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetResponseHeaderInstances sets the ResponseHeaderInstances field's value.
func (s *ResponseHeaderActionForAddCdnDomainInput) SetResponseHeaderInstances(v []*ResponseHeaderInstanceForAddCdnDomainInput) *ResponseHeaderActionForAddCdnDomainInput {
	s.ResponseHeaderInstances = v
	return s
}

type ResponseHeaderForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Condition *ConditionForAddCdnDomainInput `type:"structure"`

	ResponseHeaderAction *ResponseHeaderActionForAddCdnDomainInput `type:"structure"`
}

// String returns the string representation
func (s ResponseHeaderForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResponseHeaderForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *ResponseHeaderForAddCdnDomainInput) SetCondition(v *ConditionForAddCdnDomainInput) *ResponseHeaderForAddCdnDomainInput {
	s.Condition = v
	return s
}

// SetResponseHeaderAction sets the ResponseHeaderAction field's value.
func (s *ResponseHeaderForAddCdnDomainInput) SetResponseHeaderAction(v *ResponseHeaderActionForAddCdnDomainInput) *ResponseHeaderForAddCdnDomainInput {
	s.ResponseHeaderAction = v
	return s
}

type ResponseHeaderInstanceForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	AccessOriginControl *bool `type:"boolean"`

	Action *string `type:"string"`

	Key *string `type:"string"`

	Value *string `type:"string"`

	ValueType *string `type:"string"`
}

// String returns the string representation
func (s ResponseHeaderInstanceForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResponseHeaderInstanceForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetAccessOriginControl sets the AccessOriginControl field's value.
func (s *ResponseHeaderInstanceForAddCdnDomainInput) SetAccessOriginControl(v bool) *ResponseHeaderInstanceForAddCdnDomainInput {
	s.AccessOriginControl = &v
	return s
}

// SetAction sets the Action field's value.
func (s *ResponseHeaderInstanceForAddCdnDomainInput) SetAction(v string) *ResponseHeaderInstanceForAddCdnDomainInput {
	s.Action = &v
	return s
}

// SetKey sets the Key field's value.
func (s *ResponseHeaderInstanceForAddCdnDomainInput) SetKey(v string) *ResponseHeaderInstanceForAddCdnDomainInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ResponseHeaderInstanceForAddCdnDomainInput) SetValue(v string) *ResponseHeaderInstanceForAddCdnDomainInput {
	s.Value = &v
	return s
}

// SetValueType sets the ValueType field's value.
func (s *ResponseHeaderInstanceForAddCdnDomainInput) SetValueType(v string) *ResponseHeaderInstanceForAddCdnDomainInput {
	s.ValueType = &v
	return s
}

type RewriteHLSForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	SignName *string `type:"string"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s RewriteHLSForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RewriteHLSForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetSignName sets the SignName field's value.
func (s *RewriteHLSForAddCdnDomainInput) SetSignName(v string) *RewriteHLSForAddCdnDomainInput {
	s.SignName = &v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *RewriteHLSForAddCdnDomainInput) SetSwitch(v bool) *RewriteHLSForAddCdnDomainInput {
	s.Switch = &v
	return s
}

type RewriteM3u8RuleForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	DeleteParam *bool `type:"boolean"`

	KeepM3u8Param *bool `type:"boolean"`

	TransferEncoding *bool `type:"boolean"`
}

// String returns the string representation
func (s RewriteM3u8RuleForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RewriteM3u8RuleForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetDeleteParam sets the DeleteParam field's value.
func (s *RewriteM3u8RuleForAddCdnDomainInput) SetDeleteParam(v bool) *RewriteM3u8RuleForAddCdnDomainInput {
	s.DeleteParam = &v
	return s
}

// SetKeepM3u8Param sets the KeepM3u8Param field's value.
func (s *RewriteM3u8RuleForAddCdnDomainInput) SetKeepM3u8Param(v bool) *RewriteM3u8RuleForAddCdnDomainInput {
	s.KeepM3u8Param = &v
	return s
}

// SetTransferEncoding sets the TransferEncoding field's value.
func (s *RewriteM3u8RuleForAddCdnDomainInput) SetTransferEncoding(v bool) *RewriteM3u8RuleForAddCdnDomainInput {
	s.TransferEncoding = &v
	return s
}

type SharedConfigForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	ConfigName *string `type:"string"`
}

// String returns the string representation
func (s SharedConfigForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SharedConfigForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetConfigName sets the ConfigName field's value.
func (s *SharedConfigForAddCdnDomainInput) SetConfigName(v string) *SharedConfigForAddCdnDomainInput {
	s.ConfigName = &v
	return s
}

type SignCapRuleForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	CapMode *string `type:"string"`

	ParamName *string `type:"string"`

	UriLevel *int64 `type:"int64"`
}

// String returns the string representation
func (s SignCapRuleForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SignCapRuleForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetCapMode sets the CapMode field's value.
func (s *SignCapRuleForAddCdnDomainInput) SetCapMode(v string) *SignCapRuleForAddCdnDomainInput {
	s.CapMode = &v
	return s
}

// SetParamName sets the ParamName field's value.
func (s *SignCapRuleForAddCdnDomainInput) SetParamName(v string) *SignCapRuleForAddCdnDomainInput {
	s.ParamName = &v
	return s
}

// SetUriLevel sets the UriLevel field's value.
func (s *SignCapRuleForAddCdnDomainInput) SetUriLevel(v int64) *SignCapRuleForAddCdnDomainInput {
	s.UriLevel = &v
	return s
}

type SignParamForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	ParamType *string `type:"string"`

	RequestHeader *string `type:"string"`

	SupContent *string `type:"string"`

	UriParamSup *UriParamSupForAddCdnDomainInput `type:"structure"`

	UrlParam *SignCapRuleForAddCdnDomainInput `type:"structure"`
}

// String returns the string representation
func (s SignParamForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SignParamForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetParamType sets the ParamType field's value.
func (s *SignParamForAddCdnDomainInput) SetParamType(v string) *SignParamForAddCdnDomainInput {
	s.ParamType = &v
	return s
}

// SetRequestHeader sets the RequestHeader field's value.
func (s *SignParamForAddCdnDomainInput) SetRequestHeader(v string) *SignParamForAddCdnDomainInput {
	s.RequestHeader = &v
	return s
}

// SetSupContent sets the SupContent field's value.
func (s *SignParamForAddCdnDomainInput) SetSupContent(v string) *SignParamForAddCdnDomainInput {
	s.SupContent = &v
	return s
}

// SetUriParamSup sets the UriParamSup field's value.
func (s *SignParamForAddCdnDomainInput) SetUriParamSup(v *UriParamSupForAddCdnDomainInput) *SignParamForAddCdnDomainInput {
	s.UriParamSup = v
	return s
}

// SetUrlParam sets the UrlParam field's value.
func (s *SignParamForAddCdnDomainInput) SetUrlParam(v *SignCapRuleForAddCdnDomainInput) *SignParamForAddCdnDomainInput {
	s.UrlParam = v
	return s
}

type SignedUrlAuthActionForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	AuthAlgorithm *string `type:"string"`

	BackupSecretKey *string `type:"string"`

	CustomVariableRules *CustomVariableRulesForAddCdnDomainInput `type:"structure"`

	Duration *int64 `type:"int64"`

	KeepOriginArg *bool `type:"boolean"`

	MasterSecretKey *string `type:"string"`

	MpdVarExpand *bool `type:"boolean"`

	RewriteM3u8 *bool `type:"boolean"`

	RewriteM3u8Rule *RewriteM3u8RuleForAddCdnDomainInput `type:"structure"`

	RewriteMpd *bool `type:"boolean"`

	SignName *string `type:"string"`

	SignatureRule []*string `type:"list"`

	TimeFormat *string `type:"string"`

	TimeName *string `type:"string"`

	URLAuthType *string `type:"string"`

	UrlAuthCustomAction *UrlAuthCustomActionForAddCdnDomainInput `type:"structure"`
}

// String returns the string representation
func (s SignedUrlAuthActionForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SignedUrlAuthActionForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetAuthAlgorithm sets the AuthAlgorithm field's value.
func (s *SignedUrlAuthActionForAddCdnDomainInput) SetAuthAlgorithm(v string) *SignedUrlAuthActionForAddCdnDomainInput {
	s.AuthAlgorithm = &v
	return s
}

// SetBackupSecretKey sets the BackupSecretKey field's value.
func (s *SignedUrlAuthActionForAddCdnDomainInput) SetBackupSecretKey(v string) *SignedUrlAuthActionForAddCdnDomainInput {
	s.BackupSecretKey = &v
	return s
}

// SetCustomVariableRules sets the CustomVariableRules field's value.
func (s *SignedUrlAuthActionForAddCdnDomainInput) SetCustomVariableRules(v *CustomVariableRulesForAddCdnDomainInput) *SignedUrlAuthActionForAddCdnDomainInput {
	s.CustomVariableRules = v
	return s
}

// SetDuration sets the Duration field's value.
func (s *SignedUrlAuthActionForAddCdnDomainInput) SetDuration(v int64) *SignedUrlAuthActionForAddCdnDomainInput {
	s.Duration = &v
	return s
}

// SetKeepOriginArg sets the KeepOriginArg field's value.
func (s *SignedUrlAuthActionForAddCdnDomainInput) SetKeepOriginArg(v bool) *SignedUrlAuthActionForAddCdnDomainInput {
	s.KeepOriginArg = &v
	return s
}

// SetMasterSecretKey sets the MasterSecretKey field's value.
func (s *SignedUrlAuthActionForAddCdnDomainInput) SetMasterSecretKey(v string) *SignedUrlAuthActionForAddCdnDomainInput {
	s.MasterSecretKey = &v
	return s
}

// SetMpdVarExpand sets the MpdVarExpand field's value.
func (s *SignedUrlAuthActionForAddCdnDomainInput) SetMpdVarExpand(v bool) *SignedUrlAuthActionForAddCdnDomainInput {
	s.MpdVarExpand = &v
	return s
}

// SetRewriteM3u8 sets the RewriteM3u8 field's value.
func (s *SignedUrlAuthActionForAddCdnDomainInput) SetRewriteM3u8(v bool) *SignedUrlAuthActionForAddCdnDomainInput {
	s.RewriteM3u8 = &v
	return s
}

// SetRewriteM3u8Rule sets the RewriteM3u8Rule field's value.
func (s *SignedUrlAuthActionForAddCdnDomainInput) SetRewriteM3u8Rule(v *RewriteM3u8RuleForAddCdnDomainInput) *SignedUrlAuthActionForAddCdnDomainInput {
	s.RewriteM3u8Rule = v
	return s
}

// SetRewriteMpd sets the RewriteMpd field's value.
func (s *SignedUrlAuthActionForAddCdnDomainInput) SetRewriteMpd(v bool) *SignedUrlAuthActionForAddCdnDomainInput {
	s.RewriteMpd = &v
	return s
}

// SetSignName sets the SignName field's value.
func (s *SignedUrlAuthActionForAddCdnDomainInput) SetSignName(v string) *SignedUrlAuthActionForAddCdnDomainInput {
	s.SignName = &v
	return s
}

// SetSignatureRule sets the SignatureRule field's value.
func (s *SignedUrlAuthActionForAddCdnDomainInput) SetSignatureRule(v []*string) *SignedUrlAuthActionForAddCdnDomainInput {
	s.SignatureRule = v
	return s
}

// SetTimeFormat sets the TimeFormat field's value.
func (s *SignedUrlAuthActionForAddCdnDomainInput) SetTimeFormat(v string) *SignedUrlAuthActionForAddCdnDomainInput {
	s.TimeFormat = &v
	return s
}

// SetTimeName sets the TimeName field's value.
func (s *SignedUrlAuthActionForAddCdnDomainInput) SetTimeName(v string) *SignedUrlAuthActionForAddCdnDomainInput {
	s.TimeName = &v
	return s
}

// SetURLAuthType sets the URLAuthType field's value.
func (s *SignedUrlAuthActionForAddCdnDomainInput) SetURLAuthType(v string) *SignedUrlAuthActionForAddCdnDomainInput {
	s.URLAuthType = &v
	return s
}

// SetUrlAuthCustomAction sets the UrlAuthCustomAction field's value.
func (s *SignedUrlAuthActionForAddCdnDomainInput) SetUrlAuthCustomAction(v *UrlAuthCustomActionForAddCdnDomainInput) *SignedUrlAuthActionForAddCdnDomainInput {
	s.UrlAuthCustomAction = v
	return s
}

type SignedUrlAuthForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	SignedUrlAuthRules []*SignedUrlAuthRuleForAddCdnDomainInput `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s SignedUrlAuthForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SignedUrlAuthForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetSignedUrlAuthRules sets the SignedUrlAuthRules field's value.
func (s *SignedUrlAuthForAddCdnDomainInput) SetSignedUrlAuthRules(v []*SignedUrlAuthRuleForAddCdnDomainInput) *SignedUrlAuthForAddCdnDomainInput {
	s.SignedUrlAuthRules = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *SignedUrlAuthForAddCdnDomainInput) SetSwitch(v bool) *SignedUrlAuthForAddCdnDomainInput {
	s.Switch = &v
	return s
}

type SignedUrlAuthRuleForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Condition *ConditionForAddCdnDomainInput `type:"structure"`

	SignedUrlAuthAction *SignedUrlAuthActionForAddCdnDomainInput `type:"structure"`
}

// String returns the string representation
func (s SignedUrlAuthRuleForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SignedUrlAuthRuleForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *SignedUrlAuthRuleForAddCdnDomainInput) SetCondition(v *ConditionForAddCdnDomainInput) *SignedUrlAuthRuleForAddCdnDomainInput {
	s.Condition = v
	return s
}

// SetSignedUrlAuthAction sets the SignedUrlAuthAction field's value.
func (s *SignedUrlAuthRuleForAddCdnDomainInput) SetSignedUrlAuthAction(v *SignedUrlAuthActionForAddCdnDomainInput) *SignedUrlAuthRuleForAddCdnDomainInput {
	s.SignedUrlAuthAction = v
	return s
}

type SpeedLimitTimeForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	BeginTime *string `type:"string"`

	DayWeek *string `type:"string"`

	EndTime *string `type:"string"`
}

// String returns the string representation
func (s SpeedLimitTimeForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SpeedLimitTimeForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetBeginTime sets the BeginTime field's value.
func (s *SpeedLimitTimeForAddCdnDomainInput) SetBeginTime(v string) *SpeedLimitTimeForAddCdnDomainInput {
	s.BeginTime = &v
	return s
}

// SetDayWeek sets the DayWeek field's value.
func (s *SpeedLimitTimeForAddCdnDomainInput) SetDayWeek(v string) *SpeedLimitTimeForAddCdnDomainInput {
	s.DayWeek = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *SpeedLimitTimeForAddCdnDomainInput) SetEndTime(v string) *SpeedLimitTimeForAddCdnDomainInput {
	s.EndTime = &v
	return s
}

type StatusCodeActionForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	DefaultAction *string `type:"string"`

	FailCode *string `type:"string"`

	SuccessCode *string `type:"string"`
}

// String returns the string representation
func (s StatusCodeActionForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StatusCodeActionForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetDefaultAction sets the DefaultAction field's value.
func (s *StatusCodeActionForAddCdnDomainInput) SetDefaultAction(v string) *StatusCodeActionForAddCdnDomainInput {
	s.DefaultAction = &v
	return s
}

// SetFailCode sets the FailCode field's value.
func (s *StatusCodeActionForAddCdnDomainInput) SetFailCode(v string) *StatusCodeActionForAddCdnDomainInput {
	s.FailCode = &v
	return s
}

// SetSuccessCode sets the SuccessCode field's value.
func (s *StatusCodeActionForAddCdnDomainInput) SetSuccessCode(v string) *StatusCodeActionForAddCdnDomainInput {
	s.SuccessCode = &v
	return s
}

type TargetQueryComponentsForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Action *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s TargetQueryComponentsForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TargetQueryComponentsForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *TargetQueryComponentsForAddCdnDomainInput) SetAction(v string) *TargetQueryComponentsForAddCdnDomainInput {
	s.Action = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TargetQueryComponentsForAddCdnDomainInput) SetValue(v string) *TargetQueryComponentsForAddCdnDomainInput {
	s.Value = &v
	return s
}

type TimeOutActionForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Action *string `type:"string"`

	Time *int64 `type:"int64"`
}

// String returns the string representation
func (s TimeOutActionForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TimeOutActionForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *TimeOutActionForAddCdnDomainInput) SetAction(v string) *TimeOutActionForAddCdnDomainInput {
	s.Action = &v
	return s
}

// SetTime sets the Time field's value.
func (s *TimeOutActionForAddCdnDomainInput) SetTime(v int64) *TimeOutActionForAddCdnDomainInput {
	s.Time = &v
	return s
}

type TimeoutForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Switch *bool `type:"boolean"`

	TimeoutRules []*TimeoutRuleForAddCdnDomainInput `type:"list"`
}

// String returns the string representation
func (s TimeoutForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TimeoutForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetSwitch sets the Switch field's value.
func (s *TimeoutForAddCdnDomainInput) SetSwitch(v bool) *TimeoutForAddCdnDomainInput {
	s.Switch = &v
	return s
}

// SetTimeoutRules sets the TimeoutRules field's value.
func (s *TimeoutForAddCdnDomainInput) SetTimeoutRules(v []*TimeoutRuleForAddCdnDomainInput) *TimeoutForAddCdnDomainInput {
	s.TimeoutRules = v
	return s
}

type TimeoutRuleForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Condition *ConditionForAddCdnDomainInput `type:"structure"`

	TimeoutAction *ConvertTimeoutActionForAddCdnDomainInput `type:"structure"`
}

// String returns the string representation
func (s TimeoutRuleForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TimeoutRuleForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *TimeoutRuleForAddCdnDomainInput) SetCondition(v *ConditionForAddCdnDomainInput) *TimeoutRuleForAddCdnDomainInput {
	s.Condition = v
	return s
}

// SetTimeoutAction sets the TimeoutAction field's value.
func (s *TimeoutRuleForAddCdnDomainInput) SetTimeoutAction(v *ConvertTimeoutActionForAddCdnDomainInput) *TimeoutRuleForAddCdnDomainInput {
	s.TimeoutAction = v
	return s
}

type TosAuthInformationForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	AccessKeyId *string `type:"string"`

	AccessKeySecret *string `type:"string"`

	AccountKey *string `type:"string"`
}

// String returns the string representation
func (s TosAuthInformationForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TosAuthInformationForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetAccessKeyId sets the AccessKeyId field's value.
func (s *TosAuthInformationForAddCdnDomainInput) SetAccessKeyId(v string) *TosAuthInformationForAddCdnDomainInput {
	s.AccessKeyId = &v
	return s
}

// SetAccessKeySecret sets the AccessKeySecret field's value.
func (s *TosAuthInformationForAddCdnDomainInput) SetAccessKeySecret(v string) *TosAuthInformationForAddCdnDomainInput {
	s.AccessKeySecret = &v
	return s
}

// SetAccountKey sets the AccountKey field's value.
func (s *TosAuthInformationForAddCdnDomainInput) SetAccountKey(v string) *TosAuthInformationForAddCdnDomainInput {
	s.AccountKey = &v
	return s
}

type UaAccessRuleForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	AllowEmpty *bool `type:"boolean"`

	IgnoreCase *bool `type:"boolean"`

	RuleType *string `type:"string"`

	Switch *bool `type:"boolean"`

	UserAgent []*string `type:"list"`
}

// String returns the string representation
func (s UaAccessRuleForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UaAccessRuleForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetAllowEmpty sets the AllowEmpty field's value.
func (s *UaAccessRuleForAddCdnDomainInput) SetAllowEmpty(v bool) *UaAccessRuleForAddCdnDomainInput {
	s.AllowEmpty = &v
	return s
}

// SetIgnoreCase sets the IgnoreCase field's value.
func (s *UaAccessRuleForAddCdnDomainInput) SetIgnoreCase(v bool) *UaAccessRuleForAddCdnDomainInput {
	s.IgnoreCase = &v
	return s
}

// SetRuleType sets the RuleType field's value.
func (s *UaAccessRuleForAddCdnDomainInput) SetRuleType(v string) *UaAccessRuleForAddCdnDomainInput {
	s.RuleType = &v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *UaAccessRuleForAddCdnDomainInput) SetSwitch(v bool) *UaAccessRuleForAddCdnDomainInput {
	s.Switch = &v
	return s
}

// SetUserAgent sets the UserAgent field's value.
func (s *UaAccessRuleForAddCdnDomainInput) SetUserAgent(v []*string) *UaAccessRuleForAddCdnDomainInput {
	s.UserAgent = v
	return s
}

type UriParamSupForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	JoinSymbol *string `type:"string"`

	SplitSymbol *string `type:"string"`

	StartLevel *int64 `type:"int64"`

	TermLevel *int64 `type:"int64"`
}

// String returns the string representation
func (s UriParamSupForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UriParamSupForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetJoinSymbol sets the JoinSymbol field's value.
func (s *UriParamSupForAddCdnDomainInput) SetJoinSymbol(v string) *UriParamSupForAddCdnDomainInput {
	s.JoinSymbol = &v
	return s
}

// SetSplitSymbol sets the SplitSymbol field's value.
func (s *UriParamSupForAddCdnDomainInput) SetSplitSymbol(v string) *UriParamSupForAddCdnDomainInput {
	s.SplitSymbol = &v
	return s
}

// SetStartLevel sets the StartLevel field's value.
func (s *UriParamSupForAddCdnDomainInput) SetStartLevel(v int64) *UriParamSupForAddCdnDomainInput {
	s.StartLevel = &v
	return s
}

// SetTermLevel sets the TermLevel field's value.
func (s *UriParamSupForAddCdnDomainInput) SetTermLevel(v int64) *UriParamSupForAddCdnDomainInput {
	s.TermLevel = &v
	return s
}

type UrlAuthCustomActionForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	ExpTimeCapRule *ExpTimeCapRuleForAddCdnDomainInput `type:"structure"`

	ParamCalRules []*string `type:"list"`

	SignCapRule *SignCapRuleForAddCdnDomainInput `type:"structure"`

	SignJoinSymbol *string `type:"string"`

	SignParam []*SignParamForAddCdnDomainInput `type:"list"`
}

// String returns the string representation
func (s UrlAuthCustomActionForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UrlAuthCustomActionForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetExpTimeCapRule sets the ExpTimeCapRule field's value.
func (s *UrlAuthCustomActionForAddCdnDomainInput) SetExpTimeCapRule(v *ExpTimeCapRuleForAddCdnDomainInput) *UrlAuthCustomActionForAddCdnDomainInput {
	s.ExpTimeCapRule = v
	return s
}

// SetParamCalRules sets the ParamCalRules field's value.
func (s *UrlAuthCustomActionForAddCdnDomainInput) SetParamCalRules(v []*string) *UrlAuthCustomActionForAddCdnDomainInput {
	s.ParamCalRules = v
	return s
}

// SetSignCapRule sets the SignCapRule field's value.
func (s *UrlAuthCustomActionForAddCdnDomainInput) SetSignCapRule(v *SignCapRuleForAddCdnDomainInput) *UrlAuthCustomActionForAddCdnDomainInput {
	s.SignCapRule = v
	return s
}

// SetSignJoinSymbol sets the SignJoinSymbol field's value.
func (s *UrlAuthCustomActionForAddCdnDomainInput) SetSignJoinSymbol(v string) *UrlAuthCustomActionForAddCdnDomainInput {
	s.SignJoinSymbol = &v
	return s
}

// SetSignParam sets the SignParam field's value.
func (s *UrlAuthCustomActionForAddCdnDomainInput) SetSignParam(v []*SignParamForAddCdnDomainInput) *UrlAuthCustomActionForAddCdnDomainInput {
	s.SignParam = v
	return s
}

type UrlNormalizeForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	NormalizeObject []*string `type:"list"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s UrlNormalizeForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UrlNormalizeForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetNormalizeObject sets the NormalizeObject field's value.
func (s *UrlNormalizeForAddCdnDomainInput) SetNormalizeObject(v []*string) *UrlNormalizeForAddCdnDomainInput {
	s.NormalizeObject = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *UrlNormalizeForAddCdnDomainInput) SetSwitch(v bool) *UrlNormalizeForAddCdnDomainInput {
	s.Switch = &v
	return s
}

type VideoDragForAddCdnDomainInput struct {
	_ struct{} `type:"structure"`

	Switch *bool `type:"boolean"`
}

// String returns the string representation
func (s VideoDragForAddCdnDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s VideoDragForAddCdnDomainInput) GoString() string {
	return s.String()
}

// SetSwitch sets the Switch field's value.
func (s *VideoDragForAddCdnDomainInput) SetSwitch(v bool) *VideoDragForAddCdnDomainInput {
	s.Switch = &v
	return s
}
