// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package autoscaling

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateScalingConfigurationCommon = "CreateScalingConfiguration"

// CreateScalingConfigurationCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateScalingConfigurationCommon operation. The "output" return
// value will be populated with the CreateScalingConfigurationCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateScalingConfigurationCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateScalingConfigurationCommon Send returns without error.
//
// See CreateScalingConfigurationCommon for more information on using the CreateScalingConfigurationCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateScalingConfigurationCommonRequest method.
//    req, resp := client.CreateScalingConfigurationCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *AUTOSCALING) CreateScalingConfigurationCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateScalingConfigurationCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// CreateScalingConfigurationCommon API operation for AUTO_SCALING.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for AUTO_SCALING's
// API operation CreateScalingConfigurationCommon for usage and error information.
func (c *AUTOSCALING) CreateScalingConfigurationCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateScalingConfigurationCommonRequest(input)
	return out, req.Send()
}

// CreateScalingConfigurationCommonWithContext is the same as CreateScalingConfigurationCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateScalingConfigurationCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AUTOSCALING) CreateScalingConfigurationCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateScalingConfigurationCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateScalingConfiguration = "CreateScalingConfiguration"

// CreateScalingConfigurationRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateScalingConfiguration operation. The "output" return
// value will be populated with the CreateScalingConfigurationCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateScalingConfigurationCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateScalingConfigurationCommon Send returns without error.
//
// See CreateScalingConfiguration for more information on using the CreateScalingConfiguration
// API call, and error handling.
//
//    // Example sending a request using the CreateScalingConfigurationRequest method.
//    req, resp := client.CreateScalingConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *AUTOSCALING) CreateScalingConfigurationRequest(input *CreateScalingConfigurationInput) (req *request.Request, output *CreateScalingConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateScalingConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateScalingConfigurationInput{}
	}

	output = &CreateScalingConfigurationOutput{}
	req = c.newRequest(op, input, output)

	return
}

// CreateScalingConfiguration API operation for AUTO_SCALING.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for AUTO_SCALING's
// API operation CreateScalingConfiguration for usage and error information.
func (c *AUTOSCALING) CreateScalingConfiguration(input *CreateScalingConfigurationInput) (*CreateScalingConfigurationOutput, error) {
	req, out := c.CreateScalingConfigurationRequest(input)
	return out, req.Send()
}

// CreateScalingConfigurationWithContext is the same as CreateScalingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateScalingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AUTOSCALING) CreateScalingConfigurationWithContext(ctx volcengine.Context, input *CreateScalingConfigurationInput, opts ...request.Option) (*CreateScalingConfigurationOutput, error) {
	req, out := c.CreateScalingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateScalingConfigurationInput struct {
	_ struct{} `type:"structure"`

	ClientToken *string `type:"string"`

	Eip *EipForCreateScalingConfigurationInput `type:"structure"`

	HostName *string `type:"string"`

	HpcClusterId *string `type:"string"`

	// ImageId is a required field
	ImageId *string `type:"string" required:"true"`

	InstanceDescription *string `type:"string"`

	// InstanceName is a required field
	InstanceName *string `type:"string" required:"true"`

	InstanceTypeOverrides []*InstanceTypeOverrideForCreateScalingConfigurationInput `type:"list"`

	InstanceTypes []*string `type:"list"`

	Ipv6AddressCount *int32 `type:"int32"`

	KeyPairName *string `type:"string"`

	Password *string `min:"8" max:"30" type:"string"`

	ProjectName *string `max:"64" type:"string"`

	// ScalingConfigurationName is a required field
	ScalingConfigurationName *string `min:"1" max:"128" type:"string" required:"true"`

	// ScalingGroupId is a required field
	ScalingGroupId *string `type:"string" required:"true"`

	SecurityEnhancementStrategy *string `type:"string"`

	// SecurityGroupIds is a required field
	SecurityGroupIds []*string `type:"list" required:"true"`

	SpotStrategy *string `type:"string"`

	Tags *string `type:"string"`

	UserData *string `type:"string"`

	// Volumes is a required field
	Volumes []*VolumeForCreateScalingConfigurationInput `type:"list" required:"true"`

	ZoneId *string `type:"string"`
}

// String returns the string representation
func (s CreateScalingConfigurationInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateScalingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateScalingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateScalingConfigurationInput"}
	if s.ImageId == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageId"))
	}
	if s.InstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceName"))
	}
	if s.Password != nil && len(*s.Password) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("Password", 8))
	}
	if s.Password != nil && len(*s.Password) > 30 {
		invalidParams.Add(request.NewErrParamMaxLen("Password", 30, *s.Password))
	}
	if s.ProjectName != nil && len(*s.ProjectName) > 64 {
		invalidParams.Add(request.NewErrParamMaxLen("ProjectName", 64, *s.ProjectName))
	}
	if s.ScalingConfigurationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalingConfigurationName"))
	}
	if s.ScalingConfigurationName != nil && len(*s.ScalingConfigurationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScalingConfigurationName", 1))
	}
	if s.ScalingConfigurationName != nil && len(*s.ScalingConfigurationName) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("ScalingConfigurationName", 128, *s.ScalingConfigurationName))
	}
	if s.ScalingGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalingGroupId"))
	}
	if s.SecurityGroupIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityGroupIds"))
	}
	if s.Volumes == nil {
		invalidParams.Add(request.NewErrParamRequired("Volumes"))
	}
	if s.Volumes != nil {
		for i, v := range s.Volumes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Volumes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateScalingConfigurationInput) SetClientToken(v string) *CreateScalingConfigurationInput {
	s.ClientToken = &v
	return s
}

// SetEip sets the Eip field's value.
func (s *CreateScalingConfigurationInput) SetEip(v *EipForCreateScalingConfigurationInput) *CreateScalingConfigurationInput {
	s.Eip = v
	return s
}

// SetHostName sets the HostName field's value.
func (s *CreateScalingConfigurationInput) SetHostName(v string) *CreateScalingConfigurationInput {
	s.HostName = &v
	return s
}

// SetHpcClusterId sets the HpcClusterId field's value.
func (s *CreateScalingConfigurationInput) SetHpcClusterId(v string) *CreateScalingConfigurationInput {
	s.HpcClusterId = &v
	return s
}

// SetImageId sets the ImageId field's value.
func (s *CreateScalingConfigurationInput) SetImageId(v string) *CreateScalingConfigurationInput {
	s.ImageId = &v
	return s
}

// SetInstanceDescription sets the InstanceDescription field's value.
func (s *CreateScalingConfigurationInput) SetInstanceDescription(v string) *CreateScalingConfigurationInput {
	s.InstanceDescription = &v
	return s
}

// SetInstanceName sets the InstanceName field's value.
func (s *CreateScalingConfigurationInput) SetInstanceName(v string) *CreateScalingConfigurationInput {
	s.InstanceName = &v
	return s
}

// SetInstanceTypeOverrides sets the InstanceTypeOverrides field's value.
func (s *CreateScalingConfigurationInput) SetInstanceTypeOverrides(v []*InstanceTypeOverrideForCreateScalingConfigurationInput) *CreateScalingConfigurationInput {
	s.InstanceTypeOverrides = v
	return s
}

// SetInstanceTypes sets the InstanceTypes field's value.
func (s *CreateScalingConfigurationInput) SetInstanceTypes(v []*string) *CreateScalingConfigurationInput {
	s.InstanceTypes = v
	return s
}

// SetIpv6AddressCount sets the Ipv6AddressCount field's value.
func (s *CreateScalingConfigurationInput) SetIpv6AddressCount(v int32) *CreateScalingConfigurationInput {
	s.Ipv6AddressCount = &v
	return s
}

// SetKeyPairName sets the KeyPairName field's value.
func (s *CreateScalingConfigurationInput) SetKeyPairName(v string) *CreateScalingConfigurationInput {
	s.KeyPairName = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *CreateScalingConfigurationInput) SetPassword(v string) *CreateScalingConfigurationInput {
	s.Password = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *CreateScalingConfigurationInput) SetProjectName(v string) *CreateScalingConfigurationInput {
	s.ProjectName = &v
	return s
}

// SetScalingConfigurationName sets the ScalingConfigurationName field's value.
func (s *CreateScalingConfigurationInput) SetScalingConfigurationName(v string) *CreateScalingConfigurationInput {
	s.ScalingConfigurationName = &v
	return s
}

// SetScalingGroupId sets the ScalingGroupId field's value.
func (s *CreateScalingConfigurationInput) SetScalingGroupId(v string) *CreateScalingConfigurationInput {
	s.ScalingGroupId = &v
	return s
}

// SetSecurityEnhancementStrategy sets the SecurityEnhancementStrategy field's value.
func (s *CreateScalingConfigurationInput) SetSecurityEnhancementStrategy(v string) *CreateScalingConfigurationInput {
	s.SecurityEnhancementStrategy = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *CreateScalingConfigurationInput) SetSecurityGroupIds(v []*string) *CreateScalingConfigurationInput {
	s.SecurityGroupIds = v
	return s
}

// SetSpotStrategy sets the SpotStrategy field's value.
func (s *CreateScalingConfigurationInput) SetSpotStrategy(v string) *CreateScalingConfigurationInput {
	s.SpotStrategy = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateScalingConfigurationInput) SetTags(v string) *CreateScalingConfigurationInput {
	s.Tags = &v
	return s
}

// SetUserData sets the UserData field's value.
func (s *CreateScalingConfigurationInput) SetUserData(v string) *CreateScalingConfigurationInput {
	s.UserData = &v
	return s
}

// SetVolumes sets the Volumes field's value.
func (s *CreateScalingConfigurationInput) SetVolumes(v []*VolumeForCreateScalingConfigurationInput) *CreateScalingConfigurationInput {
	s.Volumes = v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *CreateScalingConfigurationInput) SetZoneId(v string) *CreateScalingConfigurationInput {
	s.ZoneId = &v
	return s
}

type CreateScalingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	ScalingConfigurationId *string `type:"string"`
}

// String returns the string representation
func (s CreateScalingConfigurationOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateScalingConfigurationOutput) GoString() string {
	return s.String()
}

// SetScalingConfigurationId sets the ScalingConfigurationId field's value.
func (s *CreateScalingConfigurationOutput) SetScalingConfigurationId(v string) *CreateScalingConfigurationOutput {
	s.ScalingConfigurationId = &v
	return s
}

type EipForCreateScalingConfigurationInput struct {
	_ struct{} `type:"structure"`

	Bandwidth *int32 `type:"int32"`

	BandwidthPackageId *string `type:"string"`

	BillingType *string `type:"string"`

	ISP *string `type:"string"`

	SecurityProtectionInstanceId *int32 `type:"int32"`

	SecurityProtectionTypes []*string `type:"list"`
}

// String returns the string representation
func (s EipForCreateScalingConfigurationInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s EipForCreateScalingConfigurationInput) GoString() string {
	return s.String()
}

// SetBandwidth sets the Bandwidth field's value.
func (s *EipForCreateScalingConfigurationInput) SetBandwidth(v int32) *EipForCreateScalingConfigurationInput {
	s.Bandwidth = &v
	return s
}

// SetBandwidthPackageId sets the BandwidthPackageId field's value.
func (s *EipForCreateScalingConfigurationInput) SetBandwidthPackageId(v string) *EipForCreateScalingConfigurationInput {
	s.BandwidthPackageId = &v
	return s
}

// SetBillingType sets the BillingType field's value.
func (s *EipForCreateScalingConfigurationInput) SetBillingType(v string) *EipForCreateScalingConfigurationInput {
	s.BillingType = &v
	return s
}

// SetISP sets the ISP field's value.
func (s *EipForCreateScalingConfigurationInput) SetISP(v string) *EipForCreateScalingConfigurationInput {
	s.ISP = &v
	return s
}

// SetSecurityProtectionInstanceId sets the SecurityProtectionInstanceId field's value.
func (s *EipForCreateScalingConfigurationInput) SetSecurityProtectionInstanceId(v int32) *EipForCreateScalingConfigurationInput {
	s.SecurityProtectionInstanceId = &v
	return s
}

// SetSecurityProtectionTypes sets the SecurityProtectionTypes field's value.
func (s *EipForCreateScalingConfigurationInput) SetSecurityProtectionTypes(v []*string) *EipForCreateScalingConfigurationInput {
	s.SecurityProtectionTypes = v
	return s
}

type InstanceTypeOverrideForCreateScalingConfigurationInput struct {
	_ struct{} `type:"structure"`

	InstanceType *string `type:"string"`

	PriceLimit *float64 `type:"float"`
}

// String returns the string representation
func (s InstanceTypeOverrideForCreateScalingConfigurationInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceTypeOverrideForCreateScalingConfigurationInput) GoString() string {
	return s.String()
}

// SetInstanceType sets the InstanceType field's value.
func (s *InstanceTypeOverrideForCreateScalingConfigurationInput) SetInstanceType(v string) *InstanceTypeOverrideForCreateScalingConfigurationInput {
	s.InstanceType = &v
	return s
}

// SetPriceLimit sets the PriceLimit field's value.
func (s *InstanceTypeOverrideForCreateScalingConfigurationInput) SetPriceLimit(v float64) *InstanceTypeOverrideForCreateScalingConfigurationInput {
	s.PriceLimit = &v
	return s
}

type VolumeForCreateScalingConfigurationInput struct {
	_ struct{} `type:"structure"`

	DeleteWithInstance *bool `type:"boolean"`

	// Size is a required field
	Size *int32 `type:"int32" required:"true"`

	// VolumeType is a required field
	VolumeType *string `type:"string" required:"true"`
}

// String returns the string representation
func (s VolumeForCreateScalingConfigurationInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s VolumeForCreateScalingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VolumeForCreateScalingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VolumeForCreateScalingConfigurationInput"}
	if s.Size == nil {
		invalidParams.Add(request.NewErrParamRequired("Size"))
	}
	if s.VolumeType == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeleteWithInstance sets the DeleteWithInstance field's value.
func (s *VolumeForCreateScalingConfigurationInput) SetDeleteWithInstance(v bool) *VolumeForCreateScalingConfigurationInput {
	s.DeleteWithInstance = &v
	return s
}

// SetSize sets the Size field's value.
func (s *VolumeForCreateScalingConfigurationInput) SetSize(v int32) *VolumeForCreateScalingConfigurationInput {
	s.Size = &v
	return s
}

// SetVolumeType sets the VolumeType field's value.
func (s *VolumeForCreateScalingConfigurationInput) SetVolumeType(v string) *VolumeForCreateScalingConfigurationInput {
	s.VolumeType = &v
	return s
}
