// Example Code generated by Beijing Volcanoengine Technology.
package vpcexample

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/service/vpc"
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/credentials"
	"github.com/volcengine/volcengine-go-sdk/volcengine/session"
)

func CreateNetworkAcl() {
	ak, sk, region := "Your AK", "Your SK", "cn-beijing"
	config := volcengine.NewConfig().
		WithRegion(region).
		WithCredentials(credentials.NewStaticCredentials(ak, sk, ""))
	sess, err := session.NewSession(config)
	if err != nil {
		panic(err)
	}
	svc := vpc.New(sess)
	createNetworkAclInput := &vpc.CreateNetworkAclInput{
		NetworkAclName: volcengine.String("acl-1"),
		VpcId:          volcengine.String("vpc-bp1opxu1zkhn00gzv****"),
	}

	resp, err := svc.CreateNetworkAcl(createNetworkAclInput)
	if err != nil {
		panic(err)
	}
	fmt.Println(resp)
}
