// Example Code generated by Beijing Volcanoengine Technology.
package storageebsexample

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/service/storageebs"
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/credentials"
	"github.com/volcengine/volcengine-go-sdk/volcengine/session"
)

func CreateTags() {
	ak, sk, region := "Your AK", "Your SK", "cn-beijing"
	config := volcengine.NewConfig().
		WithRegion(region).
		WithCredentials(credentials.NewStaticCredentials(ak, sk, ""))
	sess, err := session.NewSession(config)
	if err != nil {
		panic(err)
	}
	svc := storageebs.New(sess)
	reqTags := &storageebs.TagForCreateTagsInput{
		Key:   volcengine.String("tag"),
		Value: volcengine.String("test"),
	}
	createTagsInput := &storageebs.CreateTagsInput{
		ResourceIds:  volcengine.StringSlice([]string{"vol-76pwr6rilv8lzwxv*****", "vol-76pwr6rilv8lzwxv****"}),
		ResourceType: volcengine.String("volume"),
		Tags:         []*storageebs.TagForCreateTagsInput{reqTags},
	}

	resp, err := svc.CreateTags(createTagsInput)
	if err != nil {
		panic(err)
	}
	fmt.Println(resp)
}
