// Example Code generated by Beijing Volcanoengine Technology.
package directconnectexample

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/service/directconnect"
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/credentials"
	"github.com/volcengine/volcengine-go-sdk/volcengine/session"
)

func DeleteDirectConnectConnection() {
	ak, sk, region := "Your AK", "Your SK", "cn-beijing"
	config := volcengine.NewConfig().
		WithRegion(region).
		WithCredentials(credentials.NewStaticCredentials(ak, sk, ""))
	sess, err := session.NewSession(config)
	if err != nil {
		panic(err)
	}
	svc := directconnect.New(sess)
	deleteDirectConnectConnectionInput := &directconnect.DeleteDirectConnectConnectionInput{
		DirectConnectConnectionId: volcengine.String("dcc-3tehy13n2l4c6c0v****"),
	}

	resp, err := svc.DeleteDirectConnectConnection(deleteDirectConnectConnectionInput)
	if err != nil {
		panic(err)
	}
	fmt.Println(resp)
}
