<a href="https://pinniped.dev" target="_blank">
  <img src="site/content/docs/img/pinniped_logo.svg" alt="Pinniped Logo" width="100%"/>
</a>

## Overview

Pinniped provides identity services to Kubernetes.

- Easily plug in external identity providers into Kubernetes clusters while offering a simple install and configuration experience. Leverage first class integration with Kubernetes and kubectl command-line.
- Give users a consistent, unified login experience across all your clusters, including on-premises and managed cloud environments.
- Securely integrate with an enterprise IDP using standard protocols or use secure, externally managed identities instead of relying on simple, shared credentials.

To learn more, please visit the Pinniped project's website, https://pinniped.dev.

## Getting started with Pinniped

Care to kick the tires? It's easy to [install and try Pinniped](https://pinniped.dev/docs/).

## Discussion

Got a question, comment, or idea? Please don't hesitate to reach out
via GitHub [Discussions](https://github.com/vmware-tanzu/pinniped/discussions),
GitHub [Issues](https://github.com/vmware-tanzu/pinniped/issues),
or in the Kubernetes Slack Workspace within the [#pinniped channel](https://go.pinniped.dev/community/slack).
Join our [Google Group](https://go.pinniped.dev/community/group) to receive updates and meeting invitations.

## Contributions

Pinniped is better because of our contributors and [maintainers](MAINTAINERS.md). It is because of you that we can bring
great software to the community.

Want to get involved? Contributions are welcome.

Please see the [contributing guide](CONTRIBUTING.md) for more information about reporting bugs, requesting features,
building and testing the code, submitting PRs, and other contributor topics.

## Adopters

Some organizations and products using Pinniped are featured in [ADOPTERS.md](ADOPTERS.md).
Add your own organization or product [here](https://github.com/vmware-tanzu/pinniped/discussions/152).

## Reporting security vulnerabilities

Please follow the procedure described in [SECURITY.md](SECURITY.md).

## License

Pinniped is open source and licensed under Apache License Version 2.0. See [LICENSE](LICENSE).

Copyright 2020-2024 the Pinniped contributors. All Rights Reserved.
