// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package deadlineiface provides an interface to enable mocking the AWSDeadlineCloud service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package deadlineiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/deadline"
)

// DeadlineAPI provides an interface to enable mocking the
// deadline.Deadline service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// AWSDeadlineCloud.
//	func myFunc(svc deadlineiface.DeadlineAPI) bool {
//	    // Make svc.AssociateMemberToFarm request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := deadline.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockDeadlineClient struct {
//	    deadlineiface.DeadlineAPI
//	}
//	func (m *mockDeadlineClient) AssociateMemberToFarm(input *deadline.AssociateMemberToFarmInput) (*deadline.AssociateMemberToFarmOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockDeadlineClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type DeadlineAPI interface {
	AssociateMemberToFarm(*deadline.AssociateMemberToFarmInput) (*deadline.AssociateMemberToFarmOutput, error)
	AssociateMemberToFarmWithContext(aws.Context, *deadline.AssociateMemberToFarmInput, ...request.Option) (*deadline.AssociateMemberToFarmOutput, error)
	AssociateMemberToFarmRequest(*deadline.AssociateMemberToFarmInput) (*request.Request, *deadline.AssociateMemberToFarmOutput)

	AssociateMemberToFleet(*deadline.AssociateMemberToFleetInput) (*deadline.AssociateMemberToFleetOutput, error)
	AssociateMemberToFleetWithContext(aws.Context, *deadline.AssociateMemberToFleetInput, ...request.Option) (*deadline.AssociateMemberToFleetOutput, error)
	AssociateMemberToFleetRequest(*deadline.AssociateMemberToFleetInput) (*request.Request, *deadline.AssociateMemberToFleetOutput)

	AssociateMemberToJob(*deadline.AssociateMemberToJobInput) (*deadline.AssociateMemberToJobOutput, error)
	AssociateMemberToJobWithContext(aws.Context, *deadline.AssociateMemberToJobInput, ...request.Option) (*deadline.AssociateMemberToJobOutput, error)
	AssociateMemberToJobRequest(*deadline.AssociateMemberToJobInput) (*request.Request, *deadline.AssociateMemberToJobOutput)

	AssociateMemberToQueue(*deadline.AssociateMemberToQueueInput) (*deadline.AssociateMemberToQueueOutput, error)
	AssociateMemberToQueueWithContext(aws.Context, *deadline.AssociateMemberToQueueInput, ...request.Option) (*deadline.AssociateMemberToQueueOutput, error)
	AssociateMemberToQueueRequest(*deadline.AssociateMemberToQueueInput) (*request.Request, *deadline.AssociateMemberToQueueOutput)

	AssumeFleetRoleForRead(*deadline.AssumeFleetRoleForReadInput) (*deadline.AssumeFleetRoleForReadOutput, error)
	AssumeFleetRoleForReadWithContext(aws.Context, *deadline.AssumeFleetRoleForReadInput, ...request.Option) (*deadline.AssumeFleetRoleForReadOutput, error)
	AssumeFleetRoleForReadRequest(*deadline.AssumeFleetRoleForReadInput) (*request.Request, *deadline.AssumeFleetRoleForReadOutput)

	AssumeFleetRoleForWorker(*deadline.AssumeFleetRoleForWorkerInput) (*deadline.AssumeFleetRoleForWorkerOutput, error)
	AssumeFleetRoleForWorkerWithContext(aws.Context, *deadline.AssumeFleetRoleForWorkerInput, ...request.Option) (*deadline.AssumeFleetRoleForWorkerOutput, error)
	AssumeFleetRoleForWorkerRequest(*deadline.AssumeFleetRoleForWorkerInput) (*request.Request, *deadline.AssumeFleetRoleForWorkerOutput)

	AssumeQueueRoleForRead(*deadline.AssumeQueueRoleForReadInput) (*deadline.AssumeQueueRoleForReadOutput, error)
	AssumeQueueRoleForReadWithContext(aws.Context, *deadline.AssumeQueueRoleForReadInput, ...request.Option) (*deadline.AssumeQueueRoleForReadOutput, error)
	AssumeQueueRoleForReadRequest(*deadline.AssumeQueueRoleForReadInput) (*request.Request, *deadline.AssumeQueueRoleForReadOutput)

	AssumeQueueRoleForUser(*deadline.AssumeQueueRoleForUserInput) (*deadline.AssumeQueueRoleForUserOutput, error)
	AssumeQueueRoleForUserWithContext(aws.Context, *deadline.AssumeQueueRoleForUserInput, ...request.Option) (*deadline.AssumeQueueRoleForUserOutput, error)
	AssumeQueueRoleForUserRequest(*deadline.AssumeQueueRoleForUserInput) (*request.Request, *deadline.AssumeQueueRoleForUserOutput)

	AssumeQueueRoleForWorker(*deadline.AssumeQueueRoleForWorkerInput) (*deadline.AssumeQueueRoleForWorkerOutput, error)
	AssumeQueueRoleForWorkerWithContext(aws.Context, *deadline.AssumeQueueRoleForWorkerInput, ...request.Option) (*deadline.AssumeQueueRoleForWorkerOutput, error)
	AssumeQueueRoleForWorkerRequest(*deadline.AssumeQueueRoleForWorkerInput) (*request.Request, *deadline.AssumeQueueRoleForWorkerOutput)

	BatchGetJobEntity(*deadline.BatchGetJobEntityInput) (*deadline.BatchGetJobEntityOutput, error)
	BatchGetJobEntityWithContext(aws.Context, *deadline.BatchGetJobEntityInput, ...request.Option) (*deadline.BatchGetJobEntityOutput, error)
	BatchGetJobEntityRequest(*deadline.BatchGetJobEntityInput) (*request.Request, *deadline.BatchGetJobEntityOutput)

	CopyJobTemplate(*deadline.CopyJobTemplateInput) (*deadline.CopyJobTemplateOutput, error)
	CopyJobTemplateWithContext(aws.Context, *deadline.CopyJobTemplateInput, ...request.Option) (*deadline.CopyJobTemplateOutput, error)
	CopyJobTemplateRequest(*deadline.CopyJobTemplateInput) (*request.Request, *deadline.CopyJobTemplateOutput)

	CreateBudget(*deadline.CreateBudgetInput) (*deadline.CreateBudgetOutput, error)
	CreateBudgetWithContext(aws.Context, *deadline.CreateBudgetInput, ...request.Option) (*deadline.CreateBudgetOutput, error)
	CreateBudgetRequest(*deadline.CreateBudgetInput) (*request.Request, *deadline.CreateBudgetOutput)

	CreateFarm(*deadline.CreateFarmInput) (*deadline.CreateFarmOutput, error)
	CreateFarmWithContext(aws.Context, *deadline.CreateFarmInput, ...request.Option) (*deadline.CreateFarmOutput, error)
	CreateFarmRequest(*deadline.CreateFarmInput) (*request.Request, *deadline.CreateFarmOutput)

	CreateFleet(*deadline.CreateFleetInput) (*deadline.CreateFleetOutput, error)
	CreateFleetWithContext(aws.Context, *deadline.CreateFleetInput, ...request.Option) (*deadline.CreateFleetOutput, error)
	CreateFleetRequest(*deadline.CreateFleetInput) (*request.Request, *deadline.CreateFleetOutput)

	CreateJob(*deadline.CreateJobInput) (*deadline.CreateJobOutput, error)
	CreateJobWithContext(aws.Context, *deadline.CreateJobInput, ...request.Option) (*deadline.CreateJobOutput, error)
	CreateJobRequest(*deadline.CreateJobInput) (*request.Request, *deadline.CreateJobOutput)

	CreateLicenseEndpoint(*deadline.CreateLicenseEndpointInput) (*deadline.CreateLicenseEndpointOutput, error)
	CreateLicenseEndpointWithContext(aws.Context, *deadline.CreateLicenseEndpointInput, ...request.Option) (*deadline.CreateLicenseEndpointOutput, error)
	CreateLicenseEndpointRequest(*deadline.CreateLicenseEndpointInput) (*request.Request, *deadline.CreateLicenseEndpointOutput)

	CreateMonitor(*deadline.CreateMonitorInput) (*deadline.CreateMonitorOutput, error)
	CreateMonitorWithContext(aws.Context, *deadline.CreateMonitorInput, ...request.Option) (*deadline.CreateMonitorOutput, error)
	CreateMonitorRequest(*deadline.CreateMonitorInput) (*request.Request, *deadline.CreateMonitorOutput)

	CreateQueue(*deadline.CreateQueueInput) (*deadline.CreateQueueOutput, error)
	CreateQueueWithContext(aws.Context, *deadline.CreateQueueInput, ...request.Option) (*deadline.CreateQueueOutput, error)
	CreateQueueRequest(*deadline.CreateQueueInput) (*request.Request, *deadline.CreateQueueOutput)

	CreateQueueEnvironment(*deadline.CreateQueueEnvironmentInput) (*deadline.CreateQueueEnvironmentOutput, error)
	CreateQueueEnvironmentWithContext(aws.Context, *deadline.CreateQueueEnvironmentInput, ...request.Option) (*deadline.CreateQueueEnvironmentOutput, error)
	CreateQueueEnvironmentRequest(*deadline.CreateQueueEnvironmentInput) (*request.Request, *deadline.CreateQueueEnvironmentOutput)

	CreateQueueFleetAssociation(*deadline.CreateQueueFleetAssociationInput) (*deadline.CreateQueueFleetAssociationOutput, error)
	CreateQueueFleetAssociationWithContext(aws.Context, *deadline.CreateQueueFleetAssociationInput, ...request.Option) (*deadline.CreateQueueFleetAssociationOutput, error)
	CreateQueueFleetAssociationRequest(*deadline.CreateQueueFleetAssociationInput) (*request.Request, *deadline.CreateQueueFleetAssociationOutput)

	CreateStorageProfile(*deadline.CreateStorageProfileInput) (*deadline.CreateStorageProfileOutput, error)
	CreateStorageProfileWithContext(aws.Context, *deadline.CreateStorageProfileInput, ...request.Option) (*deadline.CreateStorageProfileOutput, error)
	CreateStorageProfileRequest(*deadline.CreateStorageProfileInput) (*request.Request, *deadline.CreateStorageProfileOutput)

	CreateWorker(*deadline.CreateWorkerInput) (*deadline.CreateWorkerOutput, error)
	CreateWorkerWithContext(aws.Context, *deadline.CreateWorkerInput, ...request.Option) (*deadline.CreateWorkerOutput, error)
	CreateWorkerRequest(*deadline.CreateWorkerInput) (*request.Request, *deadline.CreateWorkerOutput)

	DeleteBudget(*deadline.DeleteBudgetInput) (*deadline.DeleteBudgetOutput, error)
	DeleteBudgetWithContext(aws.Context, *deadline.DeleteBudgetInput, ...request.Option) (*deadline.DeleteBudgetOutput, error)
	DeleteBudgetRequest(*deadline.DeleteBudgetInput) (*request.Request, *deadline.DeleteBudgetOutput)

	DeleteFarm(*deadline.DeleteFarmInput) (*deadline.DeleteFarmOutput, error)
	DeleteFarmWithContext(aws.Context, *deadline.DeleteFarmInput, ...request.Option) (*deadline.DeleteFarmOutput, error)
	DeleteFarmRequest(*deadline.DeleteFarmInput) (*request.Request, *deadline.DeleteFarmOutput)

	DeleteFleet(*deadline.DeleteFleetInput) (*deadline.DeleteFleetOutput, error)
	DeleteFleetWithContext(aws.Context, *deadline.DeleteFleetInput, ...request.Option) (*deadline.DeleteFleetOutput, error)
	DeleteFleetRequest(*deadline.DeleteFleetInput) (*request.Request, *deadline.DeleteFleetOutput)

	DeleteLicenseEndpoint(*deadline.DeleteLicenseEndpointInput) (*deadline.DeleteLicenseEndpointOutput, error)
	DeleteLicenseEndpointWithContext(aws.Context, *deadline.DeleteLicenseEndpointInput, ...request.Option) (*deadline.DeleteLicenseEndpointOutput, error)
	DeleteLicenseEndpointRequest(*deadline.DeleteLicenseEndpointInput) (*request.Request, *deadline.DeleteLicenseEndpointOutput)

	DeleteMeteredProduct(*deadline.DeleteMeteredProductInput) (*deadline.DeleteMeteredProductOutput, error)
	DeleteMeteredProductWithContext(aws.Context, *deadline.DeleteMeteredProductInput, ...request.Option) (*deadline.DeleteMeteredProductOutput, error)
	DeleteMeteredProductRequest(*deadline.DeleteMeteredProductInput) (*request.Request, *deadline.DeleteMeteredProductOutput)

	DeleteMonitor(*deadline.DeleteMonitorInput) (*deadline.DeleteMonitorOutput, error)
	DeleteMonitorWithContext(aws.Context, *deadline.DeleteMonitorInput, ...request.Option) (*deadline.DeleteMonitorOutput, error)
	DeleteMonitorRequest(*deadline.DeleteMonitorInput) (*request.Request, *deadline.DeleteMonitorOutput)

	DeleteQueue(*deadline.DeleteQueueInput) (*deadline.DeleteQueueOutput, error)
	DeleteQueueWithContext(aws.Context, *deadline.DeleteQueueInput, ...request.Option) (*deadline.DeleteQueueOutput, error)
	DeleteQueueRequest(*deadline.DeleteQueueInput) (*request.Request, *deadline.DeleteQueueOutput)

	DeleteQueueEnvironment(*deadline.DeleteQueueEnvironmentInput) (*deadline.DeleteQueueEnvironmentOutput, error)
	DeleteQueueEnvironmentWithContext(aws.Context, *deadline.DeleteQueueEnvironmentInput, ...request.Option) (*deadline.DeleteQueueEnvironmentOutput, error)
	DeleteQueueEnvironmentRequest(*deadline.DeleteQueueEnvironmentInput) (*request.Request, *deadline.DeleteQueueEnvironmentOutput)

	DeleteQueueFleetAssociation(*deadline.DeleteQueueFleetAssociationInput) (*deadline.DeleteQueueFleetAssociationOutput, error)
	DeleteQueueFleetAssociationWithContext(aws.Context, *deadline.DeleteQueueFleetAssociationInput, ...request.Option) (*deadline.DeleteQueueFleetAssociationOutput, error)
	DeleteQueueFleetAssociationRequest(*deadline.DeleteQueueFleetAssociationInput) (*request.Request, *deadline.DeleteQueueFleetAssociationOutput)

	DeleteStorageProfile(*deadline.DeleteStorageProfileInput) (*deadline.DeleteStorageProfileOutput, error)
	DeleteStorageProfileWithContext(aws.Context, *deadline.DeleteStorageProfileInput, ...request.Option) (*deadline.DeleteStorageProfileOutput, error)
	DeleteStorageProfileRequest(*deadline.DeleteStorageProfileInput) (*request.Request, *deadline.DeleteStorageProfileOutput)

	DeleteWorker(*deadline.DeleteWorkerInput) (*deadline.DeleteWorkerOutput, error)
	DeleteWorkerWithContext(aws.Context, *deadline.DeleteWorkerInput, ...request.Option) (*deadline.DeleteWorkerOutput, error)
	DeleteWorkerRequest(*deadline.DeleteWorkerInput) (*request.Request, *deadline.DeleteWorkerOutput)

	DisassociateMemberFromFarm(*deadline.DisassociateMemberFromFarmInput) (*deadline.DisassociateMemberFromFarmOutput, error)
	DisassociateMemberFromFarmWithContext(aws.Context, *deadline.DisassociateMemberFromFarmInput, ...request.Option) (*deadline.DisassociateMemberFromFarmOutput, error)
	DisassociateMemberFromFarmRequest(*deadline.DisassociateMemberFromFarmInput) (*request.Request, *deadline.DisassociateMemberFromFarmOutput)

	DisassociateMemberFromFleet(*deadline.DisassociateMemberFromFleetInput) (*deadline.DisassociateMemberFromFleetOutput, error)
	DisassociateMemberFromFleetWithContext(aws.Context, *deadline.DisassociateMemberFromFleetInput, ...request.Option) (*deadline.DisassociateMemberFromFleetOutput, error)
	DisassociateMemberFromFleetRequest(*deadline.DisassociateMemberFromFleetInput) (*request.Request, *deadline.DisassociateMemberFromFleetOutput)

	DisassociateMemberFromJob(*deadline.DisassociateMemberFromJobInput) (*deadline.DisassociateMemberFromJobOutput, error)
	DisassociateMemberFromJobWithContext(aws.Context, *deadline.DisassociateMemberFromJobInput, ...request.Option) (*deadline.DisassociateMemberFromJobOutput, error)
	DisassociateMemberFromJobRequest(*deadline.DisassociateMemberFromJobInput) (*request.Request, *deadline.DisassociateMemberFromJobOutput)

	DisassociateMemberFromQueue(*deadline.DisassociateMemberFromQueueInput) (*deadline.DisassociateMemberFromQueueOutput, error)
	DisassociateMemberFromQueueWithContext(aws.Context, *deadline.DisassociateMemberFromQueueInput, ...request.Option) (*deadline.DisassociateMemberFromQueueOutput, error)
	DisassociateMemberFromQueueRequest(*deadline.DisassociateMemberFromQueueInput) (*request.Request, *deadline.DisassociateMemberFromQueueOutput)

	GetBudget(*deadline.GetBudgetInput) (*deadline.GetBudgetOutput, error)
	GetBudgetWithContext(aws.Context, *deadline.GetBudgetInput, ...request.Option) (*deadline.GetBudgetOutput, error)
	GetBudgetRequest(*deadline.GetBudgetInput) (*request.Request, *deadline.GetBudgetOutput)

	GetFarm(*deadline.GetFarmInput) (*deadline.GetFarmOutput, error)
	GetFarmWithContext(aws.Context, *deadline.GetFarmInput, ...request.Option) (*deadline.GetFarmOutput, error)
	GetFarmRequest(*deadline.GetFarmInput) (*request.Request, *deadline.GetFarmOutput)

	GetFleet(*deadline.GetFleetInput) (*deadline.GetFleetOutput, error)
	GetFleetWithContext(aws.Context, *deadline.GetFleetInput, ...request.Option) (*deadline.GetFleetOutput, error)
	GetFleetRequest(*deadline.GetFleetInput) (*request.Request, *deadline.GetFleetOutput)

	GetJob(*deadline.GetJobInput) (*deadline.GetJobOutput, error)
	GetJobWithContext(aws.Context, *deadline.GetJobInput, ...request.Option) (*deadline.GetJobOutput, error)
	GetJobRequest(*deadline.GetJobInput) (*request.Request, *deadline.GetJobOutput)

	GetLicenseEndpoint(*deadline.GetLicenseEndpointInput) (*deadline.GetLicenseEndpointOutput, error)
	GetLicenseEndpointWithContext(aws.Context, *deadline.GetLicenseEndpointInput, ...request.Option) (*deadline.GetLicenseEndpointOutput, error)
	GetLicenseEndpointRequest(*deadline.GetLicenseEndpointInput) (*request.Request, *deadline.GetLicenseEndpointOutput)

	GetMonitor(*deadline.GetMonitorInput) (*deadline.GetMonitorOutput, error)
	GetMonitorWithContext(aws.Context, *deadline.GetMonitorInput, ...request.Option) (*deadline.GetMonitorOutput, error)
	GetMonitorRequest(*deadline.GetMonitorInput) (*request.Request, *deadline.GetMonitorOutput)

	GetQueue(*deadline.GetQueueInput) (*deadline.GetQueueOutput, error)
	GetQueueWithContext(aws.Context, *deadline.GetQueueInput, ...request.Option) (*deadline.GetQueueOutput, error)
	GetQueueRequest(*deadline.GetQueueInput) (*request.Request, *deadline.GetQueueOutput)

	GetQueueEnvironment(*deadline.GetQueueEnvironmentInput) (*deadline.GetQueueEnvironmentOutput, error)
	GetQueueEnvironmentWithContext(aws.Context, *deadline.GetQueueEnvironmentInput, ...request.Option) (*deadline.GetQueueEnvironmentOutput, error)
	GetQueueEnvironmentRequest(*deadline.GetQueueEnvironmentInput) (*request.Request, *deadline.GetQueueEnvironmentOutput)

	GetQueueFleetAssociation(*deadline.GetQueueFleetAssociationInput) (*deadline.GetQueueFleetAssociationOutput, error)
	GetQueueFleetAssociationWithContext(aws.Context, *deadline.GetQueueFleetAssociationInput, ...request.Option) (*deadline.GetQueueFleetAssociationOutput, error)
	GetQueueFleetAssociationRequest(*deadline.GetQueueFleetAssociationInput) (*request.Request, *deadline.GetQueueFleetAssociationOutput)

	GetSession(*deadline.GetSessionInput) (*deadline.GetSessionOutput, error)
	GetSessionWithContext(aws.Context, *deadline.GetSessionInput, ...request.Option) (*deadline.GetSessionOutput, error)
	GetSessionRequest(*deadline.GetSessionInput) (*request.Request, *deadline.GetSessionOutput)

	GetSessionAction(*deadline.GetSessionActionInput) (*deadline.GetSessionActionOutput, error)
	GetSessionActionWithContext(aws.Context, *deadline.GetSessionActionInput, ...request.Option) (*deadline.GetSessionActionOutput, error)
	GetSessionActionRequest(*deadline.GetSessionActionInput) (*request.Request, *deadline.GetSessionActionOutput)

	GetSessionsStatisticsAggregation(*deadline.GetSessionsStatisticsAggregationInput) (*deadline.GetSessionsStatisticsAggregationOutput, error)
	GetSessionsStatisticsAggregationWithContext(aws.Context, *deadline.GetSessionsStatisticsAggregationInput, ...request.Option) (*deadline.GetSessionsStatisticsAggregationOutput, error)
	GetSessionsStatisticsAggregationRequest(*deadline.GetSessionsStatisticsAggregationInput) (*request.Request, *deadline.GetSessionsStatisticsAggregationOutput)

	GetSessionsStatisticsAggregationPages(*deadline.GetSessionsStatisticsAggregationInput, func(*deadline.GetSessionsStatisticsAggregationOutput, bool) bool) error
	GetSessionsStatisticsAggregationPagesWithContext(aws.Context, *deadline.GetSessionsStatisticsAggregationInput, func(*deadline.GetSessionsStatisticsAggregationOutput, bool) bool, ...request.Option) error

	GetStep(*deadline.GetStepInput) (*deadline.GetStepOutput, error)
	GetStepWithContext(aws.Context, *deadline.GetStepInput, ...request.Option) (*deadline.GetStepOutput, error)
	GetStepRequest(*deadline.GetStepInput) (*request.Request, *deadline.GetStepOutput)

	GetStorageProfile(*deadline.GetStorageProfileInput) (*deadline.GetStorageProfileOutput, error)
	GetStorageProfileWithContext(aws.Context, *deadline.GetStorageProfileInput, ...request.Option) (*deadline.GetStorageProfileOutput, error)
	GetStorageProfileRequest(*deadline.GetStorageProfileInput) (*request.Request, *deadline.GetStorageProfileOutput)

	GetStorageProfileForQueue(*deadline.GetStorageProfileForQueueInput) (*deadline.GetStorageProfileForQueueOutput, error)
	GetStorageProfileForQueueWithContext(aws.Context, *deadline.GetStorageProfileForQueueInput, ...request.Option) (*deadline.GetStorageProfileForQueueOutput, error)
	GetStorageProfileForQueueRequest(*deadline.GetStorageProfileForQueueInput) (*request.Request, *deadline.GetStorageProfileForQueueOutput)

	GetTask(*deadline.GetTaskInput) (*deadline.GetTaskOutput, error)
	GetTaskWithContext(aws.Context, *deadline.GetTaskInput, ...request.Option) (*deadline.GetTaskOutput, error)
	GetTaskRequest(*deadline.GetTaskInput) (*request.Request, *deadline.GetTaskOutput)

	GetWorker(*deadline.GetWorkerInput) (*deadline.GetWorkerOutput, error)
	GetWorkerWithContext(aws.Context, *deadline.GetWorkerInput, ...request.Option) (*deadline.GetWorkerOutput, error)
	GetWorkerRequest(*deadline.GetWorkerInput) (*request.Request, *deadline.GetWorkerOutput)

	ListAvailableMeteredProducts(*deadline.ListAvailableMeteredProductsInput) (*deadline.ListAvailableMeteredProductsOutput, error)
	ListAvailableMeteredProductsWithContext(aws.Context, *deadline.ListAvailableMeteredProductsInput, ...request.Option) (*deadline.ListAvailableMeteredProductsOutput, error)
	ListAvailableMeteredProductsRequest(*deadline.ListAvailableMeteredProductsInput) (*request.Request, *deadline.ListAvailableMeteredProductsOutput)

	ListAvailableMeteredProductsPages(*deadline.ListAvailableMeteredProductsInput, func(*deadline.ListAvailableMeteredProductsOutput, bool) bool) error
	ListAvailableMeteredProductsPagesWithContext(aws.Context, *deadline.ListAvailableMeteredProductsInput, func(*deadline.ListAvailableMeteredProductsOutput, bool) bool, ...request.Option) error

	ListBudgets(*deadline.ListBudgetsInput) (*deadline.ListBudgetsOutput, error)
	ListBudgetsWithContext(aws.Context, *deadline.ListBudgetsInput, ...request.Option) (*deadline.ListBudgetsOutput, error)
	ListBudgetsRequest(*deadline.ListBudgetsInput) (*request.Request, *deadline.ListBudgetsOutput)

	ListBudgetsPages(*deadline.ListBudgetsInput, func(*deadline.ListBudgetsOutput, bool) bool) error
	ListBudgetsPagesWithContext(aws.Context, *deadline.ListBudgetsInput, func(*deadline.ListBudgetsOutput, bool) bool, ...request.Option) error

	ListFarmMembers(*deadline.ListFarmMembersInput) (*deadline.ListFarmMembersOutput, error)
	ListFarmMembersWithContext(aws.Context, *deadline.ListFarmMembersInput, ...request.Option) (*deadline.ListFarmMembersOutput, error)
	ListFarmMembersRequest(*deadline.ListFarmMembersInput) (*request.Request, *deadline.ListFarmMembersOutput)

	ListFarmMembersPages(*deadline.ListFarmMembersInput, func(*deadline.ListFarmMembersOutput, bool) bool) error
	ListFarmMembersPagesWithContext(aws.Context, *deadline.ListFarmMembersInput, func(*deadline.ListFarmMembersOutput, bool) bool, ...request.Option) error

	ListFarms(*deadline.ListFarmsInput) (*deadline.ListFarmsOutput, error)
	ListFarmsWithContext(aws.Context, *deadline.ListFarmsInput, ...request.Option) (*deadline.ListFarmsOutput, error)
	ListFarmsRequest(*deadline.ListFarmsInput) (*request.Request, *deadline.ListFarmsOutput)

	ListFarmsPages(*deadline.ListFarmsInput, func(*deadline.ListFarmsOutput, bool) bool) error
	ListFarmsPagesWithContext(aws.Context, *deadline.ListFarmsInput, func(*deadline.ListFarmsOutput, bool) bool, ...request.Option) error

	ListFleetMembers(*deadline.ListFleetMembersInput) (*deadline.ListFleetMembersOutput, error)
	ListFleetMembersWithContext(aws.Context, *deadline.ListFleetMembersInput, ...request.Option) (*deadline.ListFleetMembersOutput, error)
	ListFleetMembersRequest(*deadline.ListFleetMembersInput) (*request.Request, *deadline.ListFleetMembersOutput)

	ListFleetMembersPages(*deadline.ListFleetMembersInput, func(*deadline.ListFleetMembersOutput, bool) bool) error
	ListFleetMembersPagesWithContext(aws.Context, *deadline.ListFleetMembersInput, func(*deadline.ListFleetMembersOutput, bool) bool, ...request.Option) error

	ListFleets(*deadline.ListFleetsInput) (*deadline.ListFleetsOutput, error)
	ListFleetsWithContext(aws.Context, *deadline.ListFleetsInput, ...request.Option) (*deadline.ListFleetsOutput, error)
	ListFleetsRequest(*deadline.ListFleetsInput) (*request.Request, *deadline.ListFleetsOutput)

	ListFleetsPages(*deadline.ListFleetsInput, func(*deadline.ListFleetsOutput, bool) bool) error
	ListFleetsPagesWithContext(aws.Context, *deadline.ListFleetsInput, func(*deadline.ListFleetsOutput, bool) bool, ...request.Option) error

	ListJobMembers(*deadline.ListJobMembersInput) (*deadline.ListJobMembersOutput, error)
	ListJobMembersWithContext(aws.Context, *deadline.ListJobMembersInput, ...request.Option) (*deadline.ListJobMembersOutput, error)
	ListJobMembersRequest(*deadline.ListJobMembersInput) (*request.Request, *deadline.ListJobMembersOutput)

	ListJobMembersPages(*deadline.ListJobMembersInput, func(*deadline.ListJobMembersOutput, bool) bool) error
	ListJobMembersPagesWithContext(aws.Context, *deadline.ListJobMembersInput, func(*deadline.ListJobMembersOutput, bool) bool, ...request.Option) error

	ListJobs(*deadline.ListJobsInput) (*deadline.ListJobsOutput, error)
	ListJobsWithContext(aws.Context, *deadline.ListJobsInput, ...request.Option) (*deadline.ListJobsOutput, error)
	ListJobsRequest(*deadline.ListJobsInput) (*request.Request, *deadline.ListJobsOutput)

	ListJobsPages(*deadline.ListJobsInput, func(*deadline.ListJobsOutput, bool) bool) error
	ListJobsPagesWithContext(aws.Context, *deadline.ListJobsInput, func(*deadline.ListJobsOutput, bool) bool, ...request.Option) error

	ListLicenseEndpoints(*deadline.ListLicenseEndpointsInput) (*deadline.ListLicenseEndpointsOutput, error)
	ListLicenseEndpointsWithContext(aws.Context, *deadline.ListLicenseEndpointsInput, ...request.Option) (*deadline.ListLicenseEndpointsOutput, error)
	ListLicenseEndpointsRequest(*deadline.ListLicenseEndpointsInput) (*request.Request, *deadline.ListLicenseEndpointsOutput)

	ListLicenseEndpointsPages(*deadline.ListLicenseEndpointsInput, func(*deadline.ListLicenseEndpointsOutput, bool) bool) error
	ListLicenseEndpointsPagesWithContext(aws.Context, *deadline.ListLicenseEndpointsInput, func(*deadline.ListLicenseEndpointsOutput, bool) bool, ...request.Option) error

	ListMeteredProducts(*deadline.ListMeteredProductsInput) (*deadline.ListMeteredProductsOutput, error)
	ListMeteredProductsWithContext(aws.Context, *deadline.ListMeteredProductsInput, ...request.Option) (*deadline.ListMeteredProductsOutput, error)
	ListMeteredProductsRequest(*deadline.ListMeteredProductsInput) (*request.Request, *deadline.ListMeteredProductsOutput)

	ListMeteredProductsPages(*deadline.ListMeteredProductsInput, func(*deadline.ListMeteredProductsOutput, bool) bool) error
	ListMeteredProductsPagesWithContext(aws.Context, *deadline.ListMeteredProductsInput, func(*deadline.ListMeteredProductsOutput, bool) bool, ...request.Option) error

	ListMonitors(*deadline.ListMonitorsInput) (*deadline.ListMonitorsOutput, error)
	ListMonitorsWithContext(aws.Context, *deadline.ListMonitorsInput, ...request.Option) (*deadline.ListMonitorsOutput, error)
	ListMonitorsRequest(*deadline.ListMonitorsInput) (*request.Request, *deadline.ListMonitorsOutput)

	ListMonitorsPages(*deadline.ListMonitorsInput, func(*deadline.ListMonitorsOutput, bool) bool) error
	ListMonitorsPagesWithContext(aws.Context, *deadline.ListMonitorsInput, func(*deadline.ListMonitorsOutput, bool) bool, ...request.Option) error

	ListQueueEnvironments(*deadline.ListQueueEnvironmentsInput) (*deadline.ListQueueEnvironmentsOutput, error)
	ListQueueEnvironmentsWithContext(aws.Context, *deadline.ListQueueEnvironmentsInput, ...request.Option) (*deadline.ListQueueEnvironmentsOutput, error)
	ListQueueEnvironmentsRequest(*deadline.ListQueueEnvironmentsInput) (*request.Request, *deadline.ListQueueEnvironmentsOutput)

	ListQueueEnvironmentsPages(*deadline.ListQueueEnvironmentsInput, func(*deadline.ListQueueEnvironmentsOutput, bool) bool) error
	ListQueueEnvironmentsPagesWithContext(aws.Context, *deadline.ListQueueEnvironmentsInput, func(*deadline.ListQueueEnvironmentsOutput, bool) bool, ...request.Option) error

	ListQueueFleetAssociations(*deadline.ListQueueFleetAssociationsInput) (*deadline.ListQueueFleetAssociationsOutput, error)
	ListQueueFleetAssociationsWithContext(aws.Context, *deadline.ListQueueFleetAssociationsInput, ...request.Option) (*deadline.ListQueueFleetAssociationsOutput, error)
	ListQueueFleetAssociationsRequest(*deadline.ListQueueFleetAssociationsInput) (*request.Request, *deadline.ListQueueFleetAssociationsOutput)

	ListQueueFleetAssociationsPages(*deadline.ListQueueFleetAssociationsInput, func(*deadline.ListQueueFleetAssociationsOutput, bool) bool) error
	ListQueueFleetAssociationsPagesWithContext(aws.Context, *deadline.ListQueueFleetAssociationsInput, func(*deadline.ListQueueFleetAssociationsOutput, bool) bool, ...request.Option) error

	ListQueueMembers(*deadline.ListQueueMembersInput) (*deadline.ListQueueMembersOutput, error)
	ListQueueMembersWithContext(aws.Context, *deadline.ListQueueMembersInput, ...request.Option) (*deadline.ListQueueMembersOutput, error)
	ListQueueMembersRequest(*deadline.ListQueueMembersInput) (*request.Request, *deadline.ListQueueMembersOutput)

	ListQueueMembersPages(*deadline.ListQueueMembersInput, func(*deadline.ListQueueMembersOutput, bool) bool) error
	ListQueueMembersPagesWithContext(aws.Context, *deadline.ListQueueMembersInput, func(*deadline.ListQueueMembersOutput, bool) bool, ...request.Option) error

	ListQueues(*deadline.ListQueuesInput) (*deadline.ListQueuesOutput, error)
	ListQueuesWithContext(aws.Context, *deadline.ListQueuesInput, ...request.Option) (*deadline.ListQueuesOutput, error)
	ListQueuesRequest(*deadline.ListQueuesInput) (*request.Request, *deadline.ListQueuesOutput)

	ListQueuesPages(*deadline.ListQueuesInput, func(*deadline.ListQueuesOutput, bool) bool) error
	ListQueuesPagesWithContext(aws.Context, *deadline.ListQueuesInput, func(*deadline.ListQueuesOutput, bool) bool, ...request.Option) error

	ListSessionActions(*deadline.ListSessionActionsInput) (*deadline.ListSessionActionsOutput, error)
	ListSessionActionsWithContext(aws.Context, *deadline.ListSessionActionsInput, ...request.Option) (*deadline.ListSessionActionsOutput, error)
	ListSessionActionsRequest(*deadline.ListSessionActionsInput) (*request.Request, *deadline.ListSessionActionsOutput)

	ListSessionActionsPages(*deadline.ListSessionActionsInput, func(*deadline.ListSessionActionsOutput, bool) bool) error
	ListSessionActionsPagesWithContext(aws.Context, *deadline.ListSessionActionsInput, func(*deadline.ListSessionActionsOutput, bool) bool, ...request.Option) error

	ListSessions(*deadline.ListSessionsInput) (*deadline.ListSessionsOutput, error)
	ListSessionsWithContext(aws.Context, *deadline.ListSessionsInput, ...request.Option) (*deadline.ListSessionsOutput, error)
	ListSessionsRequest(*deadline.ListSessionsInput) (*request.Request, *deadline.ListSessionsOutput)

	ListSessionsPages(*deadline.ListSessionsInput, func(*deadline.ListSessionsOutput, bool) bool) error
	ListSessionsPagesWithContext(aws.Context, *deadline.ListSessionsInput, func(*deadline.ListSessionsOutput, bool) bool, ...request.Option) error

	ListSessionsForWorker(*deadline.ListSessionsForWorkerInput) (*deadline.ListSessionsForWorkerOutput, error)
	ListSessionsForWorkerWithContext(aws.Context, *deadline.ListSessionsForWorkerInput, ...request.Option) (*deadline.ListSessionsForWorkerOutput, error)
	ListSessionsForWorkerRequest(*deadline.ListSessionsForWorkerInput) (*request.Request, *deadline.ListSessionsForWorkerOutput)

	ListSessionsForWorkerPages(*deadline.ListSessionsForWorkerInput, func(*deadline.ListSessionsForWorkerOutput, bool) bool) error
	ListSessionsForWorkerPagesWithContext(aws.Context, *deadline.ListSessionsForWorkerInput, func(*deadline.ListSessionsForWorkerOutput, bool) bool, ...request.Option) error

	ListStepConsumers(*deadline.ListStepConsumersInput) (*deadline.ListStepConsumersOutput, error)
	ListStepConsumersWithContext(aws.Context, *deadline.ListStepConsumersInput, ...request.Option) (*deadline.ListStepConsumersOutput, error)
	ListStepConsumersRequest(*deadline.ListStepConsumersInput) (*request.Request, *deadline.ListStepConsumersOutput)

	ListStepConsumersPages(*deadline.ListStepConsumersInput, func(*deadline.ListStepConsumersOutput, bool) bool) error
	ListStepConsumersPagesWithContext(aws.Context, *deadline.ListStepConsumersInput, func(*deadline.ListStepConsumersOutput, bool) bool, ...request.Option) error

	ListStepDependencies(*deadline.ListStepDependenciesInput) (*deadline.ListStepDependenciesOutput, error)
	ListStepDependenciesWithContext(aws.Context, *deadline.ListStepDependenciesInput, ...request.Option) (*deadline.ListStepDependenciesOutput, error)
	ListStepDependenciesRequest(*deadline.ListStepDependenciesInput) (*request.Request, *deadline.ListStepDependenciesOutput)

	ListStepDependenciesPages(*deadline.ListStepDependenciesInput, func(*deadline.ListStepDependenciesOutput, bool) bool) error
	ListStepDependenciesPagesWithContext(aws.Context, *deadline.ListStepDependenciesInput, func(*deadline.ListStepDependenciesOutput, bool) bool, ...request.Option) error

	ListSteps(*deadline.ListStepsInput) (*deadline.ListStepsOutput, error)
	ListStepsWithContext(aws.Context, *deadline.ListStepsInput, ...request.Option) (*deadline.ListStepsOutput, error)
	ListStepsRequest(*deadline.ListStepsInput) (*request.Request, *deadline.ListStepsOutput)

	ListStepsPages(*deadline.ListStepsInput, func(*deadline.ListStepsOutput, bool) bool) error
	ListStepsPagesWithContext(aws.Context, *deadline.ListStepsInput, func(*deadline.ListStepsOutput, bool) bool, ...request.Option) error

	ListStorageProfiles(*deadline.ListStorageProfilesInput) (*deadline.ListStorageProfilesOutput, error)
	ListStorageProfilesWithContext(aws.Context, *deadline.ListStorageProfilesInput, ...request.Option) (*deadline.ListStorageProfilesOutput, error)
	ListStorageProfilesRequest(*deadline.ListStorageProfilesInput) (*request.Request, *deadline.ListStorageProfilesOutput)

	ListStorageProfilesPages(*deadline.ListStorageProfilesInput, func(*deadline.ListStorageProfilesOutput, bool) bool) error
	ListStorageProfilesPagesWithContext(aws.Context, *deadline.ListStorageProfilesInput, func(*deadline.ListStorageProfilesOutput, bool) bool, ...request.Option) error

	ListStorageProfilesForQueue(*deadline.ListStorageProfilesForQueueInput) (*deadline.ListStorageProfilesForQueueOutput, error)
	ListStorageProfilesForQueueWithContext(aws.Context, *deadline.ListStorageProfilesForQueueInput, ...request.Option) (*deadline.ListStorageProfilesForQueueOutput, error)
	ListStorageProfilesForQueueRequest(*deadline.ListStorageProfilesForQueueInput) (*request.Request, *deadline.ListStorageProfilesForQueueOutput)

	ListStorageProfilesForQueuePages(*deadline.ListStorageProfilesForQueueInput, func(*deadline.ListStorageProfilesForQueueOutput, bool) bool) error
	ListStorageProfilesForQueuePagesWithContext(aws.Context, *deadline.ListStorageProfilesForQueueInput, func(*deadline.ListStorageProfilesForQueueOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*deadline.ListTagsForResourceInput) (*deadline.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *deadline.ListTagsForResourceInput, ...request.Option) (*deadline.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*deadline.ListTagsForResourceInput) (*request.Request, *deadline.ListTagsForResourceOutput)

	ListTasks(*deadline.ListTasksInput) (*deadline.ListTasksOutput, error)
	ListTasksWithContext(aws.Context, *deadline.ListTasksInput, ...request.Option) (*deadline.ListTasksOutput, error)
	ListTasksRequest(*deadline.ListTasksInput) (*request.Request, *deadline.ListTasksOutput)

	ListTasksPages(*deadline.ListTasksInput, func(*deadline.ListTasksOutput, bool) bool) error
	ListTasksPagesWithContext(aws.Context, *deadline.ListTasksInput, func(*deadline.ListTasksOutput, bool) bool, ...request.Option) error

	ListWorkers(*deadline.ListWorkersInput) (*deadline.ListWorkersOutput, error)
	ListWorkersWithContext(aws.Context, *deadline.ListWorkersInput, ...request.Option) (*deadline.ListWorkersOutput, error)
	ListWorkersRequest(*deadline.ListWorkersInput) (*request.Request, *deadline.ListWorkersOutput)

	ListWorkersPages(*deadline.ListWorkersInput, func(*deadline.ListWorkersOutput, bool) bool) error
	ListWorkersPagesWithContext(aws.Context, *deadline.ListWorkersInput, func(*deadline.ListWorkersOutput, bool) bool, ...request.Option) error

	PutMeteredProduct(*deadline.PutMeteredProductInput) (*deadline.PutMeteredProductOutput, error)
	PutMeteredProductWithContext(aws.Context, *deadline.PutMeteredProductInput, ...request.Option) (*deadline.PutMeteredProductOutput, error)
	PutMeteredProductRequest(*deadline.PutMeteredProductInput) (*request.Request, *deadline.PutMeteredProductOutput)

	SearchJobs(*deadline.SearchJobsInput) (*deadline.SearchJobsOutput, error)
	SearchJobsWithContext(aws.Context, *deadline.SearchJobsInput, ...request.Option) (*deadline.SearchJobsOutput, error)
	SearchJobsRequest(*deadline.SearchJobsInput) (*request.Request, *deadline.SearchJobsOutput)

	SearchSteps(*deadline.SearchStepsInput) (*deadline.SearchStepsOutput, error)
	SearchStepsWithContext(aws.Context, *deadline.SearchStepsInput, ...request.Option) (*deadline.SearchStepsOutput, error)
	SearchStepsRequest(*deadline.SearchStepsInput) (*request.Request, *deadline.SearchStepsOutput)

	SearchTasks(*deadline.SearchTasksInput) (*deadline.SearchTasksOutput, error)
	SearchTasksWithContext(aws.Context, *deadline.SearchTasksInput, ...request.Option) (*deadline.SearchTasksOutput, error)
	SearchTasksRequest(*deadline.SearchTasksInput) (*request.Request, *deadline.SearchTasksOutput)

	SearchWorkers(*deadline.SearchWorkersInput) (*deadline.SearchWorkersOutput, error)
	SearchWorkersWithContext(aws.Context, *deadline.SearchWorkersInput, ...request.Option) (*deadline.SearchWorkersOutput, error)
	SearchWorkersRequest(*deadline.SearchWorkersInput) (*request.Request, *deadline.SearchWorkersOutput)

	StartSessionsStatisticsAggregation(*deadline.StartSessionsStatisticsAggregationInput) (*deadline.StartSessionsStatisticsAggregationOutput, error)
	StartSessionsStatisticsAggregationWithContext(aws.Context, *deadline.StartSessionsStatisticsAggregationInput, ...request.Option) (*deadline.StartSessionsStatisticsAggregationOutput, error)
	StartSessionsStatisticsAggregationRequest(*deadline.StartSessionsStatisticsAggregationInput) (*request.Request, *deadline.StartSessionsStatisticsAggregationOutput)

	TagResource(*deadline.TagResourceInput) (*deadline.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *deadline.TagResourceInput, ...request.Option) (*deadline.TagResourceOutput, error)
	TagResourceRequest(*deadline.TagResourceInput) (*request.Request, *deadline.TagResourceOutput)

	UntagResource(*deadline.UntagResourceInput) (*deadline.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *deadline.UntagResourceInput, ...request.Option) (*deadline.UntagResourceOutput, error)
	UntagResourceRequest(*deadline.UntagResourceInput) (*request.Request, *deadline.UntagResourceOutput)

	UpdateBudget(*deadline.UpdateBudgetInput) (*deadline.UpdateBudgetOutput, error)
	UpdateBudgetWithContext(aws.Context, *deadline.UpdateBudgetInput, ...request.Option) (*deadline.UpdateBudgetOutput, error)
	UpdateBudgetRequest(*deadline.UpdateBudgetInput) (*request.Request, *deadline.UpdateBudgetOutput)

	UpdateFarm(*deadline.UpdateFarmInput) (*deadline.UpdateFarmOutput, error)
	UpdateFarmWithContext(aws.Context, *deadline.UpdateFarmInput, ...request.Option) (*deadline.UpdateFarmOutput, error)
	UpdateFarmRequest(*deadline.UpdateFarmInput) (*request.Request, *deadline.UpdateFarmOutput)

	UpdateFleet(*deadline.UpdateFleetInput) (*deadline.UpdateFleetOutput, error)
	UpdateFleetWithContext(aws.Context, *deadline.UpdateFleetInput, ...request.Option) (*deadline.UpdateFleetOutput, error)
	UpdateFleetRequest(*deadline.UpdateFleetInput) (*request.Request, *deadline.UpdateFleetOutput)

	UpdateJob(*deadline.UpdateJobInput) (*deadline.UpdateJobOutput, error)
	UpdateJobWithContext(aws.Context, *deadline.UpdateJobInput, ...request.Option) (*deadline.UpdateJobOutput, error)
	UpdateJobRequest(*deadline.UpdateJobInput) (*request.Request, *deadline.UpdateJobOutput)

	UpdateMonitor(*deadline.UpdateMonitorInput) (*deadline.UpdateMonitorOutput, error)
	UpdateMonitorWithContext(aws.Context, *deadline.UpdateMonitorInput, ...request.Option) (*deadline.UpdateMonitorOutput, error)
	UpdateMonitorRequest(*deadline.UpdateMonitorInput) (*request.Request, *deadline.UpdateMonitorOutput)

	UpdateQueue(*deadline.UpdateQueueInput) (*deadline.UpdateQueueOutput, error)
	UpdateQueueWithContext(aws.Context, *deadline.UpdateQueueInput, ...request.Option) (*deadline.UpdateQueueOutput, error)
	UpdateQueueRequest(*deadline.UpdateQueueInput) (*request.Request, *deadline.UpdateQueueOutput)

	UpdateQueueEnvironment(*deadline.UpdateQueueEnvironmentInput) (*deadline.UpdateQueueEnvironmentOutput, error)
	UpdateQueueEnvironmentWithContext(aws.Context, *deadline.UpdateQueueEnvironmentInput, ...request.Option) (*deadline.UpdateQueueEnvironmentOutput, error)
	UpdateQueueEnvironmentRequest(*deadline.UpdateQueueEnvironmentInput) (*request.Request, *deadline.UpdateQueueEnvironmentOutput)

	UpdateQueueFleetAssociation(*deadline.UpdateQueueFleetAssociationInput) (*deadline.UpdateQueueFleetAssociationOutput, error)
	UpdateQueueFleetAssociationWithContext(aws.Context, *deadline.UpdateQueueFleetAssociationInput, ...request.Option) (*deadline.UpdateQueueFleetAssociationOutput, error)
	UpdateQueueFleetAssociationRequest(*deadline.UpdateQueueFleetAssociationInput) (*request.Request, *deadline.UpdateQueueFleetAssociationOutput)

	UpdateSession(*deadline.UpdateSessionInput) (*deadline.UpdateSessionOutput, error)
	UpdateSessionWithContext(aws.Context, *deadline.UpdateSessionInput, ...request.Option) (*deadline.UpdateSessionOutput, error)
	UpdateSessionRequest(*deadline.UpdateSessionInput) (*request.Request, *deadline.UpdateSessionOutput)

	UpdateStep(*deadline.UpdateStepInput) (*deadline.UpdateStepOutput, error)
	UpdateStepWithContext(aws.Context, *deadline.UpdateStepInput, ...request.Option) (*deadline.UpdateStepOutput, error)
	UpdateStepRequest(*deadline.UpdateStepInput) (*request.Request, *deadline.UpdateStepOutput)

	UpdateStorageProfile(*deadline.UpdateStorageProfileInput) (*deadline.UpdateStorageProfileOutput, error)
	UpdateStorageProfileWithContext(aws.Context, *deadline.UpdateStorageProfileInput, ...request.Option) (*deadline.UpdateStorageProfileOutput, error)
	UpdateStorageProfileRequest(*deadline.UpdateStorageProfileInput) (*request.Request, *deadline.UpdateStorageProfileOutput)

	UpdateTask(*deadline.UpdateTaskInput) (*deadline.UpdateTaskOutput, error)
	UpdateTaskWithContext(aws.Context, *deadline.UpdateTaskInput, ...request.Option) (*deadline.UpdateTaskOutput, error)
	UpdateTaskRequest(*deadline.UpdateTaskInput) (*request.Request, *deadline.UpdateTaskOutput)

	UpdateWorker(*deadline.UpdateWorkerInput) (*deadline.UpdateWorkerOutput, error)
	UpdateWorkerWithContext(aws.Context, *deadline.UpdateWorkerInput, ...request.Option) (*deadline.UpdateWorkerOutput, error)
	UpdateWorkerRequest(*deadline.UpdateWorkerInput) (*request.Request, *deadline.UpdateWorkerOutput)

	UpdateWorkerSchedule(*deadline.UpdateWorkerScheduleInput) (*deadline.UpdateWorkerScheduleOutput, error)
	UpdateWorkerScheduleWithContext(aws.Context, *deadline.UpdateWorkerScheduleInput, ...request.Option) (*deadline.UpdateWorkerScheduleOutput, error)
	UpdateWorkerScheduleRequest(*deadline.UpdateWorkerScheduleInput) (*request.Request, *deadline.UpdateWorkerScheduleOutput)

	WaitUntilFleetActive(*deadline.GetFleetInput) error
	WaitUntilFleetActiveWithContext(aws.Context, *deadline.GetFleetInput, ...request.WaiterOption) error

	WaitUntilJobCreateComplete(*deadline.GetJobInput) error
	WaitUntilJobCreateCompleteWithContext(aws.Context, *deadline.GetJobInput, ...request.WaiterOption) error

	WaitUntilLicenseEndpointDeleted(*deadline.GetLicenseEndpointInput) error
	WaitUntilLicenseEndpointDeletedWithContext(aws.Context, *deadline.GetLicenseEndpointInput, ...request.WaiterOption) error

	WaitUntilLicenseEndpointValid(*deadline.GetLicenseEndpointInput) error
	WaitUntilLicenseEndpointValidWithContext(aws.Context, *deadline.GetLicenseEndpointInput, ...request.WaiterOption) error

	WaitUntilQueueFleetAssociationStopped(*deadline.GetQueueFleetAssociationInput) error
	WaitUntilQueueFleetAssociationStoppedWithContext(aws.Context, *deadline.GetQueueFleetAssociationInput, ...request.WaiterOption) error

	WaitUntilQueueScheduling(*deadline.GetQueueInput) error
	WaitUntilQueueSchedulingWithContext(aws.Context, *deadline.GetQueueInput, ...request.WaiterOption) error

	WaitUntilQueueSchedulingBlocked(*deadline.GetQueueInput) error
	WaitUntilQueueSchedulingBlockedWithContext(aws.Context, *deadline.GetQueueInput, ...request.WaiterOption) error
}

var _ DeadlineAPI = (*deadline.Deadline)(nil)
