// Copyright Project Harbor Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
import { Injectable } from '@angular/core';
import { Observable, throwError as observableThrowError } from 'rxjs';
import { ScanApiRepository } from './scanAll.api.repository';
import { ErrorHandler } from '../../../../shared/units/error-handler';
import { HttpClient } from '@angular/common/http';
import { ScanningMetrics } from '../../config/config';
import { catchError, map } from 'rxjs/operators';
import { CURRENT_BASE_HREF } from '../../../../shared/units/utils';

@Injectable()
export class ScanAllRepoService {
    constructor(
        private http: HttpClient,
        private scanApiRepository: ScanApiRepository
    ) {}

    public manualScan(): Observable<any> {
        let param = {
            schedule: {
                type: 'Manual',
            },
        };
        return this.scanApiRepository.postSchedule(param);
    }

    public getSchedule(): Observable<any> {
        return this.scanApiRepository.getSchedule();
    }

    public postSchedule(type, cron): Observable<any> {
        let param = {
            schedule: {
                type: type,
                cron: cron,
            },
        };

        return this.scanApiRepository.postSchedule(param);
    }

    public putSchedule(type, cron): Observable<any> {
        let param = {
            schedule: {
                type: type,
                cron: cron,
            },
        };

        return this.scanApiRepository.putSchedule(param);
    }
    getMetrics(): Observable<ScanningMetrics> {
        return this.http
            .get(CURRENT_BASE_HREF + '/scans/all/metrics')
            .pipe(catchError(error => observableThrowError(error)))
            .pipe(map(response => response as ScanningMetrics));
    }
    getScanners(): Observable<any> {
        return this.http
            .get(CURRENT_BASE_HREF + '/scanners')
            .pipe(catchError(error => observableThrowError(error)));
    }
    getScannerMetadata(uid: string): Observable<any> {
        return this.http
            .get(`${CURRENT_BASE_HREF}/scanners/${uid}/metadata`)
            .pipe(catchError(error => observableThrowError(error)));
    }
}
