// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vpc

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opModifyRouteTableAttributesCommon = "ModifyRouteTableAttributes"

// ModifyRouteTableAttributesCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ModifyRouteTableAttributesCommon operation. The "output" return
// value will be populated with the ModifyRouteTableAttributesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ModifyRouteTableAttributesCommon Request to send the API call to the service.
// the "output" return value is not valid until after ModifyRouteTableAttributesCommon Send returns without error.
//
// See ModifyRouteTableAttributesCommon for more information on using the ModifyRouteTableAttributesCommon
// API call, and error handling.
//
//    // Example sending a request using the ModifyRouteTableAttributesCommonRequest method.
//    req, resp := client.ModifyRouteTableAttributesCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VPC) ModifyRouteTableAttributesCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opModifyRouteTableAttributesCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// ModifyRouteTableAttributesCommon API operation for VPC.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VPC's
// API operation ModifyRouteTableAttributesCommon for usage and error information.
func (c *VPC) ModifyRouteTableAttributesCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ModifyRouteTableAttributesCommonRequest(input)
	return out, req.Send()
}

// ModifyRouteTableAttributesCommonWithContext is the same as ModifyRouteTableAttributesCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyRouteTableAttributesCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPC) ModifyRouteTableAttributesCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ModifyRouteTableAttributesCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyRouteTableAttributes = "ModifyRouteTableAttributes"

// ModifyRouteTableAttributesRequest generates a "volcengine/request.Request" representing the
// client's request for the ModifyRouteTableAttributes operation. The "output" return
// value will be populated with the ModifyRouteTableAttributesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ModifyRouteTableAttributesCommon Request to send the API call to the service.
// the "output" return value is not valid until after ModifyRouteTableAttributesCommon Send returns without error.
//
// See ModifyRouteTableAttributes for more information on using the ModifyRouteTableAttributes
// API call, and error handling.
//
//    // Example sending a request using the ModifyRouteTableAttributesRequest method.
//    req, resp := client.ModifyRouteTableAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VPC) ModifyRouteTableAttributesRequest(input *ModifyRouteTableAttributesInput) (req *request.Request, output *ModifyRouteTableAttributesOutput) {
	op := &request.Operation{
		Name:       opModifyRouteTableAttributes,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyRouteTableAttributesInput{}
	}

	output = &ModifyRouteTableAttributesOutput{}
	req = c.newRequest(op, input, output)

	return
}

// ModifyRouteTableAttributes API operation for VPC.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VPC's
// API operation ModifyRouteTableAttributes for usage and error information.
func (c *VPC) ModifyRouteTableAttributes(input *ModifyRouteTableAttributesInput) (*ModifyRouteTableAttributesOutput, error) {
	req, out := c.ModifyRouteTableAttributesRequest(input)
	return out, req.Send()
}

// ModifyRouteTableAttributesWithContext is the same as ModifyRouteTableAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyRouteTableAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPC) ModifyRouteTableAttributesWithContext(ctx volcengine.Context, input *ModifyRouteTableAttributesInput, opts ...request.Option) (*ModifyRouteTableAttributesOutput, error) {
	req, out := c.ModifyRouteTableAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ModifyRouteTableAttributesInput struct {
	_ struct{} `type:"structure"`

	Description *string `min:"1" max:"255" type:"string"`

	// RouteTableId is a required field
	RouteTableId *string `type:"string" required:"true"`

	RouteTableName *string `min:"1" max:"128" type:"string"`
}

// String returns the string representation
func (s ModifyRouteTableAttributesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyRouteTableAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyRouteTableAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyRouteTableAttributesInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Description != nil && len(*s.Description) > 255 {
		invalidParams.Add(request.NewErrParamMaxLen("Description", 255, *s.Description))
	}
	if s.RouteTableId == nil {
		invalidParams.Add(request.NewErrParamRequired("RouteTableId"))
	}
	if s.RouteTableName != nil && len(*s.RouteTableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RouteTableName", 1))
	}
	if s.RouteTableName != nil && len(*s.RouteTableName) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("RouteTableName", 128, *s.RouteTableName))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *ModifyRouteTableAttributesInput) SetDescription(v string) *ModifyRouteTableAttributesInput {
	s.Description = &v
	return s
}

// SetRouteTableId sets the RouteTableId field's value.
func (s *ModifyRouteTableAttributesInput) SetRouteTableId(v string) *ModifyRouteTableAttributesInput {
	s.RouteTableId = &v
	return s
}

// SetRouteTableName sets the RouteTableName field's value.
func (s *ModifyRouteTableAttributesInput) SetRouteTableName(v string) *ModifyRouteTableAttributesInput {
	s.RouteTableName = &v
	return s
}

type ModifyRouteTableAttributesOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	RequestId *string `type:"string"`
}

// String returns the string representation
func (s ModifyRouteTableAttributesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyRouteTableAttributesOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *ModifyRouteTableAttributesOutput) SetRequestId(v string) *ModifyRouteTableAttributesOutput {
	s.RequestId = &v
	return s
}
