// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vpc

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDescribeSecurityGroupsCommon = "DescribeSecurityGroups"

// DescribeSecurityGroupsCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeSecurityGroupsCommon operation. The "output" return
// value will be populated with the DescribeSecurityGroupsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeSecurityGroupsCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeSecurityGroupsCommon Send returns without error.
//
// See DescribeSecurityGroupsCommon for more information on using the DescribeSecurityGroupsCommon
// API call, and error handling.
//
//    // Example sending a request using the DescribeSecurityGroupsCommonRequest method.
//    req, resp := client.DescribeSecurityGroupsCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VPC) DescribeSecurityGroupsCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDescribeSecurityGroupsCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// DescribeSecurityGroupsCommon API operation for VPC.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VPC's
// API operation DescribeSecurityGroupsCommon for usage and error information.
func (c *VPC) DescribeSecurityGroupsCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DescribeSecurityGroupsCommonRequest(input)
	return out, req.Send()
}

// DescribeSecurityGroupsCommonWithContext is the same as DescribeSecurityGroupsCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSecurityGroupsCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPC) DescribeSecurityGroupsCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DescribeSecurityGroupsCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSecurityGroups = "DescribeSecurityGroups"

// DescribeSecurityGroupsRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeSecurityGroups operation. The "output" return
// value will be populated with the DescribeSecurityGroupsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeSecurityGroupsCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeSecurityGroupsCommon Send returns without error.
//
// See DescribeSecurityGroups for more information on using the DescribeSecurityGroups
// API call, and error handling.
//
//    // Example sending a request using the DescribeSecurityGroupsRequest method.
//    req, resp := client.DescribeSecurityGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VPC) DescribeSecurityGroupsRequest(input *DescribeSecurityGroupsInput) (req *request.Request, output *DescribeSecurityGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeSecurityGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSecurityGroupsInput{}
	}

	output = &DescribeSecurityGroupsOutput{}
	req = c.newRequest(op, input, output)

	return
}

// DescribeSecurityGroups API operation for VPC.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VPC's
// API operation DescribeSecurityGroups for usage and error information.
func (c *VPC) DescribeSecurityGroups(input *DescribeSecurityGroupsInput) (*DescribeSecurityGroupsOutput, error) {
	req, out := c.DescribeSecurityGroupsRequest(input)
	return out, req.Send()
}

// DescribeSecurityGroupsWithContext is the same as DescribeSecurityGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSecurityGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPC) DescribeSecurityGroupsWithContext(ctx volcengine.Context, input *DescribeSecurityGroupsInput, opts ...request.Option) (*DescribeSecurityGroupsOutput, error) {
	req, out := c.DescribeSecurityGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type DescribeSecurityGroupsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `min:"1" max:"100" type:"integer"`

	NextToken *string `type:"string"`

	PageNumber *int64 `type:"integer"`

	PageSize *int64 `max:"100" type:"integer"`

	ProjectName *string `type:"string"`

	SecurityGroupIds []*string `type:"list"`

	SecurityGroupNames []*string `type:"list"`

	TagFilters []*TagFilterForDescribeSecurityGroupsInput `type:"list"`

	VpcId *string `type:"string"`
}

// String returns the string representation
func (s DescribeSecurityGroupsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSecurityGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSecurityGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSecurityGroupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.MaxResults != nil && *s.MaxResults > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("MaxResults", 100))
	}
	if s.PageSize != nil && *s.PageSize > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("PageSize", 100))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeSecurityGroupsInput) SetMaxResults(v int64) *DescribeSecurityGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSecurityGroupsInput) SetNextToken(v string) *DescribeSecurityGroupsInput {
	s.NextToken = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *DescribeSecurityGroupsInput) SetPageNumber(v int64) *DescribeSecurityGroupsInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *DescribeSecurityGroupsInput) SetPageSize(v int64) *DescribeSecurityGroupsInput {
	s.PageSize = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *DescribeSecurityGroupsInput) SetProjectName(v string) *DescribeSecurityGroupsInput {
	s.ProjectName = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *DescribeSecurityGroupsInput) SetSecurityGroupIds(v []*string) *DescribeSecurityGroupsInput {
	s.SecurityGroupIds = v
	return s
}

// SetSecurityGroupNames sets the SecurityGroupNames field's value.
func (s *DescribeSecurityGroupsInput) SetSecurityGroupNames(v []*string) *DescribeSecurityGroupsInput {
	s.SecurityGroupNames = v
	return s
}

// SetTagFilters sets the TagFilters field's value.
func (s *DescribeSecurityGroupsInput) SetTagFilters(v []*TagFilterForDescribeSecurityGroupsInput) *DescribeSecurityGroupsInput {
	s.TagFilters = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *DescribeSecurityGroupsInput) SetVpcId(v string) *DescribeSecurityGroupsInput {
	s.VpcId = &v
	return s
}

type DescribeSecurityGroupsOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	NextToken *string `type:"string"`

	PageNumber *int64 `type:"integer"`

	PageSize *int64 `type:"integer"`

	RequestId *string `type:"string"`

	SecurityGroups []*SecurityGroupForDescribeSecurityGroupsOutput `type:"list"`

	TotalCount *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeSecurityGroupsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSecurityGroupsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSecurityGroupsOutput) SetNextToken(v string) *DescribeSecurityGroupsOutput {
	s.NextToken = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *DescribeSecurityGroupsOutput) SetPageNumber(v int64) *DescribeSecurityGroupsOutput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *DescribeSecurityGroupsOutput) SetPageSize(v int64) *DescribeSecurityGroupsOutput {
	s.PageSize = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeSecurityGroupsOutput) SetRequestId(v string) *DescribeSecurityGroupsOutput {
	s.RequestId = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *DescribeSecurityGroupsOutput) SetSecurityGroups(v []*SecurityGroupForDescribeSecurityGroupsOutput) *DescribeSecurityGroupsOutput {
	s.SecurityGroups = v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *DescribeSecurityGroupsOutput) SetTotalCount(v int64) *DescribeSecurityGroupsOutput {
	s.TotalCount = &v
	return s
}

type SecurityGroupForDescribeSecurityGroupsOutput struct {
	_ struct{} `type:"structure"`

	CreationTime *string `type:"string"`

	Description *string `type:"string"`

	ProjectName *string `type:"string"`

	SecurityGroupId *string `type:"string"`

	SecurityGroupName *string `type:"string"`

	ServiceManaged *bool `type:"boolean"`

	Status *string `type:"string"`

	Tags []*TagForDescribeSecurityGroupsOutput `type:"list"`

	Type *string `type:"string"`

	VpcId *string `type:"string"`
}

// String returns the string representation
func (s SecurityGroupForDescribeSecurityGroupsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SecurityGroupForDescribeSecurityGroupsOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *SecurityGroupForDescribeSecurityGroupsOutput) SetCreationTime(v string) *SecurityGroupForDescribeSecurityGroupsOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *SecurityGroupForDescribeSecurityGroupsOutput) SetDescription(v string) *SecurityGroupForDescribeSecurityGroupsOutput {
	s.Description = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *SecurityGroupForDescribeSecurityGroupsOutput) SetProjectName(v string) *SecurityGroupForDescribeSecurityGroupsOutput {
	s.ProjectName = &v
	return s
}

// SetSecurityGroupId sets the SecurityGroupId field's value.
func (s *SecurityGroupForDescribeSecurityGroupsOutput) SetSecurityGroupId(v string) *SecurityGroupForDescribeSecurityGroupsOutput {
	s.SecurityGroupId = &v
	return s
}

// SetSecurityGroupName sets the SecurityGroupName field's value.
func (s *SecurityGroupForDescribeSecurityGroupsOutput) SetSecurityGroupName(v string) *SecurityGroupForDescribeSecurityGroupsOutput {
	s.SecurityGroupName = &v
	return s
}

// SetServiceManaged sets the ServiceManaged field's value.
func (s *SecurityGroupForDescribeSecurityGroupsOutput) SetServiceManaged(v bool) *SecurityGroupForDescribeSecurityGroupsOutput {
	s.ServiceManaged = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *SecurityGroupForDescribeSecurityGroupsOutput) SetStatus(v string) *SecurityGroupForDescribeSecurityGroupsOutput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *SecurityGroupForDescribeSecurityGroupsOutput) SetTags(v []*TagForDescribeSecurityGroupsOutput) *SecurityGroupForDescribeSecurityGroupsOutput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *SecurityGroupForDescribeSecurityGroupsOutput) SetType(v string) *SecurityGroupForDescribeSecurityGroupsOutput {
	s.Type = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *SecurityGroupForDescribeSecurityGroupsOutput) SetVpcId(v string) *SecurityGroupForDescribeSecurityGroupsOutput {
	s.VpcId = &v
	return s
}

type TagFilterForDescribeSecurityGroupsInput struct {
	_ struct{} `type:"structure"`

	Key *string `type:"string"`

	Values []*string `type:"list"`
}

// String returns the string representation
func (s TagFilterForDescribeSecurityGroupsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagFilterForDescribeSecurityGroupsInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagFilterForDescribeSecurityGroupsInput) SetKey(v string) *TagFilterForDescribeSecurityGroupsInput {
	s.Key = &v
	return s
}

// SetValues sets the Values field's value.
func (s *TagFilterForDescribeSecurityGroupsInput) SetValues(v []*string) *TagFilterForDescribeSecurityGroupsInput {
	s.Values = v
	return s
}

type TagForDescribeSecurityGroupsOutput struct {
	_ struct{} `type:"structure"`

	Key *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s TagForDescribeSecurityGroupsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForDescribeSecurityGroupsOutput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForDescribeSecurityGroupsOutput) SetKey(v string) *TagForDescribeSecurityGroupsOutput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForDescribeSecurityGroupsOutput) SetValue(v string) *TagForDescribeSecurityGroupsOutput {
	s.Value = &v
	return s
}
