// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vpc

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateNetworkAclCommon = "CreateNetworkAcl"

// CreateNetworkAclCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateNetworkAclCommon operation. The "output" return
// value will be populated with the CreateNetworkAclCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateNetworkAclCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateNetworkAclCommon Send returns without error.
//
// See CreateNetworkAclCommon for more information on using the CreateNetworkAclCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateNetworkAclCommonRequest method.
//    req, resp := client.CreateNetworkAclCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VPC) CreateNetworkAclCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateNetworkAclCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// CreateNetworkAclCommon API operation for VPC.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VPC's
// API operation CreateNetworkAclCommon for usage and error information.
func (c *VPC) CreateNetworkAclCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateNetworkAclCommonRequest(input)
	return out, req.Send()
}

// CreateNetworkAclCommonWithContext is the same as CreateNetworkAclCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNetworkAclCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPC) CreateNetworkAclCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateNetworkAclCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNetworkAcl = "CreateNetworkAcl"

// CreateNetworkAclRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateNetworkAcl operation. The "output" return
// value will be populated with the CreateNetworkAclCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateNetworkAclCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateNetworkAclCommon Send returns without error.
//
// See CreateNetworkAcl for more information on using the CreateNetworkAcl
// API call, and error handling.
//
//    // Example sending a request using the CreateNetworkAclRequest method.
//    req, resp := client.CreateNetworkAclRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VPC) CreateNetworkAclRequest(input *CreateNetworkAclInput) (req *request.Request, output *CreateNetworkAclOutput) {
	op := &request.Operation{
		Name:       opCreateNetworkAcl,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNetworkAclInput{}
	}

	output = &CreateNetworkAclOutput{}
	req = c.newRequest(op, input, output)

	return
}

// CreateNetworkAcl API operation for VPC.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VPC's
// API operation CreateNetworkAcl for usage and error information.
func (c *VPC) CreateNetworkAcl(input *CreateNetworkAclInput) (*CreateNetworkAclOutput, error) {
	req, out := c.CreateNetworkAclRequest(input)
	return out, req.Send()
}

// CreateNetworkAclWithContext is the same as CreateNetworkAcl with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNetworkAcl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPC) CreateNetworkAclWithContext(ctx volcengine.Context, input *CreateNetworkAclInput, opts ...request.Option) (*CreateNetworkAclOutput, error) {
	req, out := c.CreateNetworkAclRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateNetworkAclInput struct {
	_ struct{} `type:"structure"`

	ClientToken *string `type:"string"`

	Description *string `min:"1" max:"255" type:"string"`

	NetworkAclName *string `min:"1" max:"128" type:"string"`

	ProjectName *string `type:"string"`

	Tags []*TagForCreateNetworkAclInput `type:"list"`

	// VpcId is a required field
	VpcId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateNetworkAclInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNetworkAclInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateNetworkAclInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateNetworkAclInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Description != nil && len(*s.Description) > 255 {
		invalidParams.Add(request.NewErrParamMaxLen("Description", 255, *s.Description))
	}
	if s.NetworkAclName != nil && len(*s.NetworkAclName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkAclName", 1))
	}
	if s.NetworkAclName != nil && len(*s.NetworkAclName) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("NetworkAclName", 128, *s.NetworkAclName))
	}
	if s.VpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateNetworkAclInput) SetClientToken(v string) *CreateNetworkAclInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateNetworkAclInput) SetDescription(v string) *CreateNetworkAclInput {
	s.Description = &v
	return s
}

// SetNetworkAclName sets the NetworkAclName field's value.
func (s *CreateNetworkAclInput) SetNetworkAclName(v string) *CreateNetworkAclInput {
	s.NetworkAclName = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *CreateNetworkAclInput) SetProjectName(v string) *CreateNetworkAclInput {
	s.ProjectName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateNetworkAclInput) SetTags(v []*TagForCreateNetworkAclInput) *CreateNetworkAclInput {
	s.Tags = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *CreateNetworkAclInput) SetVpcId(v string) *CreateNetworkAclInput {
	s.VpcId = &v
	return s
}

type CreateNetworkAclOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	NetworkAclId *string `type:"string"`

	RequestId *string `type:"string"`
}

// String returns the string representation
func (s CreateNetworkAclOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNetworkAclOutput) GoString() string {
	return s.String()
}

// SetNetworkAclId sets the NetworkAclId field's value.
func (s *CreateNetworkAclOutput) SetNetworkAclId(v string) *CreateNetworkAclOutput {
	s.NetworkAclId = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateNetworkAclOutput) SetRequestId(v string) *CreateNetworkAclOutput {
	s.RequestId = &v
	return s
}

type TagForCreateNetworkAclInput struct {
	_ struct{} `type:"structure"`

	Key *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s TagForCreateNetworkAclInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForCreateNetworkAclInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForCreateNetworkAclInput) SetKey(v string) *TagForCreateNetworkAclInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForCreateNetworkAclInput) SetValue(v string) *TagForCreateNetworkAclInput {
	s.Value = &v
	return s
}
