// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package rocketmq

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDescribeTopicAccessPoliciesCommon = "DescribeTopicAccessPolicies"

// DescribeTopicAccessPoliciesCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeTopicAccessPoliciesCommon operation. The "output" return
// value will be populated with the DescribeTopicAccessPoliciesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeTopicAccessPoliciesCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeTopicAccessPoliciesCommon Send returns without error.
//
// See DescribeTopicAccessPoliciesCommon for more information on using the DescribeTopicAccessPoliciesCommon
// API call, and error handling.
//
//    // Example sending a request using the DescribeTopicAccessPoliciesCommonRequest method.
//    req, resp := client.DescribeTopicAccessPoliciesCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ROCKETMQ) DescribeTopicAccessPoliciesCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDescribeTopicAccessPoliciesCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeTopicAccessPoliciesCommon API operation for ROCKETMQ.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ROCKETMQ's
// API operation DescribeTopicAccessPoliciesCommon for usage and error information.
func (c *ROCKETMQ) DescribeTopicAccessPoliciesCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DescribeTopicAccessPoliciesCommonRequest(input)
	return out, req.Send()
}

// DescribeTopicAccessPoliciesCommonWithContext is the same as DescribeTopicAccessPoliciesCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTopicAccessPoliciesCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ROCKETMQ) DescribeTopicAccessPoliciesCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DescribeTopicAccessPoliciesCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTopicAccessPolicies = "DescribeTopicAccessPolicies"

// DescribeTopicAccessPoliciesRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeTopicAccessPolicies operation. The "output" return
// value will be populated with the DescribeTopicAccessPoliciesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeTopicAccessPoliciesCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeTopicAccessPoliciesCommon Send returns without error.
//
// See DescribeTopicAccessPolicies for more information on using the DescribeTopicAccessPolicies
// API call, and error handling.
//
//    // Example sending a request using the DescribeTopicAccessPoliciesRequest method.
//    req, resp := client.DescribeTopicAccessPoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ROCKETMQ) DescribeTopicAccessPoliciesRequest(input *DescribeTopicAccessPoliciesInput) (req *request.Request, output *DescribeTopicAccessPoliciesOutput) {
	op := &request.Operation{
		Name:       opDescribeTopicAccessPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTopicAccessPoliciesInput{}
	}

	output = &DescribeTopicAccessPoliciesOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeTopicAccessPolicies API operation for ROCKETMQ.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ROCKETMQ's
// API operation DescribeTopicAccessPolicies for usage and error information.
func (c *ROCKETMQ) DescribeTopicAccessPolicies(input *DescribeTopicAccessPoliciesInput) (*DescribeTopicAccessPoliciesOutput, error) {
	req, out := c.DescribeTopicAccessPoliciesRequest(input)
	return out, req.Send()
}

// DescribeTopicAccessPoliciesWithContext is the same as DescribeTopicAccessPolicies with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTopicAccessPolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ROCKETMQ) DescribeTopicAccessPoliciesWithContext(ctx volcengine.Context, input *DescribeTopicAccessPoliciesInput, opts ...request.Option) (*DescribeTopicAccessPoliciesOutput, error) {
	req, out := c.DescribeTopicAccessPoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AccessPolicyForDescribeTopicAccessPoliciesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AccessKey *string `min:"24" max:"24" type:"string" json:",omitempty"`

	Authority *string `min:"3" max:"4" type:"string" json:",omitempty"`
}

// String returns the string representation
func (s AccessPolicyForDescribeTopicAccessPoliciesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessPolicyForDescribeTopicAccessPoliciesOutput) GoString() string {
	return s.String()
}

// SetAccessKey sets the AccessKey field's value.
func (s *AccessPolicyForDescribeTopicAccessPoliciesOutput) SetAccessKey(v string) *AccessPolicyForDescribeTopicAccessPoliciesOutput {
	s.AccessKey = &v
	return s
}

// SetAuthority sets the Authority field's value.
func (s *AccessPolicyForDescribeTopicAccessPoliciesOutput) SetAuthority(v string) *AccessPolicyForDescribeTopicAccessPoliciesOutput {
	s.Authority = &v
	return s
}

type DescribeTopicAccessPoliciesInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AccessKey *string `type:"string" json:",omitempty"`

	// InstanceId is a required field
	InstanceId *string `type:"string" json:",omitempty" required:"true"`

	// PageNumber is a required field
	PageNumber *int32 `min:"1" type:"int32" json:",omitempty" required:"true"`

	// PageSize is a required field
	PageSize *int32 `min:"1" max:"100" type:"int32" json:",omitempty" required:"true"`

	// TopicName is a required field
	TopicName *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s DescribeTopicAccessPoliciesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTopicAccessPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTopicAccessPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTopicAccessPoliciesInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.PageNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PageNumber"))
	}
	if s.PageNumber != nil && *s.PageNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageNumber", 1))
	}
	if s.PageSize == nil {
		invalidParams.Add(request.NewErrParamRequired("PageSize"))
	}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}
	if s.PageSize != nil && *s.PageSize > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("PageSize", 100))
	}
	if s.TopicName == nil {
		invalidParams.Add(request.NewErrParamRequired("TopicName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessKey sets the AccessKey field's value.
func (s *DescribeTopicAccessPoliciesInput) SetAccessKey(v string) *DescribeTopicAccessPoliciesInput {
	s.AccessKey = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *DescribeTopicAccessPoliciesInput) SetInstanceId(v string) *DescribeTopicAccessPoliciesInput {
	s.InstanceId = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *DescribeTopicAccessPoliciesInput) SetPageNumber(v int32) *DescribeTopicAccessPoliciesInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *DescribeTopicAccessPoliciesInput) SetPageSize(v int32) *DescribeTopicAccessPoliciesInput {
	s.PageSize = &v
	return s
}

// SetTopicName sets the TopicName field's value.
func (s *DescribeTopicAccessPoliciesInput) SetTopicName(v string) *DescribeTopicAccessPoliciesInput {
	s.TopicName = &v
	return s
}

type DescribeTopicAccessPoliciesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	AccessPolicies []*AccessPolicyForDescribeTopicAccessPoliciesOutput `type:"list" json:",omitempty"`

	Total *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s DescribeTopicAccessPoliciesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTopicAccessPoliciesOutput) GoString() string {
	return s.String()
}

// SetAccessPolicies sets the AccessPolicies field's value.
func (s *DescribeTopicAccessPoliciesOutput) SetAccessPolicies(v []*AccessPolicyForDescribeTopicAccessPoliciesOutput) *DescribeTopicAccessPoliciesOutput {
	s.AccessPolicies = v
	return s
}

// SetTotal sets the Total field's value.
func (s *DescribeTopicAccessPoliciesOutput) SetTotal(v int32) *DescribeTopicAccessPoliciesOutput {
	s.Total = &v
	return s
}
