// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package mongodb

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDescribeDBInstancesCommon = "DescribeDBInstances"

// DescribeDBInstancesCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeDBInstancesCommon operation. The "output" return
// value will be populated with the DescribeDBInstancesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeDBInstancesCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeDBInstancesCommon Send returns without error.
//
// See DescribeDBInstancesCommon for more information on using the DescribeDBInstancesCommon
// API call, and error handling.
//
//    // Example sending a request using the DescribeDBInstancesCommonRequest method.
//    req, resp := client.DescribeDBInstancesCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MONGODB) DescribeDBInstancesCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDescribeDBInstancesCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeDBInstancesCommon API operation for MONGODB.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for MONGODB's
// API operation DescribeDBInstancesCommon for usage and error information.
func (c *MONGODB) DescribeDBInstancesCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DescribeDBInstancesCommonRequest(input)
	return out, req.Send()
}

// DescribeDBInstancesCommonWithContext is the same as DescribeDBInstancesCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBInstancesCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MONGODB) DescribeDBInstancesCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DescribeDBInstancesCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDBInstances = "DescribeDBInstances"

// DescribeDBInstancesRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeDBInstances operation. The "output" return
// value will be populated with the DescribeDBInstancesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeDBInstancesCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeDBInstancesCommon Send returns without error.
//
// See DescribeDBInstances for more information on using the DescribeDBInstances
// API call, and error handling.
//
//    // Example sending a request using the DescribeDBInstancesRequest method.
//    req, resp := client.DescribeDBInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MONGODB) DescribeDBInstancesRequest(input *DescribeDBInstancesInput) (req *request.Request, output *DescribeDBInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeDBInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDBInstancesInput{}
	}

	output = &DescribeDBInstancesOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeDBInstances API operation for MONGODB.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for MONGODB's
// API operation DescribeDBInstances for usage and error information.
func (c *MONGODB) DescribeDBInstances(input *DescribeDBInstancesInput) (*DescribeDBInstancesOutput, error) {
	req, out := c.DescribeDBInstancesRequest(input)
	return out, req.Send()
}

// DescribeDBInstancesWithContext is the same as DescribeDBInstances with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MONGODB) DescribeDBInstancesWithContext(ctx volcengine.Context, input *DescribeDBInstancesInput, opts ...request.Option) (*DescribeDBInstancesOutput, error) {
	req, out := c.DescribeDBInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type DBInstanceForDescribeDBInstancesOutput struct {
	_ struct{} `type:"structure"`

	AutoRenew *bool `type:"boolean"`

	ChargeStatus *string `type:"string" enum:"EnumOfChargeStatusForDescribeDBInstancesOutput"`

	ChargeType *string `type:"string" enum:"EnumOfChargeTypeForDescribeDBInstancesOutput"`

	ClosedTime *string `type:"string"`

	ConfigServersId *string `type:"string"`

	CreateTime *string `type:"string"`

	DBEngineVersion *string `type:"string" enum:"EnumOfDBEngineVersionForDescribeDBInstancesOutput"`

	DBEngineVersionStr *string `type:"string"`

	ExpiredTime *string `type:"string"`

	InstanceId *string `type:"string"`

	InstanceName *string `type:"string"`

	InstanceStatus *string `type:"string" enum:"EnumOfInstanceStatusForDescribeDBInstancesOutput"`

	InstanceType *string `type:"string" enum:"EnumOfInstanceTypeForDescribeDBInstancesOutput"`

	MongosId *string `type:"string"`

	PrivateEndpoint *string `type:"string"`

	ProjectName *string `type:"string"`

	ReclaimTime *string `type:"string"`

	StorageType *string `type:"string" enum:"EnumOfStorageTypeForDescribeDBInstancesOutput"`

	SubnetId *string `type:"string"`

	Tags []*TagForDescribeDBInstancesOutput `type:"list"`

	UpdateTime *string `type:"string"`

	VpcId *string `type:"string"`

	ZoneId *string `type:"string"`
}

// String returns the string representation
func (s DBInstanceForDescribeDBInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DBInstanceForDescribeDBInstancesOutput) GoString() string {
	return s.String()
}

// SetAutoRenew sets the AutoRenew field's value.
func (s *DBInstanceForDescribeDBInstancesOutput) SetAutoRenew(v bool) *DBInstanceForDescribeDBInstancesOutput {
	s.AutoRenew = &v
	return s
}

// SetChargeStatus sets the ChargeStatus field's value.
func (s *DBInstanceForDescribeDBInstancesOutput) SetChargeStatus(v string) *DBInstanceForDescribeDBInstancesOutput {
	s.ChargeStatus = &v
	return s
}

// SetChargeType sets the ChargeType field's value.
func (s *DBInstanceForDescribeDBInstancesOutput) SetChargeType(v string) *DBInstanceForDescribeDBInstancesOutput {
	s.ChargeType = &v
	return s
}

// SetClosedTime sets the ClosedTime field's value.
func (s *DBInstanceForDescribeDBInstancesOutput) SetClosedTime(v string) *DBInstanceForDescribeDBInstancesOutput {
	s.ClosedTime = &v
	return s
}

// SetConfigServersId sets the ConfigServersId field's value.
func (s *DBInstanceForDescribeDBInstancesOutput) SetConfigServersId(v string) *DBInstanceForDescribeDBInstancesOutput {
	s.ConfigServersId = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *DBInstanceForDescribeDBInstancesOutput) SetCreateTime(v string) *DBInstanceForDescribeDBInstancesOutput {
	s.CreateTime = &v
	return s
}

// SetDBEngineVersion sets the DBEngineVersion field's value.
func (s *DBInstanceForDescribeDBInstancesOutput) SetDBEngineVersion(v string) *DBInstanceForDescribeDBInstancesOutput {
	s.DBEngineVersion = &v
	return s
}

// SetDBEngineVersionStr sets the DBEngineVersionStr field's value.
func (s *DBInstanceForDescribeDBInstancesOutput) SetDBEngineVersionStr(v string) *DBInstanceForDescribeDBInstancesOutput {
	s.DBEngineVersionStr = &v
	return s
}

// SetExpiredTime sets the ExpiredTime field's value.
func (s *DBInstanceForDescribeDBInstancesOutput) SetExpiredTime(v string) *DBInstanceForDescribeDBInstancesOutput {
	s.ExpiredTime = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *DBInstanceForDescribeDBInstancesOutput) SetInstanceId(v string) *DBInstanceForDescribeDBInstancesOutput {
	s.InstanceId = &v
	return s
}

// SetInstanceName sets the InstanceName field's value.
func (s *DBInstanceForDescribeDBInstancesOutput) SetInstanceName(v string) *DBInstanceForDescribeDBInstancesOutput {
	s.InstanceName = &v
	return s
}

// SetInstanceStatus sets the InstanceStatus field's value.
func (s *DBInstanceForDescribeDBInstancesOutput) SetInstanceStatus(v string) *DBInstanceForDescribeDBInstancesOutput {
	s.InstanceStatus = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *DBInstanceForDescribeDBInstancesOutput) SetInstanceType(v string) *DBInstanceForDescribeDBInstancesOutput {
	s.InstanceType = &v
	return s
}

// SetMongosId sets the MongosId field's value.
func (s *DBInstanceForDescribeDBInstancesOutput) SetMongosId(v string) *DBInstanceForDescribeDBInstancesOutput {
	s.MongosId = &v
	return s
}

// SetPrivateEndpoint sets the PrivateEndpoint field's value.
func (s *DBInstanceForDescribeDBInstancesOutput) SetPrivateEndpoint(v string) *DBInstanceForDescribeDBInstancesOutput {
	s.PrivateEndpoint = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *DBInstanceForDescribeDBInstancesOutput) SetProjectName(v string) *DBInstanceForDescribeDBInstancesOutput {
	s.ProjectName = &v
	return s
}

// SetReclaimTime sets the ReclaimTime field's value.
func (s *DBInstanceForDescribeDBInstancesOutput) SetReclaimTime(v string) *DBInstanceForDescribeDBInstancesOutput {
	s.ReclaimTime = &v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *DBInstanceForDescribeDBInstancesOutput) SetStorageType(v string) *DBInstanceForDescribeDBInstancesOutput {
	s.StorageType = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *DBInstanceForDescribeDBInstancesOutput) SetSubnetId(v string) *DBInstanceForDescribeDBInstancesOutput {
	s.SubnetId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DBInstanceForDescribeDBInstancesOutput) SetTags(v []*TagForDescribeDBInstancesOutput) *DBInstanceForDescribeDBInstancesOutput {
	s.Tags = v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *DBInstanceForDescribeDBInstancesOutput) SetUpdateTime(v string) *DBInstanceForDescribeDBInstancesOutput {
	s.UpdateTime = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *DBInstanceForDescribeDBInstancesOutput) SetVpcId(v string) *DBInstanceForDescribeDBInstancesOutput {
	s.VpcId = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *DBInstanceForDescribeDBInstancesOutput) SetZoneId(v string) *DBInstanceForDescribeDBInstancesOutput {
	s.ZoneId = &v
	return s
}

type DescribeDBInstancesInput struct {
	_ struct{} `type:"structure"`

	CreateEndTime *string `type:"string"`

	CreateStartTime *string `type:"string"`

	DBEngine *string `type:"string" enum:"EnumOfDBEngineForDescribeDBInstancesInput"`

	DBEngineVersion *string `type:"string" enum:"EnumOfDBEngineVersionForDescribeDBInstancesInput"`

	InstanceId *string `type:"string"`

	InstanceName *string `type:"string"`

	InstanceStatus *string `type:"string" enum:"EnumOfInstanceStatusForDescribeDBInstancesInput"`

	InstanceType *string `type:"string" enum:"EnumOfInstanceTypeForDescribeDBInstancesInput"`

	PageNumber *int32 `type:"int32"`

	PageSize *int32 `type:"int32"`

	ProjectName *string `type:"string"`

	TagFilters []*TagFilterForDescribeDBInstancesInput `type:"list"`

	UpdateEndTime *string `type:"string"`

	UpdateStartTime *string `type:"string"`

	VpcId *string `type:"string"`

	ZoneId *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBInstancesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBInstancesInput) GoString() string {
	return s.String()
}

// SetCreateEndTime sets the CreateEndTime field's value.
func (s *DescribeDBInstancesInput) SetCreateEndTime(v string) *DescribeDBInstancesInput {
	s.CreateEndTime = &v
	return s
}

// SetCreateStartTime sets the CreateStartTime field's value.
func (s *DescribeDBInstancesInput) SetCreateStartTime(v string) *DescribeDBInstancesInput {
	s.CreateStartTime = &v
	return s
}

// SetDBEngine sets the DBEngine field's value.
func (s *DescribeDBInstancesInput) SetDBEngine(v string) *DescribeDBInstancesInput {
	s.DBEngine = &v
	return s
}

// SetDBEngineVersion sets the DBEngineVersion field's value.
func (s *DescribeDBInstancesInput) SetDBEngineVersion(v string) *DescribeDBInstancesInput {
	s.DBEngineVersion = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *DescribeDBInstancesInput) SetInstanceId(v string) *DescribeDBInstancesInput {
	s.InstanceId = &v
	return s
}

// SetInstanceName sets the InstanceName field's value.
func (s *DescribeDBInstancesInput) SetInstanceName(v string) *DescribeDBInstancesInput {
	s.InstanceName = &v
	return s
}

// SetInstanceStatus sets the InstanceStatus field's value.
func (s *DescribeDBInstancesInput) SetInstanceStatus(v string) *DescribeDBInstancesInput {
	s.InstanceStatus = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *DescribeDBInstancesInput) SetInstanceType(v string) *DescribeDBInstancesInput {
	s.InstanceType = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *DescribeDBInstancesInput) SetPageNumber(v int32) *DescribeDBInstancesInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *DescribeDBInstancesInput) SetPageSize(v int32) *DescribeDBInstancesInput {
	s.PageSize = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *DescribeDBInstancesInput) SetProjectName(v string) *DescribeDBInstancesInput {
	s.ProjectName = &v
	return s
}

// SetTagFilters sets the TagFilters field's value.
func (s *DescribeDBInstancesInput) SetTagFilters(v []*TagFilterForDescribeDBInstancesInput) *DescribeDBInstancesInput {
	s.TagFilters = v
	return s
}

// SetUpdateEndTime sets the UpdateEndTime field's value.
func (s *DescribeDBInstancesInput) SetUpdateEndTime(v string) *DescribeDBInstancesInput {
	s.UpdateEndTime = &v
	return s
}

// SetUpdateStartTime sets the UpdateStartTime field's value.
func (s *DescribeDBInstancesInput) SetUpdateStartTime(v string) *DescribeDBInstancesInput {
	s.UpdateStartTime = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *DescribeDBInstancesInput) SetVpcId(v string) *DescribeDBInstancesInput {
	s.VpcId = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *DescribeDBInstancesInput) SetZoneId(v string) *DescribeDBInstancesInput {
	s.ZoneId = &v
	return s
}

type DescribeDBInstancesOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	DBInstances []*DBInstanceForDescribeDBInstancesOutput `type:"list"`

	Total *int32 `type:"int32"`
}

// String returns the string representation
func (s DescribeDBInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBInstancesOutput) GoString() string {
	return s.String()
}

// SetDBInstances sets the DBInstances field's value.
func (s *DescribeDBInstancesOutput) SetDBInstances(v []*DBInstanceForDescribeDBInstancesOutput) *DescribeDBInstancesOutput {
	s.DBInstances = v
	return s
}

// SetTotal sets the Total field's value.
func (s *DescribeDBInstancesOutput) SetTotal(v int32) *DescribeDBInstancesOutput {
	s.Total = &v
	return s
}

type TagFilterForDescribeDBInstancesInput struct {
	_ struct{} `type:"structure"`

	Key *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s TagFilterForDescribeDBInstancesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagFilterForDescribeDBInstancesInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagFilterForDescribeDBInstancesInput) SetKey(v string) *TagFilterForDescribeDBInstancesInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagFilterForDescribeDBInstancesInput) SetValue(v string) *TagFilterForDescribeDBInstancesInput {
	s.Value = &v
	return s
}

type TagForDescribeDBInstancesOutput struct {
	_ struct{} `type:"structure"`

	Key *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s TagForDescribeDBInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForDescribeDBInstancesOutput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForDescribeDBInstancesOutput) SetKey(v string) *TagForDescribeDBInstancesOutput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForDescribeDBInstancesOutput) SetValue(v string) *TagForDescribeDBInstancesOutput {
	s.Value = &v
	return s
}

const (
	// EnumOfChargeStatusForDescribeDBInstancesOutputNormal is a EnumOfChargeStatusForDescribeDBInstancesOutput enum value
	EnumOfChargeStatusForDescribeDBInstancesOutputNormal = "Normal"

	// EnumOfChargeStatusForDescribeDBInstancesOutputOverdue is a EnumOfChargeStatusForDescribeDBInstancesOutput enum value
	EnumOfChargeStatusForDescribeDBInstancesOutputOverdue = "Overdue"

	// EnumOfChargeStatusForDescribeDBInstancesOutputWaitingPaid is a EnumOfChargeStatusForDescribeDBInstancesOutput enum value
	EnumOfChargeStatusForDescribeDBInstancesOutputWaitingPaid = "WaitingPaid"

	// EnumOfChargeStatusForDescribeDBInstancesOutputUnDeploy is a EnumOfChargeStatusForDescribeDBInstancesOutput enum value
	EnumOfChargeStatusForDescribeDBInstancesOutputUnDeploy = "UnDeploy"

	// EnumOfChargeStatusForDescribeDBInstancesOutputRenewing is a EnumOfChargeStatusForDescribeDBInstancesOutput enum value
	EnumOfChargeStatusForDescribeDBInstancesOutputRenewing = "Renewing"

	// EnumOfChargeStatusForDescribeDBInstancesOutputOwing is a EnumOfChargeStatusForDescribeDBInstancesOutput enum value
	EnumOfChargeStatusForDescribeDBInstancesOutputOwing = "Owing"

	// EnumOfChargeStatusForDescribeDBInstancesOutputUnsubscribing is a EnumOfChargeStatusForDescribeDBInstancesOutput enum value
	EnumOfChargeStatusForDescribeDBInstancesOutputUnsubscribing = "Unsubscribing"
)

const (
	// EnumOfChargeTypeForDescribeDBInstancesOutputNotEnabled is a EnumOfChargeTypeForDescribeDBInstancesOutput enum value
	EnumOfChargeTypeForDescribeDBInstancesOutputNotEnabled = "NotEnabled"

	// EnumOfChargeTypeForDescribeDBInstancesOutputPostPaid is a EnumOfChargeTypeForDescribeDBInstancesOutput enum value
	EnumOfChargeTypeForDescribeDBInstancesOutputPostPaid = "PostPaid"

	// EnumOfChargeTypeForDescribeDBInstancesOutputPrepaid is a EnumOfChargeTypeForDescribeDBInstancesOutput enum value
	EnumOfChargeTypeForDescribeDBInstancesOutputPrepaid = "Prepaid"
)

const (
	// EnumOfDBEngineForDescribeDBInstancesInputMongoDb is a EnumOfDBEngineForDescribeDBInstancesInput enum value
	EnumOfDBEngineForDescribeDBInstancesInputMongoDb = "MongoDB"
)

const (
	// EnumOfDBEngineVersionForDescribeDBInstancesInputMongoDb40 is a EnumOfDBEngineVersionForDescribeDBInstancesInput enum value
	EnumOfDBEngineVersionForDescribeDBInstancesInputMongoDb40 = "MongoDB_4_0"

	// EnumOfDBEngineVersionForDescribeDBInstancesInputMongoDb42 is a EnumOfDBEngineVersionForDescribeDBInstancesInput enum value
	EnumOfDBEngineVersionForDescribeDBInstancesInputMongoDb42 = "MongoDB_4_2"

	// EnumOfDBEngineVersionForDescribeDBInstancesInputMongoDb44 is a EnumOfDBEngineVersionForDescribeDBInstancesInput enum value
	EnumOfDBEngineVersionForDescribeDBInstancesInputMongoDb44 = "MongoDB_4_4"

	// EnumOfDBEngineVersionForDescribeDBInstancesInputMongoDb50 is a EnumOfDBEngineVersionForDescribeDBInstancesInput enum value
	EnumOfDBEngineVersionForDescribeDBInstancesInputMongoDb50 = "MongoDB_5_0"

	// EnumOfDBEngineVersionForDescribeDBInstancesInputMongoDb60 is a EnumOfDBEngineVersionForDescribeDBInstancesInput enum value
	EnumOfDBEngineVersionForDescribeDBInstancesInputMongoDb60 = "MongoDB_6_0"
)

const (
	// EnumOfDBEngineVersionForDescribeDBInstancesOutputMongoDb40 is a EnumOfDBEngineVersionForDescribeDBInstancesOutput enum value
	EnumOfDBEngineVersionForDescribeDBInstancesOutputMongoDb40 = "MongoDB_4_0"

	// EnumOfDBEngineVersionForDescribeDBInstancesOutputMongoDb42 is a EnumOfDBEngineVersionForDescribeDBInstancesOutput enum value
	EnumOfDBEngineVersionForDescribeDBInstancesOutputMongoDb42 = "MongoDB_4_2"

	// EnumOfDBEngineVersionForDescribeDBInstancesOutputMongoDb44 is a EnumOfDBEngineVersionForDescribeDBInstancesOutput enum value
	EnumOfDBEngineVersionForDescribeDBInstancesOutputMongoDb44 = "MongoDB_4_4"

	// EnumOfDBEngineVersionForDescribeDBInstancesOutputMongoDb50 is a EnumOfDBEngineVersionForDescribeDBInstancesOutput enum value
	EnumOfDBEngineVersionForDescribeDBInstancesOutputMongoDb50 = "MongoDB_5_0"

	// EnumOfDBEngineVersionForDescribeDBInstancesOutputMongoDb60 is a EnumOfDBEngineVersionForDescribeDBInstancesOutput enum value
	EnumOfDBEngineVersionForDescribeDBInstancesOutputMongoDb60 = "MongoDB_6_0"
)

const (
	// EnumOfInstanceStatusForDescribeDBInstancesInputCreating is a EnumOfInstanceStatusForDescribeDBInstancesInput enum value
	EnumOfInstanceStatusForDescribeDBInstancesInputCreating = "Creating"

	// EnumOfInstanceStatusForDescribeDBInstancesInputRunning is a EnumOfInstanceStatusForDescribeDBInstancesInput enum value
	EnumOfInstanceStatusForDescribeDBInstancesInputRunning = "Running"

	// EnumOfInstanceStatusForDescribeDBInstancesInputDeleting is a EnumOfInstanceStatusForDescribeDBInstancesInput enum value
	EnumOfInstanceStatusForDescribeDBInstancesInputDeleting = "Deleting"

	// EnumOfInstanceStatusForDescribeDBInstancesInputDestroying is a EnumOfInstanceStatusForDescribeDBInstancesInput enum value
	EnumOfInstanceStatusForDescribeDBInstancesInputDestroying = "Destroying"

	// EnumOfInstanceStatusForDescribeDBInstancesInputRestarting is a EnumOfInstanceStatusForDescribeDBInstancesInput enum value
	EnumOfInstanceStatusForDescribeDBInstancesInputRestarting = "Restarting"

	// EnumOfInstanceStatusForDescribeDBInstancesInputRebuilding is a EnumOfInstanceStatusForDescribeDBInstancesInput enum value
	EnumOfInstanceStatusForDescribeDBInstancesInputRebuilding = "Rebuilding"

	// EnumOfInstanceStatusForDescribeDBInstancesInputUpdating is a EnumOfInstanceStatusForDescribeDBInstancesInput enum value
	EnumOfInstanceStatusForDescribeDBInstancesInputUpdating = "Updating"

	// EnumOfInstanceStatusForDescribeDBInstancesInputMigrating is a EnumOfInstanceStatusForDescribeDBInstancesInput enum value
	EnumOfInstanceStatusForDescribeDBInstancesInputMigrating = "Migrating"

	// EnumOfInstanceStatusForDescribeDBInstancesInputRestoring is a EnumOfInstanceStatusForDescribeDBInstancesInput enum value
	EnumOfInstanceStatusForDescribeDBInstancesInputRestoring = "Restoring"

	// EnumOfInstanceStatusForDescribeDBInstancesInputImporting is a EnumOfInstanceStatusForDescribeDBInstancesInput enum value
	EnumOfInstanceStatusForDescribeDBInstancesInputImporting = "Importing"

	// EnumOfInstanceStatusForDescribeDBInstancesInputError is a EnumOfInstanceStatusForDescribeDBInstancesInput enum value
	EnumOfInstanceStatusForDescribeDBInstancesInputError = "Error"

	// EnumOfInstanceStatusForDescribeDBInstancesInputScaling is a EnumOfInstanceStatusForDescribeDBInstancesInput enum value
	EnumOfInstanceStatusForDescribeDBInstancesInputScaling = "Scaling"

	// EnumOfInstanceStatusForDescribeDBInstancesInputUpgrading is a EnumOfInstanceStatusForDescribeDBInstancesInput enum value
	EnumOfInstanceStatusForDescribeDBInstancesInputUpgrading = "Upgrading"

	// EnumOfInstanceStatusForDescribeDBInstancesInputDeleted is a EnumOfInstanceStatusForDescribeDBInstancesInput enum value
	EnumOfInstanceStatusForDescribeDBInstancesInputDeleted = "Deleted"

	// EnumOfInstanceStatusForDescribeDBInstancesInputRecycled is a EnumOfInstanceStatusForDescribeDBInstancesInput enum value
	EnumOfInstanceStatusForDescribeDBInstancesInputRecycled = "Recycled"

	// EnumOfInstanceStatusForDescribeDBInstancesInputClosed is a EnumOfInstanceStatusForDescribeDBInstancesInput enum value
	EnumOfInstanceStatusForDescribeDBInstancesInputClosed = "Closed"

	// EnumOfInstanceStatusForDescribeDBInstancesInputCreateFailed is a EnumOfInstanceStatusForDescribeDBInstancesInput enum value
	EnumOfInstanceStatusForDescribeDBInstancesInputCreateFailed = "CreateFailed"

	// EnumOfInstanceStatusForDescribeDBInstancesInputNetCreating is a EnumOfInstanceStatusForDescribeDBInstancesInput enum value
	EnumOfInstanceStatusForDescribeDBInstancesInputNetCreating = "NetCreating"

	// EnumOfInstanceStatusForDescribeDBInstancesInputNetReleasing is a EnumOfInstanceStatusForDescribeDBInstancesInput enum value
	EnumOfInstanceStatusForDescribeDBInstancesInputNetReleasing = "NetReleasing"

	// EnumOfInstanceStatusForDescribeDBInstancesInputWaitingPaid is a EnumOfInstanceStatusForDescribeDBInstancesInput enum value
	EnumOfInstanceStatusForDescribeDBInstancesInputWaitingPaid = "WaitingPaid"

	// EnumOfInstanceStatusForDescribeDBInstancesInputClosing is a EnumOfInstanceStatusForDescribeDBInstancesInput enum value
	EnumOfInstanceStatusForDescribeDBInstancesInputClosing = "Closing"

	// EnumOfInstanceStatusForDescribeDBInstancesInputReleased is a EnumOfInstanceStatusForDescribeDBInstancesInput enum value
	EnumOfInstanceStatusForDescribeDBInstancesInputReleased = "Released"

	// EnumOfInstanceStatusForDescribeDBInstancesInputDestroyed is a EnumOfInstanceStatusForDescribeDBInstancesInput enum value
	EnumOfInstanceStatusForDescribeDBInstancesInputDestroyed = "Destroyed"

	// EnumOfInstanceStatusForDescribeDBInstancesInputReclaiming is a EnumOfInstanceStatusForDescribeDBInstancesInput enum value
	EnumOfInstanceStatusForDescribeDBInstancesInputReclaiming = "Reclaiming"

	// EnumOfInstanceStatusForDescribeDBInstancesInputResuming is a EnumOfInstanceStatusForDescribeDBInstancesInput enum value
	EnumOfInstanceStatusForDescribeDBInstancesInputResuming = "Resuming"

	// EnumOfInstanceStatusForDescribeDBInstancesInputAllowListMaintaining is a EnumOfInstanceStatusForDescribeDBInstancesInput enum value
	EnumOfInstanceStatusForDescribeDBInstancesInputAllowListMaintaining = "AllowListMaintaining"

	// EnumOfInstanceStatusForDescribeDBInstancesInputTaskFailedAvailable is a EnumOfInstanceStatusForDescribeDBInstancesInput enum value
	EnumOfInstanceStatusForDescribeDBInstancesInputTaskFailedAvailable = "TaskFailed_Available"

	// EnumOfInstanceStatusForDescribeDBInstancesInputUnavailable is a EnumOfInstanceStatusForDescribeDBInstancesInput enum value
	EnumOfInstanceStatusForDescribeDBInstancesInputUnavailable = "Unavailable"

	// EnumOfInstanceStatusForDescribeDBInstancesInputNetworkMaintaining is a EnumOfInstanceStatusForDescribeDBInstancesInput enum value
	EnumOfInstanceStatusForDescribeDBInstancesInputNetworkMaintaining = "NetworkMaintaining"

	// EnumOfInstanceStatusForDescribeDBInstancesInputTdemaintaining is a EnumOfInstanceStatusForDescribeDBInstancesInput enum value
	EnumOfInstanceStatusForDescribeDBInstancesInputTdemaintaining = "TDEMaintaining"

	// EnumOfInstanceStatusForDescribeDBInstancesInputSslupdating is a EnumOfInstanceStatusForDescribeDBInstancesInput enum value
	EnumOfInstanceStatusForDescribeDBInstancesInputSslupdating = "SSLUpdating"

	// EnumOfInstanceStatusForDescribeDBInstancesInputSwitchMastering is a EnumOfInstanceStatusForDescribeDBInstancesInput enum value
	EnumOfInstanceStatusForDescribeDBInstancesInputSwitchMastering = "SwitchMastering"

	// EnumOfInstanceStatusForDescribeDBInstancesInputTemporary is a EnumOfInstanceStatusForDescribeDBInstancesInput enum value
	EnumOfInstanceStatusForDescribeDBInstancesInputTemporary = "Temporary"
)

const (
	// EnumOfInstanceStatusForDescribeDBInstancesOutputCreating is a EnumOfInstanceStatusForDescribeDBInstancesOutput enum value
	EnumOfInstanceStatusForDescribeDBInstancesOutputCreating = "Creating"

	// EnumOfInstanceStatusForDescribeDBInstancesOutputRunning is a EnumOfInstanceStatusForDescribeDBInstancesOutput enum value
	EnumOfInstanceStatusForDescribeDBInstancesOutputRunning = "Running"

	// EnumOfInstanceStatusForDescribeDBInstancesOutputDeleting is a EnumOfInstanceStatusForDescribeDBInstancesOutput enum value
	EnumOfInstanceStatusForDescribeDBInstancesOutputDeleting = "Deleting"

	// EnumOfInstanceStatusForDescribeDBInstancesOutputDestroying is a EnumOfInstanceStatusForDescribeDBInstancesOutput enum value
	EnumOfInstanceStatusForDescribeDBInstancesOutputDestroying = "Destroying"

	// EnumOfInstanceStatusForDescribeDBInstancesOutputRestarting is a EnumOfInstanceStatusForDescribeDBInstancesOutput enum value
	EnumOfInstanceStatusForDescribeDBInstancesOutputRestarting = "Restarting"

	// EnumOfInstanceStatusForDescribeDBInstancesOutputRebuilding is a EnumOfInstanceStatusForDescribeDBInstancesOutput enum value
	EnumOfInstanceStatusForDescribeDBInstancesOutputRebuilding = "Rebuilding"

	// EnumOfInstanceStatusForDescribeDBInstancesOutputUpdating is a EnumOfInstanceStatusForDescribeDBInstancesOutput enum value
	EnumOfInstanceStatusForDescribeDBInstancesOutputUpdating = "Updating"

	// EnumOfInstanceStatusForDescribeDBInstancesOutputMigrating is a EnumOfInstanceStatusForDescribeDBInstancesOutput enum value
	EnumOfInstanceStatusForDescribeDBInstancesOutputMigrating = "Migrating"

	// EnumOfInstanceStatusForDescribeDBInstancesOutputRestoring is a EnumOfInstanceStatusForDescribeDBInstancesOutput enum value
	EnumOfInstanceStatusForDescribeDBInstancesOutputRestoring = "Restoring"

	// EnumOfInstanceStatusForDescribeDBInstancesOutputImporting is a EnumOfInstanceStatusForDescribeDBInstancesOutput enum value
	EnumOfInstanceStatusForDescribeDBInstancesOutputImporting = "Importing"

	// EnumOfInstanceStatusForDescribeDBInstancesOutputError is a EnumOfInstanceStatusForDescribeDBInstancesOutput enum value
	EnumOfInstanceStatusForDescribeDBInstancesOutputError = "Error"

	// EnumOfInstanceStatusForDescribeDBInstancesOutputScaling is a EnumOfInstanceStatusForDescribeDBInstancesOutput enum value
	EnumOfInstanceStatusForDescribeDBInstancesOutputScaling = "Scaling"

	// EnumOfInstanceStatusForDescribeDBInstancesOutputUpgrading is a EnumOfInstanceStatusForDescribeDBInstancesOutput enum value
	EnumOfInstanceStatusForDescribeDBInstancesOutputUpgrading = "Upgrading"

	// EnumOfInstanceStatusForDescribeDBInstancesOutputDeleted is a EnumOfInstanceStatusForDescribeDBInstancesOutput enum value
	EnumOfInstanceStatusForDescribeDBInstancesOutputDeleted = "Deleted"

	// EnumOfInstanceStatusForDescribeDBInstancesOutputRecycled is a EnumOfInstanceStatusForDescribeDBInstancesOutput enum value
	EnumOfInstanceStatusForDescribeDBInstancesOutputRecycled = "Recycled"

	// EnumOfInstanceStatusForDescribeDBInstancesOutputClosed is a EnumOfInstanceStatusForDescribeDBInstancesOutput enum value
	EnumOfInstanceStatusForDescribeDBInstancesOutputClosed = "Closed"

	// EnumOfInstanceStatusForDescribeDBInstancesOutputCreateFailed is a EnumOfInstanceStatusForDescribeDBInstancesOutput enum value
	EnumOfInstanceStatusForDescribeDBInstancesOutputCreateFailed = "CreateFailed"

	// EnumOfInstanceStatusForDescribeDBInstancesOutputNetCreating is a EnumOfInstanceStatusForDescribeDBInstancesOutput enum value
	EnumOfInstanceStatusForDescribeDBInstancesOutputNetCreating = "NetCreating"

	// EnumOfInstanceStatusForDescribeDBInstancesOutputNetReleasing is a EnumOfInstanceStatusForDescribeDBInstancesOutput enum value
	EnumOfInstanceStatusForDescribeDBInstancesOutputNetReleasing = "NetReleasing"

	// EnumOfInstanceStatusForDescribeDBInstancesOutputWaitingPaid is a EnumOfInstanceStatusForDescribeDBInstancesOutput enum value
	EnumOfInstanceStatusForDescribeDBInstancesOutputWaitingPaid = "WaitingPaid"

	// EnumOfInstanceStatusForDescribeDBInstancesOutputClosing is a EnumOfInstanceStatusForDescribeDBInstancesOutput enum value
	EnumOfInstanceStatusForDescribeDBInstancesOutputClosing = "Closing"

	// EnumOfInstanceStatusForDescribeDBInstancesOutputReleased is a EnumOfInstanceStatusForDescribeDBInstancesOutput enum value
	EnumOfInstanceStatusForDescribeDBInstancesOutputReleased = "Released"

	// EnumOfInstanceStatusForDescribeDBInstancesOutputDestroyed is a EnumOfInstanceStatusForDescribeDBInstancesOutput enum value
	EnumOfInstanceStatusForDescribeDBInstancesOutputDestroyed = "Destroyed"

	// EnumOfInstanceStatusForDescribeDBInstancesOutputReclaiming is a EnumOfInstanceStatusForDescribeDBInstancesOutput enum value
	EnumOfInstanceStatusForDescribeDBInstancesOutputReclaiming = "Reclaiming"

	// EnumOfInstanceStatusForDescribeDBInstancesOutputResuming is a EnumOfInstanceStatusForDescribeDBInstancesOutput enum value
	EnumOfInstanceStatusForDescribeDBInstancesOutputResuming = "Resuming"

	// EnumOfInstanceStatusForDescribeDBInstancesOutputAllowListMaintaining is a EnumOfInstanceStatusForDescribeDBInstancesOutput enum value
	EnumOfInstanceStatusForDescribeDBInstancesOutputAllowListMaintaining = "AllowListMaintaining"

	// EnumOfInstanceStatusForDescribeDBInstancesOutputTaskFailedAvailable is a EnumOfInstanceStatusForDescribeDBInstancesOutput enum value
	EnumOfInstanceStatusForDescribeDBInstancesOutputTaskFailedAvailable = "TaskFailed_Available"

	// EnumOfInstanceStatusForDescribeDBInstancesOutputUnavailable is a EnumOfInstanceStatusForDescribeDBInstancesOutput enum value
	EnumOfInstanceStatusForDescribeDBInstancesOutputUnavailable = "Unavailable"

	// EnumOfInstanceStatusForDescribeDBInstancesOutputNetworkMaintaining is a EnumOfInstanceStatusForDescribeDBInstancesOutput enum value
	EnumOfInstanceStatusForDescribeDBInstancesOutputNetworkMaintaining = "NetworkMaintaining"

	// EnumOfInstanceStatusForDescribeDBInstancesOutputTdemaintaining is a EnumOfInstanceStatusForDescribeDBInstancesOutput enum value
	EnumOfInstanceStatusForDescribeDBInstancesOutputTdemaintaining = "TDEMaintaining"

	// EnumOfInstanceStatusForDescribeDBInstancesOutputSslupdating is a EnumOfInstanceStatusForDescribeDBInstancesOutput enum value
	EnumOfInstanceStatusForDescribeDBInstancesOutputSslupdating = "SSLUpdating"

	// EnumOfInstanceStatusForDescribeDBInstancesOutputSwitchMastering is a EnumOfInstanceStatusForDescribeDBInstancesOutput enum value
	EnumOfInstanceStatusForDescribeDBInstancesOutputSwitchMastering = "SwitchMastering"

	// EnumOfInstanceStatusForDescribeDBInstancesOutputTemporary is a EnumOfInstanceStatusForDescribeDBInstancesOutput enum value
	EnumOfInstanceStatusForDescribeDBInstancesOutputTemporary = "Temporary"
)

const (
	// EnumOfInstanceTypeForDescribeDBInstancesInputReplicaSet is a EnumOfInstanceTypeForDescribeDBInstancesInput enum value
	EnumOfInstanceTypeForDescribeDBInstancesInputReplicaSet = "ReplicaSet"

	// EnumOfInstanceTypeForDescribeDBInstancesInputShardedCluster is a EnumOfInstanceTypeForDescribeDBInstancesInput enum value
	EnumOfInstanceTypeForDescribeDBInstancesInputShardedCluster = "ShardedCluster"
)

const (
	// EnumOfInstanceTypeForDescribeDBInstancesOutputReplicaSet is a EnumOfInstanceTypeForDescribeDBInstancesOutput enum value
	EnumOfInstanceTypeForDescribeDBInstancesOutputReplicaSet = "ReplicaSet"

	// EnumOfInstanceTypeForDescribeDBInstancesOutputShardedCluster is a EnumOfInstanceTypeForDescribeDBInstancesOutput enum value
	EnumOfInstanceTypeForDescribeDBInstancesOutputShardedCluster = "ShardedCluster"
)

const (
	// EnumOfStorageTypeForDescribeDBInstancesOutputLocalSsd is a EnumOfStorageTypeForDescribeDBInstancesOutput enum value
	EnumOfStorageTypeForDescribeDBInstancesOutputLocalSsd = "LocalSSD"

	// EnumOfStorageTypeForDescribeDBInstancesOutputLocalHdd is a EnumOfStorageTypeForDescribeDBInstancesOutput enum value
	EnumOfStorageTypeForDescribeDBInstancesOutputLocalHdd = "LocalHDD"

	// EnumOfStorageTypeForDescribeDBInstancesOutputEssdFlexPl is a EnumOfStorageTypeForDescribeDBInstancesOutput enum value
	EnumOfStorageTypeForDescribeDBInstancesOutputEssdFlexPl = "ESSD_FlexPL"

	// EnumOfStorageTypeForDescribeDBInstancesOutputEssdPl0 is a EnumOfStorageTypeForDescribeDBInstancesOutput enum value
	EnumOfStorageTypeForDescribeDBInstancesOutputEssdPl0 = "ESSD_PL0"

	// EnumOfStorageTypeForDescribeDBInstancesOutputEssdPl1 is a EnumOfStorageTypeForDescribeDBInstancesOutput enum value
	EnumOfStorageTypeForDescribeDBInstancesOutputEssdPl1 = "ESSD_PL1"

	// EnumOfStorageTypeForDescribeDBInstancesOutputEssdPl2 is a EnumOfStorageTypeForDescribeDBInstancesOutput enum value
	EnumOfStorageTypeForDescribeDBInstancesOutputEssdPl2 = "ESSD_PL2"

	// EnumOfStorageTypeForDescribeDBInstancesOutputEssd is a EnumOfStorageTypeForDescribeDBInstancesOutput enum value
	EnumOfStorageTypeForDescribeDBInstancesOutputEssd = "ESSD"
)
