// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package mcs

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opGetRiskCommon = "GetRisk"

// GetRiskCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the GetRiskCommon operation. The "output" return
// value will be populated with the GetRiskCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned GetRiskCommon Request to send the API call to the service.
// the "output" return value is not valid until after GetRiskCommon Send returns without error.
//
// See GetRiskCommon for more information on using the GetRiskCommon
// API call, and error handling.
//
//    // Example sending a request using the GetRiskCommonRequest method.
//    req, resp := client.GetRiskCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MCS) GetRiskCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opGetRiskCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// GetRiskCommon API operation for MCS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for MCS's
// API operation GetRiskCommon for usage and error information.
func (c *MCS) GetRiskCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.GetRiskCommonRequest(input)
	return out, req.Send()
}

// GetRiskCommonWithContext is the same as GetRiskCommon with the addition of
// the ability to pass a context and additional request options.
//
// See GetRiskCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MCS) GetRiskCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.GetRiskCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRisk = "GetRisk"

// GetRiskRequest generates a "volcengine/request.Request" representing the
// client's request for the GetRisk operation. The "output" return
// value will be populated with the GetRiskCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned GetRiskCommon Request to send the API call to the service.
// the "output" return value is not valid until after GetRiskCommon Send returns without error.
//
// See GetRisk for more information on using the GetRisk
// API call, and error handling.
//
//    // Example sending a request using the GetRiskRequest method.
//    req, resp := client.GetRiskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MCS) GetRiskRequest(input *GetRiskInput) (req *request.Request, output *GetRiskOutput) {
	op := &request.Operation{
		Name:       opGetRisk,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRiskInput{}
	}

	output = &GetRiskOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// GetRisk API operation for MCS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for MCS's
// API operation GetRisk for usage and error information.
func (c *MCS) GetRisk(input *GetRiskInput) (*GetRiskOutput, error) {
	req, out := c.GetRiskRequest(input)
	return out, req.Send()
}

// GetRiskWithContext is the same as GetRisk with the addition of
// the ability to pass a context and additional request options.
//
// See GetRisk for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MCS) GetRiskWithContext(ctx volcengine.Context, input *GetRiskInput, opts ...request.Option) (*GetRiskOutput, error) {
	req, out := c.GetRiskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AffectedResourceForGetRiskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AssetCreatedTimeMilli *int64 `type:"int64" json:",omitempty"`

	BusinessTagIDs []*string `type:"list" json:",omitempty"`

	CloudAccountName *string `type:"string" json:",omitempty"`

	CloudAccountUID *string `type:"string" json:",omitempty"`

	CloudAssetID *string `type:"string" json:",omitempty"`

	CloudAssetName *string `type:"string" json:",omitempty"`

	CloudAssetProductType *string `type:"string" json:",omitempty"`

	CloudAssetType *string `type:"string" json:",omitempty" enum:"EnumOfCloudAssetTypeForGetRiskOutput"`

	CloudVendor *string `type:"string" json:",omitempty"`

	RecordUUID *string `type:"string" json:",omitempty"`

	SecuritySituationTagIDs []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s AffectedResourceForGetRiskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AffectedResourceForGetRiskOutput) GoString() string {
	return s.String()
}

// SetAssetCreatedTimeMilli sets the AssetCreatedTimeMilli field's value.
func (s *AffectedResourceForGetRiskOutput) SetAssetCreatedTimeMilli(v int64) *AffectedResourceForGetRiskOutput {
	s.AssetCreatedTimeMilli = &v
	return s
}

// SetBusinessTagIDs sets the BusinessTagIDs field's value.
func (s *AffectedResourceForGetRiskOutput) SetBusinessTagIDs(v []*string) *AffectedResourceForGetRiskOutput {
	s.BusinessTagIDs = v
	return s
}

// SetCloudAccountName sets the CloudAccountName field's value.
func (s *AffectedResourceForGetRiskOutput) SetCloudAccountName(v string) *AffectedResourceForGetRiskOutput {
	s.CloudAccountName = &v
	return s
}

// SetCloudAccountUID sets the CloudAccountUID field's value.
func (s *AffectedResourceForGetRiskOutput) SetCloudAccountUID(v string) *AffectedResourceForGetRiskOutput {
	s.CloudAccountUID = &v
	return s
}

// SetCloudAssetID sets the CloudAssetID field's value.
func (s *AffectedResourceForGetRiskOutput) SetCloudAssetID(v string) *AffectedResourceForGetRiskOutput {
	s.CloudAssetID = &v
	return s
}

// SetCloudAssetName sets the CloudAssetName field's value.
func (s *AffectedResourceForGetRiskOutput) SetCloudAssetName(v string) *AffectedResourceForGetRiskOutput {
	s.CloudAssetName = &v
	return s
}

// SetCloudAssetProductType sets the CloudAssetProductType field's value.
func (s *AffectedResourceForGetRiskOutput) SetCloudAssetProductType(v string) *AffectedResourceForGetRiskOutput {
	s.CloudAssetProductType = &v
	return s
}

// SetCloudAssetType sets the CloudAssetType field's value.
func (s *AffectedResourceForGetRiskOutput) SetCloudAssetType(v string) *AffectedResourceForGetRiskOutput {
	s.CloudAssetType = &v
	return s
}

// SetCloudVendor sets the CloudVendor field's value.
func (s *AffectedResourceForGetRiskOutput) SetCloudVendor(v string) *AffectedResourceForGetRiskOutput {
	s.CloudVendor = &v
	return s
}

// SetRecordUUID sets the RecordUUID field's value.
func (s *AffectedResourceForGetRiskOutput) SetRecordUUID(v string) *AffectedResourceForGetRiskOutput {
	s.RecordUUID = &v
	return s
}

// SetSecuritySituationTagIDs sets the SecuritySituationTagIDs field's value.
func (s *AffectedResourceForGetRiskOutput) SetSecuritySituationTagIDs(v []*string) *AffectedResourceForGetRiskOutput {
	s.SecuritySituationTagIDs = v
	return s
}

type AssociatedCveForGetRiskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Desc *string `type:"string" json:",omitempty"`

	ID *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s AssociatedCveForGetRiskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociatedCveForGetRiskOutput) GoString() string {
	return s.String()
}

// SetDesc sets the Desc field's value.
func (s *AssociatedCveForGetRiskOutput) SetDesc(v string) *AssociatedCveForGetRiskOutput {
	s.Desc = &v
	return s
}

// SetID sets the ID field's value.
func (s *AssociatedCveForGetRiskOutput) SetID(v string) *AssociatedCveForGetRiskOutput {
	s.ID = &v
	return s
}

type ContainerEnvForGetRiskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ClusterID *string `type:"string" json:",omitempty"`

	ClusterName *string `type:"string" json:",omitempty"`

	ContainerGroupID *string `type:"string" json:",omitempty"`

	ContainerGroupName *string `type:"string" json:",omitempty"`

	ContainerID *string `type:"string" json:",omitempty"`

	ContainerName *string `type:"string" json:",omitempty"`

	NodeID *string `type:"string" json:",omitempty"`

	NodeName *string `type:"string" json:",omitempty"`

	NodePoolID *string `type:"string" json:",omitempty"`

	NodePoolName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ContainerEnvForGetRiskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ContainerEnvForGetRiskOutput) GoString() string {
	return s.String()
}

// SetClusterID sets the ClusterID field's value.
func (s *ContainerEnvForGetRiskOutput) SetClusterID(v string) *ContainerEnvForGetRiskOutput {
	s.ClusterID = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *ContainerEnvForGetRiskOutput) SetClusterName(v string) *ContainerEnvForGetRiskOutput {
	s.ClusterName = &v
	return s
}

// SetContainerGroupID sets the ContainerGroupID field's value.
func (s *ContainerEnvForGetRiskOutput) SetContainerGroupID(v string) *ContainerEnvForGetRiskOutput {
	s.ContainerGroupID = &v
	return s
}

// SetContainerGroupName sets the ContainerGroupName field's value.
func (s *ContainerEnvForGetRiskOutput) SetContainerGroupName(v string) *ContainerEnvForGetRiskOutput {
	s.ContainerGroupName = &v
	return s
}

// SetContainerID sets the ContainerID field's value.
func (s *ContainerEnvForGetRiskOutput) SetContainerID(v string) *ContainerEnvForGetRiskOutput {
	s.ContainerID = &v
	return s
}

// SetContainerName sets the ContainerName field's value.
func (s *ContainerEnvForGetRiskOutput) SetContainerName(v string) *ContainerEnvForGetRiskOutput {
	s.ContainerName = &v
	return s
}

// SetNodeID sets the NodeID field's value.
func (s *ContainerEnvForGetRiskOutput) SetNodeID(v string) *ContainerEnvForGetRiskOutput {
	s.NodeID = &v
	return s
}

// SetNodeName sets the NodeName field's value.
func (s *ContainerEnvForGetRiskOutput) SetNodeName(v string) *ContainerEnvForGetRiskOutput {
	s.NodeName = &v
	return s
}

// SetNodePoolID sets the NodePoolID field's value.
func (s *ContainerEnvForGetRiskOutput) SetNodePoolID(v string) *ContainerEnvForGetRiskOutput {
	s.NodePoolID = &v
	return s
}

// SetNodePoolName sets the NodePoolName field's value.
func (s *ContainerEnvForGetRiskOutput) SetNodePoolName(v string) *ContainerEnvForGetRiskOutput {
	s.NodePoolName = &v
	return s
}

type FileForGetRiskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CreateTimeNano *int64 `type:"int64" json:",omitempty"`

	Md5 *string `type:"string" json:",omitempty"`

	ModifiedTimeNano *int64 `type:"int64" json:",omitempty"`

	Owner *OwnerForGetRiskOutput `type:"structure" json:",omitempty"`

	Path *string `type:"string" json:",omitempty"`

	Sha1 *string `type:"string" json:",omitempty"`

	Sha256 *string `type:"string" json:",omitempty"`

	Size *int64 `type:"int64" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s FileForGetRiskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FileForGetRiskOutput) GoString() string {
	return s.String()
}

// SetCreateTimeNano sets the CreateTimeNano field's value.
func (s *FileForGetRiskOutput) SetCreateTimeNano(v int64) *FileForGetRiskOutput {
	s.CreateTimeNano = &v
	return s
}

// SetMd5 sets the Md5 field's value.
func (s *FileForGetRiskOutput) SetMd5(v string) *FileForGetRiskOutput {
	s.Md5 = &v
	return s
}

// SetModifiedTimeNano sets the ModifiedTimeNano field's value.
func (s *FileForGetRiskOutput) SetModifiedTimeNano(v int64) *FileForGetRiskOutput {
	s.ModifiedTimeNano = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *FileForGetRiskOutput) SetOwner(v *OwnerForGetRiskOutput) *FileForGetRiskOutput {
	s.Owner = v
	return s
}

// SetPath sets the Path field's value.
func (s *FileForGetRiskOutput) SetPath(v string) *FileForGetRiskOutput {
	s.Path = &v
	return s
}

// SetSha1 sets the Sha1 field's value.
func (s *FileForGetRiskOutput) SetSha1(v string) *FileForGetRiskOutput {
	s.Sha1 = &v
	return s
}

// SetSha256 sets the Sha256 field's value.
func (s *FileForGetRiskOutput) SetSha256(v string) *FileForGetRiskOutput {
	s.Sha256 = &v
	return s
}

// SetSize sets the Size field's value.
func (s *FileForGetRiskOutput) SetSize(v int64) *FileForGetRiskOutput {
	s.Size = &v
	return s
}

// SetType sets the Type field's value.
func (s *FileForGetRiskOutput) SetType(v string) *FileForGetRiskOutput {
	s.Type = &v
	return s
}

type GetRiskInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// RiskID is a required field
	RiskID *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s GetRiskInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRiskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRiskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRiskInput"}
	if s.RiskID == nil {
		invalidParams.Add(request.NewErrParamRequired("RiskID"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRiskID sets the RiskID field's value.
func (s *GetRiskInput) SetRiskID(v string) *GetRiskInput {
	s.RiskID = &v
	return s
}

type GetRiskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	AffectAssetCount *int64 `type:"int64" json:",omitempty"`

	ReferenceData *ReferenceDataForGetRiskOutput `type:"structure" json:",omitempty"`

	RepairProposalType *string `type:"string" json:",omitempty"`

	RiskBaseInfo *RiskBaseInfoForGetRiskOutput `type:"structure" json:",omitempty"`

	Strategy *StrategyForGetRiskOutput `type:"structure" json:",omitempty"`

	StrategyRiskResourceConfigInfos []*StrategyRiskResourceConfigInfoForGetRiskOutput `type:"list" json:",omitempty"`

	Vuln *VulnForGetRiskOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s GetRiskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRiskOutput) GoString() string {
	return s.String()
}

// SetAffectAssetCount sets the AffectAssetCount field's value.
func (s *GetRiskOutput) SetAffectAssetCount(v int64) *GetRiskOutput {
	s.AffectAssetCount = &v
	return s
}

// SetReferenceData sets the ReferenceData field's value.
func (s *GetRiskOutput) SetReferenceData(v *ReferenceDataForGetRiskOutput) *GetRiskOutput {
	s.ReferenceData = v
	return s
}

// SetRepairProposalType sets the RepairProposalType field's value.
func (s *GetRiskOutput) SetRepairProposalType(v string) *GetRiskOutput {
	s.RepairProposalType = &v
	return s
}

// SetRiskBaseInfo sets the RiskBaseInfo field's value.
func (s *GetRiskOutput) SetRiskBaseInfo(v *RiskBaseInfoForGetRiskOutput) *GetRiskOutput {
	s.RiskBaseInfo = v
	return s
}

// SetStrategy sets the Strategy field's value.
func (s *GetRiskOutput) SetStrategy(v *StrategyForGetRiskOutput) *GetRiskOutput {
	s.Strategy = v
	return s
}

// SetStrategyRiskResourceConfigInfos sets the StrategyRiskResourceConfigInfos field's value.
func (s *GetRiskOutput) SetStrategyRiskResourceConfigInfos(v []*StrategyRiskResourceConfigInfoForGetRiskOutput) *GetRiskOutput {
	s.StrategyRiskResourceConfigInfos = v
	return s
}

// SetVuln sets the Vuln field's value.
func (s *GetRiskOutput) SetVuln(v *VulnForGetRiskOutput) *GetRiskOutput {
	s.Vuln = v
	return s
}

type OSProcForGetRiskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CmdLine *string `type:"string" json:",omitempty"`

	CreateTimeNano *int64 `type:"int64" json:",omitempty"`

	File *FileForGetRiskOutput `type:"structure" json:",omitempty"`

	OSParentProcessID *string `type:"string" json:",omitempty"`

	OSProcessCred *string `type:"string" json:",omitempty"`

	OSProcessExecDir *string `type:"string" json:",omitempty"`

	OSProcessGroupID *string `type:"string" json:",omitempty"`

	OSProcessID *string `type:"string" json:",omitempty"`

	OSUser *OSUserForGetRiskOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s OSProcForGetRiskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OSProcForGetRiskOutput) GoString() string {
	return s.String()
}

// SetCmdLine sets the CmdLine field's value.
func (s *OSProcForGetRiskOutput) SetCmdLine(v string) *OSProcForGetRiskOutput {
	s.CmdLine = &v
	return s
}

// SetCreateTimeNano sets the CreateTimeNano field's value.
func (s *OSProcForGetRiskOutput) SetCreateTimeNano(v int64) *OSProcForGetRiskOutput {
	s.CreateTimeNano = &v
	return s
}

// SetFile sets the File field's value.
func (s *OSProcForGetRiskOutput) SetFile(v *FileForGetRiskOutput) *OSProcForGetRiskOutput {
	s.File = v
	return s
}

// SetOSParentProcessID sets the OSParentProcessID field's value.
func (s *OSProcForGetRiskOutput) SetOSParentProcessID(v string) *OSProcForGetRiskOutput {
	s.OSParentProcessID = &v
	return s
}

// SetOSProcessCred sets the OSProcessCred field's value.
func (s *OSProcForGetRiskOutput) SetOSProcessCred(v string) *OSProcForGetRiskOutput {
	s.OSProcessCred = &v
	return s
}

// SetOSProcessExecDir sets the OSProcessExecDir field's value.
func (s *OSProcForGetRiskOutput) SetOSProcessExecDir(v string) *OSProcForGetRiskOutput {
	s.OSProcessExecDir = &v
	return s
}

// SetOSProcessGroupID sets the OSProcessGroupID field's value.
func (s *OSProcForGetRiskOutput) SetOSProcessGroupID(v string) *OSProcForGetRiskOutput {
	s.OSProcessGroupID = &v
	return s
}

// SetOSProcessID sets the OSProcessID field's value.
func (s *OSProcForGetRiskOutput) SetOSProcessID(v string) *OSProcForGetRiskOutput {
	s.OSProcessID = &v
	return s
}

// SetOSUser sets the OSUser field's value.
func (s *OSProcForGetRiskOutput) SetOSUser(v *OSUserForGetRiskOutput) *OSProcForGetRiskOutput {
	s.OSUser = v
	return s
}

type OSUserForGetRiskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ID *string `type:"string" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s OSUserForGetRiskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OSUserForGetRiskOutput) GoString() string {
	return s.String()
}

// SetID sets the ID field's value.
func (s *OSUserForGetRiskOutput) SetID(v string) *OSUserForGetRiskOutput {
	s.ID = &v
	return s
}

// SetName sets the Name field's value.
func (s *OSUserForGetRiskOutput) SetName(v string) *OSUserForGetRiskOutput {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *OSUserForGetRiskOutput) SetType(v string) *OSUserForGetRiskOutput {
	s.Type = &v
	return s
}

type OwnerForGetRiskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ID *string `type:"string" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s OwnerForGetRiskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OwnerForGetRiskOutput) GoString() string {
	return s.String()
}

// SetID sets the ID field's value.
func (s *OwnerForGetRiskOutput) SetID(v string) *OwnerForGetRiskOutput {
	s.ID = &v
	return s
}

// SetName sets the Name field's value.
func (s *OwnerForGetRiskOutput) SetName(v string) *OwnerForGetRiskOutput {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *OwnerForGetRiskOutput) SetType(v string) *OwnerForGetRiskOutput {
	s.Type = &v
	return s
}

type PortRangeInfoForGetRiskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	PortEnd *int64 `type:"int64" json:",omitempty"`

	PortStart *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s PortRangeInfoForGetRiskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PortRangeInfoForGetRiskOutput) GoString() string {
	return s.String()
}

// SetPortEnd sets the PortEnd field's value.
func (s *PortRangeInfoForGetRiskOutput) SetPortEnd(v int64) *PortRangeInfoForGetRiskOutput {
	s.PortEnd = &v
	return s
}

// SetPortStart sets the PortStart field's value.
func (s *PortRangeInfoForGetRiskOutput) SetPortStart(v int64) *PortRangeInfoForGetRiskOutput {
	s.PortStart = &v
	return s
}

type ReferenceDataForGetRiskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	StrategyDBIngressMinimumACL *StrategyDBIngressMinimumACLForGetRiskOutput `type:"structure" json:",omitempty"`

	StrategyOSSBucketLimitAnonymousACL *StrategyOSSBucketLimitAnonymousACLForGetRiskOutput `type:"structure" json:",omitempty"`

	StrategyOSSBucketServerEncrypt *StrategyOSSBucketServerEncryptForGetRiskOutput `type:"structure" json:",omitempty"`

	StrategyOSSBucketVersionBakRecovery *StrategyOSSBucketVersionBakRecoveryForGetRiskOutput `type:"structure" json:",omitempty"`

	StrategySLBACLOpen *StrategySLBACLOpenForGetRiskOutput `type:"structure" json:",omitempty"`

	StrategySLBMinimumForwardStrategy *StrategySLBMinimumForwardStrategyForGetRiskOutput `type:"structure" json:",omitempty"`

	StrategySecurityGroupIngressMinimumACL *StrategySecurityGroupIngressMinimumACLForGetRiskOutput `type:"structure" json:",omitempty"`

	StrategyVMDefendBurstSolution *StrategyVMDefendBurstSolutionForGetRiskOutput `type:"structure" json:",omitempty"`

	StrategyVMIdentityAuthSSHKeyPair *StrategyVMIdentityAuthSSHKeyPairForGetRiskOutput `type:"structure" json:",omitempty"`

	StrategyVMSecurityGroupRuleLimitPortAccess *StrategyVMSecurityGroupRuleLimitPortAccessForGetRiskOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s ReferenceDataForGetRiskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ReferenceDataForGetRiskOutput) GoString() string {
	return s.String()
}

// SetStrategyDBIngressMinimumACL sets the StrategyDBIngressMinimumACL field's value.
func (s *ReferenceDataForGetRiskOutput) SetStrategyDBIngressMinimumACL(v *StrategyDBIngressMinimumACLForGetRiskOutput) *ReferenceDataForGetRiskOutput {
	s.StrategyDBIngressMinimumACL = v
	return s
}

// SetStrategyOSSBucketLimitAnonymousACL sets the StrategyOSSBucketLimitAnonymousACL field's value.
func (s *ReferenceDataForGetRiskOutput) SetStrategyOSSBucketLimitAnonymousACL(v *StrategyOSSBucketLimitAnonymousACLForGetRiskOutput) *ReferenceDataForGetRiskOutput {
	s.StrategyOSSBucketLimitAnonymousACL = v
	return s
}

// SetStrategyOSSBucketServerEncrypt sets the StrategyOSSBucketServerEncrypt field's value.
func (s *ReferenceDataForGetRiskOutput) SetStrategyOSSBucketServerEncrypt(v *StrategyOSSBucketServerEncryptForGetRiskOutput) *ReferenceDataForGetRiskOutput {
	s.StrategyOSSBucketServerEncrypt = v
	return s
}

// SetStrategyOSSBucketVersionBakRecovery sets the StrategyOSSBucketVersionBakRecovery field's value.
func (s *ReferenceDataForGetRiskOutput) SetStrategyOSSBucketVersionBakRecovery(v *StrategyOSSBucketVersionBakRecoveryForGetRiskOutput) *ReferenceDataForGetRiskOutput {
	s.StrategyOSSBucketVersionBakRecovery = v
	return s
}

// SetStrategySLBACLOpen sets the StrategySLBACLOpen field's value.
func (s *ReferenceDataForGetRiskOutput) SetStrategySLBACLOpen(v *StrategySLBACLOpenForGetRiskOutput) *ReferenceDataForGetRiskOutput {
	s.StrategySLBACLOpen = v
	return s
}

// SetStrategySLBMinimumForwardStrategy sets the StrategySLBMinimumForwardStrategy field's value.
func (s *ReferenceDataForGetRiskOutput) SetStrategySLBMinimumForwardStrategy(v *StrategySLBMinimumForwardStrategyForGetRiskOutput) *ReferenceDataForGetRiskOutput {
	s.StrategySLBMinimumForwardStrategy = v
	return s
}

// SetStrategySecurityGroupIngressMinimumACL sets the StrategySecurityGroupIngressMinimumACL field's value.
func (s *ReferenceDataForGetRiskOutput) SetStrategySecurityGroupIngressMinimumACL(v *StrategySecurityGroupIngressMinimumACLForGetRiskOutput) *ReferenceDataForGetRiskOutput {
	s.StrategySecurityGroupIngressMinimumACL = v
	return s
}

// SetStrategyVMDefendBurstSolution sets the StrategyVMDefendBurstSolution field's value.
func (s *ReferenceDataForGetRiskOutput) SetStrategyVMDefendBurstSolution(v *StrategyVMDefendBurstSolutionForGetRiskOutput) *ReferenceDataForGetRiskOutput {
	s.StrategyVMDefendBurstSolution = v
	return s
}

// SetStrategyVMIdentityAuthSSHKeyPair sets the StrategyVMIdentityAuthSSHKeyPair field's value.
func (s *ReferenceDataForGetRiskOutput) SetStrategyVMIdentityAuthSSHKeyPair(v *StrategyVMIdentityAuthSSHKeyPairForGetRiskOutput) *ReferenceDataForGetRiskOutput {
	s.StrategyVMIdentityAuthSSHKeyPair = v
	return s
}

// SetStrategyVMSecurityGroupRuleLimitPortAccess sets the StrategyVMSecurityGroupRuleLimitPortAccess field's value.
func (s *ReferenceDataForGetRiskOutput) SetStrategyVMSecurityGroupRuleLimitPortAccess(v *StrategyVMSecurityGroupRuleLimitPortAccessForGetRiskOutput) *ReferenceDataForGetRiskOutput {
	s.StrategyVMSecurityGroupRuleLimitPortAccess = v
	return s
}

type RiskBaseInfoForGetRiskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AffectedResource *AffectedResourceForGetRiskOutput `type:"structure" json:",omitempty"`

	LastDetectTimeMilli *int64 `type:"int64" json:",omitempty"`

	LastDiscoverTimeMilli *int64 `type:"int64" json:",omitempty"`

	ResourceStatus *string `type:"string" json:",omitempty" enum:"EnumOfResourceStatusForGetRiskOutput"`

	RiskExemptMeta *RiskExemptMetaForGetRiskOutput `type:"structure" json:",omitempty"`

	RiskID *string `type:"string" json:",omitempty"`

	RiskLevel *string `type:"string" json:",omitempty" enum:"EnumOfRiskLevelForGetRiskOutput"`

	RiskMetaID *string `type:"string" json:",omitempty"`

	RiskModelType *string `type:"string" json:",omitempty" enum:"EnumOfRiskModelTypeForGetRiskOutput"`

	RiskName *string `type:"string" json:",omitempty"`

	RiskProcessStatus *string `type:"string" json:",omitempty"`

	RiskStatus *string `type:"string" json:",omitempty" enum:"EnumOfRiskStatusForGetRiskOutput"`

	RiskTypes []*string `type:"list" json:",omitempty"`

	SupportRepair *bool `type:"boolean" json:",omitempty"`

	SupportVerify *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s RiskBaseInfoForGetRiskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RiskBaseInfoForGetRiskOutput) GoString() string {
	return s.String()
}

// SetAffectedResource sets the AffectedResource field's value.
func (s *RiskBaseInfoForGetRiskOutput) SetAffectedResource(v *AffectedResourceForGetRiskOutput) *RiskBaseInfoForGetRiskOutput {
	s.AffectedResource = v
	return s
}

// SetLastDetectTimeMilli sets the LastDetectTimeMilli field's value.
func (s *RiskBaseInfoForGetRiskOutput) SetLastDetectTimeMilli(v int64) *RiskBaseInfoForGetRiskOutput {
	s.LastDetectTimeMilli = &v
	return s
}

// SetLastDiscoverTimeMilli sets the LastDiscoverTimeMilli field's value.
func (s *RiskBaseInfoForGetRiskOutput) SetLastDiscoverTimeMilli(v int64) *RiskBaseInfoForGetRiskOutput {
	s.LastDiscoverTimeMilli = &v
	return s
}

// SetResourceStatus sets the ResourceStatus field's value.
func (s *RiskBaseInfoForGetRiskOutput) SetResourceStatus(v string) *RiskBaseInfoForGetRiskOutput {
	s.ResourceStatus = &v
	return s
}

// SetRiskExemptMeta sets the RiskExemptMeta field's value.
func (s *RiskBaseInfoForGetRiskOutput) SetRiskExemptMeta(v *RiskExemptMetaForGetRiskOutput) *RiskBaseInfoForGetRiskOutput {
	s.RiskExemptMeta = v
	return s
}

// SetRiskID sets the RiskID field's value.
func (s *RiskBaseInfoForGetRiskOutput) SetRiskID(v string) *RiskBaseInfoForGetRiskOutput {
	s.RiskID = &v
	return s
}

// SetRiskLevel sets the RiskLevel field's value.
func (s *RiskBaseInfoForGetRiskOutput) SetRiskLevel(v string) *RiskBaseInfoForGetRiskOutput {
	s.RiskLevel = &v
	return s
}

// SetRiskMetaID sets the RiskMetaID field's value.
func (s *RiskBaseInfoForGetRiskOutput) SetRiskMetaID(v string) *RiskBaseInfoForGetRiskOutput {
	s.RiskMetaID = &v
	return s
}

// SetRiskModelType sets the RiskModelType field's value.
func (s *RiskBaseInfoForGetRiskOutput) SetRiskModelType(v string) *RiskBaseInfoForGetRiskOutput {
	s.RiskModelType = &v
	return s
}

// SetRiskName sets the RiskName field's value.
func (s *RiskBaseInfoForGetRiskOutput) SetRiskName(v string) *RiskBaseInfoForGetRiskOutput {
	s.RiskName = &v
	return s
}

// SetRiskProcessStatus sets the RiskProcessStatus field's value.
func (s *RiskBaseInfoForGetRiskOutput) SetRiskProcessStatus(v string) *RiskBaseInfoForGetRiskOutput {
	s.RiskProcessStatus = &v
	return s
}

// SetRiskStatus sets the RiskStatus field's value.
func (s *RiskBaseInfoForGetRiskOutput) SetRiskStatus(v string) *RiskBaseInfoForGetRiskOutput {
	s.RiskStatus = &v
	return s
}

// SetRiskTypes sets the RiskTypes field's value.
func (s *RiskBaseInfoForGetRiskOutput) SetRiskTypes(v []*string) *RiskBaseInfoForGetRiskOutput {
	s.RiskTypes = v
	return s
}

// SetSupportRepair sets the SupportRepair field's value.
func (s *RiskBaseInfoForGetRiskOutput) SetSupportRepair(v bool) *RiskBaseInfoForGetRiskOutput {
	s.SupportRepair = &v
	return s
}

// SetSupportVerify sets the SupportVerify field's value.
func (s *RiskBaseInfoForGetRiskOutput) SetSupportVerify(v bool) *RiskBaseInfoForGetRiskOutput {
	s.SupportVerify = &v
	return s
}

type RiskExemptMetaForGetRiskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ExemptDesc *string `type:"string" json:",omitempty"`

	ExemptExpireTimeMilli *int64 `type:"int64" json:",omitempty"`

	ExemptReasonType *string `type:"string" json:",omitempty" enum:"EnumOfExemptReasonTypeForGetRiskOutput"`
}

// String returns the string representation
func (s RiskExemptMetaForGetRiskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RiskExemptMetaForGetRiskOutput) GoString() string {
	return s.String()
}

// SetExemptDesc sets the ExemptDesc field's value.
func (s *RiskExemptMetaForGetRiskOutput) SetExemptDesc(v string) *RiskExemptMetaForGetRiskOutput {
	s.ExemptDesc = &v
	return s
}

// SetExemptExpireTimeMilli sets the ExemptExpireTimeMilli field's value.
func (s *RiskExemptMetaForGetRiskOutput) SetExemptExpireTimeMilli(v int64) *RiskExemptMetaForGetRiskOutput {
	s.ExemptExpireTimeMilli = &v
	return s
}

// SetExemptReasonType sets the ExemptReasonType field's value.
func (s *RiskExemptMetaForGetRiskOutput) SetExemptReasonType(v string) *RiskExemptMetaForGetRiskOutput {
	s.ExemptReasonType = &v
	return s
}

type SLBAclGroupInfoForGetRiskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	IPCount *int64 `type:"int64" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Policy *string `type:"string" json:",omitempty" enum:"EnumOfPolicyForGetRiskOutput"`

	UID *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s SLBAclGroupInfoForGetRiskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SLBAclGroupInfoForGetRiskOutput) GoString() string {
	return s.String()
}

// SetIPCount sets the IPCount field's value.
func (s *SLBAclGroupInfoForGetRiskOutput) SetIPCount(v int64) *SLBAclGroupInfoForGetRiskOutput {
	s.IPCount = &v
	return s
}

// SetName sets the Name field's value.
func (s *SLBAclGroupInfoForGetRiskOutput) SetName(v string) *SLBAclGroupInfoForGetRiskOutput {
	s.Name = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *SLBAclGroupInfoForGetRiskOutput) SetPolicy(v string) *SLBAclGroupInfoForGetRiskOutput {
	s.Policy = &v
	return s
}

// SetUID sets the UID field's value.
func (s *SLBAclGroupInfoForGetRiskOutput) SetUID(v string) *SLBAclGroupInfoForGetRiskOutput {
	s.UID = &v
	return s
}

type SLBListenerInfoForGetRiskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AclGroupUIDs []*string `type:"list" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Port *int64 `type:"int64" json:",omitempty"`

	ProtocolType *string `type:"string" json:",omitempty" enum:"EnumOfProtocolTypeForGetRiskOutput"`

	UID *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s SLBListenerInfoForGetRiskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SLBListenerInfoForGetRiskOutput) GoString() string {
	return s.String()
}

// SetAclGroupUIDs sets the AclGroupUIDs field's value.
func (s *SLBListenerInfoForGetRiskOutput) SetAclGroupUIDs(v []*string) *SLBListenerInfoForGetRiskOutput {
	s.AclGroupUIDs = v
	return s
}

// SetName sets the Name field's value.
func (s *SLBListenerInfoForGetRiskOutput) SetName(v string) *SLBListenerInfoForGetRiskOutput {
	s.Name = &v
	return s
}

// SetPort sets the Port field's value.
func (s *SLBListenerInfoForGetRiskOutput) SetPort(v int64) *SLBListenerInfoForGetRiskOutput {
	s.Port = &v
	return s
}

// SetProtocolType sets the ProtocolType field's value.
func (s *SLBListenerInfoForGetRiskOutput) SetProtocolType(v string) *SLBListenerInfoForGetRiskOutput {
	s.ProtocolType = &v
	return s
}

// SetUID sets the UID field's value.
func (s *SLBListenerInfoForGetRiskOutput) SetUID(v string) *SLBListenerInfoForGetRiskOutput {
	s.UID = &v
	return s
}

type SSHKeyPairInfoForGetRiskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CreateTimeMilli *int64 `type:"int64" json:",omitempty"`

	FingerPrint *string `type:"string" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	UID *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s SSHKeyPairInfoForGetRiskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SSHKeyPairInfoForGetRiskOutput) GoString() string {
	return s.String()
}

// SetCreateTimeMilli sets the CreateTimeMilli field's value.
func (s *SSHKeyPairInfoForGetRiskOutput) SetCreateTimeMilli(v int64) *SSHKeyPairInfoForGetRiskOutput {
	s.CreateTimeMilli = &v
	return s
}

// SetFingerPrint sets the FingerPrint field's value.
func (s *SSHKeyPairInfoForGetRiskOutput) SetFingerPrint(v string) *SSHKeyPairInfoForGetRiskOutput {
	s.FingerPrint = &v
	return s
}

// SetName sets the Name field's value.
func (s *SSHKeyPairInfoForGetRiskOutput) SetName(v string) *SSHKeyPairInfoForGetRiskOutput {
	s.Name = &v
	return s
}

// SetUID sets the UID field's value.
func (s *SSHKeyPairInfoForGetRiskOutput) SetUID(v string) *SSHKeyPairInfoForGetRiskOutput {
	s.UID = &v
	return s
}

type SecurityGroupRuleInfoForGetRiskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Policy *string `type:"string" json:",omitempty" enum:"EnumOfPolicyForGetRiskOutput"`

	PortRangeInfos []*PortRangeInfoForGetRiskOutput `type:"list" json:",omitempty"`

	Priority *int64 `type:"int64" json:",omitempty"`

	ProtocolType *string `type:"string" json:",omitempty"`

	SecurityGroupName *string `type:"string" json:",omitempty"`

	SecurityGroupRuleUID *string `type:"string" json:",omitempty"`

	SecurityGroupUID *string `type:"string" json:",omitempty"`

	SerivceNameCN *string `type:"string" json:",omitempty"`

	SerivceNameEN *string `type:"string" json:",omitempty"`

	SrouceCidrIP *string `type:"string" json:",omitempty"`

	SrouceIPType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s SecurityGroupRuleInfoForGetRiskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SecurityGroupRuleInfoForGetRiskOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *SecurityGroupRuleInfoForGetRiskOutput) SetPolicy(v string) *SecurityGroupRuleInfoForGetRiskOutput {
	s.Policy = &v
	return s
}

// SetPortRangeInfos sets the PortRangeInfos field's value.
func (s *SecurityGroupRuleInfoForGetRiskOutput) SetPortRangeInfos(v []*PortRangeInfoForGetRiskOutput) *SecurityGroupRuleInfoForGetRiskOutput {
	s.PortRangeInfos = v
	return s
}

// SetPriority sets the Priority field's value.
func (s *SecurityGroupRuleInfoForGetRiskOutput) SetPriority(v int64) *SecurityGroupRuleInfoForGetRiskOutput {
	s.Priority = &v
	return s
}

// SetProtocolType sets the ProtocolType field's value.
func (s *SecurityGroupRuleInfoForGetRiskOutput) SetProtocolType(v string) *SecurityGroupRuleInfoForGetRiskOutput {
	s.ProtocolType = &v
	return s
}

// SetSecurityGroupName sets the SecurityGroupName field's value.
func (s *SecurityGroupRuleInfoForGetRiskOutput) SetSecurityGroupName(v string) *SecurityGroupRuleInfoForGetRiskOutput {
	s.SecurityGroupName = &v
	return s
}

// SetSecurityGroupRuleUID sets the SecurityGroupRuleUID field's value.
func (s *SecurityGroupRuleInfoForGetRiskOutput) SetSecurityGroupRuleUID(v string) *SecurityGroupRuleInfoForGetRiskOutput {
	s.SecurityGroupRuleUID = &v
	return s
}

// SetSecurityGroupUID sets the SecurityGroupUID field's value.
func (s *SecurityGroupRuleInfoForGetRiskOutput) SetSecurityGroupUID(v string) *SecurityGroupRuleInfoForGetRiskOutput {
	s.SecurityGroupUID = &v
	return s
}

// SetSerivceNameCN sets the SerivceNameCN field's value.
func (s *SecurityGroupRuleInfoForGetRiskOutput) SetSerivceNameCN(v string) *SecurityGroupRuleInfoForGetRiskOutput {
	s.SerivceNameCN = &v
	return s
}

// SetSerivceNameEN sets the SerivceNameEN field's value.
func (s *SecurityGroupRuleInfoForGetRiskOutput) SetSerivceNameEN(v string) *SecurityGroupRuleInfoForGetRiskOutput {
	s.SerivceNameEN = &v
	return s
}

// SetSrouceCidrIP sets the SrouceCidrIP field's value.
func (s *SecurityGroupRuleInfoForGetRiskOutput) SetSrouceCidrIP(v string) *SecurityGroupRuleInfoForGetRiskOutput {
	s.SrouceCidrIP = &v
	return s
}

// SetSrouceIPType sets the SrouceIPType field's value.
func (s *SecurityGroupRuleInfoForGetRiskOutput) SetSrouceIPType(v string) *SecurityGroupRuleInfoForGetRiskOutput {
	s.SrouceIPType = &v
	return s
}

type StrategyDBIngressMinimumACLForGetRiskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	SecurityGroupRuleInfos []*SecurityGroupRuleInfoForGetRiskOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s StrategyDBIngressMinimumACLForGetRiskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StrategyDBIngressMinimumACLForGetRiskOutput) GoString() string {
	return s.String()
}

// SetSecurityGroupRuleInfos sets the SecurityGroupRuleInfos field's value.
func (s *StrategyDBIngressMinimumACLForGetRiskOutput) SetSecurityGroupRuleInfos(v []*SecurityGroupRuleInfoForGetRiskOutput) *StrategyDBIngressMinimumACLForGetRiskOutput {
	s.SecurityGroupRuleInfos = v
	return s
}

type StrategyForGetRiskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AffectedResourceType *string `type:"string" json:",omitempty" enum:"EnumOfAffectedResourceTypeForGetRiskOutput"`

	ForceRepairActionName *string `type:"string" json:",omitempty"`

	ForceRepairActionUID *string `type:"string" json:",omitempty"`

	RepairAdvice *string `type:"string" json:",omitempty"`

	RepairSupportAutomation *string `type:"string" json:",omitempty" enum:"EnumOfRepairSupportAutomationForGetRiskOutput"`

	ResourceRiskStatus *string `type:"string" json:",omitempty" enum:"EnumOfResourceRiskStatusForGetRiskOutput"`

	StrategyCategories []*string `type:"list" json:",omitempty"`

	StrategyDesc *string `type:"string" json:",omitempty"`

	StrategyID *string `type:"string" json:",omitempty"`

	StrategyImpactType *string `type:"string" json:",omitempty"`

	StrategyTitle *string `type:"string" json:",omitempty"`

	StrategyType *string `type:"string" json:",omitempty" enum:"EnumOfStrategyTypeForGetRiskOutput"`

	SupportForceRepair *bool `type:"boolean" json:",omitempty"`

	TaskRunning *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s StrategyForGetRiskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StrategyForGetRiskOutput) GoString() string {
	return s.String()
}

// SetAffectedResourceType sets the AffectedResourceType field's value.
func (s *StrategyForGetRiskOutput) SetAffectedResourceType(v string) *StrategyForGetRiskOutput {
	s.AffectedResourceType = &v
	return s
}

// SetForceRepairActionName sets the ForceRepairActionName field's value.
func (s *StrategyForGetRiskOutput) SetForceRepairActionName(v string) *StrategyForGetRiskOutput {
	s.ForceRepairActionName = &v
	return s
}

// SetForceRepairActionUID sets the ForceRepairActionUID field's value.
func (s *StrategyForGetRiskOutput) SetForceRepairActionUID(v string) *StrategyForGetRiskOutput {
	s.ForceRepairActionUID = &v
	return s
}

// SetRepairAdvice sets the RepairAdvice field's value.
func (s *StrategyForGetRiskOutput) SetRepairAdvice(v string) *StrategyForGetRiskOutput {
	s.RepairAdvice = &v
	return s
}

// SetRepairSupportAutomation sets the RepairSupportAutomation field's value.
func (s *StrategyForGetRiskOutput) SetRepairSupportAutomation(v string) *StrategyForGetRiskOutput {
	s.RepairSupportAutomation = &v
	return s
}

// SetResourceRiskStatus sets the ResourceRiskStatus field's value.
func (s *StrategyForGetRiskOutput) SetResourceRiskStatus(v string) *StrategyForGetRiskOutput {
	s.ResourceRiskStatus = &v
	return s
}

// SetStrategyCategories sets the StrategyCategories field's value.
func (s *StrategyForGetRiskOutput) SetStrategyCategories(v []*string) *StrategyForGetRiskOutput {
	s.StrategyCategories = v
	return s
}

// SetStrategyDesc sets the StrategyDesc field's value.
func (s *StrategyForGetRiskOutput) SetStrategyDesc(v string) *StrategyForGetRiskOutput {
	s.StrategyDesc = &v
	return s
}

// SetStrategyID sets the StrategyID field's value.
func (s *StrategyForGetRiskOutput) SetStrategyID(v string) *StrategyForGetRiskOutput {
	s.StrategyID = &v
	return s
}

// SetStrategyImpactType sets the StrategyImpactType field's value.
func (s *StrategyForGetRiskOutput) SetStrategyImpactType(v string) *StrategyForGetRiskOutput {
	s.StrategyImpactType = &v
	return s
}

// SetStrategyTitle sets the StrategyTitle field's value.
func (s *StrategyForGetRiskOutput) SetStrategyTitle(v string) *StrategyForGetRiskOutput {
	s.StrategyTitle = &v
	return s
}

// SetStrategyType sets the StrategyType field's value.
func (s *StrategyForGetRiskOutput) SetStrategyType(v string) *StrategyForGetRiskOutput {
	s.StrategyType = &v
	return s
}

// SetSupportForceRepair sets the SupportForceRepair field's value.
func (s *StrategyForGetRiskOutput) SetSupportForceRepair(v bool) *StrategyForGetRiskOutput {
	s.SupportForceRepair = &v
	return s
}

// SetTaskRunning sets the TaskRunning field's value.
func (s *StrategyForGetRiskOutput) SetTaskRunning(v bool) *StrategyForGetRiskOutput {
	s.TaskRunning = &v
	return s
}

type StrategyOSSBucketLimitAnonymousACLForGetRiskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s StrategyOSSBucketLimitAnonymousACLForGetRiskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StrategyOSSBucketLimitAnonymousACLForGetRiskOutput) GoString() string {
	return s.String()
}

type StrategyOSSBucketServerEncryptForGetRiskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s StrategyOSSBucketServerEncryptForGetRiskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StrategyOSSBucketServerEncryptForGetRiskOutput) GoString() string {
	return s.String()
}

type StrategyOSSBucketVersionBakRecoveryForGetRiskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s StrategyOSSBucketVersionBakRecoveryForGetRiskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StrategyOSSBucketVersionBakRecoveryForGetRiskOutput) GoString() string {
	return s.String()
}

type StrategyRiskResourceConfigInfoForGetRiskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ResourceConfigType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s StrategyRiskResourceConfigInfoForGetRiskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StrategyRiskResourceConfigInfoForGetRiskOutput) GoString() string {
	return s.String()
}

// SetResourceConfigType sets the ResourceConfigType field's value.
func (s *StrategyRiskResourceConfigInfoForGetRiskOutput) SetResourceConfigType(v string) *StrategyRiskResourceConfigInfoForGetRiskOutput {
	s.ResourceConfigType = &v
	return s
}

type StrategySLBACLOpenForGetRiskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	SLBAclGroupInfos []*SLBAclGroupInfoForGetRiskOutput `type:"list" json:",omitempty"`

	SLBListenerInfos []*SLBListenerInfoForGetRiskOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s StrategySLBACLOpenForGetRiskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StrategySLBACLOpenForGetRiskOutput) GoString() string {
	return s.String()
}

// SetSLBAclGroupInfos sets the SLBAclGroupInfos field's value.
func (s *StrategySLBACLOpenForGetRiskOutput) SetSLBAclGroupInfos(v []*SLBAclGroupInfoForGetRiskOutput) *StrategySLBACLOpenForGetRiskOutput {
	s.SLBAclGroupInfos = v
	return s
}

// SetSLBListenerInfos sets the SLBListenerInfos field's value.
func (s *StrategySLBACLOpenForGetRiskOutput) SetSLBListenerInfos(v []*SLBListenerInfoForGetRiskOutput) *StrategySLBACLOpenForGetRiskOutput {
	s.SLBListenerInfos = v
	return s
}

type StrategySLBMinimumForwardStrategyForGetRiskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	SLBListenerInfos []*SLBListenerInfoForGetRiskOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s StrategySLBMinimumForwardStrategyForGetRiskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StrategySLBMinimumForwardStrategyForGetRiskOutput) GoString() string {
	return s.String()
}

// SetSLBListenerInfos sets the SLBListenerInfos field's value.
func (s *StrategySLBMinimumForwardStrategyForGetRiskOutput) SetSLBListenerInfos(v []*SLBListenerInfoForGetRiskOutput) *StrategySLBMinimumForwardStrategyForGetRiskOutput {
	s.SLBListenerInfos = v
	return s
}

type StrategySecurityGroupIngressMinimumACLForGetRiskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	SecurityGroupRuleInfos []*SecurityGroupRuleInfoForGetRiskOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s StrategySecurityGroupIngressMinimumACLForGetRiskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StrategySecurityGroupIngressMinimumACLForGetRiskOutput) GoString() string {
	return s.String()
}

// SetSecurityGroupRuleInfos sets the SecurityGroupRuleInfos field's value.
func (s *StrategySecurityGroupIngressMinimumACLForGetRiskOutput) SetSecurityGroupRuleInfos(v []*SecurityGroupRuleInfoForGetRiskOutput) *StrategySecurityGroupIngressMinimumACLForGetRiskOutput {
	s.SecurityGroupRuleInfos = v
	return s
}

type StrategyVMDefendBurstSolutionForGetRiskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s StrategyVMDefendBurstSolutionForGetRiskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StrategyVMDefendBurstSolutionForGetRiskOutput) GoString() string {
	return s.String()
}

type StrategyVMIdentityAuthSSHKeyPairForGetRiskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	SSHKeyPairInfos []*SSHKeyPairInfoForGetRiskOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s StrategyVMIdentityAuthSSHKeyPairForGetRiskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StrategyVMIdentityAuthSSHKeyPairForGetRiskOutput) GoString() string {
	return s.String()
}

// SetSSHKeyPairInfos sets the SSHKeyPairInfos field's value.
func (s *StrategyVMIdentityAuthSSHKeyPairForGetRiskOutput) SetSSHKeyPairInfos(v []*SSHKeyPairInfoForGetRiskOutput) *StrategyVMIdentityAuthSSHKeyPairForGetRiskOutput {
	s.SSHKeyPairInfos = v
	return s
}

type StrategyVMSecurityGroupRuleLimitPortAccessForGetRiskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	SecurityGroupRuleInfos []*SecurityGroupRuleInfoForGetRiskOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s StrategyVMSecurityGroupRuleLimitPortAccessForGetRiskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StrategyVMSecurityGroupRuleLimitPortAccessForGetRiskOutput) GoString() string {
	return s.String()
}

// SetSecurityGroupRuleInfos sets the SecurityGroupRuleInfos field's value.
func (s *StrategyVMSecurityGroupRuleLimitPortAccessForGetRiskOutput) SetSecurityGroupRuleInfos(v []*SecurityGroupRuleInfoForGetRiskOutput) *StrategyVMSecurityGroupRuleLimitPortAccessForGetRiskOutput {
	s.SecurityGroupRuleInfos = v
	return s
}

type VulnCvssForGetRiskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CvssScore *float64 `type:"double" json:",omitempty"`

	CvssVec *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s VulnCvssForGetRiskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s VulnCvssForGetRiskOutput) GoString() string {
	return s.String()
}

// SetCvssScore sets the CvssScore field's value.
func (s *VulnCvssForGetRiskOutput) SetCvssScore(v float64) *VulnCvssForGetRiskOutput {
	s.CvssScore = &v
	return s
}

// SetCvssVec sets the CvssVec field's value.
func (s *VulnCvssForGetRiskOutput) SetCvssVec(v string) *VulnCvssForGetRiskOutput {
	s.CvssVec = &v
	return s
}

type VulnForGetRiskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AffectedAssetsCnt *int64 `type:"int64" json:",omitempty"`

	ApplicableVendors []*string `type:"list" json:",omitempty"`

	AssociatedCves []*AssociatedCveForGetRiskOutput `type:"list" json:",omitempty"`

	AttachedResourceRiskStatus *string `type:"string" json:",omitempty" enum:"EnumOfAttachedResourceRiskStatusForGetRiskOutput"`

	VulnCategory *string `type:"string" json:",omitempty" enum:"EnumOfVulnCategoryForGetRiskOutput"`

	VulnCvss *VulnCvssForGetRiskOutput `type:"structure" json:",omitempty"`

	VulnDesc *string `type:"string" json:",omitempty"`

	VulnSolution *string `type:"string" json:",omitempty"`

	VulnTitle *string `type:"string" json:",omitempty"`

	VulnViewID *string `type:"string" json:",omitempty"`

	VulnerableSoftPackages []*VulnerableSoftPackageForGetRiskOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s VulnForGetRiskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s VulnForGetRiskOutput) GoString() string {
	return s.String()
}

// SetAffectedAssetsCnt sets the AffectedAssetsCnt field's value.
func (s *VulnForGetRiskOutput) SetAffectedAssetsCnt(v int64) *VulnForGetRiskOutput {
	s.AffectedAssetsCnt = &v
	return s
}

// SetApplicableVendors sets the ApplicableVendors field's value.
func (s *VulnForGetRiskOutput) SetApplicableVendors(v []*string) *VulnForGetRiskOutput {
	s.ApplicableVendors = v
	return s
}

// SetAssociatedCves sets the AssociatedCves field's value.
func (s *VulnForGetRiskOutput) SetAssociatedCves(v []*AssociatedCveForGetRiskOutput) *VulnForGetRiskOutput {
	s.AssociatedCves = v
	return s
}

// SetAttachedResourceRiskStatus sets the AttachedResourceRiskStatus field's value.
func (s *VulnForGetRiskOutput) SetAttachedResourceRiskStatus(v string) *VulnForGetRiskOutput {
	s.AttachedResourceRiskStatus = &v
	return s
}

// SetVulnCategory sets the VulnCategory field's value.
func (s *VulnForGetRiskOutput) SetVulnCategory(v string) *VulnForGetRiskOutput {
	s.VulnCategory = &v
	return s
}

// SetVulnCvss sets the VulnCvss field's value.
func (s *VulnForGetRiskOutput) SetVulnCvss(v *VulnCvssForGetRiskOutput) *VulnForGetRiskOutput {
	s.VulnCvss = v
	return s
}

// SetVulnDesc sets the VulnDesc field's value.
func (s *VulnForGetRiskOutput) SetVulnDesc(v string) *VulnForGetRiskOutput {
	s.VulnDesc = &v
	return s
}

// SetVulnSolution sets the VulnSolution field's value.
func (s *VulnForGetRiskOutput) SetVulnSolution(v string) *VulnForGetRiskOutput {
	s.VulnSolution = &v
	return s
}

// SetVulnTitle sets the VulnTitle field's value.
func (s *VulnForGetRiskOutput) SetVulnTitle(v string) *VulnForGetRiskOutput {
	s.VulnTitle = &v
	return s
}

// SetVulnViewID sets the VulnViewID field's value.
func (s *VulnForGetRiskOutput) SetVulnViewID(v string) *VulnForGetRiskOutput {
	s.VulnViewID = &v
	return s
}

// SetVulnerableSoftPackages sets the VulnerableSoftPackages field's value.
func (s *VulnForGetRiskOutput) SetVulnerableSoftPackages(v []*VulnerableSoftPackageForGetRiskOutput) *VulnForGetRiskOutput {
	s.VulnerableSoftPackages = v
	return s
}

type VulnerableSoftPackageForGetRiskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ContainerEnv *ContainerEnvForGetRiskOutput `type:"structure" json:",omitempty"`

	ImgID *string `type:"string" json:",omitempty"`

	ImgName *string `type:"string" json:",omitempty"`

	OSProc *OSProcForGetRiskOutput `type:"structure" json:",omitempty"`

	VulnPkgName *string `type:"string" json:",omitempty"`

	VulnPkgPath *string `type:"string" json:",omitempty"`

	VulnPkgVer *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s VulnerableSoftPackageForGetRiskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s VulnerableSoftPackageForGetRiskOutput) GoString() string {
	return s.String()
}

// SetContainerEnv sets the ContainerEnv field's value.
func (s *VulnerableSoftPackageForGetRiskOutput) SetContainerEnv(v *ContainerEnvForGetRiskOutput) *VulnerableSoftPackageForGetRiskOutput {
	s.ContainerEnv = v
	return s
}

// SetImgID sets the ImgID field's value.
func (s *VulnerableSoftPackageForGetRiskOutput) SetImgID(v string) *VulnerableSoftPackageForGetRiskOutput {
	s.ImgID = &v
	return s
}

// SetImgName sets the ImgName field's value.
func (s *VulnerableSoftPackageForGetRiskOutput) SetImgName(v string) *VulnerableSoftPackageForGetRiskOutput {
	s.ImgName = &v
	return s
}

// SetOSProc sets the OSProc field's value.
func (s *VulnerableSoftPackageForGetRiskOutput) SetOSProc(v *OSProcForGetRiskOutput) *VulnerableSoftPackageForGetRiskOutput {
	s.OSProc = v
	return s
}

// SetVulnPkgName sets the VulnPkgName field's value.
func (s *VulnerableSoftPackageForGetRiskOutput) SetVulnPkgName(v string) *VulnerableSoftPackageForGetRiskOutput {
	s.VulnPkgName = &v
	return s
}

// SetVulnPkgPath sets the VulnPkgPath field's value.
func (s *VulnerableSoftPackageForGetRiskOutput) SetVulnPkgPath(v string) *VulnerableSoftPackageForGetRiskOutput {
	s.VulnPkgPath = &v
	return s
}

// SetVulnPkgVer sets the VulnPkgVer field's value.
func (s *VulnerableSoftPackageForGetRiskOutput) SetVulnPkgVer(v string) *VulnerableSoftPackageForGetRiskOutput {
	s.VulnPkgVer = &v
	return s
}

const (
	// EnumOfAffectedResourceTypeForGetRiskOutputComputeVm is a EnumOfAffectedResourceTypeForGetRiskOutput enum value
	EnumOfAffectedResourceTypeForGetRiskOutputComputeVm = "ComputeVm"

	// EnumOfAffectedResourceTypeForGetRiskOutputK8scluster is a EnumOfAffectedResourceTypeForGetRiskOutput enum value
	EnumOfAffectedResourceTypeForGetRiskOutputK8scluster = "K8SCluster"

	// EnumOfAffectedResourceTypeForGetRiskOutputK8spod is a EnumOfAffectedResourceTypeForGetRiskOutput enum value
	EnumOfAffectedResourceTypeForGetRiskOutputK8spod = "K8SPOD"

	// EnumOfAffectedResourceTypeForGetRiskOutputK8scontainer is a EnumOfAffectedResourceTypeForGetRiskOutput enum value
	EnumOfAffectedResourceTypeForGetRiskOutputK8scontainer = "K8SContainer"

	// EnumOfAffectedResourceTypeForGetRiskOutputK8sapp is a EnumOfAffectedResourceTypeForGetRiskOutput enum value
	EnumOfAffectedResourceTypeForGetRiskOutputK8sapp = "K8SApp"

	// EnumOfAffectedResourceTypeForGetRiskOutputComputeCr is a EnumOfAffectedResourceTypeForGetRiskOutput enum value
	EnumOfAffectedResourceTypeForGetRiskOutputComputeCr = "ComputeCR"

	// EnumOfAffectedResourceTypeForGetRiskOutputNetworkSecurityGroup is a EnumOfAffectedResourceTypeForGetRiskOutput enum value
	EnumOfAffectedResourceTypeForGetRiskOutputNetworkSecurityGroup = "NetworkSecurityGroup"

	// EnumOfAffectedResourceTypeForGetRiskOutputNetworkSlb is a EnumOfAffectedResourceTypeForGetRiskOutput enum value
	EnumOfAffectedResourceTypeForGetRiskOutputNetworkSlb = "NetworkSlb"

	// EnumOfAffectedResourceTypeForGetRiskOutputNetworkVpc is a EnumOfAffectedResourceTypeForGetRiskOutput enum value
	EnumOfAffectedResourceTypeForGetRiskOutputNetworkVpc = "NetworkVpc"

	// EnumOfAffectedResourceTypeForGetRiskOutputNetworkSubnet is a EnumOfAffectedResourceTypeForGetRiskOutput enum value
	EnumOfAffectedResourceTypeForGetRiskOutputNetworkSubnet = "NetworkSubnet"

	// EnumOfAffectedResourceTypeForGetRiskOutputNetworkNatGateway is a EnumOfAffectedResourceTypeForGetRiskOutput enum value
	EnumOfAffectedResourceTypeForGetRiskOutputNetworkNatGateway = "NetworkNatGateway"

	// EnumOfAffectedResourceTypeForGetRiskOutputNetworkApigateway is a EnumOfAffectedResourceTypeForGetRiskOutput enum value
	EnumOfAffectedResourceTypeForGetRiskOutputNetworkApigateway = "NetworkAPIGateway"

	// EnumOfAffectedResourceTypeForGetRiskOutputNetworkEip is a EnumOfAffectedResourceTypeForGetRiskOutput enum value
	EnumOfAffectedResourceTypeForGetRiskOutputNetworkEip = "NetworkEip"

	// EnumOfAffectedResourceTypeForGetRiskOutputNetworkInterface is a EnumOfAffectedResourceTypeForGetRiskOutput enum value
	EnumOfAffectedResourceTypeForGetRiskOutputNetworkInterface = "NetworkInterface"

	// EnumOfAffectedResourceTypeForGetRiskOutputNetworkRouteTable is a EnumOfAffectedResourceTypeForGetRiskOutput enum value
	EnumOfAffectedResourceTypeForGetRiskOutputNetworkRouteTable = "NetworkRouteTable"

	// EnumOfAffectedResourceTypeForGetRiskOutputNetworkIpsecVpn is a EnumOfAffectedResourceTypeForGetRiskOutput enum value
	EnumOfAffectedResourceTypeForGetRiskOutputNetworkIpsecVpn = "NetworkIPSecVPN"

	// EnumOfAffectedResourceTypeForGetRiskOutputNetworkSslvpn is a EnumOfAffectedResourceTypeForGetRiskOutput enum value
	EnumOfAffectedResourceTypeForGetRiskOutputNetworkSslvpn = "NetworkSSLVPN"

	// EnumOfAffectedResourceTypeForGetRiskOutputNetworkDirectConnectGateway is a EnumOfAffectedResourceTypeForGetRiskOutput enum value
	EnumOfAffectedResourceTypeForGetRiskOutputNetworkDirectConnectGateway = "NetworkDirectConnectGateway"

	// EnumOfAffectedResourceTypeForGetRiskOutputNetworkCen is a EnumOfAffectedResourceTypeForGetRiskOutput enum value
	EnumOfAffectedResourceTypeForGetRiskOutputNetworkCen = "NetworkCEN"

	// EnumOfAffectedResourceTypeForGetRiskOutputStorageOssBucket is a EnumOfAffectedResourceTypeForGetRiskOutput enum value
	EnumOfAffectedResourceTypeForGetRiskOutputStorageOssBucket = "StorageOssBucket"

	// EnumOfAffectedResourceTypeForGetRiskOutputStorageDb is a EnumOfAffectedResourceTypeForGetRiskOutput enum value
	EnumOfAffectedResourceTypeForGetRiskOutputStorageDb = "StorageDB"

	// EnumOfAffectedResourceTypeForGetRiskOutputStorageVolume is a EnumOfAffectedResourceTypeForGetRiskOutput enum value
	EnumOfAffectedResourceTypeForGetRiskOutputStorageVolume = "StorageVolume"

	// EnumOfAffectedResourceTypeForGetRiskOutputIdentityIamAccount is a EnumOfAffectedResourceTypeForGetRiskOutput enum value
	EnumOfAffectedResourceTypeForGetRiskOutputIdentityIamAccount = "IdentityIamAccount"

	// EnumOfAffectedResourceTypeForGetRiskOutputComputeMseregistryCenter is a EnumOfAffectedResourceTypeForGetRiskOutput enum value
	EnumOfAffectedResourceTypeForGetRiskOutputComputeMseregistryCenter = "ComputeMSERegistryCenter"

	// EnumOfAffectedResourceTypeForGetRiskOutputComputeMsegateway is a EnumOfAffectedResourceTypeForGetRiskOutput enum value
	EnumOfAffectedResourceTypeForGetRiskOutputComputeMsegateway = "ComputeMSEGateway"

	// EnumOfAffectedResourceTypeForGetRiskOutputMqinstance is a EnumOfAffectedResourceTypeForGetRiskOutput enum value
	EnumOfAffectedResourceTypeForGetRiskOutputMqinstance = "MQInstance"
)

const (
	// EnumOfAttachedResourceRiskStatusForGetRiskOutputNotDetected is a EnumOfAttachedResourceRiskStatusForGetRiskOutput enum value
	EnumOfAttachedResourceRiskStatusForGetRiskOutputNotDetected = "not_detected"

	// EnumOfAttachedResourceRiskStatusForGetRiskOutputPassed is a EnumOfAttachedResourceRiskStatusForGetRiskOutput enum value
	EnumOfAttachedResourceRiskStatusForGetRiskOutputPassed = "passed"

	// EnumOfAttachedResourceRiskStatusForGetRiskOutputNotPassed is a EnumOfAttachedResourceRiskStatusForGetRiskOutput enum value
	EnumOfAttachedResourceRiskStatusForGetRiskOutputNotPassed = "not_passed"

	// EnumOfAttachedResourceRiskStatusForGetRiskOutputExempted is a EnumOfAttachedResourceRiskStatusForGetRiskOutput enum value
	EnumOfAttachedResourceRiskStatusForGetRiskOutputExempted = "exempted"

	// EnumOfAttachedResourceRiskStatusForGetRiskOutputVerifying is a EnumOfAttachedResourceRiskStatusForGetRiskOutput enum value
	EnumOfAttachedResourceRiskStatusForGetRiskOutputVerifying = "verifying"

	// EnumOfAttachedResourceRiskStatusForGetRiskOutputFixing is a EnumOfAttachedResourceRiskStatusForGetRiskOutput enum value
	EnumOfAttachedResourceRiskStatusForGetRiskOutputFixing = "fixing"
)

const (
	// EnumOfCloudAssetTypeForGetRiskOutputComputeVm is a EnumOfCloudAssetTypeForGetRiskOutput enum value
	EnumOfCloudAssetTypeForGetRiskOutputComputeVm = "ComputeVm"

	// EnumOfCloudAssetTypeForGetRiskOutputK8scluster is a EnumOfCloudAssetTypeForGetRiskOutput enum value
	EnumOfCloudAssetTypeForGetRiskOutputK8scluster = "K8SCluster"

	// EnumOfCloudAssetTypeForGetRiskOutputK8spod is a EnumOfCloudAssetTypeForGetRiskOutput enum value
	EnumOfCloudAssetTypeForGetRiskOutputK8spod = "K8SPOD"

	// EnumOfCloudAssetTypeForGetRiskOutputK8scontainer is a EnumOfCloudAssetTypeForGetRiskOutput enum value
	EnumOfCloudAssetTypeForGetRiskOutputK8scontainer = "K8SContainer"

	// EnumOfCloudAssetTypeForGetRiskOutputK8sapp is a EnumOfCloudAssetTypeForGetRiskOutput enum value
	EnumOfCloudAssetTypeForGetRiskOutputK8sapp = "K8SApp"

	// EnumOfCloudAssetTypeForGetRiskOutputComputeCr is a EnumOfCloudAssetTypeForGetRiskOutput enum value
	EnumOfCloudAssetTypeForGetRiskOutputComputeCr = "ComputeCR"

	// EnumOfCloudAssetTypeForGetRiskOutputNetworkSecurityGroup is a EnumOfCloudAssetTypeForGetRiskOutput enum value
	EnumOfCloudAssetTypeForGetRiskOutputNetworkSecurityGroup = "NetworkSecurityGroup"

	// EnumOfCloudAssetTypeForGetRiskOutputNetworkSlb is a EnumOfCloudAssetTypeForGetRiskOutput enum value
	EnumOfCloudAssetTypeForGetRiskOutputNetworkSlb = "NetworkSlb"

	// EnumOfCloudAssetTypeForGetRiskOutputNetworkVpc is a EnumOfCloudAssetTypeForGetRiskOutput enum value
	EnumOfCloudAssetTypeForGetRiskOutputNetworkVpc = "NetworkVpc"

	// EnumOfCloudAssetTypeForGetRiskOutputNetworkSubnet is a EnumOfCloudAssetTypeForGetRiskOutput enum value
	EnumOfCloudAssetTypeForGetRiskOutputNetworkSubnet = "NetworkSubnet"

	// EnumOfCloudAssetTypeForGetRiskOutputNetworkNatGateway is a EnumOfCloudAssetTypeForGetRiskOutput enum value
	EnumOfCloudAssetTypeForGetRiskOutputNetworkNatGateway = "NetworkNatGateway"

	// EnumOfCloudAssetTypeForGetRiskOutputNetworkApigateway is a EnumOfCloudAssetTypeForGetRiskOutput enum value
	EnumOfCloudAssetTypeForGetRiskOutputNetworkApigateway = "NetworkAPIGateway"

	// EnumOfCloudAssetTypeForGetRiskOutputNetworkEip is a EnumOfCloudAssetTypeForGetRiskOutput enum value
	EnumOfCloudAssetTypeForGetRiskOutputNetworkEip = "NetworkEip"

	// EnumOfCloudAssetTypeForGetRiskOutputNetworkInterface is a EnumOfCloudAssetTypeForGetRiskOutput enum value
	EnumOfCloudAssetTypeForGetRiskOutputNetworkInterface = "NetworkInterface"

	// EnumOfCloudAssetTypeForGetRiskOutputNetworkRouteTable is a EnumOfCloudAssetTypeForGetRiskOutput enum value
	EnumOfCloudAssetTypeForGetRiskOutputNetworkRouteTable = "NetworkRouteTable"

	// EnumOfCloudAssetTypeForGetRiskOutputNetworkIpsecVpn is a EnumOfCloudAssetTypeForGetRiskOutput enum value
	EnumOfCloudAssetTypeForGetRiskOutputNetworkIpsecVpn = "NetworkIPSecVPN"

	// EnumOfCloudAssetTypeForGetRiskOutputNetworkSslvpn is a EnumOfCloudAssetTypeForGetRiskOutput enum value
	EnumOfCloudAssetTypeForGetRiskOutputNetworkSslvpn = "NetworkSSLVPN"

	// EnumOfCloudAssetTypeForGetRiskOutputNetworkDirectConnectGateway is a EnumOfCloudAssetTypeForGetRiskOutput enum value
	EnumOfCloudAssetTypeForGetRiskOutputNetworkDirectConnectGateway = "NetworkDirectConnectGateway"

	// EnumOfCloudAssetTypeForGetRiskOutputNetworkCen is a EnumOfCloudAssetTypeForGetRiskOutput enum value
	EnumOfCloudAssetTypeForGetRiskOutputNetworkCen = "NetworkCEN"

	// EnumOfCloudAssetTypeForGetRiskOutputStorageOssBucket is a EnumOfCloudAssetTypeForGetRiskOutput enum value
	EnumOfCloudAssetTypeForGetRiskOutputStorageOssBucket = "StorageOssBucket"

	// EnumOfCloudAssetTypeForGetRiskOutputStorageDb is a EnumOfCloudAssetTypeForGetRiskOutput enum value
	EnumOfCloudAssetTypeForGetRiskOutputStorageDb = "StorageDB"

	// EnumOfCloudAssetTypeForGetRiskOutputStorageVolume is a EnumOfCloudAssetTypeForGetRiskOutput enum value
	EnumOfCloudAssetTypeForGetRiskOutputStorageVolume = "StorageVolume"

	// EnumOfCloudAssetTypeForGetRiskOutputIdentityIamAccount is a EnumOfCloudAssetTypeForGetRiskOutput enum value
	EnumOfCloudAssetTypeForGetRiskOutputIdentityIamAccount = "IdentityIamAccount"

	// EnumOfCloudAssetTypeForGetRiskOutputComputeMseregistryCenter is a EnumOfCloudAssetTypeForGetRiskOutput enum value
	EnumOfCloudAssetTypeForGetRiskOutputComputeMseregistryCenter = "ComputeMSERegistryCenter"

	// EnumOfCloudAssetTypeForGetRiskOutputComputeMsegateway is a EnumOfCloudAssetTypeForGetRiskOutput enum value
	EnumOfCloudAssetTypeForGetRiskOutputComputeMsegateway = "ComputeMSEGateway"

	// EnumOfCloudAssetTypeForGetRiskOutputMqinstance is a EnumOfCloudAssetTypeForGetRiskOutput enum value
	EnumOfCloudAssetTypeForGetRiskOutputMqinstance = "MQInstance"
)

const (
	// EnumOfExemptReasonTypeForGetRiskOutputReasonTypeIgnored is a EnumOfExemptReasonTypeForGetRiskOutput enum value
	EnumOfExemptReasonTypeForGetRiskOutputReasonTypeIgnored = "reason_type_ignored"

	// EnumOfExemptReasonTypeForGetRiskOutputReasonTypeRepaired is a EnumOfExemptReasonTypeForGetRiskOutput enum value
	EnumOfExemptReasonTypeForGetRiskOutputReasonTypeRepaired = "reason_type_repaired"
)

const (
	// EnumOfPolicyForGetRiskOutputAllow is a EnumOfPolicyForGetRiskOutput enum value
	EnumOfPolicyForGetRiskOutputAllow = "allow"

	// EnumOfPolicyForGetRiskOutputDeny is a EnumOfPolicyForGetRiskOutput enum value
	EnumOfPolicyForGetRiskOutputDeny = "deny"
)

const (
	// EnumOfProtocolTypeForGetRiskOutputIpv4 is a EnumOfProtocolTypeForGetRiskOutput enum value
	EnumOfProtocolTypeForGetRiskOutputIpv4 = "ipv4"

	// EnumOfProtocolTypeForGetRiskOutputIpv6 is a EnumOfProtocolTypeForGetRiskOutput enum value
	EnumOfProtocolTypeForGetRiskOutputIpv6 = "ipv6"
)

const (
	// EnumOfRepairSupportAutomationForGetRiskOutputManualRepair is a EnumOfRepairSupportAutomationForGetRiskOutput enum value
	EnumOfRepairSupportAutomationForGetRiskOutputManualRepair = "manual_repair"

	// EnumOfRepairSupportAutomationForGetRiskOutputSemiAutoRepair is a EnumOfRepairSupportAutomationForGetRiskOutput enum value
	EnumOfRepairSupportAutomationForGetRiskOutputSemiAutoRepair = "semi_auto_repair"

	// EnumOfRepairSupportAutomationForGetRiskOutputAutoRepair is a EnumOfRepairSupportAutomationForGetRiskOutput enum value
	EnumOfRepairSupportAutomationForGetRiskOutputAutoRepair = "auto_repair"
)

const (
	// EnumOfResourceRiskStatusForGetRiskOutputPassed is a EnumOfResourceRiskStatusForGetRiskOutput enum value
	EnumOfResourceRiskStatusForGetRiskOutputPassed = "passed"

	// EnumOfResourceRiskStatusForGetRiskOutputNotPassed is a EnumOfResourceRiskStatusForGetRiskOutput enum value
	EnumOfResourceRiskStatusForGetRiskOutputNotPassed = "not_passed"

	// EnumOfResourceRiskStatusForGetRiskOutputExempted is a EnumOfResourceRiskStatusForGetRiskOutput enum value
	EnumOfResourceRiskStatusForGetRiskOutputExempted = "exempted"
)

const (
	// EnumOfResourceStatusForGetRiskOutputExist is a EnumOfResourceStatusForGetRiskOutput enum value
	EnumOfResourceStatusForGetRiskOutputExist = "exist"

	// EnumOfResourceStatusForGetRiskOutputNotExist is a EnumOfResourceStatusForGetRiskOutput enum value
	EnumOfResourceStatusForGetRiskOutputNotExist = "not-exist"
)

const (
	// EnumOfRiskLevelForGetRiskOutput700Critical is a EnumOfRiskLevelForGetRiskOutput enum value
	EnumOfRiskLevelForGetRiskOutput700Critical = "700-critical"

	// EnumOfRiskLevelForGetRiskOutput500High is a EnumOfRiskLevelForGetRiskOutput enum value
	EnumOfRiskLevelForGetRiskOutput500High = "500-high"

	// EnumOfRiskLevelForGetRiskOutput300Mid is a EnumOfRiskLevelForGetRiskOutput enum value
	EnumOfRiskLevelForGetRiskOutput300Mid = "300-mid"

	// EnumOfRiskLevelForGetRiskOutput100Low is a EnumOfRiskLevelForGetRiskOutput enum value
	EnumOfRiskLevelForGetRiskOutput100Low = "100-low"

	// EnumOfRiskLevelForGetRiskOutput050Security is a EnumOfRiskLevelForGetRiskOutput enum value
	EnumOfRiskLevelForGetRiskOutput050Security = "050-security"
)

const (
	// EnumOfRiskModelTypeForGetRiskOutputRiskModelAlert is a EnumOfRiskModelTypeForGetRiskOutput enum value
	EnumOfRiskModelTypeForGetRiskOutputRiskModelAlert = "risk_model_alert"

	// EnumOfRiskModelTypeForGetRiskOutputRiskModelVulnerability is a EnumOfRiskModelTypeForGetRiskOutput enum value
	EnumOfRiskModelTypeForGetRiskOutputRiskModelVulnerability = "risk_model_vulnerability"

	// EnumOfRiskModelTypeForGetRiskOutputRiskModelBaseline is a EnumOfRiskModelTypeForGetRiskOutput enum value
	EnumOfRiskModelTypeForGetRiskOutputRiskModelBaseline = "risk_model_baseline"

	// EnumOfRiskModelTypeForGetRiskOutputRiskModelMcStrategy is a EnumOfRiskModelTypeForGetRiskOutput enum value
	EnumOfRiskModelTypeForGetRiskOutputRiskModelMcStrategy = "risk_model_mc_strategy"

	// EnumOfRiskModelTypeForGetRiskOutputRiskModelAttackChainAnalysis is a EnumOfRiskModelTypeForGetRiskOutput enum value
	EnumOfRiskModelTypeForGetRiskOutputRiskModelAttackChainAnalysis = "risk_model_attack_chain_analysis"
)

const (
	// EnumOfRiskStatusForGetRiskOutputHandled is a EnumOfRiskStatusForGetRiskOutput enum value
	EnumOfRiskStatusForGetRiskOutputHandled = "handled"

	// EnumOfRiskStatusForGetRiskOutputPartialHandled is a EnumOfRiskStatusForGetRiskOutput enum value
	EnumOfRiskStatusForGetRiskOutputPartialHandled = "partial_handled"

	// EnumOfRiskStatusForGetRiskOutputUnhandled is a EnumOfRiskStatusForGetRiskOutput enum value
	EnumOfRiskStatusForGetRiskOutputUnhandled = "unhandled"

	// EnumOfRiskStatusForGetRiskOutputWhitened is a EnumOfRiskStatusForGetRiskOutput enum value
	EnumOfRiskStatusForGetRiskOutputWhitened = "whitened"
)

const (
	// EnumOfRiskTypeListForGetRiskOutputWeekPassword is a EnumOfRiskTypeListForGetRiskOutput enum value
	EnumOfRiskTypeListForGetRiskOutputWeekPassword = "week_password"

	// EnumOfRiskTypeListForGetRiskOutputConfigError is a EnumOfRiskTypeListForGetRiskOutput enum value
	EnumOfRiskTypeListForGetRiskOutputConfigError = "config_error"

	// EnumOfRiskTypeListForGetRiskOutputAuthBypass is a EnumOfRiskTypeListForGetRiskOutput enum value
	EnumOfRiskTypeListForGetRiskOutputAuthBypass = "auth_bypass"

	// EnumOfRiskTypeListForGetRiskOutputUnauthorized is a EnumOfRiskTypeListForGetRiskOutput enum value
	EnumOfRiskTypeListForGetRiskOutputUnauthorized = "unauthorized"

	// EnumOfRiskTypeListForGetRiskOutputSuspiciousLeakage is a EnumOfRiskTypeListForGetRiskOutput enum value
	EnumOfRiskTypeListForGetRiskOutputSuspiciousLeakage = "suspicious_leakage"

	// EnumOfRiskTypeListForGetRiskOutputComplianceProblem is a EnumOfRiskTypeListForGetRiskOutput enum value
	EnumOfRiskTypeListForGetRiskOutputComplianceProblem = "compliance_problem"

	// EnumOfRiskTypeListForGetRiskOutputCryptoRisk is a EnumOfRiskTypeListForGetRiskOutput enum value
	EnumOfRiskTypeListForGetRiskOutputCryptoRisk = "crypto_risk"

	// EnumOfRiskTypeListForGetRiskOutputOthers is a EnumOfRiskTypeListForGetRiskOutput enum value
	EnumOfRiskTypeListForGetRiskOutputOthers = "others"

	// EnumOfRiskTypeListForGetRiskOutputComponentRisk is a EnumOfRiskTypeListForGetRiskOutput enum value
	EnumOfRiskTypeListForGetRiskOutputComponentRisk = "component_risk"
)

const (
	// EnumOfSecuritySituationTagIDListForGetRiskOutputExistAlarmRisk is a EnumOfSecuritySituationTagIDListForGetRiskOutput enum value
	EnumOfSecuritySituationTagIDListForGetRiskOutputExistAlarmRisk = "ExistAlarmRisk"

	// EnumOfSecuritySituationTagIDListForGetRiskOutputExistVulnRisk is a EnumOfSecuritySituationTagIDListForGetRiskOutput enum value
	EnumOfSecuritySituationTagIDListForGetRiskOutputExistVulnRisk = "ExistVulnRisk"

	// EnumOfSecuritySituationTagIDListForGetRiskOutputExistCspmrisk is a EnumOfSecuritySituationTagIDListForGetRiskOutput enum value
	EnumOfSecuritySituationTagIDListForGetRiskOutputExistCspmrisk = "ExistCSPMRisk"
)

const (
	// EnumOfStrategyTypeForGetRiskOutputNormalStrategy is a EnumOfStrategyTypeForGetRiskOutput enum value
	EnumOfStrategyTypeForGetRiskOutputNormalStrategy = "normal_strategy"

	// EnumOfStrategyTypeForGetRiskOutputVulnStrategy is a EnumOfStrategyTypeForGetRiskOutput enum value
	EnumOfStrategyTypeForGetRiskOutputVulnStrategy = "vuln_strategy"
)

const (
	// EnumOfVulnCategoryForGetRiskOutputVulnTypeLinux is a EnumOfVulnCategoryForGetRiskOutput enum value
	EnumOfVulnCategoryForGetRiskOutputVulnTypeLinux = "vuln_type_linux"

	// EnumOfVulnCategoryForGetRiskOutputVulnTypeWindows is a EnumOfVulnCategoryForGetRiskOutput enum value
	EnumOfVulnCategoryForGetRiskOutputVulnTypeWindows = "vuln_type_windows"

	// EnumOfVulnCategoryForGetRiskOutputVulnTypeApp is a EnumOfVulnCategoryForGetRiskOutput enum value
	EnumOfVulnCategoryForGetRiskOutputVulnTypeApp = "vuln_type_app"

	// EnumOfVulnCategoryForGetRiskOutputVulnTypeWeb is a EnumOfVulnCategoryForGetRiskOutput enum value
	EnumOfVulnCategoryForGetRiskOutputVulnTypeWeb = "vuln_type_web"

	// EnumOfVulnCategoryForGetRiskOutputVulnTypeEmg is a EnumOfVulnCategoryForGetRiskOutput enum value
	EnumOfVulnCategoryForGetRiskOutputVulnTypeEmg = "vuln_type_emg"

	// EnumOfVulnCategoryForGetRiskOutputVulnTypeUnknown is a EnumOfVulnCategoryForGetRiskOutput enum value
	EnumOfVulnCategoryForGetRiskOutputVulnTypeUnknown = "vuln_type_unknown"
)
