// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opUpdateSecretRotationPolicyCommon = "UpdateSecretRotationPolicy"

// UpdateSecretRotationPolicyCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the UpdateSecretRotationPolicyCommon operation. The "output" return
// value will be populated with the UpdateSecretRotationPolicyCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned UpdateSecretRotationPolicyCommon Request to send the API call to the service.
// the "output" return value is not valid until after UpdateSecretRotationPolicyCommon Send returns without error.
//
// See UpdateSecretRotationPolicyCommon for more information on using the UpdateSecretRotationPolicyCommon
// API call, and error handling.
//
//    // Example sending a request using the UpdateSecretRotationPolicyCommonRequest method.
//    req, resp := client.UpdateSecretRotationPolicyCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) UpdateSecretRotationPolicyCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opUpdateSecretRotationPolicyCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// UpdateSecretRotationPolicyCommon API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation UpdateSecretRotationPolicyCommon for usage and error information.
func (c *KMS) UpdateSecretRotationPolicyCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.UpdateSecretRotationPolicyCommonRequest(input)
	return out, req.Send()
}

// UpdateSecretRotationPolicyCommonWithContext is the same as UpdateSecretRotationPolicyCommon with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSecretRotationPolicyCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) UpdateSecretRotationPolicyCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.UpdateSecretRotationPolicyCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSecretRotationPolicy = "UpdateSecretRotationPolicy"

// UpdateSecretRotationPolicyRequest generates a "volcengine/request.Request" representing the
// client's request for the UpdateSecretRotationPolicy operation. The "output" return
// value will be populated with the UpdateSecretRotationPolicyCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned UpdateSecretRotationPolicyCommon Request to send the API call to the service.
// the "output" return value is not valid until after UpdateSecretRotationPolicyCommon Send returns without error.
//
// See UpdateSecretRotationPolicy for more information on using the UpdateSecretRotationPolicy
// API call, and error handling.
//
//    // Example sending a request using the UpdateSecretRotationPolicyRequest method.
//    req, resp := client.UpdateSecretRotationPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) UpdateSecretRotationPolicyRequest(input *UpdateSecretRotationPolicyInput) (req *request.Request, output *UpdateSecretRotationPolicyOutput) {
	op := &request.Operation{
		Name:       opUpdateSecretRotationPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateSecretRotationPolicyInput{}
	}

	output = &UpdateSecretRotationPolicyOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// UpdateSecretRotationPolicy API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation UpdateSecretRotationPolicy for usage and error information.
func (c *KMS) UpdateSecretRotationPolicy(input *UpdateSecretRotationPolicyInput) (*UpdateSecretRotationPolicyOutput, error) {
	req, out := c.UpdateSecretRotationPolicyRequest(input)
	return out, req.Send()
}

// UpdateSecretRotationPolicyWithContext is the same as UpdateSecretRotationPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSecretRotationPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) UpdateSecretRotationPolicyWithContext(ctx volcengine.Context, input *UpdateSecretRotationPolicyInput, opts ...request.Option) (*UpdateSecretRotationPolicyOutput, error) {
	req, out := c.UpdateSecretRotationPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type UpdateSecretRotationPolicyInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// AutomaticRotation is a required field
	AutomaticRotation *bool `type:"boolean" json:",omitempty" required:"true"`

	RotationInterval *string `type:"string" json:",omitempty"`

	// SecretName is a required field
	SecretName *string `min:"2" max:"31" type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s UpdateSecretRotationPolicyInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSecretRotationPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSecretRotationPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSecretRotationPolicyInput"}
	if s.AutomaticRotation == nil {
		invalidParams.Add(request.NewErrParamRequired("AutomaticRotation"))
	}
	if s.SecretName == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretName"))
	}
	if s.SecretName != nil && len(*s.SecretName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("SecretName", 2))
	}
	if s.SecretName != nil && len(*s.SecretName) > 31 {
		invalidParams.Add(request.NewErrParamMaxLen("SecretName", 31, *s.SecretName))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutomaticRotation sets the AutomaticRotation field's value.
func (s *UpdateSecretRotationPolicyInput) SetAutomaticRotation(v bool) *UpdateSecretRotationPolicyInput {
	s.AutomaticRotation = &v
	return s
}

// SetRotationInterval sets the RotationInterval field's value.
func (s *UpdateSecretRotationPolicyInput) SetRotationInterval(v string) *UpdateSecretRotationPolicyInput {
	s.RotationInterval = &v
	return s
}

// SetSecretName sets the SecretName field's value.
func (s *UpdateSecretRotationPolicyInput) SetSecretName(v string) *UpdateSecretRotationPolicyInput {
	s.SecretName = &v
	return s
}

type UpdateSecretRotationPolicyOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata
}

// String returns the string representation
func (s UpdateSecretRotationPolicyOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSecretRotationPolicyOutput) GoString() string {
	return s.String()
}
