// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opEncryptCommon = "Encrypt"

// EncryptCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the EncryptCommon operation. The "output" return
// value will be populated with the EncryptCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned EncryptCommon Request to send the API call to the service.
// the "output" return value is not valid until after EncryptCommon Send returns without error.
//
// See EncryptCommon for more information on using the EncryptCommon
// API call, and error handling.
//
//    // Example sending a request using the EncryptCommonRequest method.
//    req, resp := client.EncryptCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) EncryptCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opEncryptCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// EncryptCommon API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation EncryptCommon for usage and error information.
func (c *KMS) EncryptCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.EncryptCommonRequest(input)
	return out, req.Send()
}

// EncryptCommonWithContext is the same as EncryptCommon with the addition of
// the ability to pass a context and additional request options.
//
// See EncryptCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) EncryptCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.EncryptCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEncrypt = "Encrypt"

// EncryptRequest generates a "volcengine/request.Request" representing the
// client's request for the Encrypt operation. The "output" return
// value will be populated with the EncryptCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned EncryptCommon Request to send the API call to the service.
// the "output" return value is not valid until after EncryptCommon Send returns without error.
//
// See Encrypt for more information on using the Encrypt
// API call, and error handling.
//
//    // Example sending a request using the EncryptRequest method.
//    req, resp := client.EncryptRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) EncryptRequest(input *EncryptInput) (req *request.Request, output *EncryptOutput) {
	op := &request.Operation{
		Name:       opEncrypt,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EncryptInput{}
	}

	output = &EncryptOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// Encrypt API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation Encrypt for usage and error information.
func (c *KMS) Encrypt(input *EncryptInput) (*EncryptOutput, error) {
	req, out := c.EncryptRequest(input)
	return out, req.Send()
}

// EncryptWithContext is the same as Encrypt with the addition of
// the ability to pass a context and additional request options.
//
// See Encrypt for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) EncryptWithContext(ctx volcengine.Context, input *EncryptInput, opts ...request.Option) (*EncryptOutput, error) {
	req, out := c.EncryptRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type EncryptInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	EncryptionContext map[string]*string `type:"map" json:",omitempty"`

	KeyID *string `type:"string" json:",omitempty"`

	KeyName *string `min:"2" max:"31" type:"string" json:",omitempty"`

	KeyringName *string `min:"2" max:"31" type:"string" json:",omitempty"`

	// Plaintext is a required field
	Plaintext *string `min:"1" max:"4096" type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s EncryptInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s EncryptInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncryptInput"}
	if s.KeyName != nil && len(*s.KeyName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("KeyName", 2))
	}
	if s.KeyName != nil && len(*s.KeyName) > 31 {
		invalidParams.Add(request.NewErrParamMaxLen("KeyName", 31, *s.KeyName))
	}
	if s.KeyringName != nil && len(*s.KeyringName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("KeyringName", 2))
	}
	if s.KeyringName != nil && len(*s.KeyringName) > 31 {
		invalidParams.Add(request.NewErrParamMaxLen("KeyringName", 31, *s.KeyringName))
	}
	if s.Plaintext == nil {
		invalidParams.Add(request.NewErrParamRequired("Plaintext"))
	}
	if s.Plaintext != nil && len(*s.Plaintext) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Plaintext", 1))
	}
	if s.Plaintext != nil && len(*s.Plaintext) > 4096 {
		invalidParams.Add(request.NewErrParamMaxLen("Plaintext", 4096, *s.Plaintext))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryptionContext sets the EncryptionContext field's value.
func (s *EncryptInput) SetEncryptionContext(v map[string]*string) *EncryptInput {
	s.EncryptionContext = v
	return s
}

// SetKeyID sets the KeyID field's value.
func (s *EncryptInput) SetKeyID(v string) *EncryptInput {
	s.KeyID = &v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *EncryptInput) SetKeyName(v string) *EncryptInput {
	s.KeyName = &v
	return s
}

// SetKeyringName sets the KeyringName field's value.
func (s *EncryptInput) SetKeyringName(v string) *EncryptInput {
	s.KeyringName = &v
	return s
}

// SetPlaintext sets the Plaintext field's value.
func (s *EncryptInput) SetPlaintext(v string) *EncryptInput {
	s.Plaintext = &v
	return s
}

type EncryptOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	CiphertextBlob *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s EncryptOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s EncryptOutput) GoString() string {
	return s.String()
}

// SetCiphertextBlob sets the CiphertextBlob field's value.
func (s *EncryptOutput) SetCiphertextBlob(v string) *EncryptOutput {
	s.CiphertextBlob = &v
	return s
}
