// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package ecs

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opImportKeyPairCommon = "ImportKeyPair"

// ImportKeyPairCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ImportKeyPairCommon operation. The "output" return
// value will be populated with the ImportKeyPairCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ImportKeyPairCommon Request to send the API call to the service.
// the "output" return value is not valid until after ImportKeyPairCommon Send returns without error.
//
// See ImportKeyPairCommon for more information on using the ImportKeyPairCommon
// API call, and error handling.
//
//    // Example sending a request using the ImportKeyPairCommonRequest method.
//    req, resp := client.ImportKeyPairCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ECS) ImportKeyPairCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opImportKeyPairCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// ImportKeyPairCommon API operation for ECS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ECS's
// API operation ImportKeyPairCommon for usage and error information.
func (c *ECS) ImportKeyPairCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ImportKeyPairCommonRequest(input)
	return out, req.Send()
}

// ImportKeyPairCommonWithContext is the same as ImportKeyPairCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ImportKeyPairCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) ImportKeyPairCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ImportKeyPairCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportKeyPair = "ImportKeyPair"

// ImportKeyPairRequest generates a "volcengine/request.Request" representing the
// client's request for the ImportKeyPair operation. The "output" return
// value will be populated with the ImportKeyPairCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ImportKeyPairCommon Request to send the API call to the service.
// the "output" return value is not valid until after ImportKeyPairCommon Send returns without error.
//
// See ImportKeyPair for more information on using the ImportKeyPair
// API call, and error handling.
//
//    // Example sending a request using the ImportKeyPairRequest method.
//    req, resp := client.ImportKeyPairRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ECS) ImportKeyPairRequest(input *ImportKeyPairInput) (req *request.Request, output *ImportKeyPairOutput) {
	op := &request.Operation{
		Name:       opImportKeyPair,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportKeyPairInput{}
	}

	output = &ImportKeyPairOutput{}
	req = c.newRequest(op, input, output)

	return
}

// ImportKeyPair API operation for ECS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ECS's
// API operation ImportKeyPair for usage and error information.
func (c *ECS) ImportKeyPair(input *ImportKeyPairInput) (*ImportKeyPairOutput, error) {
	req, out := c.ImportKeyPairRequest(input)
	return out, req.Send()
}

// ImportKeyPairWithContext is the same as ImportKeyPair with the addition of
// the ability to pass a context and additional request options.
//
// See ImportKeyPair for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) ImportKeyPairWithContext(ctx volcengine.Context, input *ImportKeyPairInput, opts ...request.Option) (*ImportKeyPairOutput, error) {
	req, out := c.ImportKeyPairRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ImportKeyPairInput struct {
	_ struct{} `type:"structure"`

	ClientToken *string `type:"string"`

	Description *string `type:"string"`

	// KeyPairName is a required field
	KeyPairName *string `type:"string" required:"true"`

	ProjectName *string `type:"string"`

	// PublicKey is a required field
	PublicKey *string `type:"string" required:"true"`

	Tags []*TagForImportKeyPairInput `type:"list"`
}

// String returns the string representation
func (s ImportKeyPairInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportKeyPairInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportKeyPairInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportKeyPairInput"}
	if s.KeyPairName == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyPairName"))
	}
	if s.PublicKey == nil {
		invalidParams.Add(request.NewErrParamRequired("PublicKey"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *ImportKeyPairInput) SetClientToken(v string) *ImportKeyPairInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ImportKeyPairInput) SetDescription(v string) *ImportKeyPairInput {
	s.Description = &v
	return s
}

// SetKeyPairName sets the KeyPairName field's value.
func (s *ImportKeyPairInput) SetKeyPairName(v string) *ImportKeyPairInput {
	s.KeyPairName = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *ImportKeyPairInput) SetProjectName(v string) *ImportKeyPairInput {
	s.ProjectName = &v
	return s
}

// SetPublicKey sets the PublicKey field's value.
func (s *ImportKeyPairInput) SetPublicKey(v string) *ImportKeyPairInput {
	s.PublicKey = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ImportKeyPairInput) SetTags(v []*TagForImportKeyPairInput) *ImportKeyPairInput {
	s.Tags = v
	return s
}

type ImportKeyPairOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	FingerPrint *string `type:"string"`

	KeyPairId *string `type:"string"`

	KeyPairName *string `type:"string"`
}

// String returns the string representation
func (s ImportKeyPairOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportKeyPairOutput) GoString() string {
	return s.String()
}

// SetFingerPrint sets the FingerPrint field's value.
func (s *ImportKeyPairOutput) SetFingerPrint(v string) *ImportKeyPairOutput {
	s.FingerPrint = &v
	return s
}

// SetKeyPairId sets the KeyPairId field's value.
func (s *ImportKeyPairOutput) SetKeyPairId(v string) *ImportKeyPairOutput {
	s.KeyPairId = &v
	return s
}

// SetKeyPairName sets the KeyPairName field's value.
func (s *ImportKeyPairOutput) SetKeyPairName(v string) *ImportKeyPairOutput {
	s.KeyPairName = &v
	return s
}

type TagForImportKeyPairInput struct {
	_ struct{} `type:"structure"`

	// Key is a required field
	Key *string `type:"string" required:"true"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s TagForImportKeyPairInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForImportKeyPairInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagForImportKeyPairInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagForImportKeyPairInput"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *TagForImportKeyPairInput) SetKey(v string) *TagForImportKeyPairInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForImportKeyPairInput) SetValue(v string) *TagForImportKeyPairInput {
	s.Value = &v
	return s
}
