// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package dns

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opUpdateRecordCommon = "UpdateRecord"

// UpdateRecordCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the UpdateRecordCommon operation. The "output" return
// value will be populated with the UpdateRecordCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned UpdateRecordCommon Request to send the API call to the service.
// the "output" return value is not valid until after UpdateRecordCommon Send returns without error.
//
// See UpdateRecordCommon for more information on using the UpdateRecordCommon
// API call, and error handling.
//
//    // Example sending a request using the UpdateRecordCommonRequest method.
//    req, resp := client.UpdateRecordCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *DNS) UpdateRecordCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opUpdateRecordCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// UpdateRecordCommon API operation for DNS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for DNS's
// API operation UpdateRecordCommon for usage and error information.
func (c *DNS) UpdateRecordCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.UpdateRecordCommonRequest(input)
	return out, req.Send()
}

// UpdateRecordCommonWithContext is the same as UpdateRecordCommon with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRecordCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DNS) UpdateRecordCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.UpdateRecordCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRecord = "UpdateRecord"

// UpdateRecordRequest generates a "volcengine/request.Request" representing the
// client's request for the UpdateRecord operation. The "output" return
// value will be populated with the UpdateRecordCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned UpdateRecordCommon Request to send the API call to the service.
// the "output" return value is not valid until after UpdateRecordCommon Send returns without error.
//
// See UpdateRecord for more information on using the UpdateRecord
// API call, and error handling.
//
//    // Example sending a request using the UpdateRecordRequest method.
//    req, resp := client.UpdateRecordRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *DNS) UpdateRecordRequest(input *UpdateRecordInput) (req *request.Request, output *UpdateRecordOutput) {
	op := &request.Operation{
		Name:       opUpdateRecord,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRecordInput{}
	}

	output = &UpdateRecordOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// UpdateRecord API operation for DNS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for DNS's
// API operation UpdateRecord for usage and error information.
func (c *DNS) UpdateRecord(input *UpdateRecordInput) (*UpdateRecordOutput, error) {
	req, out := c.UpdateRecordRequest(input)
	return out, req.Send()
}

// UpdateRecordWithContext is the same as UpdateRecord with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRecord for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DNS) UpdateRecordWithContext(ctx volcengine.Context, input *UpdateRecordInput, opts ...request.Option) (*UpdateRecordOutput, error) {
	req, out := c.UpdateRecordRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type UpdateRecordInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// Host is a required field
	Host *string `type:"string" json:",omitempty" required:"true"`

	// Line is a required field
	Line *string `type:"string" json:",omitempty" required:"true"`

	ProjectName *string `type:"string" json:",omitempty"`

	// RecordID is a required field
	RecordID *string `type:"string" json:",omitempty" required:"true"`

	Remark *string `type:"string" json:",omitempty"`

	TTL *int32 `type:"int32" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`

	Weight *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s UpdateRecordInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRecordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRecordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRecordInput"}
	if s.Host == nil {
		invalidParams.Add(request.NewErrParamRequired("Host"))
	}
	if s.Line == nil {
		invalidParams.Add(request.NewErrParamRequired("Line"))
	}
	if s.RecordID == nil {
		invalidParams.Add(request.NewErrParamRequired("RecordID"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHost sets the Host field's value.
func (s *UpdateRecordInput) SetHost(v string) *UpdateRecordInput {
	s.Host = &v
	return s
}

// SetLine sets the Line field's value.
func (s *UpdateRecordInput) SetLine(v string) *UpdateRecordInput {
	s.Line = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *UpdateRecordInput) SetProjectName(v string) *UpdateRecordInput {
	s.ProjectName = &v
	return s
}

// SetRecordID sets the RecordID field's value.
func (s *UpdateRecordInput) SetRecordID(v string) *UpdateRecordInput {
	s.RecordID = &v
	return s
}

// SetRemark sets the Remark field's value.
func (s *UpdateRecordInput) SetRemark(v string) *UpdateRecordInput {
	s.Remark = &v
	return s
}

// SetTTL sets the TTL field's value.
func (s *UpdateRecordInput) SetTTL(v int32) *UpdateRecordInput {
	s.TTL = &v
	return s
}

// SetType sets the Type field's value.
func (s *UpdateRecordInput) SetType(v string) *UpdateRecordInput {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *UpdateRecordInput) SetValue(v string) *UpdateRecordInput {
	s.Value = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *UpdateRecordInput) SetWeight(v int32) *UpdateRecordInput {
	s.Weight = &v
	return s
}

type UpdateRecordOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	CreatedAt *string `type:"string" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	FQDN *string `type:"string" json:",omitempty"`

	Host *string `type:"string" json:",omitempty"`

	Line *string `type:"string" json:",omitempty"`

	Operators []*string `type:"list" json:",omitempty"`

	PQDN *string `type:"string" json:",omitempty"`

	RecordID *string `type:"string" json:",omitempty"`

	RecordSetID *string `type:"string" json:",omitempty"`

	Remark *string `type:"string" json:",omitempty"`

	TTL *int32 `type:"int32" json:",omitempty"`

	Tags []*string `type:"list" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`

	UpdatedAt *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`

	Weight *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s UpdateRecordOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRecordOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *UpdateRecordOutput) SetCreatedAt(v string) *UpdateRecordOutput {
	s.CreatedAt = &v
	return s
}

// SetEnable sets the Enable field's value.
func (s *UpdateRecordOutput) SetEnable(v bool) *UpdateRecordOutput {
	s.Enable = &v
	return s
}

// SetFQDN sets the FQDN field's value.
func (s *UpdateRecordOutput) SetFQDN(v string) *UpdateRecordOutput {
	s.FQDN = &v
	return s
}

// SetHost sets the Host field's value.
func (s *UpdateRecordOutput) SetHost(v string) *UpdateRecordOutput {
	s.Host = &v
	return s
}

// SetLine sets the Line field's value.
func (s *UpdateRecordOutput) SetLine(v string) *UpdateRecordOutput {
	s.Line = &v
	return s
}

// SetOperators sets the Operators field's value.
func (s *UpdateRecordOutput) SetOperators(v []*string) *UpdateRecordOutput {
	s.Operators = v
	return s
}

// SetPQDN sets the PQDN field's value.
func (s *UpdateRecordOutput) SetPQDN(v string) *UpdateRecordOutput {
	s.PQDN = &v
	return s
}

// SetRecordID sets the RecordID field's value.
func (s *UpdateRecordOutput) SetRecordID(v string) *UpdateRecordOutput {
	s.RecordID = &v
	return s
}

// SetRecordSetID sets the RecordSetID field's value.
func (s *UpdateRecordOutput) SetRecordSetID(v string) *UpdateRecordOutput {
	s.RecordSetID = &v
	return s
}

// SetRemark sets the Remark field's value.
func (s *UpdateRecordOutput) SetRemark(v string) *UpdateRecordOutput {
	s.Remark = &v
	return s
}

// SetTTL sets the TTL field's value.
func (s *UpdateRecordOutput) SetTTL(v int32) *UpdateRecordOutput {
	s.TTL = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateRecordOutput) SetTags(v []*string) *UpdateRecordOutput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *UpdateRecordOutput) SetType(v string) *UpdateRecordOutput {
	s.Type = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *UpdateRecordOutput) SetUpdatedAt(v string) *UpdateRecordOutput {
	s.UpdatedAt = &v
	return s
}

// SetValue sets the Value field's value.
func (s *UpdateRecordOutput) SetValue(v string) *UpdateRecordOutput {
	s.Value = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *UpdateRecordOutput) SetWeight(v int32) *UpdateRecordOutput {
	s.Weight = &v
	return s
}
