// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package dcdn

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateDomainConfigsCommon = "CreateDomainConfigs"

// CreateDomainConfigsCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateDomainConfigsCommon operation. The "output" return
// value will be populated with the CreateDomainConfigsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateDomainConfigsCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateDomainConfigsCommon Send returns without error.
//
// See CreateDomainConfigsCommon for more information on using the CreateDomainConfigsCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateDomainConfigsCommonRequest method.
//    req, resp := client.CreateDomainConfigsCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *DCDN) CreateDomainConfigsCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateDomainConfigsCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateDomainConfigsCommon API operation for DCDN.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for DCDN's
// API operation CreateDomainConfigsCommon for usage and error information.
func (c *DCDN) CreateDomainConfigsCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateDomainConfigsCommonRequest(input)
	return out, req.Send()
}

// CreateDomainConfigsCommonWithContext is the same as CreateDomainConfigsCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDomainConfigsCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DCDN) CreateDomainConfigsCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateDomainConfigsCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDomainConfigs = "CreateDomainConfigs"

// CreateDomainConfigsRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateDomainConfigs operation. The "output" return
// value will be populated with the CreateDomainConfigsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateDomainConfigsCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateDomainConfigsCommon Send returns without error.
//
// See CreateDomainConfigs for more information on using the CreateDomainConfigs
// API call, and error handling.
//
//    // Example sending a request using the CreateDomainConfigsRequest method.
//    req, resp := client.CreateDomainConfigsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *DCDN) CreateDomainConfigsRequest(input *CreateDomainConfigsInput) (req *request.Request, output *CreateDomainConfigsOutput) {
	op := &request.Operation{
		Name:       opCreateDomainConfigs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDomainConfigsInput{}
	}

	output = &CreateDomainConfigsOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateDomainConfigs API operation for DCDN.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for DCDN's
// API operation CreateDomainConfigs for usage and error information.
func (c *DCDN) CreateDomainConfigs(input *CreateDomainConfigsInput) (*CreateDomainConfigsOutput, error) {
	req, out := c.CreateDomainConfigsRequest(input)
	return out, req.Send()
}

// CreateDomainConfigsWithContext is the same as CreateDomainConfigs with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDomainConfigs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DCDN) CreateDomainConfigsWithContext(ctx volcengine.Context, input *CreateDomainConfigsInput, opts ...request.Option) (*CreateDomainConfigsOutput, error) {
	req, out := c.CreateDomainConfigsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type BackupOriginForCreateDomainConfigsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Port *int32 `type:"int32" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`

	Weight *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s BackupOriginForCreateDomainConfigsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BackupOriginForCreateDomainConfigsInput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *BackupOriginForCreateDomainConfigsInput) SetName(v string) *BackupOriginForCreateDomainConfigsInput {
	s.Name = &v
	return s
}

// SetPort sets the Port field's value.
func (s *BackupOriginForCreateDomainConfigsInput) SetPort(v int32) *BackupOriginForCreateDomainConfigsInput {
	s.Port = &v
	return s
}

// SetType sets the Type field's value.
func (s *BackupOriginForCreateDomainConfigsInput) SetType(v string) *BackupOriginForCreateDomainConfigsInput {
	s.Type = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *BackupOriginForCreateDomainConfigsInput) SetWeight(v int32) *BackupOriginForCreateDomainConfigsInput {
	s.Weight = &v
	return s
}

type BrCompressForCreateDomainConfigsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s BrCompressForCreateDomainConfigsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BrCompressForCreateDomainConfigsInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *BrCompressForCreateDomainConfigsInput) SetEnable(v bool) *BrCompressForCreateDomainConfigsInput {
	s.Enable = &v
	return s
}

type CacheForCreateDomainConfigsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AdaptCache *bool `type:"boolean" json:",omitempty"`

	CacheKeyRules []*CacheKeyRuleForCreateDomainConfigsInput `type:"list" json:",omitempty"`

	CacheRules []*CacheRuleForCreateDomainConfigsInput `type:"list" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	StatusCodeCacheRule *StatusCodeCacheRuleForCreateDomainConfigsInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s CacheForCreateDomainConfigsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheForCreateDomainConfigsInput) GoString() string {
	return s.String()
}

// SetAdaptCache sets the AdaptCache field's value.
func (s *CacheForCreateDomainConfigsInput) SetAdaptCache(v bool) *CacheForCreateDomainConfigsInput {
	s.AdaptCache = &v
	return s
}

// SetCacheKeyRules sets the CacheKeyRules field's value.
func (s *CacheForCreateDomainConfigsInput) SetCacheKeyRules(v []*CacheKeyRuleForCreateDomainConfigsInput) *CacheForCreateDomainConfigsInput {
	s.CacheKeyRules = v
	return s
}

// SetCacheRules sets the CacheRules field's value.
func (s *CacheForCreateDomainConfigsInput) SetCacheRules(v []*CacheRuleForCreateDomainConfigsInput) *CacheForCreateDomainConfigsInput {
	s.CacheRules = v
	return s
}

// SetEnable sets the Enable field's value.
func (s *CacheForCreateDomainConfigsInput) SetEnable(v bool) *CacheForCreateDomainConfigsInput {
	s.Enable = &v
	return s
}

// SetStatusCodeCacheRule sets the StatusCodeCacheRule field's value.
func (s *CacheForCreateDomainConfigsInput) SetStatusCodeCacheRule(v *StatusCodeCacheRuleForCreateDomainConfigsInput) *CacheForCreateDomainConfigsInput {
	s.StatusCodeCacheRule = v
	return s
}

type CacheKeyRuleForCreateDomainConfigsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Contents *string `type:"string" json:",omitempty"`

	IgnoreCase *bool `type:"boolean" json:",omitempty"`

	ParamsFilterType *string `type:"string" json:",omitempty"`

	ParamsReserveList *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CacheKeyRuleForCreateDomainConfigsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheKeyRuleForCreateDomainConfigsInput) GoString() string {
	return s.String()
}

// SetContents sets the Contents field's value.
func (s *CacheKeyRuleForCreateDomainConfigsInput) SetContents(v string) *CacheKeyRuleForCreateDomainConfigsInput {
	s.Contents = &v
	return s
}

// SetIgnoreCase sets the IgnoreCase field's value.
func (s *CacheKeyRuleForCreateDomainConfigsInput) SetIgnoreCase(v bool) *CacheKeyRuleForCreateDomainConfigsInput {
	s.IgnoreCase = &v
	return s
}

// SetParamsFilterType sets the ParamsFilterType field's value.
func (s *CacheKeyRuleForCreateDomainConfigsInput) SetParamsFilterType(v string) *CacheKeyRuleForCreateDomainConfigsInput {
	s.ParamsFilterType = &v
	return s
}

// SetParamsReserveList sets the ParamsReserveList field's value.
func (s *CacheKeyRuleForCreateDomainConfigsInput) SetParamsReserveList(v string) *CacheKeyRuleForCreateDomainConfigsInput {
	s.ParamsReserveList = &v
	return s
}

// SetType sets the Type field's value.
func (s *CacheKeyRuleForCreateDomainConfigsInput) SetType(v string) *CacheKeyRuleForCreateDomainConfigsInput {
	s.Type = &v
	return s
}

type CacheRuleForCreateDomainConfigsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CacheTime *int32 `type:"int32" json:",omitempty"`

	CacheTimeUnit *string `type:"string" json:",omitempty"`

	Contents *string `type:"string" json:",omitempty"`

	IgnoreCase *bool `type:"boolean" json:",omitempty"`

	ParamsFilterType *string `type:"string" json:",omitempty"`

	ParamsReserveList *string `type:"string" json:",omitempty"`

	Policy *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CacheRuleForCreateDomainConfigsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheRuleForCreateDomainConfigsInput) GoString() string {
	return s.String()
}

// SetCacheTime sets the CacheTime field's value.
func (s *CacheRuleForCreateDomainConfigsInput) SetCacheTime(v int32) *CacheRuleForCreateDomainConfigsInput {
	s.CacheTime = &v
	return s
}

// SetCacheTimeUnit sets the CacheTimeUnit field's value.
func (s *CacheRuleForCreateDomainConfigsInput) SetCacheTimeUnit(v string) *CacheRuleForCreateDomainConfigsInput {
	s.CacheTimeUnit = &v
	return s
}

// SetContents sets the Contents field's value.
func (s *CacheRuleForCreateDomainConfigsInput) SetContents(v string) *CacheRuleForCreateDomainConfigsInput {
	s.Contents = &v
	return s
}

// SetIgnoreCase sets the IgnoreCase field's value.
func (s *CacheRuleForCreateDomainConfigsInput) SetIgnoreCase(v bool) *CacheRuleForCreateDomainConfigsInput {
	s.IgnoreCase = &v
	return s
}

// SetParamsFilterType sets the ParamsFilterType field's value.
func (s *CacheRuleForCreateDomainConfigsInput) SetParamsFilterType(v string) *CacheRuleForCreateDomainConfigsInput {
	s.ParamsFilterType = &v
	return s
}

// SetParamsReserveList sets the ParamsReserveList field's value.
func (s *CacheRuleForCreateDomainConfigsInput) SetParamsReserveList(v string) *CacheRuleForCreateDomainConfigsInput {
	s.ParamsReserveList = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *CacheRuleForCreateDomainConfigsInput) SetPolicy(v string) *CacheRuleForCreateDomainConfigsInput {
	s.Policy = &v
	return s
}

// SetType sets the Type field's value.
func (s *CacheRuleForCreateDomainConfigsInput) SetType(v string) *CacheRuleForCreateDomainConfigsInput {
	s.Type = &v
	return s
}

type CertBindForCreateDomainConfigsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CertId *string `type:"string" json:",omitempty"`

	CertSource *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CertBindForCreateDomainConfigsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CertBindForCreateDomainConfigsInput) GoString() string {
	return s.String()
}

// SetCertId sets the CertId field's value.
func (s *CertBindForCreateDomainConfigsInput) SetCertId(v string) *CertBindForCreateDomainConfigsInput {
	s.CertId = &v
	return s
}

// SetCertSource sets the CertSource field's value.
func (s *CertBindForCreateDomainConfigsInput) SetCertSource(v string) *CertBindForCreateDomainConfigsInput {
	s.CertSource = &v
	return s
}

type ConditionalOriginForCreateDomainConfigsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	BackupOrigins []*BackupOriginForCreateDomainConfigsInput `type:"list" json:",omitempty"`

	MatchingRuleGroupJSON *string `type:"string" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Origins []*BackupOriginForCreateDomainConfigsInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ConditionalOriginForCreateDomainConfigsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConditionalOriginForCreateDomainConfigsInput) GoString() string {
	return s.String()
}

// SetBackupOrigins sets the BackupOrigins field's value.
func (s *ConditionalOriginForCreateDomainConfigsInput) SetBackupOrigins(v []*BackupOriginForCreateDomainConfigsInput) *ConditionalOriginForCreateDomainConfigsInput {
	s.BackupOrigins = v
	return s
}

// SetMatchingRuleGroupJSON sets the MatchingRuleGroupJSON field's value.
func (s *ConditionalOriginForCreateDomainConfigsInput) SetMatchingRuleGroupJSON(v string) *ConditionalOriginForCreateDomainConfigsInput {
	s.MatchingRuleGroupJSON = &v
	return s
}

// SetName sets the Name field's value.
func (s *ConditionalOriginForCreateDomainConfigsInput) SetName(v string) *ConditionalOriginForCreateDomainConfigsInput {
	s.Name = &v
	return s
}

// SetOrigins sets the Origins field's value.
func (s *ConditionalOriginForCreateDomainConfigsInput) SetOrigins(v []*BackupOriginForCreateDomainConfigsInput) *ConditionalOriginForCreateDomainConfigsInput {
	s.Origins = v
	return s
}

type ConvertConvertOriginForCreateDomainConfigsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	BackupOriginType *string `type:"string" json:",omitempty"`

	BackupOrigins []*BackupOriginForCreateDomainConfigsInput `type:"list" json:",omitempty"`

	ConditionalOrigins []*ConditionalOriginForCreateDomainConfigsInput `type:"list" json:",omitempty"`

	FollowRedirect *FollowRedirectForCreateDomainConfigsInput `type:"structure" json:",omitempty"`

	OriginHost *OriginHostForCreateDomainConfigsInput `type:"structure" json:",omitempty"`

	OriginProtocolType *string `type:"string" json:",omitempty"`

	OriginRange *OriginRangeForCreateDomainConfigsInput `type:"structure" json:",omitempty"`

	OriginSni *OriginSniForCreateDomainConfigsInput `type:"structure" json:",omitempty"`

	OriginType *string `type:"string" json:",omitempty"`

	Origins []*ConvertOriginForCreateDomainConfigsInput `type:"list" json:",omitempty"`

	RequestHeader *RequestHeaderForCreateDomainConfigsInput `type:"structure" json:",omitempty"`

	ResponseHeader *ResponseHeaderForCreateDomainConfigsInput `type:"structure" json:",omitempty"`

	ResponseTimeout *int32 `type:"int32" json:",omitempty"`

	TosPrivateAccess *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s ConvertConvertOriginForCreateDomainConfigsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertConvertOriginForCreateDomainConfigsInput) GoString() string {
	return s.String()
}

// SetBackupOriginType sets the BackupOriginType field's value.
func (s *ConvertConvertOriginForCreateDomainConfigsInput) SetBackupOriginType(v string) *ConvertConvertOriginForCreateDomainConfigsInput {
	s.BackupOriginType = &v
	return s
}

// SetBackupOrigins sets the BackupOrigins field's value.
func (s *ConvertConvertOriginForCreateDomainConfigsInput) SetBackupOrigins(v []*BackupOriginForCreateDomainConfigsInput) *ConvertConvertOriginForCreateDomainConfigsInput {
	s.BackupOrigins = v
	return s
}

// SetConditionalOrigins sets the ConditionalOrigins field's value.
func (s *ConvertConvertOriginForCreateDomainConfigsInput) SetConditionalOrigins(v []*ConditionalOriginForCreateDomainConfigsInput) *ConvertConvertOriginForCreateDomainConfigsInput {
	s.ConditionalOrigins = v
	return s
}

// SetFollowRedirect sets the FollowRedirect field's value.
func (s *ConvertConvertOriginForCreateDomainConfigsInput) SetFollowRedirect(v *FollowRedirectForCreateDomainConfigsInput) *ConvertConvertOriginForCreateDomainConfigsInput {
	s.FollowRedirect = v
	return s
}

// SetOriginHost sets the OriginHost field's value.
func (s *ConvertConvertOriginForCreateDomainConfigsInput) SetOriginHost(v *OriginHostForCreateDomainConfigsInput) *ConvertConvertOriginForCreateDomainConfigsInput {
	s.OriginHost = v
	return s
}

// SetOriginProtocolType sets the OriginProtocolType field's value.
func (s *ConvertConvertOriginForCreateDomainConfigsInput) SetOriginProtocolType(v string) *ConvertConvertOriginForCreateDomainConfigsInput {
	s.OriginProtocolType = &v
	return s
}

// SetOriginRange sets the OriginRange field's value.
func (s *ConvertConvertOriginForCreateDomainConfigsInput) SetOriginRange(v *OriginRangeForCreateDomainConfigsInput) *ConvertConvertOriginForCreateDomainConfigsInput {
	s.OriginRange = v
	return s
}

// SetOriginSni sets the OriginSni field's value.
func (s *ConvertConvertOriginForCreateDomainConfigsInput) SetOriginSni(v *OriginSniForCreateDomainConfigsInput) *ConvertConvertOriginForCreateDomainConfigsInput {
	s.OriginSni = v
	return s
}

// SetOriginType sets the OriginType field's value.
func (s *ConvertConvertOriginForCreateDomainConfigsInput) SetOriginType(v string) *ConvertConvertOriginForCreateDomainConfigsInput {
	s.OriginType = &v
	return s
}

// SetOrigins sets the Origins field's value.
func (s *ConvertConvertOriginForCreateDomainConfigsInput) SetOrigins(v []*ConvertOriginForCreateDomainConfigsInput) *ConvertConvertOriginForCreateDomainConfigsInput {
	s.Origins = v
	return s
}

// SetRequestHeader sets the RequestHeader field's value.
func (s *ConvertConvertOriginForCreateDomainConfigsInput) SetRequestHeader(v *RequestHeaderForCreateDomainConfigsInput) *ConvertConvertOriginForCreateDomainConfigsInput {
	s.RequestHeader = v
	return s
}

// SetResponseHeader sets the ResponseHeader field's value.
func (s *ConvertConvertOriginForCreateDomainConfigsInput) SetResponseHeader(v *ResponseHeaderForCreateDomainConfigsInput) *ConvertConvertOriginForCreateDomainConfigsInput {
	s.ResponseHeader = v
	return s
}

// SetResponseTimeout sets the ResponseTimeout field's value.
func (s *ConvertConvertOriginForCreateDomainConfigsInput) SetResponseTimeout(v int32) *ConvertConvertOriginForCreateDomainConfigsInput {
	s.ResponseTimeout = &v
	return s
}

// SetTosPrivateAccess sets the TosPrivateAccess field's value.
func (s *ConvertConvertOriginForCreateDomainConfigsInput) SetTosPrivateAccess(v bool) *ConvertConvertOriginForCreateDomainConfigsInput {
	s.TosPrivateAccess = &v
	return s
}

type ConvertOriginForCreateDomainConfigsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Port *int32 `type:"int32" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`

	Weight *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ConvertOriginForCreateDomainConfigsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertOriginForCreateDomainConfigsInput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *ConvertOriginForCreateDomainConfigsInput) SetName(v string) *ConvertOriginForCreateDomainConfigsInput {
	s.Name = &v
	return s
}

// SetPort sets the Port field's value.
func (s *ConvertOriginForCreateDomainConfigsInput) SetPort(v int32) *ConvertOriginForCreateDomainConfigsInput {
	s.Port = &v
	return s
}

// SetType sets the Type field's value.
func (s *ConvertOriginForCreateDomainConfigsInput) SetType(v string) *ConvertOriginForCreateDomainConfigsInput {
	s.Type = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *ConvertOriginForCreateDomainConfigsInput) SetWeight(v int32) *ConvertOriginForCreateDomainConfigsInput {
	s.Weight = &v
	return s
}

type ConvertRuleForCreateDomainConfigsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Match *string `type:"string" json:",omitempty"`

	Replacement *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ConvertRuleForCreateDomainConfigsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertRuleForCreateDomainConfigsInput) GoString() string {
	return s.String()
}

// SetMatch sets the Match field's value.
func (s *ConvertRuleForCreateDomainConfigsInput) SetMatch(v string) *ConvertRuleForCreateDomainConfigsInput {
	s.Match = &v
	return s
}

// SetReplacement sets the Replacement field's value.
func (s *ConvertRuleForCreateDomainConfigsInput) SetReplacement(v string) *ConvertRuleForCreateDomainConfigsInput {
	s.Replacement = &v
	return s
}

type CreateDomainConfigsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	BrCompress *BrCompressForCreateDomainConfigsInput `type:"structure" json:",omitempty"`

	BusinessScene *string `type:"string" json:",omitempty"`

	Cache *CacheForCreateDomainConfigsInput `type:"structure" json:",omitempty"`

	Domains []*string `type:"list" json:",omitempty"`

	EnableFailOver *bool `type:"boolean" json:",omitempty"`

	GzipCompress *GzipCompressForCreateDomainConfigsInput `type:"structure" json:",omitempty"`

	Https *HttpsForCreateDomainConfigsInput `type:"structure" json:",omitempty"`

	IPv6Switch *bool `type:"boolean" json:",omitempty"`

	IpAccess *IpAccessForCreateDomainConfigsInput `type:"structure" json:",omitempty"`

	Origin *ConvertConvertOriginForCreateDomainConfigsInput `type:"structure" json:",omitempty"`

	PreConnect *PreConnectForCreateDomainConfigsInput `type:"structure" json:",omitempty"`

	ProjectName *string `type:"string" json:",omitempty"`

	RTTOptimize *RTTOptimizeForCreateDomainConfigsInput `type:"structure" json:",omitempty"`

	RefererAccess *RefererAccessForCreateDomainConfigsInput `type:"structure" json:",omitempty"`

	Scope *string `type:"string" json:",omitempty"`

	ServiceType *string `type:"string" json:",omitempty"`

	StaticOptimization *StaticOptimizationForCreateDomainConfigsInput `type:"structure" json:",omitempty"`

	// StrategyType is a required field
	StrategyType *string `type:"string" json:",omitempty" required:"true"`

	UploadOptimize *UploadOptimizeForCreateDomainConfigsInput `type:"structure" json:",omitempty"`

	UrlAccess *UrlAccessForCreateDomainConfigsInput `type:"structure" json:",omitempty"`

	UrlRedirect *UrlRedirectForCreateDomainConfigsInput `type:"structure" json:",omitempty"`

	UserAgentAccess *UserAgentAccessForCreateDomainConfigsInput `type:"structure" json:",omitempty"`

	WebSocket *WebSocketForCreateDomainConfigsInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s CreateDomainConfigsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDomainConfigsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDomainConfigsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDomainConfigsInput"}
	if s.StrategyType == nil {
		invalidParams.Add(request.NewErrParamRequired("StrategyType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBrCompress sets the BrCompress field's value.
func (s *CreateDomainConfigsInput) SetBrCompress(v *BrCompressForCreateDomainConfigsInput) *CreateDomainConfigsInput {
	s.BrCompress = v
	return s
}

// SetBusinessScene sets the BusinessScene field's value.
func (s *CreateDomainConfigsInput) SetBusinessScene(v string) *CreateDomainConfigsInput {
	s.BusinessScene = &v
	return s
}

// SetCache sets the Cache field's value.
func (s *CreateDomainConfigsInput) SetCache(v *CacheForCreateDomainConfigsInput) *CreateDomainConfigsInput {
	s.Cache = v
	return s
}

// SetDomains sets the Domains field's value.
func (s *CreateDomainConfigsInput) SetDomains(v []*string) *CreateDomainConfigsInput {
	s.Domains = v
	return s
}

// SetEnableFailOver sets the EnableFailOver field's value.
func (s *CreateDomainConfigsInput) SetEnableFailOver(v bool) *CreateDomainConfigsInput {
	s.EnableFailOver = &v
	return s
}

// SetGzipCompress sets the GzipCompress field's value.
func (s *CreateDomainConfigsInput) SetGzipCompress(v *GzipCompressForCreateDomainConfigsInput) *CreateDomainConfigsInput {
	s.GzipCompress = v
	return s
}

// SetHttps sets the Https field's value.
func (s *CreateDomainConfigsInput) SetHttps(v *HttpsForCreateDomainConfigsInput) *CreateDomainConfigsInput {
	s.Https = v
	return s
}

// SetIPv6Switch sets the IPv6Switch field's value.
func (s *CreateDomainConfigsInput) SetIPv6Switch(v bool) *CreateDomainConfigsInput {
	s.IPv6Switch = &v
	return s
}

// SetIpAccess sets the IpAccess field's value.
func (s *CreateDomainConfigsInput) SetIpAccess(v *IpAccessForCreateDomainConfigsInput) *CreateDomainConfigsInput {
	s.IpAccess = v
	return s
}

// SetOrigin sets the Origin field's value.
func (s *CreateDomainConfigsInput) SetOrigin(v *ConvertConvertOriginForCreateDomainConfigsInput) *CreateDomainConfigsInput {
	s.Origin = v
	return s
}

// SetPreConnect sets the PreConnect field's value.
func (s *CreateDomainConfigsInput) SetPreConnect(v *PreConnectForCreateDomainConfigsInput) *CreateDomainConfigsInput {
	s.PreConnect = v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *CreateDomainConfigsInput) SetProjectName(v string) *CreateDomainConfigsInput {
	s.ProjectName = &v
	return s
}

// SetRTTOptimize sets the RTTOptimize field's value.
func (s *CreateDomainConfigsInput) SetRTTOptimize(v *RTTOptimizeForCreateDomainConfigsInput) *CreateDomainConfigsInput {
	s.RTTOptimize = v
	return s
}

// SetRefererAccess sets the RefererAccess field's value.
func (s *CreateDomainConfigsInput) SetRefererAccess(v *RefererAccessForCreateDomainConfigsInput) *CreateDomainConfigsInput {
	s.RefererAccess = v
	return s
}

// SetScope sets the Scope field's value.
func (s *CreateDomainConfigsInput) SetScope(v string) *CreateDomainConfigsInput {
	s.Scope = &v
	return s
}

// SetServiceType sets the ServiceType field's value.
func (s *CreateDomainConfigsInput) SetServiceType(v string) *CreateDomainConfigsInput {
	s.ServiceType = &v
	return s
}

// SetStaticOptimization sets the StaticOptimization field's value.
func (s *CreateDomainConfigsInput) SetStaticOptimization(v *StaticOptimizationForCreateDomainConfigsInput) *CreateDomainConfigsInput {
	s.StaticOptimization = v
	return s
}

// SetStrategyType sets the StrategyType field's value.
func (s *CreateDomainConfigsInput) SetStrategyType(v string) *CreateDomainConfigsInput {
	s.StrategyType = &v
	return s
}

// SetUploadOptimize sets the UploadOptimize field's value.
func (s *CreateDomainConfigsInput) SetUploadOptimize(v *UploadOptimizeForCreateDomainConfigsInput) *CreateDomainConfigsInput {
	s.UploadOptimize = v
	return s
}

// SetUrlAccess sets the UrlAccess field's value.
func (s *CreateDomainConfigsInput) SetUrlAccess(v *UrlAccessForCreateDomainConfigsInput) *CreateDomainConfigsInput {
	s.UrlAccess = v
	return s
}

// SetUrlRedirect sets the UrlRedirect field's value.
func (s *CreateDomainConfigsInput) SetUrlRedirect(v *UrlRedirectForCreateDomainConfigsInput) *CreateDomainConfigsInput {
	s.UrlRedirect = v
	return s
}

// SetUserAgentAccess sets the UserAgentAccess field's value.
func (s *CreateDomainConfigsInput) SetUserAgentAccess(v *UserAgentAccessForCreateDomainConfigsInput) *CreateDomainConfigsInput {
	s.UserAgentAccess = v
	return s
}

// SetWebSocket sets the WebSocket field's value.
func (s *CreateDomainConfigsInput) SetWebSocket(v *WebSocketForCreateDomainConfigsInput) *CreateDomainConfigsInput {
	s.WebSocket = v
	return s
}

type CreateDomainConfigsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata
}

// String returns the string representation
func (s CreateDomainConfigsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDomainConfigsOutput) GoString() string {
	return s.String()
}

type FollowRedirectForCreateDomainConfigsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	MaxTries *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s FollowRedirectForCreateDomainConfigsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FollowRedirectForCreateDomainConfigsInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *FollowRedirectForCreateDomainConfigsInput) SetEnable(v bool) *FollowRedirectForCreateDomainConfigsInput {
	s.Enable = &v
	return s
}

// SetMaxTries sets the MaxTries field's value.
func (s *FollowRedirectForCreateDomainConfigsInput) SetMaxTries(v int32) *FollowRedirectForCreateDomainConfigsInput {
	s.MaxTries = &v
	return s
}

type ForceRedirectForCreateDomainConfigsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	RedirectType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ForceRedirectForCreateDomainConfigsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ForceRedirectForCreateDomainConfigsInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *ForceRedirectForCreateDomainConfigsInput) SetEnable(v bool) *ForceRedirectForCreateDomainConfigsInput {
	s.Enable = &v
	return s
}

// SetRedirectType sets the RedirectType field's value.
func (s *ForceRedirectForCreateDomainConfigsInput) SetRedirectType(v string) *ForceRedirectForCreateDomainConfigsInput {
	s.RedirectType = &v
	return s
}

type GzipCompressForCreateDomainConfigsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s GzipCompressForCreateDomainConfigsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GzipCompressForCreateDomainConfigsInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *GzipCompressForCreateDomainConfigsInput) SetEnable(v bool) *GzipCompressForCreateDomainConfigsInput {
	s.Enable = &v
	return s
}

type HeaderInfoForCreateDomainConfigsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	HeaderMode *int32 `type:"int32" json:",omitempty"`

	HeaderName *string `type:"string" json:",omitempty"`

	HeaderValue *string `type:"string" json:",omitempty"`

	HeaderValueType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s HeaderInfoForCreateDomainConfigsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HeaderInfoForCreateDomainConfigsInput) GoString() string {
	return s.String()
}

// SetHeaderMode sets the HeaderMode field's value.
func (s *HeaderInfoForCreateDomainConfigsInput) SetHeaderMode(v int32) *HeaderInfoForCreateDomainConfigsInput {
	s.HeaderMode = &v
	return s
}

// SetHeaderName sets the HeaderName field's value.
func (s *HeaderInfoForCreateDomainConfigsInput) SetHeaderName(v string) *HeaderInfoForCreateDomainConfigsInput {
	s.HeaderName = &v
	return s
}

// SetHeaderValue sets the HeaderValue field's value.
func (s *HeaderInfoForCreateDomainConfigsInput) SetHeaderValue(v string) *HeaderInfoForCreateDomainConfigsInput {
	s.HeaderValue = &v
	return s
}

// SetHeaderValueType sets the HeaderValueType field's value.
func (s *HeaderInfoForCreateDomainConfigsInput) SetHeaderValueType(v string) *HeaderInfoForCreateDomainConfigsInput {
	s.HeaderValueType = &v
	return s
}

type HstsForCreateDomainConfigsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	IncludeSubDomain *bool `type:"boolean" json:",omitempty"`

	MaxAge *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s HstsForCreateDomainConfigsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HstsForCreateDomainConfigsInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *HstsForCreateDomainConfigsInput) SetEnable(v bool) *HstsForCreateDomainConfigsInput {
	s.Enable = &v
	return s
}

// SetIncludeSubDomain sets the IncludeSubDomain field's value.
func (s *HstsForCreateDomainConfigsInput) SetIncludeSubDomain(v bool) *HstsForCreateDomainConfigsInput {
	s.IncludeSubDomain = &v
	return s
}

// SetMaxAge sets the MaxAge field's value.
func (s *HstsForCreateDomainConfigsInput) SetMaxAge(v int32) *HstsForCreateDomainConfigsInput {
	s.MaxAge = &v
	return s
}

type HttpsForCreateDomainConfigsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CertBind *CertBindForCreateDomainConfigsInput `type:"structure" json:",omitempty"`

	ForceRedirect *ForceRedirectForCreateDomainConfigsInput `type:"structure" json:",omitempty"`

	Hsts *HstsForCreateDomainConfigsInput `type:"structure" json:",omitempty"`

	Http2 *bool `type:"boolean" json:",omitempty"`

	QUICSwitch *bool `type:"boolean" json:",omitempty"`

	TlsVersions *TlsVersionsForCreateDomainConfigsInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s HttpsForCreateDomainConfigsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HttpsForCreateDomainConfigsInput) GoString() string {
	return s.String()
}

// SetCertBind sets the CertBind field's value.
func (s *HttpsForCreateDomainConfigsInput) SetCertBind(v *CertBindForCreateDomainConfigsInput) *HttpsForCreateDomainConfigsInput {
	s.CertBind = v
	return s
}

// SetForceRedirect sets the ForceRedirect field's value.
func (s *HttpsForCreateDomainConfigsInput) SetForceRedirect(v *ForceRedirectForCreateDomainConfigsInput) *HttpsForCreateDomainConfigsInput {
	s.ForceRedirect = v
	return s
}

// SetHsts sets the Hsts field's value.
func (s *HttpsForCreateDomainConfigsInput) SetHsts(v *HstsForCreateDomainConfigsInput) *HttpsForCreateDomainConfigsInput {
	s.Hsts = v
	return s
}

// SetHttp2 sets the Http2 field's value.
func (s *HttpsForCreateDomainConfigsInput) SetHttp2(v bool) *HttpsForCreateDomainConfigsInput {
	s.Http2 = &v
	return s
}

// SetQUICSwitch sets the QUICSwitch field's value.
func (s *HttpsForCreateDomainConfigsInput) SetQUICSwitch(v bool) *HttpsForCreateDomainConfigsInput {
	s.QUICSwitch = &v
	return s
}

// SetTlsVersions sets the TlsVersions field's value.
func (s *HttpsForCreateDomainConfigsInput) SetTlsVersions(v *TlsVersionsForCreateDomainConfigsInput) *HttpsForCreateDomainConfigsInput {
	s.TlsVersions = v
	return s
}

type IpAccessForCreateDomainConfigsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	FilterList []*string `type:"list" json:",omitempty"`

	FilterType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s IpAccessForCreateDomainConfigsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s IpAccessForCreateDomainConfigsInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *IpAccessForCreateDomainConfigsInput) SetEnable(v bool) *IpAccessForCreateDomainConfigsInput {
	s.Enable = &v
	return s
}

// SetFilterList sets the FilterList field's value.
func (s *IpAccessForCreateDomainConfigsInput) SetFilterList(v []*string) *IpAccessForCreateDomainConfigsInput {
	s.FilterList = v
	return s
}

// SetFilterType sets the FilterType field's value.
func (s *IpAccessForCreateDomainConfigsInput) SetFilterType(v string) *IpAccessForCreateDomainConfigsInput {
	s.FilterType = &v
	return s
}

type OriginHostForCreateDomainConfigsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	HostInfo *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s OriginHostForCreateDomainConfigsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginHostForCreateDomainConfigsInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *OriginHostForCreateDomainConfigsInput) SetEnable(v bool) *OriginHostForCreateDomainConfigsInput {
	s.Enable = &v
	return s
}

// SetHostInfo sets the HostInfo field's value.
func (s *OriginHostForCreateDomainConfigsInput) SetHostInfo(v string) *OriginHostForCreateDomainConfigsInput {
	s.HostInfo = &v
	return s
}

type OriginRangeForCreateDomainConfigsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s OriginRangeForCreateDomainConfigsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginRangeForCreateDomainConfigsInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *OriginRangeForCreateDomainConfigsInput) SetEnable(v bool) *OriginRangeForCreateDomainConfigsInput {
	s.Enable = &v
	return s
}

type OriginSniForCreateDomainConfigsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	SniInfo *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s OriginSniForCreateDomainConfigsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginSniForCreateDomainConfigsInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *OriginSniForCreateDomainConfigsInput) SetEnable(v bool) *OriginSniForCreateDomainConfigsInput {
	s.Enable = &v
	return s
}

// SetSniInfo sets the SniInfo field's value.
func (s *OriginSniForCreateDomainConfigsInput) SetSniInfo(v string) *OriginSniForCreateDomainConfigsInput {
	s.SniInfo = &v
	return s
}

type PreConnectForCreateDomainConfigsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s PreConnectForCreateDomainConfigsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PreConnectForCreateDomainConfigsInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *PreConnectForCreateDomainConfigsInput) SetEnable(v bool) *PreConnectForCreateDomainConfigsInput {
	s.Enable = &v
	return s
}

type RTTOptimizeForCreateDomainConfigsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s RTTOptimizeForCreateDomainConfigsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RTTOptimizeForCreateDomainConfigsInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *RTTOptimizeForCreateDomainConfigsInput) SetEnable(v bool) *RTTOptimizeForCreateDomainConfigsInput {
	s.Enable = &v
	return s
}

type RefererAccessForCreateDomainConfigsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AllowNone *bool `type:"boolean" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	FilterList []*string `type:"list" json:",omitempty"`

	FilterType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s RefererAccessForCreateDomainConfigsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RefererAccessForCreateDomainConfigsInput) GoString() string {
	return s.String()
}

// SetAllowNone sets the AllowNone field's value.
func (s *RefererAccessForCreateDomainConfigsInput) SetAllowNone(v bool) *RefererAccessForCreateDomainConfigsInput {
	s.AllowNone = &v
	return s
}

// SetEnable sets the Enable field's value.
func (s *RefererAccessForCreateDomainConfigsInput) SetEnable(v bool) *RefererAccessForCreateDomainConfigsInput {
	s.Enable = &v
	return s
}

// SetFilterList sets the FilterList field's value.
func (s *RefererAccessForCreateDomainConfigsInput) SetFilterList(v []*string) *RefererAccessForCreateDomainConfigsInput {
	s.FilterList = v
	return s
}

// SetFilterType sets the FilterType field's value.
func (s *RefererAccessForCreateDomainConfigsInput) SetFilterType(v string) *RefererAccessForCreateDomainConfigsInput {
	s.FilterType = &v
	return s
}

type RequestHeaderForCreateDomainConfigsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	HeaderInfo []*HeaderInfoForCreateDomainConfigsInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s RequestHeaderForCreateDomainConfigsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestHeaderForCreateDomainConfigsInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *RequestHeaderForCreateDomainConfigsInput) SetEnable(v bool) *RequestHeaderForCreateDomainConfigsInput {
	s.Enable = &v
	return s
}

// SetHeaderInfo sets the HeaderInfo field's value.
func (s *RequestHeaderForCreateDomainConfigsInput) SetHeaderInfo(v []*HeaderInfoForCreateDomainConfigsInput) *RequestHeaderForCreateDomainConfigsInput {
	s.HeaderInfo = v
	return s
}

type ResponseHeaderForCreateDomainConfigsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	HeaderInfo []*HeaderInfoForCreateDomainConfigsInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ResponseHeaderForCreateDomainConfigsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResponseHeaderForCreateDomainConfigsInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *ResponseHeaderForCreateDomainConfigsInput) SetEnable(v bool) *ResponseHeaderForCreateDomainConfigsInput {
	s.Enable = &v
	return s
}

// SetHeaderInfo sets the HeaderInfo field's value.
func (s *ResponseHeaderForCreateDomainConfigsInput) SetHeaderInfo(v []*HeaderInfoForCreateDomainConfigsInput) *ResponseHeaderForCreateDomainConfigsInput {
	s.HeaderInfo = v
	return s
}

type RuleForCreateDomainConfigsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CacheTime *int32 `type:"int32" json:",omitempty"`

	CacheTimeUnit *string `type:"string" json:",omitempty"`

	RespUrl *string `type:"string" json:",omitempty"`

	Status *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s RuleForCreateDomainConfigsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RuleForCreateDomainConfigsInput) GoString() string {
	return s.String()
}

// SetCacheTime sets the CacheTime field's value.
func (s *RuleForCreateDomainConfigsInput) SetCacheTime(v int32) *RuleForCreateDomainConfigsInput {
	s.CacheTime = &v
	return s
}

// SetCacheTimeUnit sets the CacheTimeUnit field's value.
func (s *RuleForCreateDomainConfigsInput) SetCacheTimeUnit(v string) *RuleForCreateDomainConfigsInput {
	s.CacheTimeUnit = &v
	return s
}

// SetRespUrl sets the RespUrl field's value.
func (s *RuleForCreateDomainConfigsInput) SetRespUrl(v string) *RuleForCreateDomainConfigsInput {
	s.RespUrl = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RuleForCreateDomainConfigsInput) SetStatus(v string) *RuleForCreateDomainConfigsInput {
	s.Status = &v
	return s
}

type StaticOptimizationForCreateDomainConfigsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	H2Priority *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s StaticOptimizationForCreateDomainConfigsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StaticOptimizationForCreateDomainConfigsInput) GoString() string {
	return s.String()
}

// SetH2Priority sets the H2Priority field's value.
func (s *StaticOptimizationForCreateDomainConfigsInput) SetH2Priority(v bool) *StaticOptimizationForCreateDomainConfigsInput {
	s.H2Priority = &v
	return s
}

type StatusCodeCacheRuleForCreateDomainConfigsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	Rules []*RuleForCreateDomainConfigsInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s StatusCodeCacheRuleForCreateDomainConfigsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StatusCodeCacheRuleForCreateDomainConfigsInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *StatusCodeCacheRuleForCreateDomainConfigsInput) SetEnable(v bool) *StatusCodeCacheRuleForCreateDomainConfigsInput {
	s.Enable = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *StatusCodeCacheRuleForCreateDomainConfigsInput) SetRules(v []*RuleForCreateDomainConfigsInput) *StatusCodeCacheRuleForCreateDomainConfigsInput {
	s.Rules = v
	return s
}

type TlsVersionsForCreateDomainConfigsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	TlsVersion []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s TlsVersionsForCreateDomainConfigsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TlsVersionsForCreateDomainConfigsInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *TlsVersionsForCreateDomainConfigsInput) SetEnable(v bool) *TlsVersionsForCreateDomainConfigsInput {
	s.Enable = &v
	return s
}

// SetTlsVersion sets the TlsVersion field's value.
func (s *TlsVersionsForCreateDomainConfigsInput) SetTlsVersion(v []*string) *TlsVersionsForCreateDomainConfigsInput {
	s.TlsVersion = v
	return s
}

type UploadOptimizeForCreateDomainConfigsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s UploadOptimizeForCreateDomainConfigsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadOptimizeForCreateDomainConfigsInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *UploadOptimizeForCreateDomainConfigsInput) SetEnable(v bool) *UploadOptimizeForCreateDomainConfigsInput {
	s.Enable = &v
	return s
}

type UrlAccessForCreateDomainConfigsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	GenKey *string `type:"string" json:",omitempty"`

	GenTTL *int32 `type:"int32" json:",omitempty"`

	GenType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s UrlAccessForCreateDomainConfigsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UrlAccessForCreateDomainConfigsInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *UrlAccessForCreateDomainConfigsInput) SetEnable(v bool) *UrlAccessForCreateDomainConfigsInput {
	s.Enable = &v
	return s
}

// SetGenKey sets the GenKey field's value.
func (s *UrlAccessForCreateDomainConfigsInput) SetGenKey(v string) *UrlAccessForCreateDomainConfigsInput {
	s.GenKey = &v
	return s
}

// SetGenTTL sets the GenTTL field's value.
func (s *UrlAccessForCreateDomainConfigsInput) SetGenTTL(v int32) *UrlAccessForCreateDomainConfigsInput {
	s.GenTTL = &v
	return s
}

// SetGenType sets the GenType field's value.
func (s *UrlAccessForCreateDomainConfigsInput) SetGenType(v string) *UrlAccessForCreateDomainConfigsInput {
	s.GenType = &v
	return s
}

type UrlRedirectForCreateDomainConfigsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	Rules []*ConvertRuleForCreateDomainConfigsInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s UrlRedirectForCreateDomainConfigsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UrlRedirectForCreateDomainConfigsInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *UrlRedirectForCreateDomainConfigsInput) SetEnable(v bool) *UrlRedirectForCreateDomainConfigsInput {
	s.Enable = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *UrlRedirectForCreateDomainConfigsInput) SetRules(v []*ConvertRuleForCreateDomainConfigsInput) *UrlRedirectForCreateDomainConfigsInput {
	s.Rules = v
	return s
}

type UserAgentAccessForCreateDomainConfigsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	FilterList []*string `type:"list" json:",omitempty"`

	FilterType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s UserAgentAccessForCreateDomainConfigsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UserAgentAccessForCreateDomainConfigsInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *UserAgentAccessForCreateDomainConfigsInput) SetEnable(v bool) *UserAgentAccessForCreateDomainConfigsInput {
	s.Enable = &v
	return s
}

// SetFilterList sets the FilterList field's value.
func (s *UserAgentAccessForCreateDomainConfigsInput) SetFilterList(v []*string) *UserAgentAccessForCreateDomainConfigsInput {
	s.FilterList = v
	return s
}

// SetFilterType sets the FilterType field's value.
func (s *UserAgentAccessForCreateDomainConfigsInput) SetFilterType(v string) *UserAgentAccessForCreateDomainConfigsInput {
	s.FilterType = &v
	return s
}

type WebSocketForCreateDomainConfigsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	Timeout *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s WebSocketForCreateDomainConfigsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s WebSocketForCreateDomainConfigsInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *WebSocketForCreateDomainConfigsInput) SetEnable(v bool) *WebSocketForCreateDomainConfigsInput {
	s.Enable = &v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *WebSocketForCreateDomainConfigsInput) SetTimeout(v int32) *WebSocketForCreateDomainConfigsInput {
	s.Timeout = &v
	return s
}
