// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package cr

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListRepositoriesCommon = "ListRepositories"

// ListRepositoriesCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListRepositoriesCommon operation. The "output" return
// value will be populated with the ListRepositoriesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListRepositoriesCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListRepositoriesCommon Send returns without error.
//
// See ListRepositoriesCommon for more information on using the ListRepositoriesCommon
// API call, and error handling.
//
//    // Example sending a request using the ListRepositoriesCommonRequest method.
//    req, resp := client.ListRepositoriesCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CR) ListRepositoriesCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListRepositoriesCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListRepositoriesCommon API operation for CR.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CR's
// API operation ListRepositoriesCommon for usage and error information.
func (c *CR) ListRepositoriesCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListRepositoriesCommonRequest(input)
	return out, req.Send()
}

// ListRepositoriesCommonWithContext is the same as ListRepositoriesCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListRepositoriesCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CR) ListRepositoriesCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListRepositoriesCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListRepositories = "ListRepositories"

// ListRepositoriesRequest generates a "volcengine/request.Request" representing the
// client's request for the ListRepositories operation. The "output" return
// value will be populated with the ListRepositoriesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListRepositoriesCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListRepositoriesCommon Send returns without error.
//
// See ListRepositories for more information on using the ListRepositories
// API call, and error handling.
//
//    // Example sending a request using the ListRepositoriesRequest method.
//    req, resp := client.ListRepositoriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CR) ListRepositoriesRequest(input *ListRepositoriesInput) (req *request.Request, output *ListRepositoriesOutput) {
	op := &request.Operation{
		Name:       opListRepositories,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListRepositoriesInput{}
	}

	output = &ListRepositoriesOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListRepositories API operation for CR.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CR's
// API operation ListRepositories for usage and error information.
func (c *CR) ListRepositories(input *ListRepositoriesInput) (*ListRepositoriesOutput, error) {
	req, out := c.ListRepositoriesRequest(input)
	return out, req.Send()
}

// ListRepositoriesWithContext is the same as ListRepositories with the addition of
// the ability to pass a context and additional request options.
//
// See ListRepositories for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CR) ListRepositoriesWithContext(ctx volcengine.Context, input *ListRepositoriesInput, opts ...request.Option) (*ListRepositoriesOutput, error) {
	req, out := c.ListRepositoriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type FilterForListRepositoriesInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AccessLevels []*string `type:"list" json:",omitempty"`

	Names []*string `type:"list" json:",omitempty"`

	Namespaces []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s FilterForListRepositoriesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FilterForListRepositoriesInput) GoString() string {
	return s.String()
}

// SetAccessLevels sets the AccessLevels field's value.
func (s *FilterForListRepositoriesInput) SetAccessLevels(v []*string) *FilterForListRepositoriesInput {
	s.AccessLevels = v
	return s
}

// SetNames sets the Names field's value.
func (s *FilterForListRepositoriesInput) SetNames(v []*string) *FilterForListRepositoriesInput {
	s.Names = v
	return s
}

// SetNamespaces sets the Namespaces field's value.
func (s *FilterForListRepositoriesInput) SetNamespaces(v []*string) *FilterForListRepositoriesInput {
	s.Namespaces = v
	return s
}

type ItemForListRepositoriesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AccessLevel *string `type:"string" json:",omitempty"`

	CreateTime *string `type:"string" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Namespace *string `min:"2" max:"90" type:"string" json:",omitempty"`

	UpdateTime *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ItemForListRepositoriesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ItemForListRepositoriesOutput) GoString() string {
	return s.String()
}

// SetAccessLevel sets the AccessLevel field's value.
func (s *ItemForListRepositoriesOutput) SetAccessLevel(v string) *ItemForListRepositoriesOutput {
	s.AccessLevel = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *ItemForListRepositoriesOutput) SetCreateTime(v string) *ItemForListRepositoriesOutput {
	s.CreateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ItemForListRepositoriesOutput) SetDescription(v string) *ItemForListRepositoriesOutput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *ItemForListRepositoriesOutput) SetName(v string) *ItemForListRepositoriesOutput {
	s.Name = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *ItemForListRepositoriesOutput) SetNamespace(v string) *ItemForListRepositoriesOutput {
	s.Namespace = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *ItemForListRepositoriesOutput) SetUpdateTime(v string) *ItemForListRepositoriesOutput {
	s.UpdateTime = &v
	return s
}

type ListRepositoriesInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Filter *FilterForListRepositoriesInput `type:"structure" json:",omitempty"`

	PageNumber *int64 `type:"int64" json:",omitempty"`

	PageSize *int64 `min:"1" max:"100" type:"int64" json:",omitempty"`

	// Registry is a required field
	Registry *string `min:"3" max:"30" type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s ListRepositoriesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRepositoriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRepositoriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRepositoriesInput"}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}
	if s.PageSize != nil && *s.PageSize > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("PageSize", 100))
	}
	if s.Registry == nil {
		invalidParams.Add(request.NewErrParamRequired("Registry"))
	}
	if s.Registry != nil && len(*s.Registry) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Registry", 3))
	}
	if s.Registry != nil && len(*s.Registry) > 30 {
		invalidParams.Add(request.NewErrParamMaxLen("Registry", 30, *s.Registry))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListRepositoriesInput) SetFilter(v *FilterForListRepositoriesInput) *ListRepositoriesInput {
	s.Filter = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListRepositoriesInput) SetPageNumber(v int64) *ListRepositoriesInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListRepositoriesInput) SetPageSize(v int64) *ListRepositoriesInput {
	s.PageSize = &v
	return s
}

// SetRegistry sets the Registry field's value.
func (s *ListRepositoriesInput) SetRegistry(v string) *ListRepositoriesInput {
	s.Registry = &v
	return s
}

type ListRepositoriesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Items []*ItemForListRepositoriesOutput `type:"list" json:",omitempty"`

	PageNumber *int64 `type:"int64" json:",omitempty"`

	PageSize *int64 `type:"int64" json:",omitempty"`

	Registry *string `type:"string" json:",omitempty"`

	TotalCount *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s ListRepositoriesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRepositoriesOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListRepositoriesOutput) SetItems(v []*ItemForListRepositoriesOutput) *ListRepositoriesOutput {
	s.Items = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListRepositoriesOutput) SetPageNumber(v int64) *ListRepositoriesOutput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListRepositoriesOutput) SetPageSize(v int64) *ListRepositoriesOutput {
	s.PageSize = &v
	return s
}

// SetRegistry sets the Registry field's value.
func (s *ListRepositoriesOutput) SetRegistry(v string) *ListRepositoriesOutput {
	s.Registry = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *ListRepositoriesOutput) SetTotalCount(v int64) *ListRepositoriesOutput {
	s.TotalCount = &v
	return s
}
