// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package autoscaling

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDetachInstancesCommon = "DetachInstances"

// DetachInstancesCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DetachInstancesCommon operation. The "output" return
// value will be populated with the DetachInstancesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DetachInstancesCommon Request to send the API call to the service.
// the "output" return value is not valid until after DetachInstancesCommon Send returns without error.
//
// See DetachInstancesCommon for more information on using the DetachInstancesCommon
// API call, and error handling.
//
//    // Example sending a request using the DetachInstancesCommonRequest method.
//    req, resp := client.DetachInstancesCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *AUTOSCALING) DetachInstancesCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDetachInstancesCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// DetachInstancesCommon API operation for AUTO_SCALING.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for AUTO_SCALING's
// API operation DetachInstancesCommon for usage and error information.
func (c *AUTOSCALING) DetachInstancesCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DetachInstancesCommonRequest(input)
	return out, req.Send()
}

// DetachInstancesCommonWithContext is the same as DetachInstancesCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DetachInstancesCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AUTOSCALING) DetachInstancesCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DetachInstancesCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetachInstances = "DetachInstances"

// DetachInstancesRequest generates a "volcengine/request.Request" representing the
// client's request for the DetachInstances operation. The "output" return
// value will be populated with the DetachInstancesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DetachInstancesCommon Request to send the API call to the service.
// the "output" return value is not valid until after DetachInstancesCommon Send returns without error.
//
// See DetachInstances for more information on using the DetachInstances
// API call, and error handling.
//
//    // Example sending a request using the DetachInstancesRequest method.
//    req, resp := client.DetachInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *AUTOSCALING) DetachInstancesRequest(input *DetachInstancesInput) (req *request.Request, output *DetachInstancesOutput) {
	op := &request.Operation{
		Name:       opDetachInstances,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachInstancesInput{}
	}

	output = &DetachInstancesOutput{}
	req = c.newRequest(op, input, output)

	return
}

// DetachInstances API operation for AUTO_SCALING.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for AUTO_SCALING's
// API operation DetachInstances for usage and error information.
func (c *AUTOSCALING) DetachInstances(input *DetachInstancesInput) (*DetachInstancesOutput, error) {
	req, out := c.DetachInstancesRequest(input)
	return out, req.Send()
}

// DetachInstancesWithContext is the same as DetachInstances with the addition of
// the ability to pass a context and additional request options.
//
// See DetachInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AUTOSCALING) DetachInstancesWithContext(ctx volcengine.Context, input *DetachInstancesInput, opts ...request.Option) (*DetachInstancesOutput, error) {
	req, out := c.DetachInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type DetachInstancesInput struct {
	_ struct{} `type:"structure"`

	DecreaseDesiredCapacity *bool `type:"boolean"`

	DetachOption *string `type:"string"`

	// InstanceIds is a required field
	InstanceIds []*string `type:"list" required:"true"`

	LifecycleHook *bool `type:"boolean"`

	// ScalingGroupId is a required field
	ScalingGroupId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DetachInstancesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetachInstancesInput"}
	if s.InstanceIds == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceIds"))
	}
	if s.ScalingGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalingGroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDecreaseDesiredCapacity sets the DecreaseDesiredCapacity field's value.
func (s *DetachInstancesInput) SetDecreaseDesiredCapacity(v bool) *DetachInstancesInput {
	s.DecreaseDesiredCapacity = &v
	return s
}

// SetDetachOption sets the DetachOption field's value.
func (s *DetachInstancesInput) SetDetachOption(v string) *DetachInstancesInput {
	s.DetachOption = &v
	return s
}

// SetInstanceIds sets the InstanceIds field's value.
func (s *DetachInstancesInput) SetInstanceIds(v []*string) *DetachInstancesInput {
	s.InstanceIds = v
	return s
}

// SetLifecycleHook sets the LifecycleHook field's value.
func (s *DetachInstancesInput) SetLifecycleHook(v bool) *DetachInstancesInput {
	s.LifecycleHook = &v
	return s
}

// SetScalingGroupId sets the ScalingGroupId field's value.
func (s *DetachInstancesInput) SetScalingGroupId(v string) *DetachInstancesInput {
	s.ScalingGroupId = &v
	return s
}

type DetachInstancesOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	ScalingActivityId *string `type:"string"`
}

// String returns the string representation
func (s DetachInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachInstancesOutput) GoString() string {
	return s.String()
}

// SetScalingActivityId sets the ScalingActivityId field's value.
func (s *DetachInstancesOutput) SetScalingActivityId(v string) *DetachInstancesOutput {
	s.ScalingActivityId = &v
	return s
}
