// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package ark

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateEndpointCommon = "CreateEndpoint"

// CreateEndpointCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateEndpointCommon operation. The "output" return
// value will be populated with the CreateEndpointCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateEndpointCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateEndpointCommon Send returns without error.
//
// See CreateEndpointCommon for more information on using the CreateEndpointCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateEndpointCommonRequest method.
//    req, resp := client.CreateEndpointCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ARK) CreateEndpointCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateEndpointCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateEndpointCommon API operation for ARK.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ARK's
// API operation CreateEndpointCommon for usage and error information.
func (c *ARK) CreateEndpointCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateEndpointCommonRequest(input)
	return out, req.Send()
}

// CreateEndpointCommonWithContext is the same as CreateEndpointCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEndpointCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ARK) CreateEndpointCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateEndpointCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEndpoint = "CreateEndpoint"

// CreateEndpointRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateEndpoint operation. The "output" return
// value will be populated with the CreateEndpointCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateEndpointCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateEndpointCommon Send returns without error.
//
// See CreateEndpoint for more information on using the CreateEndpoint
// API call, and error handling.
//
//    // Example sending a request using the CreateEndpointRequest method.
//    req, resp := client.CreateEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ARK) CreateEndpointRequest(input *CreateEndpointInput) (req *request.Request, output *CreateEndpointOutput) {
	op := &request.Operation{
		Name:       opCreateEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEndpointInput{}
	}

	output = &CreateEndpointOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateEndpoint API operation for ARK.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ARK's
// API operation CreateEndpoint for usage and error information.
func (c *ARK) CreateEndpoint(input *CreateEndpointInput) (*CreateEndpointOutput, error) {
	req, out := c.CreateEndpointRequest(input)
	return out, req.Send()
}

// CreateEndpointWithContext is the same as CreateEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ARK) CreateEndpointWithContext(ctx volcengine.Context, input *CreateEndpointInput, opts ...request.Option) (*CreateEndpointOutput, error) {
	req, out := c.CreateEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateEndpointInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	DryRun *bool `type:"boolean" json:",omitempty"`

	ModelReference *ModelReferenceForCreateEndpointInput `type:"structure" json:",omitempty"`

	ModelUnitId *string `type:"string" json:",omitempty"`

	Moderation *ModerationForCreateEndpointInput `type:"structure" json:",omitempty"`

	// Name is a required field
	Name *string `type:"string" json:",omitempty" required:"true"`

	ProjectName *string `type:"string" json:",omitempty"`

	RateLimit *RateLimitForCreateEndpointInput `type:"structure" json:",omitempty"`

	Tags []*TagForCreateEndpointInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s CreateEndpointInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEndpointInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateEndpointInput) SetDescription(v string) *CreateEndpointInput {
	s.Description = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *CreateEndpointInput) SetDryRun(v bool) *CreateEndpointInput {
	s.DryRun = &v
	return s
}

// SetModelReference sets the ModelReference field's value.
func (s *CreateEndpointInput) SetModelReference(v *ModelReferenceForCreateEndpointInput) *CreateEndpointInput {
	s.ModelReference = v
	return s
}

// SetModelUnitId sets the ModelUnitId field's value.
func (s *CreateEndpointInput) SetModelUnitId(v string) *CreateEndpointInput {
	s.ModelUnitId = &v
	return s
}

// SetModeration sets the Moderation field's value.
func (s *CreateEndpointInput) SetModeration(v *ModerationForCreateEndpointInput) *CreateEndpointInput {
	s.Moderation = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateEndpointInput) SetName(v string) *CreateEndpointInput {
	s.Name = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *CreateEndpointInput) SetProjectName(v string) *CreateEndpointInput {
	s.ProjectName = &v
	return s
}

// SetRateLimit sets the RateLimit field's value.
func (s *CreateEndpointInput) SetRateLimit(v *RateLimitForCreateEndpointInput) *CreateEndpointInput {
	s.RateLimit = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEndpointInput) SetTags(v []*TagForCreateEndpointInput) *CreateEndpointInput {
	s.Tags = v
	return s
}

type CreateEndpointOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Id *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CreateEndpointOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEndpointOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *CreateEndpointOutput) SetId(v string) *CreateEndpointOutput {
	s.Id = &v
	return s
}

type FoundationModelForCreateEndpointInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ModelVersion *string `type:"string" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s FoundationModelForCreateEndpointInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FoundationModelForCreateEndpointInput) GoString() string {
	return s.String()
}

// SetModelVersion sets the ModelVersion field's value.
func (s *FoundationModelForCreateEndpointInput) SetModelVersion(v string) *FoundationModelForCreateEndpointInput {
	s.ModelVersion = &v
	return s
}

// SetName sets the Name field's value.
func (s *FoundationModelForCreateEndpointInput) SetName(v string) *FoundationModelForCreateEndpointInput {
	s.Name = &v
	return s
}

type ModelReferenceForCreateEndpointInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CustomModelId *string `type:"string" json:",omitempty"`

	FoundationModel *FoundationModelForCreateEndpointInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s ModelReferenceForCreateEndpointInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ModelReferenceForCreateEndpointInput) GoString() string {
	return s.String()
}

// SetCustomModelId sets the CustomModelId field's value.
func (s *ModelReferenceForCreateEndpointInput) SetCustomModelId(v string) *ModelReferenceForCreateEndpointInput {
	s.CustomModelId = &v
	return s
}

// SetFoundationModel sets the FoundationModel field's value.
func (s *ModelReferenceForCreateEndpointInput) SetFoundationModel(v *FoundationModelForCreateEndpointInput) *ModelReferenceForCreateEndpointInput {
	s.FoundationModel = v
	return s
}

type ModerationForCreateEndpointInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Strategy *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ModerationForCreateEndpointInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ModerationForCreateEndpointInput) GoString() string {
	return s.String()
}

// SetStrategy sets the Strategy field's value.
func (s *ModerationForCreateEndpointInput) SetStrategy(v string) *ModerationForCreateEndpointInput {
	s.Strategy = &v
	return s
}

type RateLimitForCreateEndpointInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Rpm *int32 `type:"int32" json:",omitempty"`

	Tpm *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s RateLimitForCreateEndpointInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RateLimitForCreateEndpointInput) GoString() string {
	return s.String()
}

// SetRpm sets the Rpm field's value.
func (s *RateLimitForCreateEndpointInput) SetRpm(v int32) *RateLimitForCreateEndpointInput {
	s.Rpm = &v
	return s
}

// SetTpm sets the Tpm field's value.
func (s *RateLimitForCreateEndpointInput) SetTpm(v int32) *RateLimitForCreateEndpointInput {
	s.Tpm = &v
	return s
}

type TagForCreateEndpointInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TagForCreateEndpointInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForCreateEndpointInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForCreateEndpointInput) SetKey(v string) *TagForCreateEndpointInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForCreateEndpointInput) SetValue(v string) *TagForCreateEndpointInput {
	s.Value = &v
	return s
}
