package vpcpeer

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetVpcPeerConnectionAttribute invokes the vpcpeer.GetVpcPeerConnectionAttribute API synchronously
func (client *Client) GetVpcPeerConnectionAttribute(request *GetVpcPeerConnectionAttributeRequest) (response *GetVpcPeerConnectionAttributeResponse, err error) {
	response = CreateGetVpcPeerConnectionAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// GetVpcPeerConnectionAttributeWithChan invokes the vpcpeer.GetVpcPeerConnectionAttribute API asynchronously
func (client *Client) GetVpcPeerConnectionAttributeWithChan(request *GetVpcPeerConnectionAttributeRequest) (<-chan *GetVpcPeerConnectionAttributeResponse, <-chan error) {
	responseChan := make(chan *GetVpcPeerConnectionAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetVpcPeerConnectionAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetVpcPeerConnectionAttributeWithCallback invokes the vpcpeer.GetVpcPeerConnectionAttribute API asynchronously
func (client *Client) GetVpcPeerConnectionAttributeWithCallback(request *GetVpcPeerConnectionAttributeRequest, callback func(response *GetVpcPeerConnectionAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetVpcPeerConnectionAttributeResponse
		var err error
		defer close(result)
		response, err = client.GetVpcPeerConnectionAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetVpcPeerConnectionAttributeRequest is the request struct for api GetVpcPeerConnectionAttribute
type GetVpcPeerConnectionAttributeRequest struct {
	*requests.RpcRequest
	Channel              string `position:"Body" name:"Channel"`
	RequestContent       string `position:"Body" name:"RequestContent"`
	ResourceOwnerAccount string `position:"Body" name:"ResourceOwnerAccount"`
	InstanceId           string `position:"Body" name:"InstanceId"`
}

// GetVpcPeerConnectionAttributeResponse is the response struct for api GetVpcPeerConnectionAttribute
type GetVpcPeerConnectionAttributeResponse struct {
	*responses.BaseResponse
	RequestId         string       `json:"RequestId" xml:"RequestId"`
	InstanceId        string       `json:"InstanceId" xml:"InstanceId"`
	GmtCreate         string       `json:"GmtCreate" xml:"GmtCreate"`
	GmtModified       string       `json:"GmtModified" xml:"GmtModified"`
	Name              string       `json:"Name" xml:"Name"`
	Description       string       `json:"Description" xml:"Description"`
	OwnerId           int64        `json:"OwnerId" xml:"OwnerId"`
	AcceptingOwnerUid int64        `json:"AcceptingOwnerUid" xml:"AcceptingOwnerUid"`
	RegionId          string       `json:"RegionId" xml:"RegionId"`
	AcceptingRegionId string       `json:"AcceptingRegionId" xml:"AcceptingRegionId"`
	Bandwidth         int          `json:"Bandwidth" xml:"Bandwidth"`
	Status            string       `json:"Status" xml:"Status"`
	BizStatus         string       `json:"BizStatus" xml:"BizStatus"`
	GmtExpired        string       `json:"GmtExpired" xml:"GmtExpired"`
	ResourceGroupId   string       `json:"ResourceGroupId" xml:"ResourceGroupId"`
	Vpc               Vpc          `json:"Vpc" xml:"Vpc"`
	AcceptingVpc      AcceptingVpc `json:"AcceptingVpc" xml:"AcceptingVpc"`
	Tags              []TagsItem   `json:"Tags" xml:"Tags"`
}

// CreateGetVpcPeerConnectionAttributeRequest creates a request to invoke GetVpcPeerConnectionAttribute API
func CreateGetVpcPeerConnectionAttributeRequest() (request *GetVpcPeerConnectionAttributeRequest) {
	request = &GetVpcPeerConnectionAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("VpcPeer", "2022-01-01", "GetVpcPeerConnectionAttribute", "vpcpeer", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetVpcPeerConnectionAttributeResponse creates a response to parse from GetVpcPeerConnectionAttribute response
func CreateGetVpcPeerConnectionAttributeResponse() (response *GetVpcPeerConnectionAttributeResponse) {
	response = &GetVpcPeerConnectionAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
