package vcs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UnsubscribeDeviceEvent invokes the vcs.UnsubscribeDeviceEvent API synchronously
func (client *Client) UnsubscribeDeviceEvent(request *UnsubscribeDeviceEventRequest) (response *UnsubscribeDeviceEventResponse, err error) {
	response = CreateUnsubscribeDeviceEventResponse()
	err = client.DoAction(request, response)
	return
}

// UnsubscribeDeviceEventWithChan invokes the vcs.UnsubscribeDeviceEvent API asynchronously
func (client *Client) UnsubscribeDeviceEventWithChan(request *UnsubscribeDeviceEventRequest) (<-chan *UnsubscribeDeviceEventResponse, <-chan error) {
	responseChan := make(chan *UnsubscribeDeviceEventResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UnsubscribeDeviceEvent(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UnsubscribeDeviceEventWithCallback invokes the vcs.UnsubscribeDeviceEvent API asynchronously
func (client *Client) UnsubscribeDeviceEventWithCallback(request *UnsubscribeDeviceEventRequest, callback func(response *UnsubscribeDeviceEventResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UnsubscribeDeviceEventResponse
		var err error
		defer close(result)
		response, err = client.UnsubscribeDeviceEvent(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UnsubscribeDeviceEventRequest is the request struct for api UnsubscribeDeviceEvent
type UnsubscribeDeviceEventRequest struct {
	*requests.RpcRequest
	DeviceId string `position:"Query" name:"DeviceId"`
}

// UnsubscribeDeviceEventResponse is the response struct for api UnsubscribeDeviceEvent
type UnsubscribeDeviceEventResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUnsubscribeDeviceEventRequest creates a request to invoke UnsubscribeDeviceEvent API
func CreateUnsubscribeDeviceEventRequest() (request *UnsubscribeDeviceEventRequest) {
	request = &UnsubscribeDeviceEventRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vcs", "2020-05-15", "UnsubscribeDeviceEvent", "", "")
	request.Method = requests.POST
	return
}

// CreateUnsubscribeDeviceEventResponse creates a response to parse from UnsubscribeDeviceEvent response
func CreateUnsubscribeDeviceEventResponse() (response *UnsubscribeDeviceEventResponse) {
	response = &UnsubscribeDeviceEventResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
