package tag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetEffectivePolicy invokes the tag.GetEffectivePolicy API synchronously
func (client *Client) GetEffectivePolicy(request *GetEffectivePolicyRequest) (response *GetEffectivePolicyResponse, err error) {
	response = CreateGetEffectivePolicyResponse()
	err = client.DoAction(request, response)
	return
}

// GetEffectivePolicyWithChan invokes the tag.GetEffectivePolicy API asynchronously
func (client *Client) GetEffectivePolicyWithChan(request *GetEffectivePolicyRequest) (<-chan *GetEffectivePolicyResponse, <-chan error) {
	responseChan := make(chan *GetEffectivePolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetEffectivePolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetEffectivePolicyWithCallback invokes the tag.GetEffectivePolicy API asynchronously
func (client *Client) GetEffectivePolicyWithCallback(request *GetEffectivePolicyRequest, callback func(response *GetEffectivePolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetEffectivePolicyResponse
		var err error
		defer close(result)
		response, err = client.GetEffectivePolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetEffectivePolicyRequest is the request struct for api GetEffectivePolicy
type GetEffectivePolicyRequest struct {
	*requests.RpcRequest
	TargetId             string           `position:"Query" name:"TargetId"`
	TargetType           string           `position:"Query" name:"TargetType"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// GetEffectivePolicyResponse is the response struct for api GetEffectivePolicy
type GetEffectivePolicyResponse struct {
	*responses.BaseResponse
	RequestId       string `json:"RequestId" xml:"RequestId"`
	EffectivePolicy string `json:"EffectivePolicy" xml:"EffectivePolicy"`
}

// CreateGetEffectivePolicyRequest creates a request to invoke GetEffectivePolicy API
func CreateGetEffectivePolicyRequest() (request *GetEffectivePolicyRequest) {
	request = &GetEffectivePolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Tag", "2018-08-28", "GetEffectivePolicy", "tag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetEffectivePolicyResponse creates a response to parse from GetEffectivePolicy response
func CreateGetEffectivePolicyResponse() (response *GetEffectivePolicyResponse) {
	response = &GetEffectivePolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
