package swas_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListInstanceStatus invokes the swas_open.ListInstanceStatus API synchronously
func (client *Client) ListInstanceStatus(request *ListInstanceStatusRequest) (response *ListInstanceStatusResponse, err error) {
	response = CreateListInstanceStatusResponse()
	err = client.DoAction(request, response)
	return
}

// ListInstanceStatusWithChan invokes the swas_open.ListInstanceStatus API asynchronously
func (client *Client) ListInstanceStatusWithChan(request *ListInstanceStatusRequest) (<-chan *ListInstanceStatusResponse, <-chan error) {
	responseChan := make(chan *ListInstanceStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListInstanceStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListInstanceStatusWithCallback invokes the swas_open.ListInstanceStatus API asynchronously
func (client *Client) ListInstanceStatusWithCallback(request *ListInstanceStatusRequest, callback func(response *ListInstanceStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListInstanceStatusResponse
		var err error
		defer close(result)
		response, err = client.ListInstanceStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListInstanceStatusRequest is the request struct for api ListInstanceStatus
type ListInstanceStatusRequest struct {
	*requests.RpcRequest
	PageNumber  requests.Integer `position:"Query" name:"PageNumber"`
	InstanceIds string           `position:"Query" name:"InstanceIds"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
}

// ListInstanceStatusResponse is the response struct for api ListInstanceStatus
type ListInstanceStatusResponse struct {
	*responses.BaseResponse
	RequestId        string            `json:"RequestId" xml:"RequestId"`
	PageSize         int               `json:"PageSize" xml:"PageSize"`
	PageNumber       int               `json:"PageNumber" xml:"PageNumber"`
	TotalCount       int               `json:"TotalCount" xml:"TotalCount"`
	InstanceStatuses []InstanceStatuse `json:"InstanceStatuses" xml:"InstanceStatuses"`
}

// CreateListInstanceStatusRequest creates a request to invoke ListInstanceStatus API
func CreateListInstanceStatusRequest() (request *ListInstanceStatusRequest) {
	request = &ListInstanceStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SWAS-OPEN", "2020-06-01", "ListInstanceStatus", "SWAS-OPEN", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListInstanceStatusResponse creates a response to parse from ListInstanceStatus response
func CreateListInstanceStatusResponse() (response *ListInstanceStatusResponse) {
	response = &ListInstanceStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
