package swas_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ApplyFirewallTemplate invokes the swas_open.ApplyFirewallTemplate API synchronously
func (client *Client) ApplyFirewallTemplate(request *ApplyFirewallTemplateRequest) (response *ApplyFirewallTemplateResponse, err error) {
	response = CreateApplyFirewallTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// ApplyFirewallTemplateWithChan invokes the swas_open.ApplyFirewallTemplate API asynchronously
func (client *Client) ApplyFirewallTemplateWithChan(request *ApplyFirewallTemplateRequest) (<-chan *ApplyFirewallTemplateResponse, <-chan error) {
	responseChan := make(chan *ApplyFirewallTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ApplyFirewallTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ApplyFirewallTemplateWithCallback invokes the swas_open.ApplyFirewallTemplate API asynchronously
func (client *Client) ApplyFirewallTemplateWithCallback(request *ApplyFirewallTemplateRequest, callback func(response *ApplyFirewallTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ApplyFirewallTemplateResponse
		var err error
		defer close(result)
		response, err = client.ApplyFirewallTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ApplyFirewallTemplateRequest is the request struct for api ApplyFirewallTemplate
type ApplyFirewallTemplateRequest struct {
	*requests.RpcRequest
	FirewallTemplateId string    `position:"Query" name:"FirewallTemplateId"`
	ClientToken        string    `position:"Query" name:"ClientToken"`
	InstanceId         string    `position:"Query" name:"InstanceId"`
	InstanceIds        *[]string `position:"Query" name:"InstanceIds"  type:"Repeated"`
}

// ApplyFirewallTemplateResponse is the response struct for api ApplyFirewallTemplate
type ApplyFirewallTemplateResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	TaskId    string `json:"TaskId" xml:"TaskId"`
}

// CreateApplyFirewallTemplateRequest creates a request to invoke ApplyFirewallTemplate API
func CreateApplyFirewallTemplateRequest() (request *ApplyFirewallTemplateRequest) {
	request = &ApplyFirewallTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SWAS-OPEN", "2020-06-01", "ApplyFirewallTemplate", "SWAS-OPEN", "openAPI")
	request.Method = requests.POST
	return
}

// CreateApplyFirewallTemplateResponse creates a response to parse from ApplyFirewallTemplate response
func CreateApplyFirewallTemplateResponse() (response *ApplyFirewallTemplateResponse) {
	response = &ApplyFirewallTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
